/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.mixin;

import io.github.lucaargolo.kibe.data.state.ChunkLoaderState;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerLevel.class})
public class ServerWorldMixin {
    @Shadow
    @Final
    private MinecraftServer server;
    @Unique
    private ChunkLoaderState cachedChunkLoaderState = null;

    @Unique
    private ChunkLoaderState getCachedChunkLoaderState() {
        if (this.cachedChunkLoaderState == null) {
            this.cachedChunkLoaderState = ChunkLoaderState.Companion.getPersistentState(this.server);
        }
        return this.cachedChunkLoaderState;
    }

    @Inject(at={@At(value="HEAD")}, method={"areEntitiesLoaded(J)Z"}, cancellable=true)
    public void isChunkLoaded(long chunkPos, CallbackInfoReturnable<Boolean> cir) {
        ServerLevel serverWorld = (ServerLevel)this;
        ChunkLoaderState chunkLoaderState = this.getCachedChunkLoaderState();
        if (chunkLoaderState.isItBeingChunkLoaded(serverWorld, new ChunkPos(chunkPos))) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isNaturalSpawningAllowed(Lnet/minecraft/core/BlockPos;)Z"}, cancellable=true)
    public void shouldTick(BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        ServerLevel serverWorld = (ServerLevel)this;
        ChunkLoaderState chunkLoaderState = this.getCachedChunkLoaderState();
        if (chunkLoaderState.isItBeingChunkLoaded(serverWorld, new ChunkPos(pos))) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isNaturalSpawningAllowed(Lnet/minecraft/world/level/ChunkPos;)Z"}, cancellable=true)
    public void shouldTick(ChunkPos pos, CallbackInfoReturnable<Boolean> cir) {
        ServerLevel serverWorld = (ServerLevel)this;
        ChunkLoaderState chunkLoaderState = this.getCachedChunkLoaderState();
        if (chunkLoaderState.isItBeingChunkLoaded(serverWorld, pos)) {
            cir.setReturnValue((Object)true);
        }
    }
}

