/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.mixin;

import io.github.ladysnake.pal.PlayerAbility;
import io.github.lucaargolo.kibe.KibeMod;
import io.github.lucaargolo.kibe.data.component.ComponentTypeCompendium;
import io.github.lucaargolo.kibe.item.AbilityRing;
import io.github.lucaargolo.kibe.item.Glider;
import io.github.lucaargolo.kibe.item.ItemCompendium;
import io.github.lucaargolo.kibe.item.SleepingBag;
import io.github.lucaargolo.kibe.mixed.PlayerEntityMixed;
import io.github.lucaargolo.kibe.utils.SlimeBounceHandler;
import io.github.lucaargolo.kibe.utils.helper.AbilityHelper;
import io.github.lucaargolo.kibe.utils.helper.GliderHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.Pair;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin
extends LivingEntity
implements PlayerEntityMixed {
    @Unique
    private final List<Pair<ItemStack, Long>> kibe_activeRingsList = new ArrayList<Pair<ItemStack, Long>>();

    protected PlayerEntityMixin(EntityType<? extends LivingEntity> type, Level world) {
        super(type, world);
    }

    @Override
    public List<Pair<ItemStack, Long>> kibe$getActiveRingsList() {
        return this.kibe_activeRingsList;
    }

    @Inject(at={@At(value="TAIL")}, method={"eat(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/food/FoodProperties;)Lnet/minecraft/world/item/ItemStack;"})
    public void eatFood(Level world, ItemStack stack, FoodProperties foodComponent, CallbackInfoReturnable<ItemStack> cir) {
        int x;
        if (stack.getItem().equals(ItemCompendium.INSTANCE.getCURSED_KIBE()) && !world.isClientSide && (x = this.random.nextInt(64)) == 0) {
            this.kill();
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"stopSleeping()V"})
    private void wakeUpV(CallbackInfo info) {
        SleepingBag.Companion.getPlayersSleeping().remove(this);
    }

    @Inject(at={@At(value="TAIL")}, method={"stopSleepInBed(ZZ)V"})
    private void wakeUpZ(CallbackInfo info) {
        SleepingBag.Companion.getPlayersSleeping().remove(this);
    }

    /*
     * WARNING - void declaration
     */
    @Inject(at={@At(value="TAIL")}, method={"tick()V"})
    private void tick(CallbackInfo info) {
        Player player = (Player)this;
        ItemStack cursorStack = player.inventoryMenu.getCarried();
        if (cursorStack.getItem() instanceof Glider && Glider.Companion.isEnabled(cursorStack)) {
            cursorStack.set(ComponentTypeCompendium.INSTANCE.getENABLED(), (Object)false);
        }
        if (!this.onGround() && !this.isInWater() && !this.isFallFlying() && this.getDeltaMovement().y < 0.0) {
            void var6_17;
            boolean isGliding;
            ItemStack mainHandStack = player.getMainHandItem();
            ItemStack offHandStack = player.getOffhandItem();
            if (mainHandStack.getItem() instanceof Glider && Glider.Companion.isEnabled(mainHandStack)) {
                EquipmentSlot equipmentSlot = EquipmentSlot.MAINHAND;
                ItemStack itemStack = mainHandStack;
            } else if (offHandStack.getItem() instanceof Glider && Glider.Companion.isEnabled(offHandStack)) {
                EquipmentSlot equipmentSlot = EquipmentSlot.OFFHAND;
                ItemStack itemStack = offHandStack;
            } else {
                EquipmentSlot equipmentSlot = EquipmentSlot.MAINHAND;
                ItemStack itemStack = ItemStack.EMPTY;
            }
            boolean bl = isGliding = !var6_17.isEmpty();
            if (isGliding) {
                GliderHelper.INSTANCE.setPlayerGliding(player, true);
                if (!KibeMod.INSTANCE.getCONFIG().getMiscellaneousModule().getGliderUnbreakable()) {
                    void var7_9;
                    var6_17.hurtAndBreak(1, (LivingEntity)player, (EquipmentSlot)var7_9);
                }
                float hSpeed = 0.05f;
                float vSpeed = 0.5f;
                if (this.isShiftKeyDown()) {
                    hSpeed *= 2.5f;
                    vSpeed *= 1.5f;
                }
                Vec3 v = this.getDeltaMovement();
                player.setDeltaMovement(v.x, v.y * (double)vSpeed, v.z);
                v = this.getDeltaMovement();
                double x = Math.cos(Math.toRadians(player.yHeadRot + 90.0f)) * (double)hSpeed;
                double z = Math.sin(Math.toRadians(player.yHeadRot + 90.0f)) * (double)hSpeed;
                player.setDeltaMovement(v.x + x, v.y, v.z + z);
                this.fallDistance = 0.0f;
                this.hasImpulse = true;
            } else {
                GliderHelper.INSTANCE.setPlayerGliding(player, false);
            }
        } else {
            GliderHelper.INSTANCE.setPlayerGliding(player, false);
        }
        Iterator<Entity> keyIt = this.level().isClientSide ? SlimeBounceHandler.Companion.getClientBouncingEntities().keySet().iterator() : SlimeBounceHandler.Companion.getServerBouncingEntities().keySet().iterator();
        while (keyIt.hasNext()) {
            void var6_21;
            Entity entity = keyIt.next();
            if (this.level().isClientSide) {
                SlimeBounceHandler slimeBounceHandler = SlimeBounceHandler.Companion.getClientBouncingEntities().get(entity);
            } else {
                SlimeBounceHandler slimeBounceHandler = SlimeBounceHandler.Companion.getServerBouncingEntities().get(entity);
            }
            if (!player.equals((Object)entity) || player.isFallFlying()) continue;
            if (player.tickCount == var6_21.getBounceTick()) {
                Vec3 vec3 = this.getDeltaMovement();
                this.setDeltaMovement(vec3.x, var6_21.getBounce(), vec3.z);
                var6_21.setBounceTick(0);
            }
            if (!(player.onGround() || player.tickCount == var6_21.getBounceTick() || var6_21.getLastMovX() == this.getDeltaMovement().x && var6_21.getLastMovZ() == this.getDeltaMovement().z)) {
                double d = 0.935;
                Vec3 velocity = this.getDeltaMovement();
                this.setDeltaMovement(velocity.x / d, velocity.y, velocity.z / d);
                this.hasImpulse = true;
                var6_21.setLastMovX(this.getDeltaMovement().x);
                var6_21.setLastMovZ(this.getDeltaMovement().z);
            }
            if (var6_21.getWasInAir() && player.onGround() || player.isInWater()) {
                if (var6_21.getTimer() == 0) {
                    var6_21.setTimer(player.tickCount);
                    continue;
                }
                if (player.tickCount - var6_21.getTimer() <= 5) continue;
                keyIt.remove();
                SlimeBounceHandler.Companion.getServerBouncingEntities().remove(entity);
                continue;
            }
            var6_21.setTimer(0);
            var6_21.setWasInAir(true);
        }
        if (!this.level().isClientSide) {
            for (PlayerAbility playerAbility : AbilityHelper.INSTANCE.getABILITY_TO_EFFECT().keySet()) {
                if (!playerAbility.isEnabledFor(player)) continue;
                Holder<MobEffect> holder = AbilityHelper.INSTANCE.getABILITY_TO_EFFECT().get(playerAbility);
                MobEffectInstance sei = new MobEffectInstance(holder, 100, 1, false, false, true);
                player.addEffect(sei);
            }
            LinkedHashMap<AbilityRing, List> ringMap = new LinkedHashMap<AbilityRing, List>();
            for (Pair<ItemStack, Long> pair : this.kibe_activeRingsList) {
                ItemStack ringStack = (ItemStack)pair.getFirst();
                Item ringItem = ringStack.getItem();
                if (!(ringItem instanceof AbilityRing) || !Boolean.TRUE.equals(ringStack.get(ComponentTypeCompendium.INSTANCE.getENABLED()))) continue;
                ringMap.computeIfAbsent((AbilityRing)ringItem, k -> new ArrayList());
                ((List)ringMap.get(ringItem)).add(ringStack);
            }
            int n = ringMap.values().stream().mapToInt(List::size).sum();
            AbilityRing.Companion.getRINGS().forEach(ring -> {
                if (ringMap.containsKey(ring)) {
                    if (ringQnt == -1 || ringQnt <= KibeMod.INSTANCE.getCONFIG().getMiscellaneousModule().getMaxRingsPerPlayer()) {
                        AbilityHelper.INSTANCE.getRING_SOURCE().grantTo(player, ring.getAbility());
                        for (ItemStack ringStack : (List)ringMap.get(ring)) {
                            if (Boolean.TRUE.equals(ringStack.get(ComponentTypeCompendium.INSTANCE.getUNIQUE()))) continue;
                            ringStack.set(ComponentTypeCompendium.INSTANCE.getUNIQUE(), (Object)true);
                        }
                    } else {
                        if (AbilityHelper.INSTANCE.getRING_SOURCE().grants(player, ring.getAbility())) {
                            AbilityHelper.INSTANCE.getRING_SOURCE().revokeFrom(player, ring.getAbility());
                        }
                        for (ItemStack ringStack : (List)ringMap.get(ring)) {
                            if (!Boolean.TRUE.equals(ringStack.get(ComponentTypeCompendium.INSTANCE.getUNIQUE()))) continue;
                            ringStack.set(ComponentTypeCompendium.INSTANCE.getUNIQUE(), (Object)false);
                        }
                    }
                } else if (AbilityHelper.INSTANCE.getRING_SOURCE().grants(player, ring.getAbility())) {
                    AbilityHelper.INSTANCE.getRING_SOURCE().revokeFrom(player, ring.getAbility());
                }
            });
        }
    }
}

