/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.item;

import io.github.lucaargolo.kibe.KibeMod;
import io.github.lucaargolo.kibe.block.EntangledChest;
import io.github.lucaargolo.kibe.blockentity.EntangledChestEntity;
import io.github.lucaargolo.kibe.data.component.ComponentTypeCompendium;
import io.github.lucaargolo.kibe.item.EntangledBag;
import io.github.lucaargolo.kibe.utils.menu.ItemScreenHandlerFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J9\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0014\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J-\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u001c2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lio/github/lucaargolo/kibe/item/EntangledBag;", "Lnet/minecraft/world/item/Item;", "Lnet/minecraft/world/item/Item$Properties;", "settings", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "Lnet/minecraft/world/item/ItemStack;", "stack", "Lnet/minecraft/world/item/Item$TooltipContext;", "context", "", "Lnet/minecraft/network/chat/Component;", "tooltip", "Lnet/minecraft/world/item/TooltipFlag;", "type", "", "appendTooltip", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/Item$TooltipContext;Ljava/util/List;Lnet/minecraft/world/item/TooltipFlag;)V", "Lnet/minecraft/world/item/context/UseOnContext;", "Lnet/minecraft/world/InteractionResult;", "useOnBlock", "(Lnet/minecraft/world/item/context/UseOnContext;)Lnet/minecraft/world/InteractionResult;", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/InteractionHand;", "hand", "Lnet/minecraft/world/InteractionResultHolder;", "use", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;", "kibe"})
@SourceDebugExtension(value={"SMAP\nEntangledBag.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntangledBag.kt\nio/github/lucaargolo/kibe/item/EntangledBag\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n1869#2,2:60\n1869#2,2:62\n*S KotlinDebug\n*F\n+ 1 EntangledBag.kt\nio/github/lucaargolo/kibe/item/EntangledBag\n*L\n29#1:60,2\n42#1:62,2\n*E\n"})
public final class EntangledBag
extends Item {
    public EntangledBag(@NotNull Item.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Item.TooltipContext context, @NotNull List<Component> tooltip, @Nullable TooltipFlag type) {
        String key;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        super.appendHoverText(stack, context, tooltip, type);
        MutableComponent ownerText = Component.translatable((String)"tooltip.kibe.owner");
        String string = (String)stack.get(ComponentTypeCompendium.INSTANCE.getENTANGLED_KEY());
        if (string == null) {
            string = "entangledchest-global";
        }
        if (!Intrinsics.areEqual((Object)(key = string), (Object)"entangledchest-global") && stack.has(ComponentTypeCompendium.INSTANCE.getOWNER())) {
            MutableComponent mutableComponent = ownerText.append((Component)Component.literal((String)((String)stack.get(ComponentTypeCompendium.INSTANCE.getOWNER()))).withStyle(ChatFormatting.GRAY));
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"append(...)");
            tooltip.add((Component)mutableComponent);
        }
        MutableComponent color = Component.translatable((String)"tooltip.kibe.color");
        List list = (List)stack.get(ComponentTypeCompendium.INSTANCE.getRUNE_SET());
        if (list == null) {
            list = (List)KibeMod.INSTANCE.getDEFAULT_RUNE_SET();
        }
        List list2 = list;
        Intrinsics.checkNotNull((Object)list2);
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DyeColor dc = (DyeColor)element$iv;
            boolean bl = false;
            MutableComponent text = Component.literal((String)"\u25a0");
            text.setStyle(text.getStyle().withColor(TextColor.fromRgb((int)dc.getMapColor().col)));
            color.append((Component)text);
        }
        Intrinsics.checkNotNull((Object)color);
        tooltip.add((Component)color);
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.getLevel().getBlockState(context.getClickedPos()).getBlock() instanceof EntangledChest && context.getPlayer() != null) {
            Player player = context.getPlayer();
            Intrinsics.checkNotNull((Object)player);
            if (player.isShiftKeyDown()) {
                BlockEntity blockEntity = context.getLevel().getBlockEntity(context.getClickedPos());
                Intrinsics.checkNotNull((Object)blockEntity, (String)"null cannot be cast to non-null type io.github.lucaargolo.kibe.blockentity.EntangledChestEntity");
                EntangledChestEntity blockEntity2 = (EntangledChestEntity)blockEntity;
                CompoundTag compoundTag = new CompoundTag();
                RegistryAccess registryAccess = context.getLevel().registryAccess();
                Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"getRegistryManager(...)");
                CompoundTag blockEntityTag = blockEntity2.writeClientNbt(compoundTag, (HolderLookup.Provider)registryAccess);
                List runeSet = new ArrayList();
                Iterable $this$forEach$iv = (Iterable)new IntRange(1, 8);
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl = false;
                    DyeColor dyeColor = DyeColor.byName((String)blockEntityTag.getString("rune" + it), (DyeColor)DyeColor.WHITE);
                    if (dyeColor == null) {
                        dyeColor = DyeColor.WHITE;
                    }
                    runeSet.add(dyeColor);
                }
                context.getItemInHand().set(ComponentTypeCompendium.INSTANCE.getENTANGLED_KEY(), (Object)blockEntityTag.getString("key"));
                context.getItemInHand().set(ComponentTypeCompendium.INSTANCE.getOWNER(), (Object)blockEntityTag.getString("owner"));
                context.getItemInHand().set(ComponentTypeCompendium.INSTANCE.getRUNE_SET(), (Object)runeSet);
                if (!context.getLevel().isClientSide) {
                    Player player2 = context.getPlayer();
                    Intrinsics.checkNotNull((Object)player2);
                    player2.displayClientMessage((Component)Component.translatable((String)"chat.kibe.entangled_bag.success"), true);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player player, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Item item = this;
        ItemStack itemStack = player.getItemInHand(hand);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getStackInHand(...)");
        player.openMenu((MenuProvider)new ItemScreenHandlerFactory(item, hand, itemStack, use.1.INSTANCE));
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.success((Object)player.getItemInHand(hand));
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
        return interactionResultHolder;
    }
}

