/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.item;

import io.github.lucaargolo.kibe.block.BlockCompendium;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lio/github/lucaargolo/kibe/item/CursedSeeds;", "Lnet/minecraft/world/item/Item;", "Lnet/minecraft/world/item/Item$Properties;", "settings", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "Lnet/minecraft/world/item/context/UseOnContext;", "context", "Lnet/minecraft/world/InteractionResult;", "useOnBlock", "(Lnet/minecraft/world/item/context/UseOnContext;)Lnet/minecraft/world/InteractionResult;", "Lnet/minecraft/world/level/block/state/BlockState;", "blockState", "", "isSpreadableInBlockState", "(Lnet/minecraft/world/level/block/state/BlockState;)Z", "kibe"})
public final class CursedSeeds
extends Item {
    public CursedSeeds(@NotNull Item.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BlockState blockState = context.getLevel().getBlockState(context.getClickedPos());
        Intrinsics.checkNotNull((Object)blockState);
        if (this.isSpreadableInBlockState(blockState) && context.getLevel().getMaxLocalRawBrightness(context.getClickedPos().above()) <= 7) {
            if (!context.getLevel().isClientSide) {
                context.getLevel().setBlockAndUpdate(context.getClickedPos(), BlockCompendium.INSTANCE.getCURSED_DIRT().defaultBlockState());
                Player player = context.getPlayer();
                if (player != null) {
                    player.playSound(SoundEvents.GRASS_BREAK, 1.0f, 0.8f);
                }
            }
            context.getItemInHand().shrink(1);
            return InteractionResult.SUCCESS;
        }
        InteractionResult interactionResult = super.useOn(context);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"useOnBlock(...)");
        return interactionResult;
    }

    private final boolean isSpreadableInBlockState(BlockState blockState) {
        return Intrinsics.areEqual((Object)blockState.getBlock(), (Object)Blocks.DIRT) || Intrinsics.areEqual((Object)blockState.getBlock(), (Object)Blocks.GRASS_BLOCK);
    }
}

