/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import io.github.lucaargolo.kibe.menu.VacuumHopperScreenHandler;
import io.github.lucaargolo.kibe.utils.helper.FluidHelper;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b\u000b\u0010\fJ/\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J'\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J/\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0014\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001c\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0016\u0010 \u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010\u001f\u00a8\u0006!"}, d2={"Lio/github/lucaargolo/kibe/client/screen/VacuumHopperScreen;", "Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;", "Lio/github/lucaargolo/kibe/menu/VacuumHopperScreenHandler;", "screenHandler", "Lnet/minecraft/world/entity/player/Inventory;", "inventory", "Lnet/minecraft/network/chat/Component;", "title", "<init>", "(Lio/github/lucaargolo/kibe/menu/VacuumHopperScreenHandler;Lnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/network/chat/Component;)V", "", "init", "()V", "Lnet/minecraft/client/gui/GuiGraphics;", "context", "", "mouseX", "mouseY", "", "delta", "render", "(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", "drawForeground", "(Lnet/minecraft/client/gui/GuiGraphics;II)V", "drawBackground", "(Lnet/minecraft/client/gui/GuiGraphics;FII)V", "Lnet/minecraft/resources/ResourceLocation;", "kotlin.jvm.PlatformType", "texture", "Lnet/minecraft/resources/ResourceLocation;", "startX", "I", "startY", "kibe"})
@SourceDebugExtension(value={"SMAP\nVacuumHopperScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VacuumHopperScreen.kt\nio/github/lucaargolo/kibe/client/screen/VacuumHopperScreen\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n1869#2,2:90\n*S KotlinDebug\n*F\n+ 1 VacuumHopperScreen.kt\nio/github/lucaargolo/kibe/client/screen/VacuumHopperScreen\n*L\n70#1:90,2\n*E\n"})
public final class VacuumHopperScreen
extends AbstractContainerScreen<VacuumHopperScreenHandler> {
    private final ResourceLocation texture;
    private int startX;
    private int startY;

    public VacuumHopperScreen(@NotNull VacuumHopperScreenHandler screenHandler, @NotNull Inventory inventory2, @NotNull Component title) {
        Intrinsics.checkNotNullParameter((Object)((Object)screenHandler), (String)"screenHandler");
        Intrinsics.checkNotNullParameter((Object)inventory2, (String)"inventory");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        super((AbstractContainerMenu)screenHandler, inventory2, title);
        this.texture = ResourceLocation.parse((String)"kibe:textures/gui/vacuum_hopper.png");
    }

    protected void init() {
        super.init();
        this.startX = this.width / 2 - this.imageWidth / 2;
        this.startY = this.height / 2 - this.imageHeight / 2;
    }

    public void render(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.renderBackground(context, mouseX, mouseY, delta);
        super.render(context, mouseX, mouseY, delta);
        int p = (int)((float)((VacuumHopperScreenHandler)this.menu).getProcessingTicks() / (float)((VacuumHopperScreenHandler)this.menu).getTotalProcessingTicks() * (float)14);
        context.blit(this.texture, this.startX + 120, this.startY + 37, 184, 0, 8, p);
        this.renderTooltip(context, mouseX, mouseY);
        int n = this.startX + 100;
        boolean bl = mouseX <= this.startX + 112 ? n <= mouseX : false;
        if (bl) {
            n = this.startY + 18;
            boolean bl2 = mouseY <= this.startY + 70 ? n <= mouseY : false;
            if (bl2) {
                SingleVariantStorage<FluidVariant> tank2 = ((VacuumHopperScreenHandler)this.menu).getEntity().getTank();
                long stored = tank2.amount;
                long capacity = tank2.getCapacity();
                Object[] objectArray = new Component[]{tank2.isResourceBlank() ? (Component)Component.translatable((String)"tooltip.kibe.empty") : FluidVariantAttributes.getName((FluidVariant)((FluidVariant)tank2.variant)), Component.literal((String)(FluidHelper.INSTANCE.getMb(stored) + " / " + capacity / (long)81 + " mB")).withStyle(ChatFormatting.GRAY)};
                context.renderComponentTooltip(this.font, CollectionsKt.listOf((Object[])objectArray), mouseX, mouseY);
            }
        }
    }

    protected void renderLabels(@NotNull GuiGraphics context, int mouseX, int mouseY) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.drawCenteredString(this.font, this.title.getString(), this.imageWidth / 2, 6, 0xFFFFFF);
        context.drawString(this.font, this.playerInventoryTitle, 8, this.imageHeight - 96 + 4, 0xFFFFFF, false);
    }

    protected void renderBg(@NotNull GuiGraphics context, float delta, int mouseX, int mouseY) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.blit(this.texture, this.startX, this.startY, 0, 0, 176, 166);
        SingleVariantStorage<FluidVariant> tank2 = ((VacuumHopperScreenHandler)this.menu).getEntity().getTank();
        ShaderInstance oldShader = RenderSystem.getShader();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        FluidRenderHandler fluidRenderHandler = FluidRenderHandlerRegistry.INSTANCE.get(((FluidVariant)tank2.getResource()).getFluid());
        if (fluidRenderHandler != null) {
            FluidRenderHandler fluidRenderHandler2 = fluidRenderHandler;
            boolean bl = false;
            BlockAndTintGetter blockAndTintGetter = (BlockAndTintGetter)Minecraft.getInstance().level;
            LocalPlayer localPlayer = Minecraft.getInstance().player;
            Intrinsics.checkNotNull((Object)localPlayer);
            int fluidColor = fluidRenderHandler2.getFluidColor(blockAndTintGetter, localPlayer.blockPosition(), ((FluidVariant)tank2.getResource()).getFluid().defaultFluidState());
            TextureAtlasSprite sprite = fluidRenderHandler2.getFluidSprites((BlockAndTintGetter)Minecraft.getInstance().level, BlockPos.ZERO, ((FluidVariant)tank2.getResource()).getFluid().defaultFluidState())[0];
            float r = (float)(fluidColor >> 16 & 0xFF) / 255.0f;
            float g = (float)(fluidColor >> 8 & 0xFF) / 255.0f;
            float b = (float)(fluidColor & 0xFF) / 255.0f;
            Matrix4f matrix = context.pose().last().pose();
            float percentage = 0.0f;
            percentage = (float)tank2.amount / (float)tank2.getCapacity() * 52.0f;
            Tesselator tess = Tesselator.getInstance();
            Iterable $this$forEach$iv = (Iterable)new IntRange(0, (int)(percentage / (float)16));
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv;
                int index = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl2 = false;
                BufferBuilder bb = tess.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
                float p = percentage > 16.0f ? 16.0f : percentage;
                bb.addVertex(matrix, (float)this.startX + 100.0f, (float)this.startY + 70.0f - (float)index * 16.0f, 0.0f).setUv(sprite.getU1(), sprite.getV0()).setColor(r, g, b, 1.0f);
                bb.addVertex(matrix, (float)this.startX + 112.0f, (float)this.startY + 70.0f - (float)index * 16.0f, 0.0f).setUv(sprite.getU0(), sprite.getV0()).setColor(r, g, b, 1.0f);
                float atlasHeight = (float)sprite.contents().height() / (sprite.getV1() - sprite.getV0());
                bb.addVertex(matrix, (float)this.startX + 112.0f, (float)this.startY + 70.0f - p - (float)index * 16.0f, 0.0f).setUv(sprite.getU0(), sprite.getV1() - ((float)sprite.contents().height() - p) / atlasHeight).setColor(r, g, b, 1.0f);
                bb.addVertex(matrix, (float)this.startX + 100.0f, (float)this.startY + 70.0f - p - (float)index * 16.0f, 0.0f).setUv(sprite.getU1(), sprite.getV1() - ((float)sprite.contents().height() - p) / atlasHeight).setColor(r, g, b, 1.0f);
                BufferUploader.drawWithShader((MeshData)bb.buildOrThrow());
                percentage -= p;
            }
        }
        RenderSystem.setShader(() -> VacuumHopperScreen.drawBackground$lambda$1(oldShader));
        context.blit(this.texture, this.startX + 100, this.startY + 18, 172, 0, 12, 52);
    }

    private static final ShaderInstance drawBackground$lambda$1(ShaderInstance $oldShader) {
        return $oldShader;
    }
}

