/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.client.model;

import io.github.lucaargolo.kibe.block.BlockCompendium;
import io.github.lucaargolo.kibe.item.TankBlockItem;
import io.github.lucaargolo.kibe.utils.ModIdentifier;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ%\u0010\r\u001a\u00020\f2\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0001\u0018\u00010\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ3\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u000f2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\n2\u0006\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001b\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJA\u0010(\u001a\u00020\f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\b\u0010 \u001a\u0004\u0018\u00010\u001f2\u0006\u0010\"\u001a\u00020!2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010'\u001a\u00020&H\u0016\u00a2\u0006\u0004\b(\u0010)J\u0013\u0010+\u001a\u00020**\u00020*H\u0002\u00a2\u0006\u0004\b+\u0010,J\u0013\u0010-\u001a\u00020**\u00020*H\u0002\u00a2\u0006\u0004\b-\u0010,J\u0013\u0010.\u001a\u00020**\u00020*H\u0002\u00a2\u0006\u0004\b.\u0010,J\u0013\u0010/\u001a\u00020**\u00020*H\u0002\u00a2\u0006\u0004\b/\u0010,J-\u00102\u001a\u00020\f*\u0002002\u0006\u00101\u001a\u00020*2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\"\u001a\u00020!H\u0002\u00a2\u0006\u0004\b2\u00103J-\u00107\u001a\u00020\f2\u0006\u00105\u001a\u0002042\f\u00106\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010'\u001a\u00020&H\u0016\u00a2\u0006\u0004\b7\u00108JC\u0010?\u001a\u00020\f*\u0002002\u0006\u00101\u001a\u00020*2\u0006\u0010:\u001a\u0002092\u0006\u0010;\u001a\u0002092\u0006\u0010<\u001a\u0002092\u0006\u0010=\u001a\u0002092\u0006\u0010>\u001a\u000209H\u0002\u00a2\u0006\u0004\b?\u0010@JK\u0010?\u001a\u00020\f*\u0002002\u0006\u00101\u001a\u00020*2\u0006\u0010A\u001a\u00020\u00122\u0006\u0010:\u001a\u0002092\u0006\u0010;\u001a\u0002092\u0006\u0010<\u001a\u0002092\u0006\u0010=\u001a\u0002092\u0006\u0010>\u001a\u000209H\u0002\u00a2\u0006\u0004\b?\u0010BJ3\u0010G\u001a\b\u0012\u0004\u0012\u00020F0E2\b\u0010 \u001a\u0004\u0018\u00010\u001f2\b\u0010C\u001a\u0004\u0018\u00010*2\b\u0010D\u001a\u0004\u0018\u00010$H\u0016\u00a2\u0006\u0004\bG\u0010HJ\u000f\u0010I\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\bI\u0010\u001cJ\u000f\u0010J\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\bJ\u0010\u001cJ\u000f\u0010K\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\bK\u0010\u001cJ\u000f\u0010L\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\bL\u0010\u001cJ\u000f\u0010N\u001a\u00020MH\u0016\u00a2\u0006\u0004\bN\u0010OJ\u000f\u0010Q\u001a\u00020PH\u0016\u00a2\u0006\u0004\bQ\u0010RR\u001a\u0010S\u001a\b\u0012\u0004\u0012\u00020\u00110E8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bS\u0010TR\u001d\u0010U\u001a\b\u0012\u0004\u0012\u00020\u00120E8\u0006\u00a2\u0006\f\n\u0004\bU\u0010T\u001a\u0004\bV\u0010WR\"\u0010Y\u001a\u0010\u0012\f\u0012\n X*\u0004\u0018\u00010\u00070\u00070E8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bY\u0010TR\"\u0010Z\u001a\u00020P8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\bZ\u0010[\u001a\u0004\b\\\u0010R\"\u0004\b]\u0010^\u00a8\u0006_"}, d2={"Lio/github/lucaargolo/kibe/client/model/TankCustomModel;", "Lnet/minecraft/client/resources/model/UnbakedModel;", "Lnet/minecraft/client/resources/model/BakedModel;", "Lnet/fabricmc/fabric/api/renderer/v1/model/FabricBakedModel;", "<init>", "()V", "", "Lnet/minecraft/resources/ResourceLocation;", "getModelDependencies", "()Ljava/util/Collection;", "Ljava/util/function/Function;", "modelLoader", "", "setParents", "(Ljava/util/function/Function;)V", "Lnet/minecraft/client/resources/model/ModelBaker;", "baker", "Lnet/minecraft/client/resources/model/Material;", "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "textureGetter", "Lnet/minecraft/client/resources/model/ModelState;", "rotationContainer", "bake", "(Lnet/minecraft/client/resources/model/ModelBaker;Ljava/util/function/Function;Lnet/minecraft/client/resources/model/ModelState;)Lnet/minecraft/client/resources/model/BakedModel;", "getParticleSprite", "()Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "", "isVanillaAdapter", "()Z", "Lnet/minecraft/world/level/BlockAndTintGetter;", "world", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "Lnet/minecraft/core/BlockPos;", "pos", "Ljava/util/function/Supplier;", "Lnet/minecraft/util/RandomSource;", "randomSupplier", "Lnet/fabricmc/fabric/api/renderer/v1/render/RenderContext;", "context", "emitBlockQuads", "(Lnet/minecraft/world/level/BlockAndTintGetter;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;Ljava/util/function/Supplier;Lnet/fabricmc/fabric/api/renderer/v1/render/RenderContext;)V", "Lnet/minecraft/core/Direction;", "getLeft", "(Lnet/minecraft/core/Direction;)Lnet/minecraft/core/Direction;", "getRight", "getUp", "getDown", "Lnet/fabricmc/fabric/api/renderer/v1/mesh/QuadEmitter;", "side", "drawSide", "(Lnet/fabricmc/fabric/api/renderer/v1/mesh/QuadEmitter;Lnet/minecraft/core/Direction;Lnet/minecraft/world/level/BlockAndTintGetter;Lnet/minecraft/core/BlockPos;)V", "Lnet/minecraft/world/item/ItemStack;", "stack", "randSupplier", "emitItemQuads", "(Lnet/minecraft/world/item/ItemStack;Ljava/util/function/Supplier;Lnet/fabricmc/fabric/api/renderer/v1/render/RenderContext;)V", "", "left", "bottom", "right", "top", "depth", "draw", "(Lnet/fabricmc/fabric/api/renderer/v1/mesh/QuadEmitter;Lnet/minecraft/core/Direction;FFFFF)V", "sprite", "(Lnet/fabricmc/fabric/api/renderer/v1/mesh/QuadEmitter;Lnet/minecraft/core/Direction;Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;FFFFF)V", "face", "random", "", "Lnet/minecraft/client/renderer/block/model/BakedQuad;", "getQuads", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/Direction;Lnet/minecraft/util/RandomSource;)Ljava/util/List;", "useAmbientOcclusion", "hasDepth", "isSideLit", "isBuiltin", "Lnet/minecraft/client/renderer/block/model/ItemOverrides;", "getOverrides", "()Lnet/minecraft/client/renderer/block/model/ItemOverrides;", "Lnet/minecraft/client/renderer/block/model/ItemTransforms;", "getTransformation", "()Lnet/minecraft/client/renderer/block/model/ItemTransforms;", "spriteIdList", "Ljava/util/List;", "spriteList", "getSpriteList", "()Ljava/util/List;", "kotlin.jvm.PlatformType", "modelIdList", "modelTransformation", "Lnet/minecraft/client/renderer/block/model/ItemTransforms;", "getModelTransformation", "setModelTransformation", "(Lnet/minecraft/client/renderer/block/model/ItemTransforms;)V", "kibe"})
@SourceDebugExtension(value={"SMAP\nTankCustomModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TankCustomModel.kt\nio/github/lucaargolo/kibe/client/model/TankCustomModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,194:1\n1869#2,2:195\n1869#2,2:197\n*S KotlinDebug\n*F\n+ 1 TankCustomModel.kt\nio/github/lucaargolo/kibe/client/model/TankCustomModel\n*L\n53#1:195,2\n73#1:197,2\n*E\n"})
public final class TankCustomModel
implements UnbakedModel,
BakedModel,
FabricBakedModel {
    @NotNull
    private final List<Material> spriteIdList;
    @NotNull
    private final List<TextureAtlasSprite> spriteList;
    @NotNull
    private final List<ResourceLocation> modelIdList;
    public ItemTransforms modelTransformation;

    public TankCustomModel() {
        Object[] objectArray = new Material[]{new Material(InventoryMenu.BLOCK_ATLAS, ModIdentifier.INSTANCE.of("block/tank"))};
        this.spriteIdList = CollectionsKt.mutableListOf((Object[])objectArray);
        this.spriteList = new ArrayList();
        objectArray = new ResourceLocation[]{ResourceLocation.parse((String)"block/stone")};
        this.modelIdList = CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @NotNull
    public final List<TextureAtlasSprite> getSpriteList() {
        return this.spriteList;
    }

    @NotNull
    public Collection<ResourceLocation> getDependencies() {
        return CollectionsKt.emptyList();
    }

    public void resolveParents(@Nullable Function<ResourceLocation, UnbakedModel> modelLoader) {
    }

    @NotNull
    public final ItemTransforms getModelTransformation() {
        ItemTransforms itemTransforms = this.modelTransformation;
        if (itemTransforms != null) {
            return itemTransforms;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"modelTransformation");
        return null;
    }

    public final void setModelTransformation(@NotNull ItemTransforms itemTransforms) {
        Intrinsics.checkNotNullParameter((Object)itemTransforms, (String)"<set-?>");
        this.modelTransformation = itemTransforms;
    }

    @NotNull
    public BakedModel bake(@NotNull ModelBaker baker, @NotNull Function<Material, TextureAtlasSprite> textureGetter, @NotNull ModelState rotationContainer) {
        Intrinsics.checkNotNullParameter((Object)baker, (String)"baker");
        Intrinsics.checkNotNullParameter(textureGetter, (String)"textureGetter");
        Intrinsics.checkNotNullParameter((Object)rotationContainer, (String)"rotationContainer");
        UnbakedModel model = baker.getModel(this.modelIdList.get(0));
        BakedModel bakedModel = model.bake(baker, textureGetter, (ModelState)BlockModelRotation.X0_Y0);
        Intrinsics.checkNotNull((Object)bakedModel);
        BakedModel baked = bakedModel;
        ItemTransforms itemTransforms = baked.getTransforms();
        Intrinsics.checkNotNullExpressionValue((Object)itemTransforms, (String)"getTransformation(...)");
        this.setModelTransformation(itemTransforms);
        Iterable $this$forEach$iv = this.spriteIdList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Material spriteIdentifier = (Material)element$iv;
            boolean bl = false;
            TextureAtlasSprite textureAtlasSprite = textureGetter.apply(spriteIdentifier);
            Intrinsics.checkNotNullExpressionValue((Object)textureAtlasSprite, (String)"apply(...)");
            this.spriteList.add(textureAtlasSprite);
        }
        return this;
    }

    @NotNull
    public TextureAtlasSprite getParticleIcon() {
        return this.spriteList.get(0);
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitBlockQuads(@Nullable BlockAndTintGetter world, @Nullable BlockState state, @NotNull BlockPos pos, @NotNull Supplier<RandomSource> randomSupplier, @NotNull RenderContext context) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter(randomSupplier, (String)"randomSupplier");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int color = new Color(255, 255, 255, 255).getRGB();
        context.pushTransform(arg_0 -> TankCustomModel.emitBlockQuads$lambda$0(color, arg_0));
        QuadEmitter emitter = context.getEmitter();
        Iterable $this$forEach$iv = (Iterable)EntriesMappings.entries$0;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Direction it = (Direction)element$iv;
            boolean bl = false;
            BlockAndTintGetter blockAndTintGetter = world;
            if (Intrinsics.areEqual(blockAndTintGetter != null && (blockAndTintGetter = blockAndTintGetter.getBlockState(pos.offset(it.getNormal()))) != null ? blockAndTintGetter.getBlock() : null, (Object)((Object)BlockCompendium.INSTANCE.getTANK()))) continue;
            Intrinsics.checkNotNull((Object)emitter);
            this.drawSide(emitter, it, world, pos);
        }
        context.popTransform();
    }

    private final Direction getLeft(Direction $this$getLeft) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$getLeft.ordinal()]) {
            case 1 -> Direction.WEST;
            case 2 -> Direction.EAST;
            case 3 -> Direction.NORTH;
            case 4 -> Direction.SOUTH;
            case 5, 6 -> Direction.EAST;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final Direction getRight(Direction $this$getRight) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$getRight.ordinal()]) {
            case 1 -> Direction.EAST;
            case 2 -> Direction.WEST;
            case 3 -> Direction.SOUTH;
            case 4 -> Direction.NORTH;
            case 5, 6 -> Direction.WEST;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final Direction getUp(Direction $this$getUp) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$getUp.ordinal()]) {
            case 5 -> Direction.NORTH;
            case 6 -> Direction.SOUTH;
            default -> Direction.UP;
        };
    }

    private final Direction getDown(Direction $this$getDown) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$getDown.ordinal()]) {
            case 5 -> Direction.SOUTH;
            case 6 -> Direction.NORTH;
            default -> Direction.DOWN;
        };
    }

    private final void drawSide(QuadEmitter $this$drawSide, Direction side, BlockAndTintGetter world, BlockPos pos) {
        boolean bl8;
        BlockAndTintGetter blockAndTintGetter = world;
        boolean bl1 = !Intrinsics.areEqual(blockAndTintGetter != null && (blockAndTintGetter = blockAndTintGetter.getBlockState(pos.offset(this.getUp(side).getNormal()))) != null ? blockAndTintGetter.getBlock() : null, (Object)((Object)BlockCompendium.INSTANCE.getTANK()));
        BlockAndTintGetter blockAndTintGetter2 = world;
        boolean bl2 = !Intrinsics.areEqual(blockAndTintGetter2 != null && (blockAndTintGetter2 = blockAndTintGetter2.getBlockState(pos.offset(this.getDown(side).getNormal()))) != null ? blockAndTintGetter2.getBlock() : null, (Object)((Object)BlockCompendium.INSTANCE.getTANK()));
        BlockAndTintGetter blockAndTintGetter3 = world;
        boolean bl3 = !Intrinsics.areEqual(blockAndTintGetter3 != null && (blockAndTintGetter3 = blockAndTintGetter3.getBlockState(pos.offset(this.getLeft(side).getNormal()))) != null ? blockAndTintGetter3.getBlock() : null, (Object)((Object)BlockCompendium.INSTANCE.getTANK()));
        BlockAndTintGetter blockAndTintGetter4 = world;
        boolean bl4 = !Intrinsics.areEqual(blockAndTintGetter4 != null && (blockAndTintGetter4 = blockAndTintGetter4.getBlockState(pos.offset(this.getRight(side).getNormal()))) != null ? blockAndTintGetter4.getBlock() : null, (Object)((Object)BlockCompendium.INSTANCE.getTANK()));
        BlockAndTintGetter blockAndTintGetter5 = world;
        boolean bl5 = !Intrinsics.areEqual(blockAndTintGetter5 != null && (blockAndTintGetter5 = blockAndTintGetter5.getBlockState(pos.offset(this.getUp(side).getNormal()).offset(this.getLeft(side).getNormal()))) != null ? blockAndTintGetter5.getBlock() : null, (Object)((Object)BlockCompendium.INSTANCE.getTANK()));
        BlockAndTintGetter blockAndTintGetter6 = world;
        boolean bl6 = !Intrinsics.areEqual(blockAndTintGetter6 != null && (blockAndTintGetter6 = blockAndTintGetter6.getBlockState(pos.offset(this.getUp(side).getNormal()).offset(this.getRight(side).getNormal()))) != null ? blockAndTintGetter6.getBlock() : null, (Object)((Object)BlockCompendium.INSTANCE.getTANK()));
        BlockAndTintGetter blockAndTintGetter7 = world;
        boolean bl7 = !Intrinsics.areEqual(blockAndTintGetter7 != null && (blockAndTintGetter7 = blockAndTintGetter7.getBlockState(pos.offset(this.getDown(side).getNormal()).offset(this.getLeft(side).getNormal()))) != null ? blockAndTintGetter7.getBlock() : null, (Object)((Object)BlockCompendium.INSTANCE.getTANK()));
        BlockAndTintGetter blockAndTintGetter8 = world;
        boolean bl = bl8 = !Intrinsics.areEqual(blockAndTintGetter8 != null && (blockAndTintGetter8 = blockAndTintGetter8.getBlockState(pos.offset(this.getDown(side).getNormal()).offset(this.getRight(side).getNormal()))) != null ? blockAndTintGetter8.getBlock() : null, (Object)((Object)BlockCompendium.INSTANCE.getTANK()));
        if (bl1) {
            this.draw($this$drawSide, side, 0.9375f, 1.0f, 0.0625f, 0.9375f, 0.0f);
        }
        if (bl2) {
            this.draw($this$drawSide, side, 0.9375f, 0.0625f, 0.0625f, 0.0f, 0.0f);
        }
        if (bl3) {
            this.draw($this$drawSide, side, 1.0f, 0.9375f, 0.9375f, 0.0625f, 0.0f);
        }
        if (bl4) {
            this.draw($this$drawSide, side, 0.0625f, 0.9375f, 0.0f, 0.0625f, 0.0f);
        }
        if (bl1 || bl3 || bl5) {
            this.draw($this$drawSide, side, 1.0f, 1.0f, 0.9375f, 0.9375f, 0.0f);
        }
        if (bl1 || bl4 || bl6) {
            this.draw($this$drawSide, side, 0.0625f, 1.0f, 0.0f, 0.9375f, 0.0f);
        }
        if (bl2 || bl3 || bl7) {
            this.draw($this$drawSide, side, 1.0f, 0.0625f, 0.9375f, 0.0f, 0.0f);
        }
        if (bl2 || bl4 || bl8) {
            this.draw($this$drawSide, side, 0.0625f, 0.0625f, 0.0f, 0.0f, 0.0f);
        }
    }

    public void emitItemQuads(@NotNull ItemStack stack, @NotNull Supplier<RandomSource> randSupplier, @NotNull RenderContext context) {
        LocalPlayer player;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(randSupplier, (String)"randSupplier");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Minecraft client = Minecraft.getInstance();
        BlockPos blockPos = BlockPos.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"ORIGIN");
        this.emitBlockQuads(null, null, blockPos, randSupplier, context);
        SingleVariantStorage<FluidVariant> fluidTank = TankBlockItem.Companion.getFluidTank(stack);
        LocalPlayer localPlayer = player = client.player;
        Level world = localPlayer != null ? localPlayer.level() : null;
        LocalPlayer localPlayer2 = player;
        BlockPos pos = localPlayer2 != null ? localPlayer2.blockPosition() : null;
        Fluid fluid = ((FluidVariant)fluidTank.getResource()).getFluid();
        FluidRenderHandler fluidRenderHandler = FluidRenderHandlerRegistry.INSTANCE.get(fluid);
        if (fluidRenderHandler == null) {
            return;
        }
        FluidRenderHandler fluidRenderHandler2 = fluidRenderHandler;
        int fluidColor = fluidRenderHandler2.getFluidColor((BlockAndTintGetter)world, pos, fluid.defaultFluidState());
        TextureAtlasSprite fluidSprite = fluidRenderHandler2.getFluidSprites((BlockAndTintGetter)world, pos, fluid.defaultFluidState())[0];
        int color = new Color(fluidColor >> 16 & 0xFF, fluidColor >> 8 & 0xFF, fluidColor & 0xFF).getRGB();
        context.pushTransform(arg_0 -> TankCustomModel.emitItemQuads$lambda$0(color, arg_0));
        QuadEmitter emitter = context.getEmitter();
        float p = (float)fluidTank.amount / 1296000.0f;
        Intrinsics.checkNotNull((Object)emitter);
        Intrinsics.checkNotNull((Object)fluidSprite);
        this.draw(emitter, Direction.UP, fluidSprite, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f - p + 0.001f);
        this.draw(emitter, Direction.DOWN, fluidSprite, 0.0f, 0.0f, 1.0f, 1.0f, 0.001f);
        this.draw(emitter, Direction.NORTH, fluidSprite, 0.0f, 0.0f, 1.0f, p, 0.001f);
        this.draw(emitter, Direction.SOUTH, fluidSprite, 0.0f, 0.0f, 1.0f, p, 0.001f);
        this.draw(emitter, Direction.EAST, fluidSprite, 0.0f, 0.0f, 1.0f, p, 0.001f);
        this.draw(emitter, Direction.WEST, fluidSprite, 0.0f, 0.0f, 1.0f, p, 0.001f);
        context.popTransform();
    }

    private final void draw(QuadEmitter $this$draw, Direction side, float left, float bottom, float right, float top, float depth) {
        this.draw($this$draw, side, this.getParticleIcon(), left, bottom, right, top, depth);
    }

    private final void draw(QuadEmitter $this$draw, Direction side, TextureAtlasSprite sprite, float left, float bottom, float right, float top, float depth) {
        $this$draw.square(side, left, bottom, right, top, depth);
        $this$draw.spriteBake(sprite, 4);
        $this$draw.color(-1, -1, -1, -1);
        $this$draw.emit();
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction face, @Nullable RandomSource random) {
        return new ArrayList();
    }

    public boolean useAmbientOcclusion() {
        return false;
    }

    public boolean isGui3d() {
        return false;
    }

    public boolean usesBlockLight() {
        return false;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    @NotNull
    public ItemOverrides getOverrides() {
        ItemOverrides itemOverrides = ItemOverrides.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)itemOverrides, (String)"EMPTY");
        return itemOverrides;
    }

    @NotNull
    public ItemTransforms getTransforms() {
        return this.getModelTransformation();
    }

    private static final boolean emitBlockQuads$lambda$0(int $color, MutableQuadView quad) {
        quad.color($color, $color, $color, $color);
        return true;
    }

    private static final boolean emitItemQuads$lambda$0(int $color, MutableQuadView quad) {
        quad.color($color, $color, $color, $color);
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Direction> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Direction.values()));
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.NORTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.UP.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.DOWN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

