/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.block;

import com.mojang.serialization.MapCodec;
import io.github.lucaargolo.kibe.block.Drawbridge;
import io.github.lucaargolo.kibe.block.Placer;
import io.github.lucaargolo.kibe.blockentity.DrawbridgeBlockEntity;
import io.github.lucaargolo.kibe.utils.menu.BlockScreenHandlerFactory;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 A2\u00020\u0001:\u0001AB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\u000b\u001a\u00020\n2\u0016\u0010\t\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006H\u0014\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0019\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0012H\u0014\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0016H\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018JC\u0010!\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\u001b2\u0006\u0010 \u001a\u00020\u001fH\u0014\u00a2\u0006\u0004\b!\u0010\"J/\u0010&\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020$H\u0014\u00a2\u0006\u0004\b&\u0010'J\u001f\u0010)\u001a\u00020(2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b)\u0010*J\u0019\u0010+\u001a\u00020\u001f2\b\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0014\u00a2\u0006\u0004\b+\u0010,J'\u0010.\u001a\u00020-2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0014\u00a2\u0006\u0004\b.\u0010/J9\u00101\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00192\b\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0006\u00100\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u001fH\u0014\u00a2\u0006\u0004\b1\u00102J;\u00108\u001a\u0002072\b\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u00104\u001a\u0002032\b\u00106\u001a\u0004\u0018\u000105H\u0014\u00a2\u0006\u0004\b8\u00109J\u0019\u0010;\u001a\u00020:2\b\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0014\u00a2\u0006\u0004\b;\u0010<J\u0015\u0010?\u001a\b\u0012\u0004\u0012\u00020>0=H\u0014\u00a2\u0006\u0004\b?\u0010@\u00a8\u0006B"}, d2={"Lio/github/lucaargolo/kibe/block/Drawbridge;", "Lnet/minecraft/world/level/block/BaseEntityBlock;", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "settings", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/state/BlockState;", "stateManager", "", "appendProperties", "(Lnet/minecraft/world/level/block/state/StateDefinition$Builder;)V", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "ctx", "getPlacementState", "(Lnet/minecraft/world/item/context/BlockPlaceContext;)Lnet/minecraft/world/level/block/state/BlockState;", "state", "Lnet/minecraft/world/level/block/Rotation;", "rotation", "rotate", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/Rotation;)Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/world/level/block/Mirror;", "mirror", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/Mirror;)Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/core/BlockPos;", "pos", "block", "fromPos", "", "notify", "neighborUpdate", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/Block;Lnet/minecraft/core/BlockPos;Z)V", "Lnet/minecraft/server/level/ServerLevel;", "Lnet/minecraft/util/RandomSource;", "random", "scheduledTick", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V", "Lio/github/lucaargolo/kibe/blockentity/DrawbridgeBlockEntity;", "createBlockEntity", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lio/github/lucaargolo/kibe/blockentity/DrawbridgeBlockEntity;", "hasComparatorOutput", "(Lnet/minecraft/world/level/block/state/BlockState;)Z", "", "getComparatorOutput", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)I", "newState", "onStateReplaced", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Z)V", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/phys/BlockHitResult;", "hit", "Lnet/minecraft/world/InteractionResult;", "onUse", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;", "Lnet/minecraft/world/level/block/RenderShape;", "getRenderType", "(Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/level/block/RenderShape;", "Lcom/mojang/serialization/MapCodec;", "Lio/github/lucaargolo/kibe/block/Placer;", "getCodec", "()Lcom/mojang/serialization/MapCodec;", "Companion", "kibe"})
public final class Drawbridge
extends BaseEntityBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final MapCodec<Placer> CODEC;

    public Drawbridge(@NotNull BlockBehaviour.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.TRIGGERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> stateManager) {
        Intrinsics.checkNotNullParameter(stateManager, (String)"stateManager");
        Property[] propertyArray = new Property[]{BlockStateProperties.FACING};
        stateManager.add(propertyArray);
        propertyArray = new Property[]{BlockStateProperties.TRIGGERED};
        stateManager.add(propertyArray);
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)ctx.getNearestLookingDirection().getOpposite());
    }

    @NotNull
    protected BlockState rotate(@NotNull BlockState state, @NotNull Rotation rotation) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)rotation, (String)"rotation");
        Object object = state.setValue((Property)DispenserBlock.FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)DispenserBlock.FACING)));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"with(...)");
        return (BlockState)object;
    }

    @NotNull
    protected BlockState mirror(@NotNull BlockState state, @NotNull Mirror mirror) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)mirror, (String)"mirror");
        BlockState blockState = state.rotate(mirror.getRotation((Direction)state.getValue((Property)DispenserBlock.FACING)));
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"rotate(...)");
        return blockState;
    }

    protected void neighborChanged(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @Nullable Block block, @Nullable BlockPos fromPos, boolean notify) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        boolean isReceivingPower = world.hasNeighborSignal(pos) || world.hasNeighborSignal(pos.above());
        Boolean triggered = (Boolean)state.getValue((Property)DispenserBlock.TRIGGERED);
        if (isReceivingPower && !triggered.booleanValue()) {
            world.scheduleTick(pos, (Block)this, 8);
            world.setBlock(pos, (BlockState)state.setValue((Property)DispenserBlock.TRIGGERED, (Comparable)Boolean.valueOf(true)), 4);
        } else if (!isReceivingPower && triggered.booleanValue()) {
            world.scheduleTick(pos, (Block)this, 8);
            world.setBlock(pos, (BlockState)state.setValue((Property)DispenserBlock.TRIGGERED, (Comparable)Boolean.valueOf(false)), 4);
        }
    }

    protected void tick(@NotNull BlockState state, @NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull RandomSource random) {
        block3: {
            ItemStack itemStack;
            DrawbridgeBlockEntity it;
            Direction facing;
            block4: {
                ItemStack stack;
                block5: {
                    Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                    Intrinsics.checkNotNullParameter((Object)world, (String)"world");
                    Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
                    Intrinsics.checkNotNullParameter((Object)random, (String)"random");
                    facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
                    Boolean triggered = (Boolean)state.getValue((Property)DispenserBlock.TRIGGERED);
                    BlockEntity blockEntity = world.getBlockEntity(pos);
                    DrawbridgeBlockEntity drawbridgeBlockEntity = blockEntity instanceof DrawbridgeBlockEntity ? (DrawbridgeBlockEntity)blockEntity : null;
                    if (drawbridgeBlockEntity == null) break block3;
                    it = drawbridgeBlockEntity;
                    boolean bl = false;
                    if (!triggered.booleanValue()) break block4;
                    stack = it.getItem(0);
                    BlockState front = world.getBlockState(pos.relative(facing));
                    if (front.isAir()) break block5;
                    BlockPos blockPos = pos.relative(facing);
                    Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"offset(...)");
                    Intrinsics.checkNotNull((Object)front);
                    if (!Drawbridge.Companion.isSameBlock(stack, world, blockPos, front)) break block3;
                }
                Intrinsics.checkNotNull((Object)facing);
                int distance = Drawbridge.Companion.sameBlockDistance(stack, world, pos, facing);
                if (!stack.isEmpty() && distance < stack.getMaxStackSize()) {
                    BlockPos blockPos = pos.relative(facing, distance + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"offset(...)");
                    Drawbridge.Companion.placeBlock(stack, world, blockPos, facing);
                    world.playSound(null, pos, SoundEvents.PISTON_EXTEND, SoundSource.BLOCKS, 1.0f, world.random.nextFloat() * 0.25f + 0.6f);
                    world.scheduleTick(pos, (Block)this, 8);
                }
                break block3;
            }
            ItemStack stack = it.getItem(0);
            boolean bl = false;
            if (stack.isEmpty()) {
                ItemStack blockStack;
                BlockPos blockPos = pos.relative(facing);
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"offset(...)");
                itemStack = blockStack = Drawbridge.Companion.stackFromBlock(world, blockPos);
            } else {
                itemStack = stack;
            }
            ItemStack stack2 = itemStack;
            Intrinsics.checkNotNull((Object)facing);
            int distance = Drawbridge.Companion.sameBlockDistance(stack2, world, pos, facing);
            if (distance <= 0 || stack2.isEmpty() || stack2.getCount() >= stack2.getMaxStackSize()) break block3;
            Level level = (Level)world;
            BlockPos blockPos = pos.relative(facing, distance);
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"offset(...)");
            Drawbridge.Companion.breakBlock(stack2, level, blockPos, it);
            world.playSound(null, pos, SoundEvents.PISTON_CONTRACT, SoundSource.BLOCKS, 1.0f, world.random.nextFloat() * 0.25f + 0.6f);
            world.scheduleTick(pos, (Block)this, 8);
        }
    }

    @NotNull
    public DrawbridgeBlockEntity createBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new DrawbridgeBlockEntity(pos, state);
    }

    protected boolean hasAnalogOutputSignal(@Nullable BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)world.getBlockEntity(pos));
    }

    protected void onRemove(@NotNull BlockState state, @NotNull Level world, @Nullable BlockPos pos, @NotNull BlockState newState, boolean notify) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            Container container = blockEntity instanceof Container ? (Container)blockEntity : null;
            if (container != null) {
                Container it = container;
                boolean bl = false;
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)it);
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, notify);
        }
    }

    @NotNull
    protected InteractionResult useWithoutItem(@Nullable BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @Nullable BlockHitResult hit) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        player.openMenu((MenuProvider)new BlockScreenHandlerFactory((Block)this, pos, onUse.1.INSTANCE));
        return InteractionResult.SUCCESS;
    }

    @NotNull
    protected RenderShape getRenderShape(@Nullable BlockState state) {
        return RenderShape.MODEL;
    }

    @NotNull
    protected MapCodec<Placer> codec() {
        return CODEC;
    }

    static {
        MapCodec mapCodec = BaseEntityBlock.simpleCodec(Placer::new);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"createCodec(...)");
        CODEC = mapCodec;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ/\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J/\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J'\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J/\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u001cJ\u001f\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ'\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001fJ\u001f\u0010 \u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b \u0010!R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020#0\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Lio/github/lucaargolo/kibe/block/Drawbridge$Companion;", "", "<init>", "()V", "Lnet/minecraft/world/item/ItemStack;", "stack", "Lnet/minecraft/server/level/ServerLevel;", "world", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/core/Direction;", "facing", "", "placeBlock", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)V", "Lnet/minecraft/world/level/Level;", "Lio/github/lucaargolo/kibe/blockentity/DrawbridgeBlockEntity;", "blockEntity", "breakBlock", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lio/github/lucaargolo/kibe/blockentity/DrawbridgeBlockEntity;)V", "", "sameBlockDistance", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)I", "", "isSameBlock", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;)Z", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Z", "stackFromBlock", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/item/ItemStack;", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/item/ItemStack;", "silkTouchStack", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/item/ItemStack;", "Lcom/mojang/serialization/MapCodec;", "Lio/github/lucaargolo/kibe/block/Placer;", "CODEC", "Lcom/mojang/serialization/MapCodec;", "kibe"})
    public static final class Companion {
        private Companion() {
        }

        private final void placeBlock(ItemStack stack, ServerLevel world, BlockPos pos, Direction facing) {
            block0: {
                FakePlayer fakePlayer = FakePlayer.get((ServerLevel)world);
                fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, stack);
                Vec3 fakeHitPos = new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.0, (double)pos.getZ() + 0.5);
                Item item = stack.getItem();
                BlockItem blockItem = item instanceof BlockItem ? (BlockItem)item : null;
                if (blockItem == null) break block0;
                blockItem.useOn(new UseOnContext((Player)fakePlayer, InteractionHand.MAIN_HAND, new BlockHitResult(fakeHitPos, facing.getOpposite(), pos, false)));
            }
        }

        private final void breakBlock(ItemStack stack, Level world, BlockPos pos, DrawbridgeBlockEntity blockEntity) {
            world.destroyBlock(pos, false);
            if (Intrinsics.areEqual((Object)stack, (Object)blockEntity.getItem(0))) {
                stack.grow(1);
            } else {
                blockEntity.setItem(0, stack.copy());
            }
        }

        private final int sameBlockDistance(ItemStack stack, ServerLevel world, BlockPos pos, Direction facing) {
            int distance;
            for (distance = 0; distance < stack.getMaxStackSize(); ++distance) {
                BlockPos blockPos = pos.relative(facing, distance + 1);
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"offset(...)");
                if (!this.isSameBlock(stack, world, blockPos)) break;
            }
            return distance;
        }

        private final boolean isSameBlock(ItemStack stack, ServerLevel world, BlockPos pos) {
            return ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)this.stackFromBlock(world, pos));
        }

        private final boolean isSameBlock(ItemStack stack, ServerLevel world, BlockPos pos, BlockState state) {
            return ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)this.stackFromBlock(world, pos, state));
        }

        private final ItemStack stackFromBlock(ServerLevel world, BlockPos pos) {
            BlockState state = world.getBlockState(pos);
            Intrinsics.checkNotNull((Object)state);
            return this.stackFromBlock(world, pos, state);
        }

        private final ItemStack stackFromBlock(ServerLevel world, BlockPos pos, BlockState state) {
            BlockEntity entity = world.getBlockEntity(pos);
            List list = BaseEntityBlock.getDrops((BlockState)state, (ServerLevel)world, (BlockPos)pos, (BlockEntity)entity, null, (ItemStack)this.silkTouchStack((Level)world, state));
            if (list.size() == 1) {
                Intrinsics.checkNotNull((Object)list);
                ItemStack stack = (ItemStack)CollectionsKt.first((List)list);
                if (stack.getCount() == 1 && stack.getItem() instanceof BlockItem) {
                    Intrinsics.checkNotNull((Object)stack);
                    return stack;
                }
            }
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }

        private final ItemStack silkTouchStack(Level world, BlockState state) {
            ItemStack itemStack;
            Item item = Items.STICK;
            state.getTags().forEach(arg_0 -> Companion.silkTouchStack$lambda$1(Companion::silkTouchStack$lambda$0, arg_0));
            ItemStack it = itemStack = item.getDefaultInstance();
            boolean bl = false;
            it.enchant((Holder)world.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolder(Enchantments.SILK_TOUCH).get(), 1);
            ItemStack itemStack2 = itemStack;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"also(...)");
            return itemStack2;
        }

        private static final Unit silkTouchStack$lambda$0(TagKey it) {
            TagKey tagKey = it;
            if (Intrinsics.areEqual((Object)tagKey, (Object)BlockTags.MINEABLE_WITH_SHOVEL)) {
            } else if (Intrinsics.areEqual((Object)tagKey, (Object)BlockTags.MINEABLE_WITH_AXE)) {
            } else if (Intrinsics.areEqual((Object)tagKey, (Object)BlockTags.MINEABLE_WITH_PICKAXE)) {
            } else if (Intrinsics.areEqual((Object)tagKey, (Object)BlockTags.MINEABLE_WITH_HOE)) {
            }
            return Unit.INSTANCE;
        }

        private static final void silkTouchStack$lambda$1(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

