/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import io.github.lucaargolo.kibe.block.BlockCompendium;
import io.github.lucaargolo.kibe.blockentity.BlockEntityCompendium;
import io.github.lucaargolo.kibe.client.KibeModClient;
import io.github.lucaargolo.kibe.data.component.ComponentTypeCompendium;
import io.github.lucaargolo.kibe.data.state.ChunkLoaderState;
import io.github.lucaargolo.kibe.datagen.KibeDatagen;
import io.github.lucaargolo.kibe.effect.EffectCompendium;
import io.github.lucaargolo.kibe.entity.EntityCompendium;
import io.github.lucaargolo.kibe.fluid.FluidCompendium;
import io.github.lucaargolo.kibe.item.ArmorMaterialCompendium;
import io.github.lucaargolo.kibe.item.ItemCompendium;
import io.github.lucaargolo.kibe.menu.ScreenHandlerCompendium;
import io.github.lucaargolo.kibe.network.PacketCompendium;
import io.github.lucaargolo.kibe.particle.ParticleCompendium;
import io.github.lucaargolo.kibe.recipes.RecipeSerializerCompendium;
import io.github.lucaargolo.kibe.recipes.RecipeTypeCompendium;
import io.github.lucaargolo.kibe.utils.CreativeTab;
import io.github.lucaargolo.kibe.utils.EntangledChestOpenState;
import io.github.lucaargolo.kibe.utils.EntangledTankSync;
import io.github.lucaargolo.kibe.utils.ModConfig;
import io.github.lucaargolo.kibe.utils.RegistryCompendium;
import io.github.lucaargolo.kibe.utils.helper.LootHelper;
import io.github.lucaargolo.kibe.utils.helper.TooltipHelper;
import io.github.lucaargolo.kibe.utils.helper.TransferHelper;
import io.netty.buffer.ByteBuf;
import java.io.Closeable;
import java.io.File;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.DyeColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import thedarkcolour.kotlinforforge.neoforge.KotlinModLoadingContext;

@Mod(value="kibe")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0006\u001a\u00020\u0005*\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0010\u001a\u00020\n\u00a2\u0006\u0004\b\u0010\u0010\u0003R\u0014\u0010\u0012\u001a\u00020\u00118\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00118\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0013R\u0017\u0010\u0016\u001a\u00020\u00158\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R;\u0010\u001d\u001a&\u0012\f\u0012\n \u001c*\u0004\u0018\u00010\u001b0\u001b \u001c*\u0012\u0012\f\u0012\n \u001c*\u0004\u0018\u00010\u001b0\u001b\u0018\u00010\u001a0\u001a8\u0006\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 R#\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0!8\u0006\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'R\u001b\u0010,\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+R\u001b\u0010/\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b-\u0010)\u001a\u0004\b.\u0010+R\u0017\u00101\u001a\u0002008\u0006\u00a2\u0006\f\n\u0004\b1\u00102\u001a\u0004\b3\u00104R\u001b\u00109\u001a\u0002058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b6\u0010)\u001a\u0004\b7\u00108\u00a8\u0006:"}, d2={"Lio/github/lucaargolo/kibe/KibeMod;", "", "<init>", "()V", "", "", "toInt", "(Z)I", "Lnet/neoforged/neoforge/data/event/GatherDataEvent;", "event", "", "onDataGen", "(Lnet/neoforged/neoforge/data/event/GatherDataEvent;)V", "Lnet/neoforged/fml/event/lifecycle/FMLCommonSetupEvent;", "onCommonSetup", "(Lnet/neoforged/fml/event/lifecycle/FMLCommonSetupEvent;)V", "initChunkLoaderData", "", "MOD_ID", "Ljava/lang/String;", "MOD_NAME", "Ljava/util/UUID;", "FAKE_PLAYER_UUID", "Ljava/util/UUID;", "getFAKE_PLAYER_UUID", "()Ljava/util/UUID;", "Lnet/minecraft/core/NonNullList;", "Lnet/minecraft/world/item/DyeColor;", "kotlin.jvm.PlatformType", "DEFAULT_RUNE_SET", "Lnet/minecraft/core/NonNullList;", "getDEFAULT_RUNE_SET", "()Lnet/minecraft/core/NonNullList;", "Lnet/minecraft/network/codec/StreamCodec;", "Lio/netty/buffer/ByteBuf;", "", "LONG_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "getLONG_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "CLIENT$delegate", "Lkotlin/Lazy;", "getCLIENT", "()Z", "CLIENT", "TRINKET$delegate", "getTRINKET", "TRINKET", "Lorg/apache/logging/log4j/Logger;", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "getLOGGER", "()Lorg/apache/logging/log4j/Logger;", "Lio/github/lucaargolo/kibe/utils/ModConfig;", "CONFIG$delegate", "getCONFIG", "()Lio/github/lucaargolo/kibe/utils/ModConfig;", "CONFIG", "kibe"})
@SourceDebugExtension(value={"SMAP\nKibeMod.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KibeMod.kt\nio/github/lucaargolo/kibe/KibeMod\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Forge.kt\nthedarkcolour/kotlinforforge/neoforge/forge/ForgeKt\n*L\n1#1,142:1\n1869#2,2:143\n1#3:145\n24#4:146\n24#4:147\n65#4:148\n37#4:149\n66#4,3:150\n*S KotlinDebug\n*F\n+ 1 KibeMod.kt\nio/github/lucaargolo/kibe/KibeMod\n*L\n124#1:143,2\n100#1:146\n101#1:147\n120#1:148\n120#1:149\n120#1:150,3\n*E\n"})
public final class KibeMod {
    @NotNull
    public static final KibeMod INSTANCE = new KibeMod();
    @NotNull
    public static final String MOD_ID = "kibe";
    @NotNull
    public static final String MOD_NAME = "Kibe";
    @NotNull
    private static final UUID FAKE_PLAYER_UUID;
    private static final NonNullList<DyeColor> DEFAULT_RUNE_SET;
    @NotNull
    private static final StreamCodec<ByteBuf, Long> LONG_CODEC;
    @NotNull
    private static final Lazy CLIENT$delegate;
    @NotNull
    private static final Lazy TRINKET$delegate;
    @NotNull
    private static final Logger LOGGER;
    @NotNull
    private static final Lazy CONFIG$delegate;

    private KibeMod() {
    }

    @NotNull
    public final UUID getFAKE_PLAYER_UUID() {
        return FAKE_PLAYER_UUID;
    }

    public final NonNullList<DyeColor> getDEFAULT_RUNE_SET() {
        return DEFAULT_RUNE_SET;
    }

    @NotNull
    public final StreamCodec<ByteBuf, Long> getLONG_CODEC() {
        return LONG_CODEC;
    }

    public final boolean getCLIENT() {
        Lazy lazy = CLIENT$delegate;
        return (Boolean)lazy.getValue();
    }

    public final boolean getTRINKET() {
        Lazy lazy = TRINKET$delegate;
        return (Boolean)lazy.getValue();
    }

    @NotNull
    public final Logger getLOGGER() {
        return LOGGER;
    }

    @NotNull
    public final ModConfig getCONFIG() {
        Lazy lazy = CONFIG$delegate;
        return (ModConfig)lazy.getValue();
    }

    public final int toInt(boolean $this$toInt) {
        return $this$toInt ? 1 : 0;
    }

    public final void onDataGen(@NotNull GatherDataEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Iterable $this$forEach$iv = RegistryCompendium.Companion.getLazyTags();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Lazy it = (Lazy)element$iv;
            boolean bl = false;
            it.getValue();
        }
        FabricDataGenerator generator = new FabricDataGenerator(event.getGenerator(), event.getGenerator().getPackOutput().getOutputFolder(), (ModContainer)FabricLoader.getInstance().getModContainer(MOD_ID).get(), false, event.getLookupProvider());
        KibeDatagen.INSTANCE.onInitializeDataGenerator(generator);
    }

    private final void onCommonSetup(FMLCommonSetupEvent event) {
        TransferHelper.INSTANCE.initialize();
        TooltipHelper.INSTANCE.initialize();
        LootHelper.INSTANCE.initialize();
    }

    public final void initChunkLoaderData() {
        ServerLifecycleEvents.SERVER_STARTED.register(KibeMod::initChunkLoaderData$lambda$0);
    }

    private static final boolean CLIENT_delegate$lambda$0() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    private static final boolean TRINKET_delegate$lambda$0() {
        return FabricLoader.getInstance().isModLoaded("curios");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ModConfig CONFIG_delegate$lambda$0() {
        ModConfig finalConfig;
        block9: {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            File configFile = new File(FabricLoader.getInstance().getConfigDir() + File.separator + "kibe.json");
            finalConfig = null;
            LOGGER.info("[Kibe] Trying to read config file...");
            try {
                if (configFile.createNewFile()) {
                    LOGGER.info("[Kibe] No config file found, creating a new one...");
                    String string = gson.toJson(JsonParser.parseString((String)gson.toJson((Object)new ModConfig())));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
                    String json = string;
                    Closeable closeable = new PrintWriter(configFile);
                    Throwable throwable = null;
                    try {
                        PrintWriter out = (PrintWriter)closeable;
                        boolean bl = false;
                        out.println(json);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    finalConfig = new ModConfig();
                    LOGGER.info("[Kibe] Successfully created default config file.");
                    break block9;
                }
                LOGGER.info("[Kibe] A config file was found, loading it..");
                byte[] byArray = Files.readAllBytes(configFile.toPath());
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
                byte[] byArray2 = byArray;
                Object object = gson.fromJson(new String(byArray2, Charsets.UTF_8), ModConfig.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
                finalConfig = (ModConfig)object;
                LOGGER.info("[Kibe] Successfully loaded config file.");
            }
            catch (Exception exception) {
                LOGGER.error("[Kibe] There was an error creating/loading the config file!", (Throwable)exception);
                finalConfig = new ModConfig();
                LOGGER.warn("[Kibe] Defaulting to original config.");
            }
        }
        return finalConfig;
    }

    private static final void initChunkLoaderData$lambda$0(MinecraftServer server) {
        Intrinsics.checkNotNull((Object)server);
        ChunkLoaderState.Companion.getPersistentState(server);
    }

    static {
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        FAKE_PLAYER_UUID = uUID;
        DEFAULT_RUNE_SET = NonNullList.withSize((int)8, (Object)DyeColor.WHITE);
        LONG_CODEC = (StreamCodec)new StreamCodec<ByteBuf, Long>(){

            public Long decode(ByteBuf byteBuf) {
                Intrinsics.checkNotNullParameter((Object)byteBuf, (String)"byteBuf");
                return byteBuf.readLong();
            }

            public void encode(ByteBuf byteBuf, long l) {
                Intrinsics.checkNotNullParameter((Object)byteBuf, (String)"byteBuf");
                byteBuf.writeLong(l);
            }
        };
        CLIENT$delegate = LazyKt.lazy(KibeMod::CLIENT_delegate$lambda$0);
        TRINKET$delegate = LazyKt.lazy(KibeMod::TRINKET_delegate$lambda$0);
        Logger logger = LogManager.getLogger((String)MOD_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
        CONFIG$delegate = LazyKt.lazy(KibeMod::CONFIG_delegate$lambda$0);
        boolean $i$f$getMOD_BUS = false;
        KotlinModLoadingContext.Companion.get().getKEventBus().addListener(INSTANCE::onDataGen);
        $i$f$getMOD_BUS = false;
        KotlinModLoadingContext.Companion.get().getKEventBus().addListener(INSTANCE::onCommonSetup);
        ModConfig.Companion.initialize();
        CreativeTab.INSTANCE.initialize();
        RecipeSerializerCompendium.INSTANCE.initialize();
        RecipeTypeCompendium.INSTANCE.initialize();
        ArmorMaterialCompendium.INSTANCE.initialize();
        FluidCompendium.INSTANCE.initialize();
        BlockCompendium.INSTANCE.initialize();
        ItemCompendium.INSTANCE.initialize();
        ComponentTypeCompendium.INSTANCE.initialize();
        BlockEntityCompendium.INSTANCE.initialize();
        ScreenHandlerCompendium.INSTANCE.initialize();
        EntityCompendium.INSTANCE.initialize();
        EffectCompendium.INSTANCE.initialize();
        ParticleCompendium.INSTANCE.initialize();
        PacketCompendium.INSTANCE.initialize();
        EntangledTankSync.INSTANCE.initialize();
        EntangledChestOpenState.INSTANCE.initialize();
        INSTANCE.initChunkLoaderData();
        boolean $i$f$runForDist = false;
        boolean $i$f$getDIST = false;
        Dist dist = FMLEnvironment.dist;
        Intrinsics.checkNotNullExpressionValue((Object)dist, (String)"dist");
        if (dist == Dist.CLIENT) {
            boolean bl = false;
            v3 = KibeModClient.INSTANCE;
        } else {
            boolean bl = false;
            v3 = INSTANCE;
        }
    }
}

