/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.tile;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.inventory.container.CCLMenuType;
import codechicken.lib.vec.Vector3;
import mrtjp.projectred.core.init.CoreItems;
import mrtjp.projectred.core.inventory.BaseContainer;
import mrtjp.projectred.core.tile.IPacketReceiverBlockEntity;
import mrtjp.projectred.fabrication.engine.ICInterfaceType;
import mrtjp.projectred.fabrication.init.FabricationBlocks;
import mrtjp.projectred.fabrication.inventory.container.PackagingTableMenu;
import mrtjp.projectred.fabrication.item.ValidDieItem;
import mrtjp.projectred.fabrication.item.component.ICDataComponent;
import mrtjp.projectred.fabrication.tile.FabricationMachineBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class PackagingTableBlockEntity
extends FabricationMachineBlockEntity
implements IPacketReceiverBlockEntity {
    private static final int DIE_SLOT = 4;
    private static final int OUTPUT_SLOT = 9;
    private final BaseContainer inventory = new BaseContainer(this, 10){

        public boolean canPlaceItem(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 4 -> stack.getItem() instanceof ValidDieItem;
                case 9 -> false;
                default -> true;
            };
        }
    };
    private int problematicSlotMask = 0;

    public PackagingTableBlockEntity(BlockPos pos, BlockState state) {
        super(FabricationBlocks.PACKAGING_TABLE_BLOCK_ENTITY.get(), pos, state);
        this.inventory.addListener(this::onInventoryChanged);
    }

    public Container getInventory() {
        return this.inventory;
    }

    @Override
    public void saveToNBT(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.saveToNBT(tag, lookupProvider);
        this.inventory.saveTo(tag, "inventory", lookupProvider);
    }

    @Override
    public void loadFromNBT(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.loadFromNBT(tag, lookupProvider);
        this.inventory.loadFrom(tag, "inventory", lookupProvider);
    }

    public void writeDesc(MCDataOutput out) {
    }

    public void readDesc(MCDataInput in) {
    }

    public ItemInteractionResult useItemOn(ItemStack itemStack, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!this.getLevel().isClientSide) {
            CCLMenuType.openMenu((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((id, inv, p) -> new PackagingTableMenu(inv, this, id), (Component)this.getBlockState().getBlock().getName()), p -> p.writePos(this.getBlockPos()));
        }
        return ItemInteractionResult.sidedSuccess((boolean)this.getLevel().isClientSide);
    }

    public void onBlockRemoved() {
        super.onBlockRemoved();
        PackagingTableBlockEntity.dropInventory((Container)this.inventory, (Level)this.getLevel(), (Vector3)Vector3.fromBlockPos((BlockPos)this.getBlockPos()));
    }

    private void onInventoryChanged(Container inventory) {
        this.cancelWorkIfNeeded();
        this.setChanged();
    }

    @Override
    protected boolean canStartWork() {
        int[] cornerSlots;
        this.problematicSlotMask = 0;
        ItemStack dieItem = this.inventory.getItem(4);
        ICDataComponent component = ICDataComponent.getComponent(dieItem);
        if (dieItem.isEmpty() || !(dieItem.getItem() instanceof ValidDieItem) || component == null) {
            this.problematicSlotMask |= 0x10;
            return false;
        }
        if (!this.inventory.getItem(9).isEmpty()) {
            this.problematicSlotMask |= 0x200;
        }
        int[] slotMap = new int[]{1, 5, 7, 3};
        for (int r = 0; r < 4; ++r) {
            ICInterfaceType type = component.getInterfaceSpec().getInterfaceType(r);
            ItemStack itemStack = this.inventory.getItem(slotMap[r]);
            boolean match = itemStack.is(switch (type) {
                default -> throw new MatchException(null, null);
                case ICInterfaceType.NC -> (Item)CoreItems.PLATE_ITEM.get();
                case ICInterfaceType.REDSTONE, ICInterfaceType.ANALOG -> (Item)CoreItems.CONDUCTIVE_PLATE_ITEM.get();
                case ICInterfaceType.BUNDLED -> (Item)CoreItems.BUNDLED_PLATE_ITEM.get();
            });
            if (match) continue;
            this.problematicSlotMask |= 1 << slotMap[r];
        }
        for (int slot : cornerSlots = new int[]{0, 2, 6, 8}) {
            if (this.inventory.getItem(slot).is((Item)CoreItems.PLATE_ITEM.get())) continue;
            this.problematicSlotMask |= 1 << slot;
        }
        return this.problematicSlotMask == 0;
    }

    @Override
    protected int startWork() {
        return 400;
    }

    @Override
    protected int tickWork(int remainingWork) {
        if (this.canConductorWork()) {
            this.conductor.applyPower(-100.0);
            return 1;
        }
        return 0;
    }

    @Override
    protected void finishWork() {
        ItemStack gatePart = ValidDieItem.createGatePart(this.inventory.getItem(4));
        this.inventory.setItem(9, gatePart);
        for (int i = 0; i < 9; ++i) {
            this.inventory.removeItem(i, 1);
        }
    }

    public int getProblematicSlotMask() {
        return this.problematicSlotMask;
    }
}

