/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.function.Supplier;
import mrtjp.projectred.lib.Point;
import mrtjp.projectred.lib.Rect;
import mrtjp.projectred.redui.AbstractGuiNode;
import mrtjp.projectred.redui.RedUINode;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class VerticalListNode
extends AbstractGuiNode {
    private static final int TITLE_LINE_HEIGHT = 16;
    private static final int TEXT_LINE_HEIGHT = 12;
    private static final int TEXT_LEFT_PAD = 5;
    private static final int NODE_ROW_VERTICAL_PAD = 2;
    private int listHeight = 0;

    public void onSubTreePreDrawBack() {
        Rect gl11Rect = this.calculateGL11Frame();
        RenderSystem.enableScissor((int)gl11Rect.x(), (int)gl11Rect.y(), (int)gl11Rect.width(), (int)gl11Rect.height());
    }

    public void onSubTreePostDrawBack() {
        RenderSystem.disableScissor();
    }

    public void drawBack(GuiGraphics graphics, Point mouse, float partialFrame) {
        graphics.fill(this.getFrame().x(), this.getFrame().y(), this.getFrame().x() + this.getFrame().width(), this.getFrame().y() + this.getFrame().height(), 0x7F000000);
    }

    public void sortElementsVertically() {
        this.positionElementsAt(0);
    }

    public boolean canScroll() {
        Rect subFrame = this.calculateChildrenFrame();
        return subFrame.height() <= this.calculateAccumulatedFrame().height();
    }

    public double getScrollPercentage() {
        Rect subFrame = this.calculateChildrenFrame();
        if (subFrame.height() <= this.calculateAccumulatedFrame().height()) {
            return 0.0;
        }
        int totalScroll = subFrame.height() - this.getFrame().height();
        int dist = subFrame.maxY() - this.getFrame().maxY();
        return (double)(totalScroll - dist) / (double)totalScroll;
    }

    public void setScrollPercentage(double scrollPercentage) {
        Rect subFrame = this.calculateChildrenFrame();
        if (subFrame.height() <= this.getFrame().height()) {
            return;
        }
        int totalScroll = subFrame.height() - this.getFrame().height();
        int dist = (int)((double)totalScroll * scrollPercentage);
        this.positionElementsAt(-dist);
    }

    protected void positionChildNode(RedUINode node, int x, int y) {
        if (node instanceof AbstractGuiNode) {
            ((AbstractGuiNode)node).setPosition(x, y);
        }
    }

    private void positionElementsAt(int y) {
        for (RedUINode node : this.getOurChildren()) {
            this.positionChildNode(node, 0, y);
            y += node.calculateAccumulatedFrame().height();
        }
    }

    private void positionAndAddChildListElement(RedUINode node) {
        this.positionChildNode(node, 0, this.listHeight);
        this.listHeight += node.calculateAccumulatedFrame().height();
        this.addChild(node);
    }

    public void addTitleRow(Component title) {
        TitleRow titleNode = new TitleRow(title);
        titleNode.setSize(this.getFrame().width(), 16);
        this.positionAndAddChildListElement((RedUINode)new RowNode(this, 0, new RedUINode[]{titleNode}));
    }

    public void addKeyValueRow(Component key, Supplier<Component> valueSupplier) {
        TextNode keyNode = new TextNode(key);
        keyNode.setSize(this.getFrame().width() / 2, 12);
        keyNode.setPadding(5);
        TextNode valueNode = new TextNode(valueSupplier);
        valueNode.setSize(this.getFrame().width() / 2, 12);
        valueNode.setPadding(5);
        this.positionAndAddChildListElement((RedUINode)new RowNode(this, 0, new RedUINode[]{keyNode, valueNode}));
    }

    public void addTextWithNodeRow(Component key, RedUINode node) {
        TextNode textNode = new TextNode(key);
        textNode.setSize(this.getFrame().width() / 2, Math.max(12, node.calculateAccumulatedFrame().height()));
        textNode.setPadding(5);
        this.positionAndAddChildListElement((RedUINode)new RowNode(this, 2, new RedUINode[]{textNode, node}));
    }

    public void addSingleNodeRow(RedUINode node) {
        this.positionAndAddChildListElement((RedUINode)new RowNode(this, 2, node));
    }

    private static class TitleRow
    extends AbstractGuiNode {
        private static final int TITLE_COLOR = -1;
        private final Component title;

        public TitleRow(Component title) {
            this.title = title;
        }

        public void drawBack(GuiGraphics graphics, Point mouse, float partialFrame) {
            graphics.fill(this.getFrame().x(), this.getFrame().y(), this.getFrame().x() + this.getFrame().width(), this.getFrame().y() + 1, -16777216);
            Font fontRenderer = this.getRoot().getFontRenderer();
            int x = this.getFrame().midX() - fontRenderer.width((FormattedText)this.title) / 2;
            int n = this.getFrame().midY();
            Objects.requireNonNull(fontRenderer);
            int y = n - 9 / 2;
            graphics.drawString(fontRenderer, this.title, x, y, -1);
            graphics.fill(this.getFrame().x(), this.getFrame().y() + this.getFrame().height() - 1, this.getFrame().x() + this.getFrame().width(), this.getFrame().y() + this.getFrame().height(), -16777216);
        }
    }

    private class RowNode
    extends AbstractGuiNode {
        public RowNode(VerticalListNode verticalListNode, int verticalPadding, RedUINode ... rowElements) {
            int x = 0;
            int maxH = 0;
            for (RedUINode node : rowElements) {
                verticalListNode.positionChildNode(node, x, verticalPadding);
                Rect childFrame = node.calculateAccumulatedFrame();
                maxH = Math.max(maxH, childFrame.height());
                x += childFrame.width();
                this.addChild(node);
            }
            this.setSize(x, maxH + verticalPadding * 2);
        }
    }

    private static class TextNode
    extends AbstractGuiNode {
        private final Supplier<Component> textSupplier;
        private HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEFT;
        private VerticalAlignment verticalAlignment = VerticalAlignment.CENTER;
        private int padding = 4;
        private int textColor = -1;

        public TextNode(Supplier<Component> textSupplier) {
            this.textSupplier = textSupplier;
        }

        public TextNode(Component text) {
            this(() -> text);
        }

        public void setTextColor(int textColor) {
            this.textColor = textColor;
        }

        public void setPadding(int padding) {
            this.padding = padding;
        }

        public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
            this.horizontalAlignment = horizontalAlignment;
        }

        public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
            this.verticalAlignment = verticalAlignment;
        }

        public void drawBack(GuiGraphics graphics, Point mouse, float partialFrame) {
            Font fontRenderer = this.getRoot().getFontRenderer();
            Component text = this.textSupplier.get();
            int x = this.getXForAlignment(fontRenderer, text);
            int y = this.getYForAlignment(fontRenderer);
            graphics.drawString(fontRenderer, text, x, y, this.textColor);
        }

        private Rect getPaddedFrame() {
            return this.getFrame().expand(-this.padding, -this.padding);
        }

        private int getXForAlignment(Font fontRenderer, Component text) {
            return switch (this.horizontalAlignment.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> this.getPaddedFrame().x();
                case 1 -> this.getPaddedFrame().midX() - fontRenderer.width((FormattedText)text) / 2;
                case 2 -> this.getPaddedFrame().maxX() - fontRenderer.width((FormattedText)text);
            };
        }

        private int getYForAlignment(Font fontRenderer) {
            return switch (this.verticalAlignment.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> this.getPaddedFrame().y();
                case 1 -> {
                    int v1 = this.getPaddedFrame().midY();
                    Objects.requireNonNull(fontRenderer);
                    yield v1 - 9 / 2;
                }
                case 2 -> {
                    int v2 = this.getPaddedFrame().maxY();
                    Objects.requireNonNull(fontRenderer);
                    yield v2 - 9;
                }
            };
        }

        public static enum HorizontalAlignment {
            LEFT,
            CENTER,
            RIGHT;

        }

        public static enum VerticalAlignment {
            TOP,
            CENTER,
            BOTTOM;

        }
    }
}

