/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.gui;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.RedundantTransformation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import mrtjp.fengine.TileCoord;
import mrtjp.projectred.fabrication.editor.ICWorkbenchEditor;
import mrtjp.projectred.fabrication.engine.BaseTile;
import mrtjp.projectred.fabrication.gui.ICRenderTypes;
import mrtjp.projectred.fabrication.gui.LinearVectorAnimation;
import mrtjp.projectred.lib.Point;
import mrtjp.projectred.lib.Vec2;
import mrtjp.projectred.redui.ViewportRenderNode;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;

public class ICRenderNode
extends ViewportRenderNode {
    private static final int ZOOM_ANIMATION_TIME_MS = 100;
    private static final int LAYER_ANIMATION_TIME_MS = 200;
    private static final int CAMERA_ANIMATION_TIME_MS = 100;
    private static final int FOCUS_ANIMATION_TIME_MS = 400;
    private static final int ZOOM_DIST_MAX = 18;
    private static final int ZOOM_DIST_MIN = 2;
    private final ICWorkbenchEditor editor;
    private final IICRenderNodeEventReceiver eventReceiver;
    private final Vector3 cameraPosition = new Vector3();
    private final LinearVectorAnimation cameraLayerAnimator = new LinearVectorAnimation();
    private final LinearVectorAnimation cameraZoomAnimator = new LinearVectorAnimation(0.0, 8.0, 0.0);
    private int currentLayer = 0;
    private Point lastMousePos = Point.ZERO;

    public ICRenderNode(ICWorkbenchEditor editor, IICRenderNodeEventReceiver eventReceiver) {
        this.editor = editor;
        this.eventReceiver = eventReceiver;
    }

    public void setLayer(int layer) {
        int previousLayer = this.currentLayer;
        this.currentLayer = layer;
        this.cameraLayerAnimator.addDeltaWithNewDuration(new Vector3(0.0, (double)(layer - previousLayer), 0.0), 200L);
        this.eventReceiver.layerChanged(this, previousLayer, this.currentLayer);
    }

    public int getLayer() {
        return this.currentLayer;
    }

    public void moveZoomAt(Vector3 zoomPos, double zoomDelta) {
        Vector3 zoomVec = zoomPos.copy().subtract(this.cameraPosition).normalize();
        zoomVec.multiply(zoomDelta);
        this.cameraZoomAnimator.addDeltaWithNewDuration(zoomVec, 100L);
    }

    public void applyCameraDelta(Vector3 delta) {
        this.cameraZoomAnimator.addDeltaWithNewDuration(delta, 100L);
    }

    public void applyPanningDelta(Vector3 delta) {
        double scale = this.getFrame().width() > this.getFrame().height() ? this.ndcMouseToWorld((Vec2)new Vec2((double)1.0, (double)0.0)).subtract((Vector3)this.ndcMouseToWorld((Vec2)new Vec2((double)-1.0, (double)0.0))).x : this.ndcMouseToWorld((Vec2)new Vec2((double)0.0, (double)-1.0)).subtract((Vector3)this.ndcMouseToWorld((Vec2)new Vec2((double)0.0, (double)1.0))).z;
        Vector3 scaledDelta = delta.copy().multiply(scale);
        this.applyCameraDelta(scaledDelta);
    }

    public void focusCameraAtTiles(List<TileCoord> positions) {
        if (positions.isEmpty()) {
            return;
        }
        Cuboid6 bounds = new Cuboid6();
        Iterator<TileCoord> it = positions.iterator();
        TileCoord first = it.next();
        bounds.set((double)first.x, (double)first.y, (double)first.z, (double)(first.x + 1), (double)(first.y + 1), (double)(first.z + 1));
        while (it.hasNext()) {
            TileCoord next = it.next();
            bounds.enclose((double)next.x, (double)next.y, (double)next.z, (double)(next.x + 1), (double)(next.y + 1), (double)(next.z + 1));
        }
        bounds.expand(1.0);
        double midX = (bounds.min.x + bounds.max.x) / 2.0;
        double midZ = (bounds.min.z + bounds.max.z) / 2.0;
        double dist = this.distanceToEncloseRect(bounds.max.x - bounds.min.x, bounds.max.z - bounds.min.z);
        this.cameraZoomAnimator.moveToTargetWithDuration(new Vector3(midX, dist, midZ), 400L);
    }

    public void frameUpdate(Point mouse, float partialFrame) {
        TileCoord minBounds = this.editor.getTileMap().getMinBounds();
        TileCoord maxBounds = this.editor.getTileMap().getMaxBounds();
        this.cameraZoomAnimator.setBounds(minBounds.x, this.cameraLayerAnimator.vector.y + 2.0, minBounds.z, maxBounds.x + 1, this.cameraLayerAnimator.vector.y + 18.0, maxBounds.z + 1);
        long t = System.currentTimeMillis();
        this.cameraZoomAnimator.tick(t);
        this.cameraLayerAnimator.tick(t);
        this.lastMousePos = mouse;
        this.cameraPosition.set(0.0);
        this.cameraZoomAnimator.apply(this.cameraPosition);
        this.cameraLayerAnimator.apply(this.cameraPosition);
    }

    protected double getTargetPlaneDistance() {
        return this.cameraPosition.y - (double)this.currentLayer - 0.125;
    }

    protected double getVerticalFOV() {
        return 1.22173047639601;
    }

    protected double getMaxRenderDist() {
        return 20.0;
    }

    protected Vector3 getCameraPosition() {
        return this.cameraPosition;
    }

    protected void renderInViewport(PoseStack renderStack, Vec2 ndcMouse, float partialFrame, boolean isFirstHit) {
        CCRenderState ccrs = CCRenderState.instance();
        MultiBufferSource.BufferSource getter = Minecraft.getInstance().renderBuffers().bufferSource();
        Vector3 worldPos = this.ndcMouseToWorld(ndcMouse);
        for (int y = this.currentLayer - 1; y <= this.currentLayer + 1; ++y) {
            ccrs.reset();
            ccrs.alphaOverride = 255 - (int)(255.0 * Math.min(Math.abs((double)y - this.cameraLayerAnimator.vector.y), 1.0));
            ccrs.brightness = LightTexture.pack((int)15, (int)15);
            renderStack.pushPose();
            renderStack.translate(0.0f, (float)y, 0.0f);
            TileCoord minBounds = this.editor.getTileMap().getMinBounds();
            TileCoord maxBounds = this.editor.getTileMap().getMaxBounds();
            Cuboid6 bounds = new Cuboid6((double)minBounds.x, (double)minBounds.y, (double)minBounds.z, (double)(maxBounds.x + 1), (double)(maxBounds.y + 1), (double)(maxBounds.z + 1));
            ICRenderTypes.renderICGrid(renderStack, (MultiBufferSource)getter, bounds, ccrs);
            renderStack.popPose();
            for (Map.Entry<TileCoord, BaseTile> entry : this.editor.getTileMap().getTilesOnLayer(y)) {
                renderStack.pushPose();
                renderStack.translate((float)entry.getKey().x, (float)y, (float)entry.getKey().z);
                ccrs.bind(ICRenderTypes.layersRenderType, (MultiBufferSource)getter, renderStack);
                entry.getValue().renderTile(ccrs, (Transformation)RedundantTransformation.INSTANCE, partialFrame);
                renderStack.popPose();
            }
            if (y != this.currentLayer) continue;
            this.eventReceiver.onRenderOverlay(this, worldPos, isFirstHit, ccrs, (MultiBufferSource)getter, renderStack);
        }
        if (!this.editor.getStateMachine().isSimulating()) {
            TileCoord minBounds = this.editor.getTileMap().getMinBounds();
            TileCoord maxBounds = this.editor.getTileMap().getMaxBounds();
            double girdHeight = 2.0;
            Cuboid6 bounds = new Cuboid6((double)minBounds.x, (double)this.currentLayer - girdHeight - 1.0, (double)minBounds.z, (double)(maxBounds.x + 1), (double)this.currentLayer + girdHeight, (double)(maxBounds.z + 1)).expand(0.01);
            ICRenderTypes.renderGridInBounds(renderStack, (MultiBufferSource)getter, bounds, 7);
        }
        getter.endBatch();
    }

    public void onAddedToParent() {
        this.focusCameraAtTiles(List.of(this.editor.getTileMap().getMinBounds(), this.editor.getTileMap().getMaxBounds()));
    }

    public void update() {
        super.update();
        this.eventReceiver.update(this);
    }

    protected List<Component> getToolTip(Point mousePosition, boolean isFirstHit) {
        LinkedList<Component> tooltip = new LinkedList<Component>();
        this.eventReceiver.buildTooltip(this, this.mouseToWorld(mousePosition), isFirstHit, tooltip);
        return tooltip;
    }

    public boolean mouseClicked(Point p, int glfwMouseButton, boolean consumed) {
        this.lastMousePos = p;
        if (!consumed && this.isFirstHit(p)) {
            this.eventReceiver.mouseButtonPressed(this, this.mouseToWorld(p), glfwMouseButton);
            return true;
        }
        return false;
    }

    public boolean mouseReleased(Point p, int glfwMouseButton, long timeHeld, boolean consumed) {
        this.lastMousePos = p;
        this.eventReceiver.mouseButtonReleased(this, this.mouseToWorld(p), glfwMouseButton);
        return true;
    }

    public boolean mouseDragged(Point p, int glfwMouseButton, long timeHeld, boolean consumed) {
        Vector3 worldPos = this.mouseToWorld(p);
        Vector3 delta = worldPos.copy().subtract(this.mouseToWorld(this.lastMousePos));
        this.eventReceiver.mouseButtonDragged(this, worldPos, delta, glfwMouseButton);
        this.lastMousePos = p;
        return true;
    }

    public boolean mouseScrolled(Point p, double scrollX, double scrollY, boolean consumed) {
        this.lastMousePos = p;
        if (!consumed && this.isFirstHit(p)) {
            this.eventReceiver.mouseScrolled(this, this.mouseToWorld(p), scrollY);
            return true;
        }
        return false;
    }

    public static interface IICRenderNodeEventReceiver {
        default public void update(ICRenderNode renderNode) {
        }

        default public void mouseButtonPressed(ICRenderNode renderNode, Vector3 mousePosition, int glfwMouseButton) {
        }

        default public void mouseButtonReleased(ICRenderNode renderNode, Vector3 mousePosition, int glfwMouseButton) {
        }

        default public void mouseButtonDragged(ICRenderNode renderNode, Vector3 mousePosition, Vector3 delta, int glfwMouseButton) {
        }

        default public void mouseScrolled(ICRenderNode renderNode, Vector3 mousePosition, double scroll) {
        }

        default public void layerChanged(ICRenderNode renderNode, int previousLayer, int newLayer) {
        }

        public void onRenderOverlay(ICRenderNode var1, Vector3 var2, boolean var3, CCRenderState var4, MultiBufferSource var5, PoseStack var6);

        public void buildTooltip(ICRenderNode var1, Vector3 var2, boolean var3, List<Component> var4);
    }
}

