/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.gui;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.TransformationList;
import codechicken.lib.vec.Translation;
import java.util.List;
import mrtjp.projectred.fabrication.editor.tools.GatePlacerTool;
import mrtjp.projectred.fabrication.engine.gates.ICGateTileType;
import mrtjp.projectred.fabrication.gui.ICEditorToolManager;
import mrtjp.projectred.fabrication.gui.ICEditorToolTab;
import mrtjp.projectred.fabrication.gui.TabButtonNode;
import mrtjp.projectred.fabrication.gui.screen.ICWorkbenchScreen;
import mrtjp.projectred.integration.client.GateModelRenderer;
import mrtjp.projectred.lib.Point;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;

public class GatePlacerToolTab
extends ICEditorToolTab {
    private final GatePlacerTool tool;

    public GatePlacerToolTab(ICEditorToolManager manager, GatePlacerTool tool) {
        super(manager, tool);
        this.tool = tool;
        this.construct();
    }

    private void addGateButton(final ICGateTileType type) {
        ICEditorToolTab.ButtonController buttonController = new ICEditorToolTab.ButtonController(){

            @Override
            public void getTooltip(List<Component> tooltip) {
                tooltip.add((Component)Component.translatable((String)type.tileType.getUnlocalizedName()));
            }

            @Override
            public void onClick() {
                GatePlacerToolTab.this.tool.setGateType(type);
            }

            @Override
            public boolean isSelected() {
                return GatePlacerToolTab.this.tool.getGateType() == type;
            }

            @Override
            public void renderIcon(GuiGraphics graphics, Point absPos, float partialFrame) {
                MultiBufferSource.BufferSource getter = Minecraft.getInstance().renderBuffers().bufferSource();
                CCRenderState ccrs = CCRenderState.instance();
                ccrs.reset();
                ccrs.bind(RenderType.cutout(), (MultiBufferSource)getter, graphics.pose());
                ccrs.overlay = OverlayTexture.NO_OVERLAY;
                ccrs.brightness = 0xF000F0;
                double scale = 0.625;
                TransformationList t = new TransformationList(new Transformation[]{new Rotation(1.5707963267948701, 1.0, 0.0, 0.0), new Scale(16.0 * scale, -16.0 * scale, 16.0 * scale), new Translation((double)(absPos.x + 8) - scale * 8.0, (double)(absPos.y + 8) - scale * 8.0, 0.0)});
                GateModelRenderer.instance().renderInventory(ccrs, null, type.renderIndex, 0, (Transformation)t);
                getter.endBatch();
            }
        };
        this.addSingleButton(buttonController);
    }

    private void construct() {
        this.addGroup("projectred_fabrication.tilegroup.io");
        this.addGateButton(ICGateTileType.REDSTONE_IO);
        this.addGateButton(ICGateTileType.BUNDLED_COLOR_IO);
        this.addGateButton(ICGateTileType.BUNDLED_BUS_IO);
        this.addGateButton(ICGateTileType.ANALOG_IO);
        this.addGroup("projectred_fabrication.tilegroup.basic");
        this.addGateButton(ICGateTileType.OR);
        this.addGateButton(ICGateTileType.NOR);
        this.addGateButton(ICGateTileType.NOT);
        this.addGateButton(ICGateTileType.AND);
        this.addGateButton(ICGateTileType.NAND);
        this.addGateButton(ICGateTileType.XOR);
        this.addGateButton(ICGateTileType.XNOR);
        this.addGateButton(ICGateTileType.BUFFER);
        this.addGateButton(ICGateTileType.MULTIPLEXER);
        this.addGroup("projectred_fabrication.tilegroup.timing");
        this.addGateButton(ICGateTileType.PULSE);
        this.addGateButton(ICGateTileType.REPEATER);
        this.addGateButton(ICGateTileType.RANDOMIZER);
        this.addGateButton(ICGateTileType.TIMER);
        this.addGateButton(ICGateTileType.SEQUENCER);
        this.addGateButton(ICGateTileType.STATE_CELL);
        this.addGateButton(ICGateTileType.SYNCHRONIZER);
        this.addGroup("projectred_fabrication.tilegroup.memory");
        this.addGateButton(ICGateTileType.SR_LATCH);
        this.addGateButton(ICGateTileType.TOGGLE_LATCH);
        this.addGateButton(ICGateTileType.TRANSPARENT_LATCH);
        this.addGateButton(ICGateTileType.COUNTER);
    }

    @Override
    public TabButtonNode createButtonNode() {
        return new TabButtonNode(this, this, TabButtonNode.TabSide.LEFT){

            @Override
            public void renderIcon(GuiGraphics graphics, Point mouse, float partialFrame) {
                graphics.blit(ICWorkbenchScreen.BACKGROUND, this.getFrame().x() + 3, this.getFrame().y() + 3, 390.0f, 31.0f, 14, 14, 512, 512);
            }

            @Override
            public void buildTooltip(List<Component> tooltip) {
                tooltip.add((Component)Component.translatable((String)"projectred_fabrication.tool.gates"));
            }
        };
    }
}

