/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine.log;

import java.util.function.Supplier;
import mrtjp.projectred.fabrication.engine.log.CompileProblem;
import mrtjp.projectred.fabrication.engine.log.DeadGateWarning;
import mrtjp.projectred.fabrication.engine.log.DeadWireWarning;
import mrtjp.projectred.fabrication.engine.log.IODirectionMismatchError;
import mrtjp.projectred.fabrication.engine.log.IOTypeMismatchError;
import mrtjp.projectred.fabrication.engine.log.MultipleDriversError;
import mrtjp.projectred.fabrication.engine.log.NoInputsError;
import mrtjp.projectred.fabrication.engine.log.NoOutputsError;

public enum CompileProblemType {
    MULTIPLE_DRIVERS(MultipleDriversError::new),
    DEAD_WIRE(DeadWireWarning::new),
    DEAD_GATE(DeadGateWarning::new),
    IO_DIR_MISMATCH(IODirectionMismatchError::new),
    IO_TYPE_MISMATCH(IOTypeMismatchError::new),
    NO_INPUTS(NoInputsError::new),
    NO_OUTPUTS(NoOutputsError::new);

    public static final CompileProblemType[] VALUES;
    private final Supplier<CompileProblem> issueSupplier;

    private CompileProblemType(Supplier<CompileProblem> issueSupplier) {
        this.issueSupplier = issueSupplier;
    }

    public CompileProblem newInstance() {
        return this.issueSupplier.get();
    }

    public int getID() {
        return this.ordinal();
    }

    public static CompileProblem createById(int type) {
        return VALUES[type].newInstance();
    }

    static {
        VALUES = CompileProblemType.values();
    }
}

