/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine.gates;

import java.util.ArrayList;
import mrtjp.fengine.api.ICAssemblyTile;
import mrtjp.fengine.simulate.ICGate;
import mrtjp.fengine.simulate.ICSimulation;
import mrtjp.projectred.fabrication.ProjectRedFabrication;
import mrtjp.projectred.fabrication.engine.PRFabricationEngine;
import mrtjp.projectred.fabrication.engine.gates.ICGateTileType;
import mrtjp.projectred.fabrication.engine.gates.TimedStateGateTile;

public class SynchronizerGateTile
extends TimedStateGateTile {
    public SynchronizerGateTile() {
        super(ICGateTileType.SYNCHRONIZER);
    }

    @Override
    protected int redstoneInputMask() {
        return 14;
    }

    @Override
    protected int redstoneOutputMask() {
        return 1;
    }

    public int state2() {
        int s2 = 0;
        int state = this.getState2() & 0xF;
        if (state == 2 || state == 4) {
            s2 |= 1;
        }
        if (state == 3 || state == 4) {
            s2 |= 2;
        }
        return s2;
    }

    @Override
    protected void collectGate(ICAssemblyTile.Collector collector, int gateId, int[] inputRegisters, int[] outputRegisters) {
        int i;
        ArrayList<Integer> inputRegs = new ArrayList<Integer>();
        ArrayList<Integer> outputRegs = new ArrayList<Integer>();
        inputRegs.add(this.stateReg);
        inputRegs.add(inputRegisters[1]);
        inputRegs.add(inputRegisters[2]);
        inputRegs.add(inputRegisters[3]);
        for (i = 0; i < 8; ++i) {
            inputRegs.add(this.timeRegs[i]);
        }
        for (i = 0; i < 8; ++i) {
            inputRegs.add(PRFabricationEngine.REG_TIME[i]);
        }
        outputRegs.add(this.stateReg);
        outputRegs.add(outputRegisters[0]);
        for (i = 0; i < 8; ++i) {
            outputRegs.add(this.timeRegs[i]);
        }
        collector.addGate(gateId, (ICGate)new SynchronizerGate(), inputRegs, outputRegs);
    }

    public static class SynchronizerGate
    implements ICGate {
        private static byte readState(ICSimulation ic, int[] inputs) {
            return ic.getRegByteVal(inputs[0]);
        }

        private static byte readInputMask(ICSimulation ic, int[] inputs) {
            int mask = 0;
            if (ic.getRegByteVal(inputs[1]) != 0) {
                mask |= 2;
            }
            if (ic.getRegByteVal(inputs[2]) != 0) {
                mask |= 4;
            }
            if (ic.getRegByteVal(inputs[3]) != 0) {
                mask |= 8;
            }
            return (byte)mask;
        }

        private static long readSchedTime(ICSimulation ic, int[] inputs) {
            return ic.getRegLongVal(inputs, 4);
        }

        private static long readSysTime(ICSimulation ic, int[] inputs) {
            return ic.getRegLongVal(inputs, 12);
        }

        private static void writeState(ICSimulation ic, int[] outputs, byte state) {
            ic.queueRegByteVal(outputs[0], state);
        }

        private static void writeOutput(ICSimulation ic, int[] outputs, byte output) {
            ic.queueRegByteVal(outputs[1], output);
        }

        private static void writeSchedTime(ICSimulation ic, int[] outputs, long time) {
            ic.queueRegLongVal(outputs, 2, time);
        }

        public void compute(ICSimulation ic, int[] inputs, int[] outputs) {
            byte stateVal = SynchronizerGate.readState(ic, inputs);
            int state = stateVal & 0xF;
            int prevInputMask = stateVal >> 4 & 0xF;
            byte inputMask = SynchronizerGate.readInputMask(ic, inputs);
            int highMask = inputMask & ~prevInputMask;
            block0 : switch (state) {
                case 0: {
                    SynchronizerGate.writeState(ic, outputs, (byte)1);
                    SynchronizerGate.writeOutput(ic, outputs, (byte)0);
                    SynchronizerGate.writeSchedTime(ic, outputs, -1L);
                    break;
                }
                case 1: {
                    if ((inputMask & 4) != 0 || highMask == 0) {
                        SynchronizerGate.writeState(ic, outputs, (byte)(inputMask << 4 | 1));
                        break;
                    }
                    switch (highMask) {
                        case 2: {
                            SynchronizerGate.writeState(ic, outputs, (byte)(inputMask << 4 | 2));
                            break;
                        }
                        case 8: {
                            SynchronizerGate.writeState(ic, outputs, (byte)(inputMask << 4 | 3));
                            break;
                        }
                        case 10: {
                            SynchronizerGate.writeState(ic, outputs, (byte)(inputMask << 4 | 4));
                            SynchronizerGate.writeOutput(ic, outputs, (byte)1);
                            SynchronizerGate.writeSchedTime(ic, outputs, SynchronizerGate.readSysTime(ic, inputs) + 2L);
                        }
                    }
                    break;
                }
                case 2: {
                    if ((inputMask & 4) != 0) {
                        SynchronizerGate.writeState(ic, outputs, (byte)(inputMask << 4 | 1));
                        break;
                    }
                    switch (highMask) {
                        case 8: 
                        case 10: {
                            SynchronizerGate.writeState(ic, outputs, (byte)(inputMask << 4 | 4));
                            SynchronizerGate.writeOutput(ic, outputs, (byte)1);
                            SynchronizerGate.writeSchedTime(ic, outputs, SynchronizerGate.readSysTime(ic, inputs) + 2L);
                            break block0;
                        }
                    }
                    SynchronizerGate.writeState(ic, outputs, (byte)(inputMask << 4 | 2));
                    break;
                }
                case 3: {
                    if ((inputMask & 4) != 0) {
                        SynchronizerGate.writeState(ic, outputs, (byte)(inputMask << 4 | 1));
                        break;
                    }
                    switch (highMask) {
                        case 2: 
                        case 10: {
                            SynchronizerGate.writeState(ic, outputs, (byte)(inputMask << 4 | 4));
                            SynchronizerGate.writeOutput(ic, outputs, (byte)1);
                            SynchronizerGate.writeSchedTime(ic, outputs, SynchronizerGate.readSysTime(ic, inputs) + 2L);
                            break block0;
                        }
                    }
                    SynchronizerGate.writeState(ic, outputs, (byte)(inputMask << 4 | 3));
                    break;
                }
                case 4: {
                    if (SynchronizerGate.readSysTime(ic, inputs) < SynchronizerGate.readSchedTime(ic, inputs)) break;
                    SynchronizerGate.writeState(ic, outputs, (byte)(inputMask << 4 | 1));
                    SynchronizerGate.writeOutput(ic, outputs, (byte)0);
                    SynchronizerGate.writeSchedTime(ic, outputs, -1L);
                    break;
                }
                default: {
                    ProjectRedFabrication.LOGGER.error("Invalid state: " + stateVal);
                    SynchronizerGate.writeState(ic, outputs, (byte)0);
                }
            }
        }
    }
}

