/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine.gates;

import java.util.ArrayList;
import mrtjp.fengine.api.ICAssemblyTile;
import mrtjp.fengine.simulate.ICGate;
import mrtjp.fengine.simulate.ICSimulation;
import mrtjp.projectred.fabrication.ProjectRedFabrication;
import mrtjp.projectred.fabrication.engine.PRFabricationEngine;
import mrtjp.projectred.fabrication.engine.gates.ICGateTileType;
import mrtjp.projectred.fabrication.engine.gates.TimedStateGateTile;

public class PulseGateTile
extends TimedStateGateTile {
    public PulseGateTile() {
        super(ICGateTileType.PULSE);
    }

    @Override
    protected int redstoneInputMask() {
        return 4;
    }

    @Override
    protected int redstoneOutputMask() {
        return 1;
    }

    @Override
    protected void collectGate(ICAssemblyTile.Collector collector, int gateId, int[] inputRegisters, int[] outputRegisters) {
        int i;
        ArrayList<Integer> inputRegs = new ArrayList<Integer>();
        ArrayList<Integer> outputRegs = new ArrayList<Integer>();
        inputRegs.add(this.stateReg);
        inputRegs.add(inputRegisters[2]);
        for (i = 0; i < 8; ++i) {
            inputRegs.add(this.timeRegs[i]);
        }
        for (i = 0; i < 8; ++i) {
            inputRegs.add(PRFabricationEngine.REG_TIME[i]);
        }
        outputRegs.add(this.stateReg);
        outputRegs.add(outputRegisters[0]);
        for (i = 0; i < 8; ++i) {
            outputRegs.add(this.timeRegs[i]);
        }
        collector.addGate(gateId, (ICGate)new PulseGate(), inputRegs, outputRegs);
    }

    public static class PulseGate
    implements ICGate {
        private static byte readState(ICSimulation ic, int[] inputs) {
            return ic.getRegByteVal(inputs[0]);
        }

        private static byte readInput(ICSimulation ic, int[] inputs) {
            return ic.getRegByteVal(inputs[1]);
        }

        private static long readSchedTime(ICSimulation ic, int[] inputs) {
            return ic.getRegLongVal(inputs, 2);
        }

        private static long readSysTime(ICSimulation ic, int[] inputs) {
            return ic.getRegLongVal(inputs, 10);
        }

        private static void writeState(ICSimulation ic, int[] outputs, byte state) {
            ic.queueRegByteVal(outputs[0], state);
        }

        private static void writeOutput(ICSimulation ic, int[] outputs, byte output) {
            ic.queueRegByteVal(outputs[1], output);
        }

        private static void writeSchedTime(ICSimulation ic, int[] outputs, long time) {
            ic.queueRegLongVal(outputs, 2, time);
        }

        public void compute(ICSimulation ic, int[] inputs, int[] outputs) {
            byte stateVal = PulseGate.readState(ic, inputs);
            switch (stateVal) {
                case 0: {
                    if (PulseGate.readInput(ic, inputs) == 0) break;
                    PulseGate.writeState(ic, outputs, (byte)1);
                    PulseGate.writeOutput(ic, outputs, (byte)1);
                    PulseGate.writeSchedTime(ic, outputs, PulseGate.readSysTime(ic, inputs) + 2L);
                    break;
                }
                case 1: {
                    if (PulseGate.readSysTime(ic, inputs) < PulseGate.readSchedTime(ic, inputs)) break;
                    PulseGate.writeState(ic, outputs, (byte)(PulseGate.readInput(ic, inputs) == 0 ? 0 : 2));
                    PulseGate.writeOutput(ic, outputs, (byte)0);
                    PulseGate.writeSchedTime(ic, outputs, -1L);
                    break;
                }
                case 2: {
                    if (PulseGate.readInput(ic, inputs) != 0) break;
                    PulseGate.writeState(ic, outputs, (byte)0);
                    break;
                }
                default: {
                    ProjectRedFabrication.LOGGER.error("Invalid state: " + stateVal);
                    PulseGate.writeState(ic, outputs, (byte)0);
                }
            }
        }
    }
}

