/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine.gates;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.TransformationList;
import codechicken.lib.vec.Vector3;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import mrtjp.fengine.api.ICAssemblyTile;
import mrtjp.fengine.api.IPathFinder;
import mrtjp.fengine.assemble.PathFinderResult;
import mrtjp.projectred.fabrication.editor.ICWorkbenchEditor;
import mrtjp.projectred.fabrication.editor.tools.InteractionZone;
import mrtjp.projectred.fabrication.editor.tools.SimpleInteractionZone;
import mrtjp.projectred.fabrication.engine.ICInterfaceType;
import mrtjp.projectred.fabrication.engine.ICSimulationContainer;
import mrtjp.projectred.fabrication.engine.IIOConnectionTile;
import mrtjp.projectred.fabrication.engine.IRotatableICTile;
import mrtjp.projectred.fabrication.engine.PRFabricationEngine;
import mrtjp.projectred.fabrication.engine.gates.BundledGateTile;
import mrtjp.projectred.fabrication.engine.gates.ICGateTileType;
import mrtjp.projectred.fabrication.engine.log.MultipleDriversError;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;

public class BundledBusIOGateTile
extends BundledGateTile
implements IIOConnectionTile {
    public static final int BUNDLED_SIGNAL_PACKET = 6;
    private static final Cuboid6[] INPUT_TOGGLE_ZONE_BOUNDS = new Cuboid6[4];
    private static final Cuboid6[] DIR_ZONE_BOUNDS = new Cuboid6[4];
    protected final int[] regIds = new int[16];
    protected short bundledSignal = 0;

    public BundledBusIOGateTile() {
        super(ICGateTileType.BUNDLED_BUS_IO);
        Arrays.fill(this.regIds, -1);
    }

    @Override
    public void save(CompoundTag tag) {
        super.save(tag);
        for (int i = 0; i < 16; ++i) {
            tag.putInt("reg" + i, this.regIds[i]);
        }
        tag.putShort("bundled_signal", this.bundledSignal);
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        for (int i = 0; i < 16; ++i) {
            this.regIds[i] = tag.contains("reg" + i) ? tag.getInt("reg" + i) : -1;
        }
        this.bundledSignal = tag.getShort("bundled_signal");
    }

    @Override
    public void writeDesc(MCDataOutput out) {
        super.writeDesc(out);
        out.writeShort((int)this.bundledSignal);
    }

    @Override
    public void readDesc(MCDataInput in) {
        super.readDesc(in);
        this.bundledSignal = in.readShort();
    }

    @Override
    public void read(MCDataInput in, int key) {
        switch (key) {
            case 6: {
                this.bundledSignal = in.readShort();
                break;
            }
            default: {
                super.read(in, key);
            }
        }
    }

    protected void sendBundledSignalUpdate() {
        this.getWriteStream(6).writeShort((int)this.bundledSignal);
    }

    @Override
    public boolean isInputIOMode() {
        return this.getShape() == 0;
    }

    @Override
    public int getIOSide() {
        return this.getRotation();
    }

    @Override
    public ICInterfaceType getInterfaceType() {
        return ICInterfaceType.BUNDLED;
    }

    @Override
    public void onSimRegistersChanged(int rMask, ICSimulationContainer container) {
        short oldSig = this.bundledSignal;
        int newSig = this.pullBundledSignal(container);
        if (oldSig != newSig) {
            this.bundledSignal = (short)newSig;
            this.sendBundledSignalUpdate();
        }
    }

    protected int pullBundledSignal(ICSimulationContainer container) {
        int signal = 0;
        for (int i = 0; i < 16; ++i) {
            if (this.regIds[i] == -1) continue;
            signal |= container.pullRegisterValue(this.regIds[i]) << i;
        }
        return signal;
    }

    @Override
    public void buildInteractionZoneList(List<InteractionZone> zones) {
        super.buildInteractionZoneList(zones);
        zones.add(new SimpleInteractionZone.Builder().bounds(() -> INPUT_TOGGLE_ZONE_BOUNDS[this.getRotation()]).tooltip(toolTip -> {
            toolTip.add(Component.translatable((String)(this.isInputIOMode() ? "projectred_fabrication.interact.io_bundled_input" : "projectred_fabrication.interact.io_bundled_output")).append((Component)Component.literal((String)(": " + "0x%04X".formatted(this.bundledSignal)))).withStyle(ICWorkbenchEditor.UNIFORM_GRAY));
            if (this.isInputIOMode()) {
                toolTip.add(Component.translatable((String)"projectred_fabrication.interact.io_bus_toggle").withStyle(ICWorkbenchEditor.UNIFORM_GRAY.withItalic(Boolean.valueOf(true))));
            }
        }).build());
        zones.add(new SimpleInteractionZone.Builder().bounds(() -> DIR_ZONE_BOUNDS[this.getRotation()]).leftClickAction(this::toggleDirection).tooltip(toolTip -> toolTip.add(Component.translatable((String)"projectred_fabrication.interact.io_direction").append((Component)Component.literal((String)": ")).append((Component)Component.translatable((String)(this.isInputIOMode() ? "projectred_fabrication.interact.io_direction.input" : "projectred_fabrication.interact.io_direction.output"))).withStyle(ICWorkbenchEditor.UNIFORM_GRAY))).build());
    }

    protected void toggleDirection() {
        this.configureShapeAndSend((this.getShape() + 1) % 2);
    }

    public short bOutput2() {
        if (!this.getEditor().getStateMachine().isSimulating()) {
            return 0;
        }
        return this.bundledOutputMask() != 0 ? this.bundledSignal : (short)0;
    }

    public short bInput2() {
        if (!this.getEditor().getStateMachine().isSimulating()) {
            return 0;
        }
        return this.bundledInputMask() != 0 ? this.bundledSignal : (short)0;
    }

    @Override
    protected boolean canRotate() {
        return false;
    }

    @Override
    protected int bundledOutputMask() {
        return this.isInputIOMode() ? 4 : 0;
    }

    @Override
    protected int bundledInputMask() {
        return this.isInputIOMode() ? 0 : 4;
    }

    public void allocate(ICAssemblyTile.Allocator allocator) {
        if (this.isInputIOMode()) {
            for (int i = 0; i < 16; ++i) {
                this.regIds[i] = PRFabricationEngine.inputRegisterId(this.getIOSide(), i);
            }
        } else {
            Arrays.fill(this.regIds, 136);
        }
    }

    public void locate(IPathFinder pathFinder) {
        if (!this.isInputIOMode()) {
            int absR = this.toAbsoluteRotation(2);
            int absDir = IRotatableICTile.rotationToDir(absR);
            for (int i = 0; i < 16; ++i) {
                int port = i;
                PathFinderResult pfr = pathFinder.doPathFinding((d, p) -> d == absDir && p == port);
                if (pfr.outputRegisters.size() > 1) {
                    this.getEditor().getStateMachine().getCompilerLog().addProblem(new MultipleDriversError(this.getPos(), pfr.outputRegisters));
                }
                if (pfr.outputRegisters.isEmpty()) continue;
                this.regIds[i] = (Integer)pfr.outputRegisters.get(0);
            }
        }
    }

    public void registerRemaps(ICAssemblyTile.RemapRegistry remapRegistry) {
        if (!this.isInputIOMode()) {
            for (int i = 0; i < 16; ++i) {
                if (this.regIds[i] == 136) continue;
                remapRegistry.addRemap(this.regIds[i], PRFabricationEngine.outputRegisterId(this.getIOSide(), i));
            }
        }
    }

    public void consumeRemaps(ICAssemblyTile.RemapProvider remapProvider) {
        for (int i = 0; i < 16; ++i) {
            this.regIds[i] = remapProvider.getRemappedRegisterID(this.regIds[i]);
        }
    }

    public void collect(ICAssemblyTile.Collector collector) {
    }

    public Optional<Integer> getOutputRegister(int outDir, int outPort) {
        int gateOutputDir = IRotatableICTile.rotationToDir(this.toAbsoluteRotation(2));
        return this.isInputIOMode() && outDir == gateOutputDir ? Optional.of(this.regIds[outPort]) : Optional.empty();
    }

    public Optional<Integer> getInputRegister(int inDir, int inPort) {
        int gateInputDir = IRotatableICTile.rotationToDir(this.toAbsoluteRotation(2));
        return !this.isInputIOMode() && inDir == gateInputDir ? Optional.of(this.regIds[inPort]) : Optional.empty();
    }

    static {
        for (int r = 0; r < 4; ++r) {
            TransformationList t = new Scale(0.0625).with(Rotation.quarterRotations[r].at(Vector3.CENTER));
            BundledBusIOGateTile.INPUT_TOGGLE_ZONE_BOUNDS[r] = new Cuboid6(1.0, 2.0, 0.0, 15.0, 3.0, 3.0).apply((Transformation)t);
            BundledBusIOGateTile.DIR_ZONE_BOUNDS[r] = new Cuboid6(5.0, 2.0, 7.0, 11.0, 5.0, 13.0).apply((Transformation)t);
        }
    }
}

