/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Set;
import mrtjp.projectred.fabrication.engine.ICInterfaceType;
import mrtjp.projectred.fabrication.engine.IIOConnectionTile;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class InterfaceSpec {
    public static final InterfaceSpec EMPTY = new InterfaceSpec(new ICInterfaceType[]{ICInterfaceType.NC, ICInterfaceType.NC, ICInterfaceType.NC, ICInterfaceType.NC}, 0, 0, 0);
    private final ICInterfaceType[] sideInterfaces;
    private final int redstoneMask;
    private final int bundledMask;
    private final int analogMask;
    public static final Codec<ICInterfaceType> INTERFACE_TYPE_CODEC = Codec.BYTE.xmap(id -> ICInterfaceType.fromId(id & 0xFF), type -> (byte)type.getId());
    public static final StreamCodec<RegistryFriendlyByteBuf, ICInterfaceType> INTERFACE_TYPE_STREAM_CODEC = StreamCodec.of((buf, type) -> buf.writeByte(type.getId()), buf -> ICInterfaceType.fromId(buf.readByte() & 0xFF));
    public static final Codec<InterfaceSpec> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list(INTERFACE_TYPE_CODEC).fieldOf("sideInterfaces").forGetter(spec -> Arrays.asList(spec.sideInterfaces)), (App)Codec.INT.fieldOf("redstoneMask").forGetter(spec -> spec.redstoneMask), (App)Codec.INT.fieldOf("bundledMask").forGetter(spec -> spec.bundledMask), (App)Codec.INT.fieldOf("analogMask").forGetter(spec -> spec.analogMask)).apply((Applicative)instance, (sideInterfaces, redstoneMask, bundledMask, analogMask) -> new InterfaceSpec(sideInterfaces.toArray(new ICInterfaceType[4]), (int)redstoneMask, (int)bundledMask, (int)analogMask)));
    public static final StreamCodec<RegistryFriendlyByteBuf, InterfaceSpec> STREAM_CODEC = StreamCodec.composite((StreamCodec)INTERFACE_TYPE_STREAM_CODEC.apply(ByteBufCodecs.list((int)4)), spec -> Arrays.asList(spec.sideInterfaces), (StreamCodec)ByteBufCodecs.INT, spec -> spec.redstoneMask, (StreamCodec)ByteBufCodecs.INT, spec -> spec.bundledMask, (StreamCodec)ByteBufCodecs.INT, spec -> spec.analogMask, (sideInterfaces, redstoneMask, bundledMask, analogMask) -> new InterfaceSpec(sideInterfaces.toArray(new ICInterfaceType[4]), (int)redstoneMask, (int)bundledMask, (int)analogMask));

    private InterfaceSpec(ICInterfaceType[] sideInterfaces, int redstoneMask, int bundledMask, int analogMask) {
        this.sideInterfaces = Arrays.copyOf(sideInterfaces, 4);
        this.redstoneMask = redstoneMask;
        this.bundledMask = bundledMask;
        this.analogMask = analogMask;
    }

    public void save(CompoundTag tag) {
        for (int r = 0; r < 4; ++r) {
            tag.putByte("if" + r, (byte)this.sideInterfaces[r].getId());
        }
        tag.putByte("rmask", (byte)this.redstoneMask);
        tag.putByte("bmask", (byte)this.bundledMask);
        tag.putByte("amask", (byte)this.analogMask);
    }

    public static InterfaceSpec load(CompoundTag tag) {
        ICInterfaceType[] sideInterfaces = new ICInterfaceType[4];
        for (int r = 0; r < 4; ++r) {
            sideInterfaces[r] = ICInterfaceType.fromId(tag.getByte("if" + r) & 0xFF);
        }
        int redstoneMask = tag.getByte("rmask") & 0xFF;
        int bundledMask = tag.getByte("bmask") & 0xFF;
        int analogMask = tag.getByte("amask") & 0xFF;
        return new InterfaceSpec(sideInterfaces, redstoneMask, bundledMask, analogMask);
    }

    public void writeDesc(MCDataOutput packet) {
        for (int r = 0; r < 4; ++r) {
            packet.writeByte(this.sideInterfaces[r].getId());
        }
        packet.writeByte(this.bundledMask);
        packet.writeByte(this.redstoneMask);
        packet.writeByte(this.analogMask);
    }

    public static InterfaceSpec readDesc(MCDataInput packet) {
        ICInterfaceType[] sideInterfaces = new ICInterfaceType[4];
        for (int r = 0; r < 4; ++r) {
            sideInterfaces[r] = ICInterfaceType.fromId(packet.readByte() & 0xFF);
        }
        byte bundledMask = packet.readByte();
        byte redstoneMask = packet.readByte();
        byte analogMask = packet.readByte();
        return new InterfaceSpec(sideInterfaces, redstoneMask, bundledMask, analogMask);
    }

    public static InterfaceSpec fromIOTiles(Set<IIOConnectionTile> ioTiles) {
        ICInterfaceType[] sideInterfaces = new ICInterfaceType[4];
        Arrays.fill((Object[])sideInterfaces, (Object)ICInterfaceType.NC);
        int bundledMask = 0;
        int redstoneMask = 0;
        int analogMask = 0;
        for (IIOConnectionTile t : ioTiles) {
            int side = t.getIOSide();
            ICInterfaceType type = t.getInterfaceType();
            int dir = t.isInputIOMode() ? 1 : 16;
            sideInterfaces[side] = type;
            switch (type) {
                case REDSTONE: {
                    redstoneMask |= dir << side;
                    break;
                }
                case BUNDLED: {
                    bundledMask |= dir << side;
                    break;
                }
                case ANALOG: {
                    analogMask |= dir << side;
                }
            }
        }
        return new InterfaceSpec(sideInterfaces, redstoneMask, bundledMask, analogMask);
    }

    public ICInterfaceType getInterfaceType(int side) {
        return this.sideInterfaces[side];
    }

    public int getInputMask() {
        return (this.redstoneMask | this.bundledMask | this.analogMask) & 0xF;
    }

    public int getOutputMask() {
        return (this.redstoneMask | this.bundledMask | this.analogMask) >> 4 & 0xF;
    }

    public boolean isInput(int side) {
        return ((this.redstoneMask | this.bundledMask | this.analogMask) & 1 << side) != 0;
    }

    public boolean isOutput(int side) {
        return ((this.redstoneMask | this.bundledMask | this.analogMask) & 16 << side) != 0;
    }

    public int getRedstoneInputMask() {
        return this.redstoneMask & 0xF;
    }

    public int getRedstoneOutputMask() {
        return this.redstoneMask >> 4 & 0xF;
    }

    public int getBundledInputMask() {
        return this.bundledMask & 0xF;
    }

    public int getBundledOutputMask() {
        return this.bundledMask >> 4 & 0xF;
    }

    public int getAnalogInputMask() {
        return this.analogMask & 0xF;
    }

    public int getAnalogOutputMask() {
        return this.analogMask >> 4 & 0xF;
    }

    public void saveTo(CompoundTag tag, String key) {
        CompoundTag tag1 = new CompoundTag();
        this.save(tag1);
        tag.put(key, (Tag)tag1);
    }

    public static InterfaceSpec loadFrom(CompoundTag tag, String key) {
        CompoundTag tag1 = tag.getCompound(key);
        return InterfaceSpec.load(tag1);
    }

    public static InterfaceSpec createFrom(CompoundTag tag, String key) {
        return InterfaceSpec.loadFrom(tag, key);
    }
}

