/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.editor.tools;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mrtjp.fengine.TileCoord;
import mrtjp.projectred.fabrication.editor.GatePlacementType;
import mrtjp.projectred.fabrication.editor.ICEditorToolType;
import mrtjp.projectred.fabrication.editor.tools.BaseICEditorTool;
import mrtjp.projectred.fabrication.editor.tools.IICEditorTool;
import mrtjp.projectred.fabrication.engine.gates.GateTile;
import mrtjp.projectred.fabrication.engine.gates.ICGateTileType;
import mrtjp.projectred.fabrication.gui.ICRenderTypes;
import mrtjp.projectred.integration.client.GateModelRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class GatePlacerTool
extends BaseICEditorTool {
    private final Vector3 initialMouseDown = new Vector3();
    private boolean leftMouseDown;
    private boolean overwrite = false;
    private ICGateTileType gateType = ICGateTileType.OR;

    public ICGateTileType getGateType() {
        return this.gateType;
    }

    public void setGateType(ICGateTileType gateType) {
        this.gateType = gateType;
        this.leftMouseDown = false;
    }

    @Override
    public ICEditorToolType getToolType() {
        return ICEditorToolType.GATE_PLACER_TOOL;
    }

    @Override
    public void readPacket(MCDataInput input) {
        boolean overwrite = input.readBoolean();
        ICGateTileType gateType = ICGateTileType.values()[input.readUByte()];
        byte x = input.readByte();
        byte y = input.readByte();
        byte z = input.readByte();
        short r = input.readUByte();
        TileCoord pos = new TileCoord((int)x, (int)y, (int)z);
        if (!this.getEditor().getTileMap().isInBounds(pos)) {
            return;
        }
        if (this.getEditor().getTileMap().getTile(pos).isPresent()) {
            if (!overwrite) {
                return;
            }
            this.getEditor().getTileMap().removeTile(pos);
        }
        GateTile t = (GateTile)gateType.tileType.create();
        t.preparePlacement(r);
        this.getEditor().addTile(t, pos);
    }

    private void sendPlaceGatePacket(TileCoord pos, int r) {
        MCDataOutput out = this.getEditor().getToolStream(this);
        out.writeBoolean(this.overwrite);
        out.writeByte(this.gateType.ordinal());
        out.writeByte(pos.x).writeByte(pos.y).writeByte(pos.z);
        out.writeByte(r);
    }

    private boolean isValidStart(TileCoord pos) {
        if (!this.getEditor().getTileMap().isInBounds(pos)) {
            return false;
        }
        if (this.getEditor().getTileMap().getTile(pos).isPresent() && !this.overwrite) {
            return false;
        }
        if (this.gateType.placementType == GatePlacementType.INTERNAL && !this.isInBody(pos)) {
            return false;
        }
        return this.gateType.placementType != GatePlacementType.IO_EDGE || this.isOnIOEdge(pos);
    }

    @Override
    public boolean toolStart(Vector3 mousePosition, int glfwMouseButton) {
        TileCoord start;
        if (glfwMouseButton == 0 && this.isValidStart(start = IICEditorTool.toNearestPosition(mousePosition))) {
            this.leftMouseDown = true;
            this.initialMouseDown.set(mousePosition);
            return true;
        }
        return false;
    }

    @Override
    public boolean toolReleased(Vector3 mousePosition, int glfwMouseButton) {
        if (glfwMouseButton == 0 && this.leftMouseDown) {
            this.leftMouseDown = false;
            TileCoord posA = IICEditorTool.toNearestPosition(this.initialMouseDown);
            this.sendPlaceGatePacket(posA, this.getPlacementRotation(this.initialMouseDown, mousePosition));
            return true;
        }
        return false;
    }

    @Override
    public boolean toolDragged(Vector3 mousePosition, Vector3 delta, int glfwMouseButton) {
        if (glfwMouseButton == 0) {
            return this.leftMouseDown;
        }
        return false;
    }

    @Override
    public boolean toolScrolled(Vector3 mousePosition, double scroll) {
        return false;
    }

    @Override
    public void toolLayerChanged(int previousLayer, int newLayer) {
        if (this.leftMouseDown) {
            this.initialMouseDown.y = newLayer;
        }
    }

    @Override
    public boolean toolCanceled() {
        if (this.leftMouseDown) {
            this.leftMouseDown = false;
            return true;
        }
        return false;
    }

    @Override
    public void toolActivated() {
        this.leftMouseDown = false;
    }

    @Override
    public void toolDeactivated() {
        this.leftMouseDown = false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderOverlay(Vector3 mousePosition, boolean isFirstHit, CCRenderState ccrs, MultiBufferSource getter, PoseStack matrixStack) {
        if (!isFirstHit) {
            return;
        }
        ccrs.reset();
        ccrs.brightness = LightTexture.pack((int)15, (int)15);
        ccrs.bind(ICRenderTypes.layersRenderType, (MultiBufferSource)Minecraft.getInstance().renderBuffers().bufferSource(), matrixStack);
        if (!this.leftMouseDown) {
            ccrs.alphaOverride = 64;
            TileCoord mousePos = IICEditorTool.toNearestPosition(mousePosition);
            int rot = this.getHoverRotation(mousePosition);
            if (this.isValidStart(mousePos)) {
                this.renderHover(mousePos, rot, ccrs);
            }
        } else {
            ccrs.alphaOverride = 128;
            TileCoord placementPos = IICEditorTool.toNearestPosition(this.initialMouseDown);
            int rot = this.getPlacementRotation(this.initialMouseDown, mousePosition);
            this.renderHover(placementPos, rot, ccrs);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void buildTooltip(Vector3 mousePosition, boolean isFirstHit, List<Component> tooltip) {
        super.buildTooltip(mousePosition, isFirstHit, tooltip);
    }

    public void renderHover(TileCoord pos, int r, CCRenderState ccrs) {
        GateModelRenderer.instance().renderInventory(ccrs, null, this.gateType.renderIndex, r, (Transformation)new Translation((double)pos.x, (double)pos.y, (double)pos.z));
    }

    private int getHoverRotation(Vector3 hoverPos) {
        if (this.gateType.placementType == GatePlacementType.IO_EDGE) {
            return this.getEdgeRotation(IICEditorTool.toNearestPosition(hoverPos));
        }
        return 0;
    }

    private int getPlacementRotation(Vector3 initialPos, Vector3 mousePos) {
        if (this.gateType.placementType == GatePlacementType.IO_EDGE) {
            return this.getEdgeRotation(IICEditorTool.toNearestPosition(initialPos));
        }
        Vector3 i = initialPos.copy().floor().add(0.5);
        Vector3 a = mousePos.copy().subtract(i);
        a.y = 0.0;
        Vector3 b = new Vector3(1.0, 0.0, 0.0);
        if (a.mag() < 1.2) {
            return 0;
        }
        double angle = b.angle(a);
        if (a.z > 0.0) {
            angle = Math.PI * 2 - angle;
        }
        angle = (angle + 0.7853981633974483) % (Math.PI * 2);
        angle = Math.PI * 2 - angle;
        double percentage = angle / (Math.PI * 2);
        return ((int)(4.0 * percentage) + 2) % 4;
    }

    private int getEdgeRotation(TileCoord pos) {
        if (pos.z == this.getEditor().getTileMap().getMinBounds().z) {
            return 0;
        }
        if (pos.x == this.getEditor().getTileMap().getMaxBounds().x) {
            return 1;
        }
        if (pos.z == this.getEditor().getTileMap().getMaxBounds().z) {
            return 2;
        }
        if (pos.x == this.getEditor().getTileMap().getMinBounds().x) {
            return 3;
        }
        return 0;
    }
}

