/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.tournament;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.wdiscute.starcatcher.io.SingleStackContainer;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public class TournamentSettings {
    public Scoring scoring;
    public long durationInTicks;
    public float perfectCatchMultiplier;
    public int missPenalty;
    public List<SingleStackContainer> entryCost;
    public static final TournamentSettings DEFAULT = new TournamentSettings(Scoring.SIMPLE, 0L, 0.0f, 0, List.of());
    public static final Codec<TournamentSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Scoring.CODEC.optionalFieldOf("type", (Object)Scoring.SIMPLE).forGetter(TournamentSettings::getScoring), (App)Codec.LONG.optionalFieldOf("duration", (Object)0L).forGetter(TournamentSettings::getDurationInTicks), (App)Codec.FLOAT.optionalFieldOf("perfect_catch_multiplier", (Object)Float.valueOf(0.0f)).forGetter(TournamentSettings::getPerfectCatchMultiplier), (App)Codec.INT.optionalFieldOf("miss_penalty", (Object)0).forGetter(TournamentSettings::getMissPenalty), (App)SingleStackContainer.LIST_CODEC.optionalFieldOf("entry_cost", List.of()).forGetter(TournamentSettings::getEntryCost)).apply((Applicative)instance, TournamentSettings::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, TournamentSettings> STREAM_CODEC = StreamCodec.composite(Scoring.STREAM_CODEC, TournamentSettings::getScoring, (StreamCodec)ByteBufCodecs.VAR_LONG, TournamentSettings::getDurationInTicks, (StreamCodec)ByteBufCodecs.FLOAT, TournamentSettings::getPerfectCatchMultiplier, (StreamCodec)ByteBufCodecs.VAR_INT, TournamentSettings::getMissPenalty, SingleStackContainer.STREAM_CODEC_LIST, TournamentSettings::getEntryCost, TournamentSettings::new);

    public boolean canSignUp(Player player) {
        boolean canSignup = true;
        if (!this.entryCost.isEmpty()) {
            for (SingleStackContainer ssc : this.entryCost) {
                if (player.getInventory().hasAnyMatching(is -> is.is(ssc.stack().getItem()) && is.getCount() >= ssc.stack().getCount())) continue;
                canSignup = false;
            }
        }
        return canSignup;
    }

    public float getPerfectCatchMultiplier() {
        return this.perfectCatchMultiplier;
    }

    public int getMissPenalty() {
        return this.missPenalty;
    }

    public Scoring getScoring() {
        return this.scoring;
    }

    public List<SingleStackContainer> getEntryCost() {
        return this.entryCost;
    }

    public long getDurationInTicks() {
        return this.durationInTicks;
    }

    public TournamentSettings(Scoring type, long duration, float perfectCatchMultiplier, int missPenalty, List<SingleStackContainer> entryCost) {
        this.scoring = type;
        this.durationInTicks = duration;
        this.perfectCatchMultiplier = perfectCatchMultiplier;
        this.missPenalty = missPenalty;
        this.entryCost = entryCost;
    }

    public static enum Scoring implements StringRepresentable
    {
        SIMPLE("gui.starcatcher.tournament.scoring.simple"),
        WEIGHT("gui.starcatcher.tournament.scoring.weight"),
        RARITY("gui.starcatcher.tournament.scoring.rarity"),
        GOLDEN("gui.starcatcher.tournament.scoring.golden"),
        ADVANCED("gui.starcatcher.tournament.scoring.advanced");

        public static final Codec<Scoring> CODEC;
        public static final StreamCodec<RegistryFriendlyByteBuf, Scoring> STREAM_CODEC;
        private final String key;
        private static final Scoring[] vals;

        private Scoring(String name) {
            this.key = name;
        }

        public String toString() {
            return this.key;
        }

        public String getSerializedName() {
            return this.key;
        }

        public Scoring previous() {
            if (this.ordinal() == 0) {
                return vals[vals.length - 1];
            }
            return vals[(this.ordinal() - 1) % vals.length];
        }

        public Scoring next() {
            return vals[(this.ordinal() + 1) % vals.length];
        }

        static {
            CODEC = StringRepresentable.fromEnum(Scoring::values);
            STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(Scoring.class);
            vals = Scoring.values();
        }
    }
}

