/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.tournament;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.wdiscute.starcatcher.io.ExtraComposites;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class TournamentPlayerScore {
    public UUID playerUUID;
    public int score;
    public int misses;
    public int common;
    public int uncommon;
    public int rare;
    public int epic;
    public int legendary;
    public static final Codec<TournamentPlayerScore> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.CODEC.fieldOf("player_uuid").forGetter(t -> t.playerUUID), (App)Codec.INT.optionalFieldOf("score", (Object)0).forGetter(TournamentPlayerScore::getScore), (App)Codec.INT.optionalFieldOf("misses", (Object)0).forGetter(TournamentPlayerScore::getMisses), (App)Codec.INT.optionalFieldOf("common", (Object)0).forGetter(TournamentPlayerScore::getCommon), (App)Codec.INT.optionalFieldOf("uncommon", (Object)0).forGetter(TournamentPlayerScore::getUncommon), (App)Codec.INT.optionalFieldOf("rare", (Object)0).forGetter(TournamentPlayerScore::getRare), (App)Codec.INT.optionalFieldOf("epic", (Object)0).forGetter(TournamentPlayerScore::getRare), (App)Codec.INT.optionalFieldOf("legendary", (Object)0).forGetter(TournamentPlayerScore::getLegendary)).apply((Applicative)instance, TournamentPlayerScore::new));
    public static final StreamCodec<ByteBuf, TournamentPlayerScore> STREAM_CODEC = ExtraComposites.composite(UUIDUtil.STREAM_CODEC, t -> t.playerUUID, ByteBufCodecs.INT, TournamentPlayerScore::getScore, ByteBufCodecs.INT, TournamentPlayerScore::getMisses, ByteBufCodecs.INT, TournamentPlayerScore::getCommon, ByteBufCodecs.INT, TournamentPlayerScore::getUncommon, ByteBufCodecs.INT, TournamentPlayerScore::getRare, ByteBufCodecs.INT, TournamentPlayerScore::getEpic, ByteBufCodecs.INT, TournamentPlayerScore::getLegendary, TournamentPlayerScore::new);
    public static final Codec<List<TournamentPlayerScore>> LIST_CODEC = CODEC.listOf();

    public static TournamentPlayerScore empty() {
        return new TournamentPlayerScore(UUID.randomUUID(), 0, 0, 0, 0, 0, 0, 0);
    }

    public static TournamentPlayerScore empty(UUID uuid) {
        return new TournamentPlayerScore(uuid, 0, 0, 0, 0, 0, 0, 0);
    }

    public void addScore(int score) {
        this.score += score;
    }

    public TournamentPlayerScore(UUID uuid, int score, int misses, int common, int uncommon, int rare, int epic, int legendary) {
        this.playerUUID = uuid;
        this.score = score;
        this.misses = misses;
        this.common = common;
        this.uncommon = uncommon;
        this.rare = rare;
        this.epic = epic;
        this.legendary = legendary;
    }

    public int getCommon() {
        return this.common;
    }

    public int getEpic() {
        return this.epic;
    }

    public int getLegendary() {
        return this.legendary;
    }

    public int getMisses() {
        return this.misses;
    }

    public int getRare() {
        return this.rare;
    }

    public int getScore() {
        return this.score;
    }

    public int getUncommon() {
        return this.uncommon;
    }
}

