/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.tournament;

import com.mojang.authlib.GameProfile;
import com.wdiscute.starcatcher.io.network.tournament.CBActiveTournamentUpdatePayload;
import com.wdiscute.starcatcher.io.network.tournament.CBClearTournamentPayload;
import com.wdiscute.starcatcher.storage.FishProperties;
import com.wdiscute.starcatcher.tournament.Tournament;
import com.wdiscute.starcatcher.tournament.TournamentPlayerScore;
import com.wdiscute.starcatcher.tournament.TournamentSettings;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TournamentHandler {
    private static final List<Tournament> finishedTournaments = new ArrayList<Tournament>();
    private static final List<Tournament> activeTournaments = new ArrayList<Tournament>();
    private static final Logger log = LoggerFactory.getLogger(TournamentHandler.class);

    public static Tournament getTournamentOrNull(UUID uuid) {
        for (Tournament t : activeTournaments) {
            if (!t.tournamentUUID.equals(uuid)) continue;
            return t;
        }
        for (Tournament t : finishedTournaments) {
            if (!t.tournamentUUID.equals(uuid)) continue;
            return t;
        }
        return null;
    }

    public static void sendActiveTournamentUpdateToClient(ServerPlayer sp, Tournament tournament) {
        if (sp == null || tournament == null) {
            return;
        }
        PacketDistributor.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)CBActiveTournamentUpdatePayload.helper((Player)sp, tournament), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void clearTournamentToClient(ServerPlayer sp) {
        if (sp == null) {
            return;
        }
        PacketDistributor.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)new CBClearTournamentPayload(":)"), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void startTournament(Player playerWhoStartedTheTournament, Tournament tournament) {
        activeTournaments.add(tournament);
        tournament.status = Tournament.Status.ACTIVE;
        tournament.lastsUntilEpoch = System.currentTimeMillis() + tournament.settings.durationInTicks / 20L * 1000L;
        Level level = playerWhoStartedTheTournament.level();
        for (TournamentPlayerScore playerScore : tournament.playerScores) {
            ServerPlayer player = level.getServer().getPlayerList().getPlayer(playerScore.playerUUID);
            TournamentHandler.sendActiveTournamentUpdateToClient(player, tournament);
            if (player == null) continue;
            player.sendSystemMessage((Component)Component.literal((String)tournament.name).append((Component)Component.translatable((String)"gui.starcatcher.tournament.started")));
            player.sendSystemMessage((Component)Component.translatable((String)"gui.starcatcher.tournament.press_tab").withColor(-6250336));
        }
    }

    public static void cancelTournament(Level level, Tournament tournament) {
        for (TournamentPlayerScore entry : tournament.playerScores) {
            ServerPlayer player = level.getServer().getPlayerList().getPlayer(entry.playerUUID);
            TournamentHandler.sendActiveTournamentUpdateToClient(player, tournament);
            TournamentHandler.clearTournamentToClient(player);
        }
        activeTournaments.remove(tournament);
        finishedTournaments.add(tournament);
        tournament.status = Tournament.Status.CANCELLED;
    }

    public static void addScore(Player playerToAwardScoreTo, FishProperties fp, boolean perfectCatch, int size, int weight) {
        if (playerToAwardScoreTo.level().isClientSide) {
            return;
        }
        for (Tournament t : activeTournaments) {
            t.playerScores.forEach(p -> {
                if (p.playerUUID.equals(playerToAwardScoreTo.getUUID())) {
                    if (t.settings.scoring.equals((Object)TournamentSettings.Scoring.SIMPLE)) {
                        p.addScore(1);
                    }
                    Level level = playerToAwardScoreTo.level();
                    for (TournamentPlayerScore entry : t.playerScores) {
                        ServerPlayer sp = level.getServer().getPlayerList().getPlayer(entry.playerUUID);
                        TournamentHandler.sendActiveTournamentUpdateToClient(sp, t);
                    }
                }
            });
        }
    }

    public static void tick(ServerTickEvent.Post event) {
        MinecraftServer server = event.getServer();
        long levelTicks = server.getTickCount();
        if (levelTicks % 20L != 0L) {
            return;
        }
        ArrayList<Tournament> finished = new ArrayList<Tournament>();
        for (Tournament t : activeTournaments) {
            if (System.currentTimeMillis() < t.lastsUntilEpoch) continue;
            finished.add(t);
            t.status = Tournament.Status.FINISHED;
            UUID winner = null;
            int bestScore = 0;
            for (TournamentPlayerScore playerscore : t.playerScores) {
                if (playerscore.score <= bestScore) continue;
                bestScore = playerscore.score;
                winner = playerscore.playerUUID;
            }
            String winnerString = "???";
            if (winner != null) {
                winnerString = ((GameProfile)server.getProfileCache().get(winner).get()).getName();
            }
            for (TournamentPlayerScore playerScore : t.playerScores) {
                ServerPlayer player = server.getPlayerList().getPlayer(playerScore.playerUUID);
                if (player == null) continue;
                TournamentHandler.clearTournamentToClient(player);
                player.sendSystemMessage((Component)Component.literal((String)(t.name + " has ended! The winner is " + winnerString + "!")));
            }
        }
        finishedTournaments.addAll(finished);
        activeTournaments.removeAll(finished);
    }

    public static List<Tournament> getAll() {
        ArrayList<Tournament> t = new ArrayList<Tournament>();
        t.addAll(activeTournaments);
        t.addAll(finishedTournaments);
        return t;
    }

    public static void setAll(List<Tournament> tournaments) {
        activeTournaments.clear();
        activeTournaments.addAll(tournaments.stream().filter(t -> t.status.equals((Object)Tournament.Status.ACTIVE)).toList());
        finishedTournaments.clear();
        finishedTournaments.addAll(tournaments.stream().filter(t -> t.status.equals((Object)Tournament.Status.FINISHED)).toList());
        finishedTournaments.addAll(tournaments.stream().filter(t -> t.status.equals((Object)Tournament.Status.CANCELLED)).toList());
    }

    public static Tournament getTournamentForPlayer(Player player) {
        AtomicReference tToReturn = new AtomicReference();
        activeTournaments.forEach(t -> {
            Stream<TournamentPlayerScore> tournamentPlayerScoreStream = t.playerScores.stream().filter(p -> p.playerUUID.equals(player.getUUID()));
            if (tournamentPlayerScoreStream.findFirst().isPresent()) {
                tToReturn.set(t);
            }
        });
        return (Tournament)tToReturn.get();
    }
}

