/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.tournament;

import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.U;
import com.wdiscute.starcatcher.io.network.tournament.SBStandTournamentNameChangePayload;
import com.wdiscute.starcatcher.tournament.StandMenu;
import com.wdiscute.starcatcher.tournament.Tournament;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.PacketDistributor;

public class StandScreen
extends AbstractContainerScreen<StandMenu> {
    public Tournament tournament;
    public static Map<UUID, String> gameProfilesCache;
    private EditBox nameEditBox;
    private boolean nameWasFocused;
    private static final ResourceLocation BACKGROUND_OWNER;
    private static final ResourceLocation BACKGROUND;
    int uiX;
    int uiY;
    boolean isOwner = false;

    protected void init() {
        super.init();
        this.tournament = ((StandMenu)this.menu).sbe.tournament;
        gameProfilesCache = ((StandMenu)this.menu).sbe.profiles;
        this.uiX = (this.width - this.imageWidth) / 2;
        this.uiY = (this.height - this.imageHeight) / 2;
        this.subInit();
    }

    protected void subInit() {
        this.nameEditBox = new EditBox(this.font, this.uiX + 53, this.uiY + 36, 210, 12, (Component)Component.translatable((String)"container.repair"));
        this.nameEditBox.setCanLoseFocus(true);
        this.nameEditBox.setTextColor(6508608);
        this.nameEditBox.setBordered(false);
        this.nameEditBox.setMaxLength(20);
        this.nameEditBox.setValue("");
        this.nameEditBox.setTextShadow(false);
        this.nameEditBox.setEditable(false);
        this.addWidget((GuiEventListener)this.nameEditBox);
    }

    protected void renderBg(GuiGraphics guiGraphics, float v, int i, int i1) {
        this.renderBlurredBackground(i);
    }

    private void onFocusNameEditBox() {
        this.nameEditBox.setValue(this.tournament.name);
        this.tournament.name = "";
    }

    private void onUnfocusNameEditBox() {
        PacketDistributor.sendToServer((CustomPacketPayload)new SBStandTournamentNameChangePayload(this.tournament.tournamentUUID, this.nameEditBox.getValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.tournament.name = this.nameEditBox.getValue();
        this.nameEditBox.setValue("");
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        ArrayList<MutableComponent> durationTooltip;
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        if (this.isOwner) {
            this.renderImage(guiGraphics, BACKGROUND_OWNER);
        } else {
            this.renderImage(guiGraphics, BACKGROUND);
        }
        if (this.tournament != ((StandMenu)this.menu).sbe.tournament) {
            this.onTournamentReceived();
        }
        if (this.tournament == null) {
            return;
        }
        if (gameProfilesCache == null) {
            return;
        }
        double x = mouseX - this.uiX;
        double y = mouseY - this.uiY;
        if (this.nameWasFocused != this.nameEditBox.isFocused()) {
            if (this.nameEditBox.isFocused()) {
                this.onFocusNameEditBox();
            } else {
                this.onUnfocusNameEditBox();
            }
        }
        this.nameWasFocused = this.nameEditBox.isFocused();
        guiGraphics.drawString(this.font, this.tournament.name, this.uiX + 53, this.uiY + 36, 6508608, false);
        this.nameEditBox.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawString(this.font, StandScreen.getPlayerFromUUID(this.tournament.owner), this.uiX + 55, this.uiY + 56, 6508608, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.starcatcher.tournament.organizer"), this.uiX + 55, this.uiY + 68, 10258812, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)this.tournament.status.getSerializedName()), this.uiX + 130, this.uiY + 56, 6508608, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.starcatcher.tournament.status"), this.uiX + 130, this.uiY + 68, 10258812, false);
        guiGraphics.drawString(this.font, U.calculateRealLifeTimeFromTicks(this.tournament.settings.durationInTicks), this.uiX + 55, this.uiY + 88, 6508608, false);
        if (this.isOwner) {
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.starcatcher.tournament.duration"), this.uiX + 60, this.uiY + 100, 10258812, false);
        } else {
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.starcatcher.tournament.duration"), this.uiX + 56, this.uiY + 100, 10258812, false);
        }
        if (x > 52.0 && x < 116.0 && y > 85.0 && y < 98.0) {
            durationTooltip = new ArrayList<MutableComponent>();
            durationTooltip.add(Component.literal((String)(this.tournament.settings.durationInTicks + " ticks")));
            MutableComponent durationComp = Component.literal((String)String.format("%.2f ", Float.valueOf((float)this.tournament.settings.durationInTicks / 24000.0f)));
            if (this.tournament.settings.durationInTicks % 24000L == 0L) {
                durationComp = Component.literal((String)(this.tournament.settings.durationInTicks / 24000L + " "));
            }
            durationTooltip.add(durationComp.append((Component)Component.translatable((String)"gui.starcatcher.tournament.duration.days")));
            guiGraphics.renderTooltip(this.font, durationTooltip, Optional.empty(), mouseX, mouseY);
        }
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)this.tournament.settings.scoring.getSerializedName()), this.uiX + 130, this.uiY + 88, 6508608, false);
        if (this.isOwner) {
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.starcatcher.tournament.scoring"), this.uiX + 134, this.uiY + 100, 10258812, false);
        } else {
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.starcatcher.tournament.scoring"), this.uiX + 130, this.uiY + 100, 10258812, false);
        }
        if (x > 129.0 && x < 190.0 && y > 85.0 && y < 98.0) {
            durationTooltip = new ArrayList();
            durationTooltip.add(Component.translatable((String)"gui.starcatcher.tournament.scoring.later"));
            guiGraphics.renderTooltip(this.font, durationTooltip, Optional.empty(), mouseX, mouseY);
        }
        if (this.tournament.playerScores.stream().anyMatch(t -> t.playerUUID.equals(Minecraft.getInstance().player.getUUID()))) {
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.starcatcher.tournament.signed_up"), this.uiX + 65, this.uiY + 116, 10258812, false);
        } else {
            int color = this.tournament.settings.canSignUp((Player)this.minecraft.player) ? 4224300 : 10700086;
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.starcatcher.tournament.sign_up"), this.uiX + 65, this.uiY + 116, color, false);
        }
        boolean drawOthers = false;
        ArrayList<MutableComponent> others = new ArrayList<MutableComponent>();
        others.add(Component.translatable((String)"gui.starcatcher.tournament.other"));
        for (int i = 0; i < this.tournament.playerScores.size(); ++i) {
            if (i < 5) {
                if (i == 0) {
                    guiGraphics.drawString(this.font, StandScreen.getPlayerFromUUID(this.tournament.playerScores.get((int)i).playerUUID), this.uiX + 77, this.uiY + 128, 6508608, false);
                    continue;
                }
                guiGraphics.drawString(this.font, StandScreen.getPlayerFromUUID(this.tournament.playerScores.get((int)i).playerUUID), this.uiX + 65, this.uiY + 140 + (i - 1) * 12, 6508608, false);
                continue;
            }
            drawOthers = true;
            others.add(Component.literal((String)StandScreen.getPlayerFromUUID(this.tournament.playerScores.get((int)i).playerUUID)));
        }
        if (drawOthers) {
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.hover"), this.uiX + 65, this.uiY + 140 + 48, 6508608, false);
            if (x > 62.0 && x < 180.0 && y > 186.0 && y < 197.0) {
                guiGraphics.renderTooltip(this.font, others, Optional.empty(), mouseX, mouseY);
            }
        }
        if (this.isOwner) {
            if (this.tournament.status.equals((Object)Tournament.Status.SETUP)) {
                guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.starcatcher.tournament.start"), this.uiX + 236, this.uiY + 188, 6508608, false);
                if (x > 226.0 && x < 340.0 && y > 183.0 && y < 200.0) {
                    guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.starcatcher.tournament.undone"), mouseX, mouseY);
                }
            }
            if (this.tournament.status.equals((Object)Tournament.Status.ACTIVE)) {
                if (x > 226.0 && x < 340.0 && y > 183.0 && y < 200.0) {
                    guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.starcatcher.tournament.undone"), mouseX, mouseY);
                }
                guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.starcatcher.tournament.cancel"), this.uiX + 236, this.uiY + 188, 6508608, false);
            }
            if (this.tournament.status.isDone()) {
                if (x > 226.0 && x < 340.0 && y > 183.0 && y < 200.0) {
                    guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.starcatcher.tournament.undone"), mouseX, mouseY);
                }
                guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.starcatcher.tournament.new"), this.uiX + 236, this.uiY + 188, 6508608, false);
            }
        } else {
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.starcatcher.tournament.waiting").append((Component)Component.literal((String)(" " + gameProfilesCache.get(this.tournament.owner) + "..."))), this.uiX + 236, this.uiY + 188, 6508608, false);
        }
    }

    public void onTournamentReceived() {
        this.tournament = ((StandMenu)this.menu).sbe.tournament;
        gameProfilesCache = ((StandMenu)this.menu).sbe.profiles;
        this.isOwner = this.tournament.owner.equals(Minecraft.getInstance().player.getUUID());
        this.nameEditBox.setEditable(this.isOwner);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        double x = mouseX - (double)this.uiX;
        double y = mouseY - (double)this.uiY;
        if (x > 53.0 && x < 117.0 && y > 88.0 && y < 107.0 && this.isOwner && scrollY < -0.5) {
            if (!StandScreen.hasShiftDown()) {
                this.minecraft.gameMode.handleInventoryButtonClick(((StandMenu)this.menu).containerId, 101);
            } else {
                this.minecraft.gameMode.handleInventoryButtonClick(((StandMenu)this.menu).containerId, 102);
            }
        }
        if (x > 53.0 && x < 117.0 && y > 88.0 && y < 107.0 && this.isOwner && scrollY > 0.5) {
            if (!StandScreen.hasShiftDown()) {
                this.minecraft.gameMode.handleInventoryButtonClick(((StandMenu)this.menu).containerId, 103);
            } else {
                this.minecraft.gameMode.handleInventoryButtonClick(((StandMenu)this.menu).containerId, 104);
            }
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        double x = mouseX - (double)this.uiX;
        double y = mouseY - (double)this.uiY;
        assert (this.minecraft != null);
        assert (this.minecraft.gameMode != null);
        if (x > 62.0 && x < 180.0 && y > 115.0 && y < 124.0) {
            this.minecraft.gameMode.handleInventoryButtonClick(((StandMenu)this.menu).containerId, 67);
        }
        if (x > 226.0 && x < 340.0 && y > 183.0 && y < 200.0) {
            if (this.tournament.status.equals((Object)Tournament.Status.SETUP)) {
                this.minecraft.gameMode.handleInventoryButtonClick(((StandMenu)this.menu).containerId, 68);
            }
            if (this.tournament.status.equals((Object)Tournament.Status.ACTIVE)) {
                this.minecraft.gameMode.handleInventoryButtonClick(((StandMenu)this.menu).containerId, 69);
            }
            if (this.tournament.status.isDone()) {
                this.minecraft.gameMode.handleInventoryButtonClick(((StandMenu)this.menu).containerId, 53);
            }
        }
        if (x > 50.0 && x < 60.0 && y > 98.0 && y < 107.0 && this.isOwner) {
            if (!StandScreen.hasShiftDown()) {
                this.minecraft.gameMode.handleInventoryButtonClick(((StandMenu)this.menu).containerId, 101);
            } else {
                this.minecraft.gameMode.handleInventoryButtonClick(((StandMenu)this.menu).containerId, 102);
            }
        }
        if (x > 109.0 && x < 119.0 && y > 99.0 && y < 109.0 && this.isOwner) {
            if (!StandScreen.hasShiftDown()) {
                this.minecraft.gameMode.handleInventoryButtonClick(((StandMenu)this.menu).containerId, 103);
            } else {
                this.minecraft.gameMode.handleInventoryButtonClick(((StandMenu)this.menu).containerId, 104);
            }
        }
        if (!(x > 124.0) || !(x < 134.0) || !(y > 99.0) || y < 109.0) {
            // empty if block
        }
        if (!(x > 182.0) || !(x < 192.0) || !(y > 99.0) || y < 109.0) {
            // empty if block
        }
        this.nameEditBox.setFocused(false);
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public static String getPlayerFromUUID(UUID uuid) {
        if (gameProfilesCache != null && gameProfilesCache.containsKey(uuid)) {
            return gameProfilesCache.get(uuid);
        }
        return "Unknown";
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    private void renderImage(GuiGraphics guiGraphics, ResourceLocation rl) {
        guiGraphics.blit(rl, this.uiX, this.uiY, 0.0f, 0.0f, 420, 260, 420, 260);
    }

    private void renderImage(GuiGraphics guiGraphics, ResourceLocation rl, int xOffset, int yOffset) {
        guiGraphics.blit(rl, this.uiX + xOffset, this.uiY + yOffset, 0.0f, 0.0f, 420, 260, 420, 260);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.minecraft.player.closeContainer();
        }
        boolean editbox = this.nameEditBox.keyPressed(keyCode, scanCode, modifiers) || this.nameEditBox.canConsumeInput();
        return editbox || super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void onClose() {
        super.onClose();
        if (!this.nameEditBox.getValue().isEmpty()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new SBStandTournamentNameChangePayload(this.tournament.tournamentUUID, this.nameEditBox.getValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public StandScreen(StandMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.tournament = menu.sbe.tournament;
        this.imageWidth = 420;
        this.imageHeight = 260;
    }

    static {
        BACKGROUND_OWNER = Starcatcher.rl("textures/gui/tournament/background_owner.png");
        BACKGROUND = Starcatcher.rl("textures/gui/tournament/background.png");
    }
}

