/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.storage;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.wdiscute.starcatcher.Config;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.StarcatcherTags;
import com.wdiscute.starcatcher.U;
import com.wdiscute.starcatcher.bob.FishingBobEntity;
import com.wdiscute.starcatcher.compat.EclipticSeasonsCompat;
import com.wdiscute.starcatcher.compat.SereneSeasonsCompat;
import com.wdiscute.starcatcher.compat.TerraFirmaCraftSeasonsCompat;
import com.wdiscute.starcatcher.io.ExtraComposites;
import com.wdiscute.starcatcher.io.ModDataComponents;
import com.wdiscute.starcatcher.io.SingleStackContainer;
import com.wdiscute.starcatcher.registry.ModItems;
import com.wdiscute.starcatcher.registry.custom.minigamemodifiers.ModMinigameModifiers;
import com.wdiscute.starcatcher.registry.custom.sweetspotbehaviour.ModSweetSpotsBehaviour;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public record FishProperties(CatchInfo catchInfo, int baseChance, SizeAndWeight sizeWeight, Rarity rarity, WorldRestrictions wr, BaitRestrictions br, Difficulty dif, Daytime daytime, Weather weather, boolean skipMinigame, boolean hasGuideEntry) {
    public static final Codec<FishProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CatchInfo.CODEC.fieldOf("catch_info").forGetter(FishProperties::catchInfo), (App)Codec.INT.fieldOf("base_chance").forGetter(FishProperties::baseChance), (App)SizeAndWeight.CODEC.fieldOf("size_and_weight").forGetter(FishProperties::sizeWeight), (App)Rarity.CODEC.fieldOf("rarity").forGetter(FishProperties::rarity), (App)WorldRestrictions.CODEC.fieldOf("world_restrictions").forGetter(FishProperties::wr), (App)BaitRestrictions.CODEC.fieldOf("bait_restrictions").forGetter(FishProperties::br), (App)Difficulty.CODEC.fieldOf("difficulty").forGetter(FishProperties::dif), (App)Daytime.CODEC.fieldOf("daytime").forGetter(FishProperties::daytime), (App)Weather.CODEC.fieldOf("weather").forGetter(FishProperties::weather), (App)Codec.BOOL.fieldOf("skips_minigame").forGetter(FishProperties::skipMinigame), (App)Codec.BOOL.fieldOf("has_guide_entry").forGetter(FishProperties::hasGuideEntry)).apply((Applicative)instance, FishProperties::new));
    public static final Codec<List<FishProperties>> LIST_CODEC = CODEC.listOf();
    public static final StreamCodec<RegistryFriendlyByteBuf, FishProperties> STREAM_CODEC = ExtraComposites.composite(CatchInfo.STREAM_CODEC, FishProperties::catchInfo, ByteBufCodecs.VAR_INT, FishProperties::baseChance, SizeAndWeight.STREAM_CODEC, FishProperties::sizeWeight, Rarity.STREAM_CODEC, FishProperties::rarity, WorldRestrictions.STREAM_CODEC, FishProperties::wr, BaitRestrictions.STREAM_CODEC, FishProperties::br, Difficulty.STREAM_CODEC, FishProperties::dif, Daytime.STREAM_CODEC, FishProperties::daytime, Weather.STREAM_CODEC, FishProperties::weather, ByteBufCodecs.BOOL, FishProperties::skipMinigame, ByteBufCodecs.BOOL, FishProperties::hasGuideEntry, FishProperties::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, List<FishProperties>> STREAM_CODEC_LIST = STREAM_CODEC.apply(ByteBufCodecs.list());
    @Deprecated(forRemoval=true)
    public static final FishProperties DEFAULT = new FishProperties(CatchInfo.DEFAULT, 5, SizeAndWeight.DEFAULT, Rarity.COMMON, WorldRestrictions.DEFAULT, BaitRestrictions.DEFAULT, Difficulty.EASY, Daytime.ALL, Weather.ALL, false, true);

    public ResourceLocation toLoc(Level level) {
        return U.getRlFromFp(level, this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static List<ResourceLocation> getBiomesAsList(FishProperties fp, Level level) {
        level.registryAccess().registry(Registries.BIOME);
        ArrayList<ResourceLocation> rls = new ArrayList<ResourceLocation>();
        for (ResourceLocation rl : fp.wr.biomesTags) {
            TagKey biomeBeingChecked = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)rl);
            Optional optional = level.registryAccess().lookupOrThrow(Registries.BIOME).get(biomeBeingChecked);
            if (!optional.isPresent()) continue;
            for (Holder biomeHolder : (HolderSet.Named)optional.get()) {
                String biomeString = biomeHolder.getRegisteredName();
                rls.add(ResourceLocation.parse((String)biomeString));
            }
        }
        for (ResourceLocation rl : fp.wr.biomes) {
            Optional optional = level.registryAccess().lookupOrThrow(Registries.BIOME).get(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)rl));
            if (!optional.isPresent() || rls.contains(rl)) continue;
            rls.add(rl);
        }
        return rls;
    }

    public static List<ResourceLocation> getBiomesBlacklistAsList(FishProperties fp, Level level) {
        level.registryAccess().registry(Registries.BIOME);
        ArrayList<ResourceLocation> rls = new ArrayList<ResourceLocation>();
        for (ResourceLocation rl : fp.wr.biomesBlacklistTags) {
            TagKey biomeBeingChecked = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)rl);
            Optional optional = level.registryAccess().lookupOrThrow(Registries.BIOME).get(biomeBeingChecked);
            if (!optional.isPresent()) continue;
            for (Holder biomeHolder : (HolderSet.Named)optional.get()) {
                String biomeString = biomeHolder.getRegisteredName();
                rls.add(ResourceLocation.parse((String)biomeString));
            }
        }
        for (ResourceLocation rl : fp.wr.biomesBlacklist) {
            Optional optional = level.registryAccess().lookupOrThrow(Registries.BIOME).get(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)rl));
            if (!optional.isPresent() || rls.contains(rl)) continue;
            rls.add(rl);
        }
        return rls;
    }

    public static List<FishProperties> getFPs(Level level) {
        return FishProperties.getFPs(level.registryAccess());
    }

    public static List<FishProperties> getFPs(RegistryAccess registryAccess) {
        return registryAccess.registryOrThrow(Starcatcher.FISH_REGISTRY).stream().toList();
    }

    public static int getChance(FishProperties fp, Entity entity, ItemStack rod) {
        ItemStack bait;
        Level level = entity.level();
        if (!FishProperties.isSeasonCorrect(entity, fp)) {
            return 0;
        }
        if (!FishProperties.isDimensionCorrect(entity, fp)) {
            return 0;
        }
        if (!FishProperties.isBiomeCorrect(entity, fp)) {
            return 0;
        }
        if (!FishProperties.isElevationCorrect(entity, fp)) {
            return 0;
        }
        if (!FishProperties.isDaytimeCorrect(entity, fp)) {
            return 0;
        }
        if (!FishProperties.isWeatherCorrect(entity, fp, rod)) {
            return 0;
        }
        boolean fluid = fp.wr.fluids.contains(BuiltInRegistries.FLUID.getKey((Object)FishProperties.getSource(level.getFluidState(entity.blockPosition()).getType())));
        boolean fluidAbove = fp.wr.fluids.contains(BuiltInRegistries.FLUID.getKey((Object)FishProperties.getSource(level.getFluidState(entity.blockPosition().above()).getType())));
        boolean fluidBelow = fp.wr.fluids.contains(BuiltInRegistries.FLUID.getKey((Object)FishProperties.getSource(level.getFluidState(entity.blockPosition().below()).getType())));
        if (!fluid && !fluidAbove && !fluidBelow && entity instanceof FishingBobEntity) {
            return 0;
        }
        ItemStack itemStack = bait = ModDataComponents.has(rod, ModDataComponents.BAIT) ? ((SingleStackContainer)ModDataComponents.get(rod, ModDataComponents.BAIT)).stack().copy() : ItemStack.EMPTY;
        if (fp.br().correctBait().contains(BuiltInRegistries.ITEM.getKey((Object)bait.getItem()))) {
            return fp.baseChance() + fp.br().correctBaitChanceAdded();
        }
        return fp.baseChance();
    }

    public static List<FishProperties> getFpsWithGuideEntryForArea(Entity entity) {
        ArrayList<FishProperties> list = new ArrayList<FishProperties>();
        for (FishProperties fp : entity.level().registryAccess().registryOrThrow(Starcatcher.FISH_REGISTRY)) {
            if (!FishProperties.isDimensionCorrect(entity, fp) || !FishProperties.isBiomeCorrect(entity, fp) || !FishProperties.isElevationCorrect(entity, fp) || !fp.hasGuideEntry || fp.baseChance == 0) continue;
            list.add(fp);
        }
        return list;
    }

    public static boolean isWeatherCorrect(Entity entity, FishProperties fp, ItemStack rod) {
        ItemStack bait;
        Level level = entity.level();
        ItemStack itemStack = bait = ModDataComponents.has(rod, ModDataComponents.BAIT) ? ((SingleStackContainer)ModDataComponents.get(rod, ModDataComponents.BAIT)).stack().copy() : ItemStack.EMPTY;
        if (!bait.is(ModItems.METEOROLOGICAL_BAIT)) {
            if (fp.weather() == Weather.CLEAR && ((double)level.getRainLevel(0.0f) > 0.5 || (double)level.getThunderLevel(0.0f) > 0.5)) {
                return false;
            }
            if (fp.weather() == Weather.RAIN && (double)level.getRainLevel(0.0f) < 0.5) {
                return false;
            }
            if (fp.weather() == Weather.THUNDER && (double)level.getThunderLevel(0.0f) < 0.5) {
                return false;
            }
        }
        return true;
    }

    public static boolean isDaytimeCorrect(Entity entity, FishProperties fp) {
        Level level = entity.level();
        if (fp.daytime() != Daytime.ALL) {
            long time = level.getDayTime() % 24000L;
            switch (fp.daytime().ordinal()) {
                case 1: {
                    if (time < 12700L || time > 23000L) break;
                    return false;
                }
                case 2: {
                    if (time > 3500L && time < 8500L) break;
                    return false;
                }
                case 3: {
                    if (time < 23000L && time > 12700L) break;
                    return false;
                }
                case 4: {
                    if (time > 16500L && time < 19500L) break;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isElevationCorrect(Entity entity, FishProperties fp) {
        if (entity.position().y > (double)fp.wr.mustBeCaughtBelowY()) {
            return false;
        }
        return !(entity.position().y < (double)fp.wr.mustBeCaughtAboveY());
    }

    public static boolean isBiomeCorrect(Entity entity, FishProperties fp) {
        Level level = entity.level();
        List<ResourceLocation> biomes = FishProperties.getBiomesAsList(fp, level);
        List<ResourceLocation> blacklist = FishProperties.getBiomesBlacklistAsList(fp, level);
        ResourceLocation currentBiome = level.getBiome(entity.blockPosition()).getKey().location();
        if (!biomes.isEmpty() && !biomes.contains(currentBiome)) {
            return false;
        }
        return blacklist.isEmpty() || !blacklist.contains(currentBiome);
    }

    public static boolean isDimensionCorrect(Entity entity, FishProperties fp) {
        if (!fp.wr.dims.isEmpty() && !fp.wr().dims().contains(entity.level().dimension().location())) {
            return false;
        }
        return !fp.wr.dimsBlacklist.contains(entity.level().dimension().location());
    }

    public static boolean isSeasonCorrect(Entity entity, FishProperties fp) {
        if (ModList.get().isLoaded("sereneseasons") && ((Boolean)Config.ENABLE_SEASONS.get()).booleanValue() && !SereneSeasonsCompat.canCatch(fp, entity.level())) {
            return false;
        }
        if (ModList.get().isLoaded("eclipticseasons") && ((Boolean)Config.ENABLE_SEASONS.get()).booleanValue() && !EclipticSeasonsCompat.canCatch(fp, entity.level())) {
            return false;
        }
        return !ModList.get().isLoaded("tfc") || (Boolean)Config.ENABLE_SEASONS.get() == false || TerraFirmaCraftSeasonsCompat.canCatch(fp, entity.level());
    }

    public static Fluid getSource(Fluid fluid1) {
        if (fluid1 instanceof FlowingFluid) {
            FlowingFluid fluid = (FlowingFluid)fluid1;
            return fluid.getSource();
        }
        return fluid1;
    }

    public static SizeAndWeight sizeWeight(float sizeAvg, float sizeDev, float weightAvg, float weightDev) {
        return new SizeAndWeight(sizeAvg, sizeDev, weightAvg, weightDev);
    }

    public static ResourceLocation rl(String ns, String path) {
        return ResourceLocation.fromNamespaceAndPath((String)ns, (String)path);
    }

    public record CatchInfo(Holder<Item> fish, Holder<Item> bucketedFish, Holder<EntityType<?>> entityToSpawn, boolean alwaysSpawnEntity, Holder<Item> overrideMinigameWith, Holder<Item> treasure) {
        public static final Codec<CatchInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.ITEM.holderByNameCodec().fieldOf("item").forGetter(CatchInfo::fish), (App)BuiltInRegistries.ITEM.holderByNameCodec().fieldOf("fish_bucket").forGetter(CatchInfo::bucketedFish), (App)BuiltInRegistries.ENTITY_TYPE.holderByNameCodec().fieldOf("entity").forGetter(CatchInfo::entityToSpawn), (App)Codec.BOOL.fieldOf("always_spawn_entity").forGetter(CatchInfo::alwaysSpawnEntity), (App)BuiltInRegistries.ITEM.holderByNameCodec().optionalFieldOf("override_minigame_item", ModItems.MISSINGNO).forGetter(CatchInfo::overrideMinigameWith), (App)BuiltInRegistries.ITEM.holderByNameCodec().optionalFieldOf("treasure", ModItems.MISSINGNO).forGetter(CatchInfo::treasure)).apply((Applicative)instance, CatchInfo::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, CatchInfo> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.ITEM), CatchInfo::fish, (StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.ITEM), CatchInfo::bucketedFish, (StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.ENTITY_TYPE), CatchInfo::entityToSpawn, (StreamCodec)ByteBufCodecs.BOOL, CatchInfo::alwaysSpawnEntity, (StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.ITEM), CatchInfo::overrideMinigameWith, (StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.ITEM), CatchInfo::treasure, CatchInfo::new);
        public static final CatchInfo DEFAULT = new CatchInfo((Holder<Item>)ModItems.MISSINGNO, (Holder<Item>)ModItems.MISSINGNO, U.holderEntity("starcatcher", "fish"), false, (Holder<Item>)ModItems.MISSINGNO, (Holder<Item>)ModItems.WATERLOGGED_SATCHEL);

        public CatchInfo withItemToOverrideWith(Holder<Item> itemToOverrideWith) {
            return new CatchInfo(this.fish, this.bucketedFish, this.entityToSpawn, this.alwaysSpawnEntity, itemToOverrideWith, this.treasure);
        }

        public static class Builder {
            private Holder<Item> fish = ModItems.MISSINGNO;
            private Holder<Item> bucketedFish = ModItems.MISSINGNO;
            private Holder<EntityType<?>> entityToSpawn = U.holderEntity("starcatcher", "fish");
            private boolean alwaysSpawnEntity = false;
            private Holder<Item> itemToOverrideWith = ModItems.MISSINGNO;
            private Holder<Item> treasure = ModItems.WATERLOGGED_SATCHEL;

            public Builder withFish(Holder<Item> fish) {
                this.fish = fish;
                return this;
            }

            public Builder withBucketedFish(Holder<Item> bucketedFish) {
                this.bucketedFish = bucketedFish;
                return this;
            }

            public Builder withEntityToSpawn(Holder<EntityType<?>> entityToSpawn) {
                this.entityToSpawn = entityToSpawn;
                return this;
            }

            public Builder withAlwaysSpawnEntity(boolean alwaysSpawnEntity) {
                this.alwaysSpawnEntity = alwaysSpawnEntity;
                return this;
            }

            public Builder withOverrideMinigameWith(Holder<Item> itemToOverrideWith) {
                this.itemToOverrideWith = itemToOverrideWith;
                return this;
            }

            public CatchInfo build() {
                return new CatchInfo(this.fish, this.bucketedFish, this.entityToSpawn, this.alwaysSpawnEntity, this.itemToOverrideWith, this.treasure);
            }
        }
    }

    public record SizeAndWeight(float sizeAverage, float sizeDeviation, float weightAverage, float weightDeviation) {
        public static final SizeAndWeight DEFAULT = new SizeAndWeight(41.0f, 21.0f, 2001.0f, 701.0f);
        public static final SizeAndWeight NONE = new SizeAndWeight(0.0f, 0.0f, 0.0f, 0.0f);
        public static final Codec<SizeAndWeight> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("average_size_cm").forGetter(SizeAndWeight::sizeAverage), (App)Codec.FLOAT.fieldOf("deviation_size_cm").forGetter(SizeAndWeight::sizeDeviation), (App)Codec.FLOAT.fieldOf("average_weight_grams").forGetter(SizeAndWeight::weightAverage), (App)Codec.FLOAT.fieldOf("deviation_weight_grams").forGetter(SizeAndWeight::weightDeviation)).apply((Applicative)instance, SizeAndWeight::new));
        public static final StreamCodec<ByteBuf, SizeAndWeight> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, SizeAndWeight::sizeAverage, (StreamCodec)ByteBufCodecs.FLOAT, SizeAndWeight::sizeDeviation, (StreamCodec)ByteBufCodecs.FLOAT, SizeAndWeight::weightAverage, (StreamCodec)ByteBufCodecs.FLOAT, SizeAndWeight::weightDeviation, SizeAndWeight::new);
    }

    public static enum Rarity implements StringRepresentable
    {
        COMMON("common", 4, "", "", Style.EMPTY.applyFormat(ChatFormatting.WHITE), 40),
        UNCOMMON("uncommon", 8, "<gradient-37>", "</gradient-43>", Style.EMPTY.applyFormat(ChatFormatting.GREEN), 40),
        RARE("rare", 12, "<gradient-57>", "</gradient-63>", Style.EMPTY.applyFormat(ChatFormatting.BLUE), 30),
        EPIC("epic", 20, "<gradient-80>", "</gradient-90>", Style.EMPTY.applyFormat(ChatFormatting.LIGHT_PURPLE), 10),
        LEGENDARY("legendary", 35, "<rgb>", "</rgb>", Style.EMPTY.applyFormat(ChatFormatting.GOLD), 10);

        public static final Codec<Rarity> CODEC;
        public static final StreamCodec<FriendlyByteBuf, Rarity> STREAM_CODEC;
        private final String key;
        private final int xp;
        private final String pre;
        private final String post;
        private final Style style;
        private final int stoneHookGraceTicks;

        private Rarity(String key, int xp, String pre, String post, Style style, int stoneHookGraceTicks) {
            this.key = key;
            this.xp = xp;
            this.pre = pre;
            this.post = post;
            this.style = style;
            this.stoneHookGraceTicks = stoneHookGraceTicks;
        }

        public String getSerializedName() {
            return this.key;
        }

        public int getStoneHookGraceTicks() {
            return this.stoneHookGraceTicks;
        }

        public int getId() {
            return this.ordinal();
        }

        public int getXp() {
            return this.xp;
        }

        public String getPre() {
            return this.pre;
        }

        public String getPost() {
            return this.post;
        }

        public Style getStyle() {
            return this.style;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Rarity::values);
            STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(Rarity.class);
        }
    }

    public record WorldRestrictions(List<ResourceLocation> dims, List<ResourceLocation> dimsBlacklist, List<ResourceLocation> biomes, List<ResourceLocation> biomesTags, List<ResourceLocation> biomesBlacklist, List<ResourceLocation> biomesBlacklistTags, List<ResourceLocation> fluids, List<Seasons> seasons, int mustBeCaughtBelowY, int mustBeCaughtAboveY) {
        public static final WorldRestrictions DEFAULT = new WorldRestrictions(List.of(), List.of(), List.of(), List.of(), List.of(), List.of(), List.of(ResourceLocation.withDefaultNamespace((String)"water")), List.of(Seasons.ALL), Integer.MAX_VALUE, Integer.MIN_VALUE);
        public static final Codec<WorldRestrictions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)ResourceLocation.CODEC).fieldOf("dimensions").forGetter(WorldRestrictions::dims), (App)Codec.list((Codec)ResourceLocation.CODEC).fieldOf("dimensions_blacklist").forGetter(WorldRestrictions::dimsBlacklist), (App)Codec.list((Codec)ResourceLocation.CODEC).fieldOf("biomes").forGetter(WorldRestrictions::biomes), (App)Codec.list((Codec)ResourceLocation.CODEC).fieldOf("biomes_tags").forGetter(WorldRestrictions::biomesTags), (App)Codec.list((Codec)ResourceLocation.CODEC).fieldOf("biomes_blacklist").forGetter(WorldRestrictions::biomesBlacklist), (App)Codec.list((Codec)ResourceLocation.CODEC).fieldOf("biomes_blacklist_tags").forGetter(WorldRestrictions::biomesBlacklistTags), (App)Codec.list((Codec)ResourceLocation.CODEC).fieldOf("fluids").forGetter(WorldRestrictions::fluids), (App)Seasons.LIST_CODEC.fieldOf("seasons").forGetter(WorldRestrictions::seasons), (App)Codec.INT.fieldOf("below_y").forGetter(WorldRestrictions::mustBeCaughtBelowY), (App)Codec.INT.fieldOf("above_y").forGetter(WorldRestrictions::mustBeCaughtAboveY)).apply((Applicative)instance, WorldRestrictions::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, WorldRestrictions> STREAM_CODEC = ExtraComposites.composite(ByteBufCodecs.fromCodec((Codec)Codec.list((Codec)ResourceLocation.CODEC)), WorldRestrictions::dims, ByteBufCodecs.fromCodec((Codec)Codec.list((Codec)ResourceLocation.CODEC)), WorldRestrictions::dimsBlacklist, ByteBufCodecs.fromCodec((Codec)Codec.list((Codec)ResourceLocation.CODEC)), WorldRestrictions::biomes, ByteBufCodecs.fromCodec((Codec)Codec.list((Codec)ResourceLocation.CODEC)), WorldRestrictions::biomesTags, ByteBufCodecs.fromCodec((Codec)Codec.list((Codec)ResourceLocation.CODEC)), WorldRestrictions::biomesBlacklist, ByteBufCodecs.fromCodec((Codec)Codec.list((Codec)ResourceLocation.CODEC)), WorldRestrictions::biomesBlacklistTags, ByteBufCodecs.fromCodec((Codec)Codec.list((Codec)ResourceLocation.CODEC)), WorldRestrictions::fluids, Seasons.LIST_STREAM_CODEC, WorldRestrictions::seasons, ByteBufCodecs.VAR_INT, WorldRestrictions::mustBeCaughtBelowY, ByteBufCodecs.VAR_INT, WorldRestrictions::mustBeCaughtAboveY, WorldRestrictions::new);
        public static final WorldRestrictions OVERWORLD = DEFAULT.withDims(Level.OVERWORLD.location());
        public static final WorldRestrictions OVERWORLD_LUSH_CAVES = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomes(Biomes.LUSH_CAVES.location()).withMustBeCaughtBelowY(50);
        public static final WorldRestrictions OVERWORLD_STONE_CAVES = DEFAULT.withDims(Level.OVERWORLD.location()).withMustBeCaughtBelowY(50).withMustBeCaughtAboveY(0);
        public static final WorldRestrictions OVERWORLD_DEEPSLATE = DEFAULT.withDims(Level.OVERWORLD.location()).withMustBeCaughtBelowY(0);
        public static final WorldRestrictions OVERWORLD_DRIPSTONE_CAVES = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomes(Biomes.DRIPSTONE_CAVES.location()).withMustBeCaughtBelowY(50).withMustBeCaughtAboveY(0);
        public static final WorldRestrictions OVERWORLD_DEEP_DARK = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomes(Biomes.DEEP_DARK.location()).withMustBeCaughtBelowY(50);
        public static final WorldRestrictions OVERWORLD_RIVER = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomesTags(StarcatcherTags.IS_RIVER).withMustBeCaughtAboveY(50).withMustBeCaughtBelowY(100);
        public static final WorldRestrictions OVERWORLD_OCEAN = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomesTags(StarcatcherTags.IS_OCEAN).withMustBeCaughtAboveY(50).withMustBeCaughtBelowY(100);
        public static final WorldRestrictions OVERWORLD_WARM_OCEAN = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomesTags(StarcatcherTags.IS_WARM_OCEAN).withMustBeCaughtAboveY(50).withMustBeCaughtBelowY(100);
        public static final WorldRestrictions OVERWORLD_DEEP_OCEAN = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomesTags(StarcatcherTags.IS_DEEP_OCEAN).withMustBeCaughtAboveY(50).withMustBeCaughtBelowY(100);
        public static final WorldRestrictions OVERWORLD_LAKE = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomesBlacklistTags(StarcatcherTags.IS_OCEAN, StarcatcherTags.IS_RIVER).withMustBeCaughtAboveY(50).withMustBeCaughtBelowY(100);
        public static final WorldRestrictions OVERWORLD_FRESHWATER = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomesBlacklistTags(StarcatcherTags.IS_OCEAN).withMustBeCaughtAboveY(50);
        public static final WorldRestrictions OVERWORLD_COLD_FRESHWATER = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomesTags(StarcatcherTags.IS_COLD_LAKE, StarcatcherTags.IS_COLD_RIVER).withMustBeCaughtAboveY(50);
        public static final WorldRestrictions OVERWORLD_WARM_FRESHWATER = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomesTags(StarcatcherTags.IS_WARM_LAKE, StarcatcherTags.IS_WARM_RIVER).withMustBeCaughtAboveY(50);
        public static final WorldRestrictions OVERWORLD_WARM_LAKE = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomesTags(StarcatcherTags.IS_WARM_LAKE).withMustBeCaughtAboveY(50).withMustBeCaughtBelowY(100);
        public static final WorldRestrictions OVERWORLD_COLD_RIVER = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomesTags(StarcatcherTags.IS_COLD_RIVER).withMustBeCaughtAboveY(50).withMustBeCaughtBelowY(100);
        public static final WorldRestrictions OVERWORLD_COLD_OCEAN = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomesTags(StarcatcherTags.IS_COLD_OCEAN).withMustBeCaughtAboveY(50).withMustBeCaughtBelowY(100);
        public static final WorldRestrictions OVERWORLD_COLD_LAKE = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomesTags(StarcatcherTags.IS_COLD_LAKE).withMustBeCaughtAboveY(50).withMustBeCaughtBelowY(100);
        public static final WorldRestrictions OVERWORLD_COLD_MOUNTAIN = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomesTags(StarcatcherTags.IS_COLD_LAKE).withMustBeCaughtAboveY(100);
        public static final WorldRestrictions OVERWORLD_BEACH = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomesTags(StarcatcherTags.IS_BEACH).withMustBeCaughtAboveY(50);
        public static final WorldRestrictions OVERWORLD_MUSHROOM_FIELDS = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomesTags(StarcatcherTags.IS_MUSHROOM_FIELDS).withMustBeCaughtAboveY(50);
        public static final WorldRestrictions OVERWORLD_JUNGLE = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomesTags(BiomeTags.IS_JUNGLE.location()).withMustBeCaughtAboveY(50);
        public static final WorldRestrictions OVERWORLD_TAIGA = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomesTags(BiomeTags.IS_TAIGA.location()).withMustBeCaughtAboveY(50);
        public static final WorldRestrictions OVERWORLD_CHERRY_GROVE = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomesTags(StarcatcherTags.IS_CHERRY_GROVE).withMustBeCaughtAboveY(50);
        public static final WorldRestrictions OVERWORLD_SWAMP = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomesTags(StarcatcherTags.IS_SWAMP).withMustBeCaughtAboveY(50);
        public static final WorldRestrictions OVERWORLD_DARK_FOREST = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomesTags(StarcatcherTags.IS_DARK_FOREST).withMustBeCaughtAboveY(50);
        public static final WorldRestrictions OVERWORLD_FOREST = DEFAULT.withDims(Level.OVERWORLD.location()).withBiomesTags(BiomeTags.IS_FOREST.location()).withMustBeCaughtAboveY(50);
        public static final WorldRestrictions OVERWORLD_SURFACE = DEFAULT.withDims(Level.OVERWORLD.location()).withMustBeCaughtAboveY(50);
        public static final WorldRestrictions OVERWORLD_LAVA_SURFACE = DEFAULT.withDims(Level.OVERWORLD.location()).withFluids(ResourceLocation.withDefaultNamespace((String)"lava")).withMustBeCaughtAboveY(50);
        public static final WorldRestrictions OVERWORLD_LAVA_UNDERGROUND = DEFAULT.withDims(Level.OVERWORLD.location()).withFluids(ResourceLocation.withDefaultNamespace((String)"lava")).withMustBeCaughtBelowY(50);
        public static final WorldRestrictions OVERWORLD_UNDERGROUND = DEFAULT.withDims(Level.OVERWORLD.location()).withMustBeCaughtBelowY(50);
        public static final WorldRestrictions OVERWORLD_LAVA_DEEPSLATE = DEFAULT.withDims(Level.OVERWORLD.location()).withFluids(ResourceLocation.withDefaultNamespace((String)"lava")).withMustBeCaughtBelowY(0);
        public static final WorldRestrictions NETHER_LAVA = DEFAULT.withDims(Level.NETHER.location()).withFluids(ResourceLocation.withDefaultNamespace((String)"lava"));
        public static final WorldRestrictions NETHER_LAVA_CRIMSON_FOREST = DEFAULT.withDims(Level.NETHER.location()).withBiomes(Biomes.CRIMSON_FOREST.location()).withFluids(ResourceLocation.withDefaultNamespace((String)"lava"));
        public static final WorldRestrictions NETHER_LAVA_WARPED_FOREST = DEFAULT.withDims(Level.NETHER.location()).withBiomes(Biomes.WARPED_FOREST.location()).withFluids(ResourceLocation.withDefaultNamespace((String)"lava"));
        public static final WorldRestrictions NETHER_LAVA_SOUL_SAND_VALLEY = DEFAULT.withDims(Level.NETHER.location()).withBiomes(Biomes.SOUL_SAND_VALLEY.location()).withFluids(ResourceLocation.withDefaultNamespace((String)"lava"));
        public static final WorldRestrictions NETHER_LAVA_BASALT_DELTAS = DEFAULT.withDims(Level.NETHER.location()).withBiomes(Biomes.BASALT_DELTAS.location()).withFluids(ResourceLocation.withDefaultNamespace((String)"lava"));
        public static final WorldRestrictions END = DEFAULT.withDims(Level.END.location());
        public static final WorldRestrictions END_OUTER_ISLANDS = DEFAULT.withDims(Level.END.location()).withBiomesTags(BiomeTags.IS_END.location()).withBiomesBlacklist(Biomes.THE_END.location());

        public WorldRestrictions withDims(ResourceLocation ... dims) {
            return new WorldRestrictions(List.of(dims), this.dimsBlacklist, this.biomes, this.biomesTags, this.biomesBlacklist, this.biomesBlacklistTags, this.fluids, this.seasons, this.mustBeCaughtBelowY, this.mustBeCaughtAboveY);
        }

        public WorldRestrictions withDimsBlacklist(ResourceLocation ... dimsBlacklist) {
            return new WorldRestrictions(this.dims, List.of(dimsBlacklist), this.biomes, this.biomesTags, this.biomesBlacklist, this.biomesBlacklistTags, this.fluids, this.seasons, this.mustBeCaughtBelowY, this.mustBeCaughtAboveY);
        }

        public WorldRestrictions withBiomes(ResourceLocation ... biome) {
            return new WorldRestrictions(this.dims, this.dimsBlacklist, List.of(biome), this.biomesTags, this.biomesBlacklist, this.biomesBlacklistTags, this.fluids, this.seasons, this.mustBeCaughtBelowY, this.mustBeCaughtAboveY);
        }

        public WorldRestrictions withBiomesTags(ResourceLocation ... biomesTag) {
            return new WorldRestrictions(this.dims, this.dimsBlacklist, this.biomes, List.of(biomesTag), this.biomesBlacklist, this.biomesBlacklistTags, this.fluids, this.seasons, this.mustBeCaughtBelowY, this.mustBeCaughtAboveY);
        }

        public WorldRestrictions withBiomesBlacklist(ResourceLocation ... biomesBlacklist) {
            return new WorldRestrictions(this.dims, this.dimsBlacklist, this.biomes, this.biomesTags, List.of(biomesBlacklist), this.biomesBlacklistTags, this.fluids, this.seasons, this.mustBeCaughtBelowY, this.mustBeCaughtAboveY);
        }

        public WorldRestrictions withBiomesBlacklistTags(ResourceLocation ... biomesBlacklistTags) {
            return new WorldRestrictions(this.dims, this.dimsBlacklist, this.biomes, this.biomesTags, this.biomesBlacklist, List.of(biomesBlacklistTags), this.fluids, this.seasons, this.mustBeCaughtBelowY, this.mustBeCaughtAboveY);
        }

        public WorldRestrictions withFluids(ResourceLocation ... fluids) {
            return new WorldRestrictions(this.dims, this.dimsBlacklist, this.biomes, this.biomesTags, this.biomesBlacklist, this.biomesBlacklistTags, List.of(fluids), this.seasons, this.mustBeCaughtBelowY, this.mustBeCaughtAboveY);
        }

        public WorldRestrictions withSeasons(Seasons ... seasons) {
            return new WorldRestrictions(this.dims, this.dimsBlacklist, this.biomes, this.biomesTags, this.biomesBlacklist, this.biomesBlacklistTags, this.fluids, Arrays.stream(seasons).toList(), this.mustBeCaughtBelowY, this.mustBeCaughtAboveY);
        }

        public WorldRestrictions withMustBeCaughtBelowY(int mustBeCaughtBelowY) {
            return new WorldRestrictions(this.dims, this.dimsBlacklist, this.biomes, this.biomesTags, this.biomesBlacklist, this.biomesBlacklistTags, this.fluids, this.seasons, mustBeCaughtBelowY, this.mustBeCaughtAboveY);
        }

        public WorldRestrictions withMustBeCaughtAboveY(int mustBeCaughtAboveY) {
            return new WorldRestrictions(this.dims, this.dimsBlacklist, this.biomes, this.biomesTags, this.biomesBlacklist, this.biomesBlacklistTags, this.fluids, this.seasons, this.mustBeCaughtBelowY, mustBeCaughtAboveY);
        }

        public static enum Seasons implements StringRepresentable
        {
            ALL("all"),
            SPRING("spring"),
            EARLY_SPRING("early_spring"),
            MID_SPRING("mid_spring"),
            LATE_SPRING("late_spring"),
            SUMMER("summer"),
            EARLY_SUMMER("early_summer"),
            MID_SUMMER("mid_summer"),
            LATE_SUMMER("late_summer"),
            AUTUMN("autumn"),
            EARLY_AUTUMN("early_autumn"),
            MID_AUTUMN("mid_autumn"),
            LATE_AUTUMN("late_autumn"),
            WINTER("winter"),
            EARLY_WINTER("early_winter"),
            MID_WINTER("mid_winter"),
            LATE_WINTER("late_winter");

            public static final Codec<Seasons> CODEC;
            public static final Codec<List<Seasons>> LIST_CODEC;
            public static final StreamCodec<RegistryFriendlyByteBuf, Seasons> STREAM_CODEC;
            public static final StreamCodec<RegistryFriendlyByteBuf, List<Seasons>> LIST_STREAM_CODEC;
            private final String key;

            private Seasons(String key) {
                this.key = key;
            }

            public String getSerializedName() {
                return this.key;
            }

            static {
                CODEC = StringRepresentable.fromEnum(Seasons::values);
                LIST_CODEC = CODEC.listOf();
                STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(Seasons.class);
                LIST_STREAM_CODEC = STREAM_CODEC.apply(ByteBufCodecs.list());
            }
        }
    }

    public record BaitRestrictions(List<ResourceLocation> correctBait, boolean consumesBait, int correctBaitChanceAdded) {
        public static final Codec<BaitRestrictions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)ResourceLocation.CODEC).fieldOf("correct_baits").forGetter(BaitRestrictions::correctBait), (App)Codec.BOOL.fieldOf("consumes_bait").forGetter(BaitRestrictions::consumesBait), (App)Codec.INT.fieldOf("correct_bait_chance_added").forGetter(BaitRestrictions::correctBaitChanceAdded)).apply((Applicative)instance, BaitRestrictions::new));
        public static final StreamCodec<ByteBuf, BaitRestrictions> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.fromCodec((Codec)Codec.list((Codec)ResourceLocation.CODEC)), BaitRestrictions::correctBait, (StreamCodec)ByteBufCodecs.BOOL, BaitRestrictions::consumesBait, (StreamCodec)ByteBufCodecs.INT, BaitRestrictions::correctBaitChanceAdded, BaitRestrictions::new);
        public static final BaitRestrictions DEFAULT = new BaitRestrictions(List.of(), true, 0);
        public static final BaitRestrictions FISH_OF_THIEVES = new BaitRestrictions(List.of(FishProperties.rl("fishofthieves", "earthworms"), FishProperties.rl("fishofthieves", "grubs"), FishProperties.rl("fishofthieves", "leeches")), true, 20);
        public static final BaitRestrictions CHERRY_BAIT = new BaitRestrictions(List.of(ModItems.CHERRY_BAIT.getId()), true, 15);
        public static final BaitRestrictions LUSH_BAIT = new BaitRestrictions(List.of(ModItems.LUSH_BAIT.getId()), true, 15);
        public static final BaitRestrictions SCULK_BAIT = new BaitRestrictions(List.of(ModItems.SCULK_BAIT.getId()), true, 15);
        public static final BaitRestrictions DRIPSTONE_BAIT = new BaitRestrictions(List.of(ModItems.DRIPSTONE_BAIT.getId()), true, 15);
        public static final BaitRestrictions MURKWATER_BAIT = new BaitRestrictions(List.of(ModItems.MURKWATER_BAIT.getId()), true, 15);
        public static final BaitRestrictions LEGENDARY_BAIT = new BaitRestrictions(List.of(ModItems.LEGENDARY_BAIT.getId()), true, 15);
        public static final BaitRestrictions LEGENDARY_BAIT_VOIDBITER = new BaitRestrictions(List.of(ModItems.LEGENDARY_BAIT.getId()), true, 50);

        public BaitRestrictions withCorrectBait(ResourceLocation ... correctBait) {
            return new BaitRestrictions(List.of(correctBait), this.consumesBait, this.correctBaitChanceAdded);
        }

        public BaitRestrictions withConsumesBait(boolean consumesBait) {
            return new BaitRestrictions(this.correctBait, consumesBait, this.correctBaitChanceAdded);
        }

        public BaitRestrictions withCorrectBaitChanceAdded(int correctBaitChanceAdded) {
            return new BaitRestrictions(this.correctBait, this.consumesBait, correctBaitChanceAdded);
        }
    }

    public record Difficulty(int speed, int penalty, float decay, List<ResourceLocation> modifiers, List<SweetSpot> sweetSpots) {
        public static Difficulty TRASH = new Difficulty(10, 0, 0.0f, List.of(), SweetSpot.TRASH, SweetSpot.TRASH);
        public static Difficulty EASY = new Difficulty(9, 5, 1.0f, List.of(), SweetSpot.NORMAL, SweetSpot.NORMAL);
        public static Difficulty EASY_VANISHING = EASY.vanishing();
        public static Difficulty EASY_MOVING = EASY.moving();
        public static Difficulty MEDIUM = new Difficulty(10, 20, 1.0f, List.of(), SweetSpot.NORMAL, SweetSpot.THIN);
        public static Difficulty MEDIUM_VANISHING = MEDIUM.vanishing();
        public static Difficulty MEDIUM_MOVING = MEDIUM.moving();
        public static Difficulty MEDIUM_VANISHING_MOVING = MEDIUM.moving().vanishing();
        public static Difficulty HARD = new Difficulty(11, 10, 1.0f, List.of(), SweetSpot.THIN, SweetSpot.THIN);
        public static Difficulty HARD_VANISHING = HARD.vanishing();
        public static Difficulty HARD_MOVING = HARD.moving();
        public static Difficulty THIN_NO_DECAY_NOT_FORGIVING = new Difficulty(11, 40, 0.0f, List.of(), SweetSpot.THIN, SweetSpot.THIN);
        public static Difficulty HEAVY_FIVE_NORMAL = new Difficulty(5, 40, 0.0f, List.of(), SweetSpot.NORMAL_HEAVY, SweetSpot.NORMAL_HEAVY, SweetSpot.NORMAL_HEAVY, SweetSpot.NORMAL_HEAVY, SweetSpot.NORMAL_HEAVY);
        public static Difficulty FOUR_BIG = new Difficulty(9, 20, 0.0f, List.of(), SweetSpot.NORMAL, SweetSpot.NORMAL, SweetSpot.NORMAL, SweetSpot.NORMAL);
        public static Difficulty FOUR_BIG_VANISHING = FOUR_BIG.vanishing();
        public static Difficulty FOUR_BIG_MOVING = FOUR_BIG.moving();
        public static Difficulty HEAVY_EIGHT_AQUA = new Difficulty(12, 20, 0.0f, List.of(), SweetSpot.AQUA_1, SweetSpot.AQUA_1, SweetSpot.AQUA_1, SweetSpot.AQUA_1, SweetSpot.AQUA_1, SweetSpot.AQUA_1, SweetSpot.AQUA_1, SweetSpot.AQUA_1);
        public static Difficulty HEAVY_EIGHT_AQUA_MOVING = new Difficulty(12, 20, 0.0f, List.of(), SweetSpot.AQUA_1, SweetSpot.AQUA_1, SweetSpot.AQUA_1, SweetSpot.AQUA_1, SweetSpot.AQUA_1, SweetSpot.AQUA_1, SweetSpot.AQUA_1, SweetSpot.AQUA_1).moving();
        public static Difficulty THREE_AQUA_ONE_BIG_ONE_SMALL = new Difficulty(9, 20, 0.0f, List.of(), SweetSpot.AQUA, SweetSpot.AQUA, SweetSpot.THIN);
        public static Difficulty THREE_AQUA_ONE_BIG_ONE_SMALL_VANISHING = THREE_AQUA_ONE_BIG_ONE_SMALL.vanishing();
        public static Difficulty EIGHT_THIN = new Difficulty(9, 20, 0.0f, List.of(), SweetSpot.THIN, SweetSpot.THIN, SweetSpot.THIN, SweetSpot.THIN, SweetSpot.THIN, SweetSpot.THIN, SweetSpot.THIN, SweetSpot.THIN);
        public static Difficulty EIGHT_THIN_VANISHING = EIGHT_THIN.vanishing();
        public static Difficulty EIGHT_THIN_MOVING = EIGHT_THIN.moving();
        public static Difficulty EIGHT_THIN_MOVING_VANISHING = EIGHT_THIN.vanishing();
        public static Difficulty THREE_BIG_TWO_THIN = new Difficulty(9, 20, 0.0f, List.of(), SweetSpot.THIN, SweetSpot.THIN, SweetSpot.THIN, SweetSpot.THIN, SweetSpot.THIN, SweetSpot.THIN, SweetSpot.THIN, SweetSpot.THIN).vanishing();
        public static Difficulty THREE_BIG_TWO_THIN_VANISHING = THREE_BIG_TWO_THIN.vanishing();
        public static Difficulty FOUR_STONE_SPOTS = new Difficulty(12, 20, 0.0f, List.of(), SweetSpot.STONE, SweetSpot.STONE, SweetSpot.STONE, SweetSpot.STONE);
        public static Difficulty EASY_FAST_FISH = new Difficulty(15, 20, 1.0f, List.of(), SweetSpot.NORMAL, SweetSpot.NORMAL);
        public static Difficulty SINGLE_BIG_FAST = new Difficulty(13, 30, 1.0f, List.of(), SweetSpot.NORMAL_STEADY);
        public static Difficulty SINGLE_BIG_FAST_MOVING = SINGLE_BIG_FAST.moving();
        public static Difficulty SINGLE_BIG_FAST_VANISHING = SINGLE_BIG_FAST.vanishing();
        public static Difficulty TWO_AQUA = new Difficulty(10, 20, 1.0f, List.of(), SweetSpot.AQUA, SweetSpot.AQUA);
        public static Difficulty FOUR_AQUA = new Difficulty(10, 20, 1.0f, List.of(), SweetSpot.AQUA, SweetSpot.AQUA);
        public static Difficulty THIN_NO_DECAY = new Difficulty(10, 20, 0.0f, List.of(), SweetSpot.THIN, SweetSpot.THIN);
        public static Difficulty NON_STOP_ACTION_THREE_BIG = new Difficulty(14, 20, 1.0f, List.of(), SweetSpot.NORMAL, SweetSpot.NORMAL, SweetSpot.NORMAL);
        public static Difficulty NON_STOP_ACTION_AQUA = new Difficulty(14, 2, 0.2f, List.of(), SweetSpot.AQUA_1, SweetSpot.AQUA_1, SweetSpot.AQUA_1, SweetSpot.AQUA_1);
        public static Difficulty WITHER = new Difficulty(10, 30, 1.0f, List.of(), SweetSpot.WITHER_BIG, SweetSpot.WITHER, SweetSpot.WITHER);
        public static Difficulty CREEPER = new Difficulty(10, 20, 1.0f, List.of((ResourceLocation)ModMinigameModifiers.SPAWN_TNT_SWEET_SPOTS.getFirst()), SweetSpot.CREEPER, SweetSpot.CREEPER);
        public static Difficulty DEEPSLATE_CRAB = new Difficulty(14, 10, 1.0f, List.of(), SweetSpot.DEEPSLATE_CRAB_CLAW, SweetSpot.DEEPSLATE_CRAB_CLAW, SweetSpot.DEEPSLATE_CRAB_LEG, SweetSpot.DEEPSLATE_CRAB_LEG, SweetSpot.DEEPSLATE_CRAB_LEG, SweetSpot.DEEPSLATE_CRAB_LEG, SweetSpot.DEEPSLATE_CRAB_LEG, SweetSpot.DEEPSLATE_CRAB_LEG);
        public static Difficulty OBSIDIAN_CRAB = new Difficulty(14, 10, 1.0f, List.of(), SweetSpot.OBSIDIAN_CRAB_CLAW, SweetSpot.OBSIDIAN_CRAB_CLAW, SweetSpot.OBSIDIAN_CRAB_LEG, SweetSpot.OBSIDIAN_CRAB_LEG, SweetSpot.OBSIDIAN_CRAB_LEG, SweetSpot.OBSIDIAN_CRAB_LEG, SweetSpot.OBSIDIAN_CRAB_LEG, SweetSpot.OBSIDIAN_CRAB_LEG);
        public static Difficulty NETHER_CRAB = new Difficulty(14, 10, 1.0f, List.of(), SweetSpot.NETHER_CRAB_CLAW, SweetSpot.NETHER_CRAB_CLAW, SweetSpot.NETHER_CRAB_LEG, SweetSpot.NETHER_CRAB_LEG, SweetSpot.NETHER_CRAB_LEG, SweetSpot.NETHER_CRAB_LEG, SweetSpot.NETHER_CRAB_LEG, SweetSpot.NETHER_CRAB_LEG);
        public static Difficulty END_CRAB = new Difficulty(14, 10, 1.0f, List.of(), SweetSpot.END_CRAB_CLAW, SweetSpot.END_CRAB_CLAW, SweetSpot.END_CRAB_LEG, SweetSpot.END_CRAB_LEG, SweetSpot.END_CRAB_LEG, SweetSpot.END_CRAB_LEG, SweetSpot.END_CRAB_LEG, SweetSpot.END_CRAB_LEG);
        public static Difficulty VOIDBITER = new Difficulty(14, 10, 1.0f, List.of(), SweetSpot.AQUA, SweetSpot.THIN, SweetSpot.THIN);
        public static Difficulty JOEL = new Difficulty(14, 5, 1.0f, List.of(), SweetSpot.AQUA_1, SweetSpot.AQUA_1);
        public static Difficulty CERBERAY = new Difficulty(16, 10, 1.5f, List.of((ResourceLocation)ModMinigameModifiers.SPAWN_TNT_SWEET_SPOTS_PLUS.getFirst(), (ResourceLocation)ModMinigameModifiers.NIKDO53_MODIFIER.getFirst()), SweetSpot.THIN, SweetSpot.THIN, SweetSpot.THIN);
        public static final Codec<Difficulty> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("speed").forGetter(Difficulty::speed), (App)Codec.INT.fieldOf("missPenalty").forGetter(Difficulty::penalty), (App)Codec.FLOAT.fieldOf("decay").forGetter(Difficulty::decay), (App)ResourceLocation.CODEC.listOf().fieldOf("modifiers").forGetter(Difficulty::modifiers), (App)SweetSpot.LIST_CODEC.fieldOf("sweetspots").forGetter(Difficulty::sweetSpots)).apply((Applicative)instance, Difficulty::new));
        public static final StreamCodec<FriendlyByteBuf, Difficulty> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, Difficulty::speed, (StreamCodec)ByteBufCodecs.INT, Difficulty::penalty, (StreamCodec)ByteBufCodecs.FLOAT, Difficulty::decay, (StreamCodec)ResourceLocation.STREAM_CODEC.apply(ByteBufCodecs.list()), Difficulty::modifiers, SweetSpot.LIST_STREAM_CODEC, Difficulty::sweetSpots, Difficulty::new);

        public Difficulty(int speed, int penalty, float decay, List<ResourceLocation> modifiers, SweetSpot ... sweetSpots) {
            this(speed, penalty, decay, modifiers, Arrays.stream(sweetSpots).toList());
        }

        public Difficulty withModifiers(List<ResourceLocation> modifiers) {
            return new Difficulty(this.speed, this.penalty, this.decay, modifiers, this.sweetSpots);
        }

        public Difficulty vanishing(float vanishingRate) {
            ArrayList<SweetSpot> sss = new ArrayList<SweetSpot>();
            this.sweetSpots.forEach(s -> sss.add(s.vanishing(vanishingRate)));
            return new Difficulty(this.speed, this.penalty, this.decay, this.modifiers, sss);
        }

        public Difficulty vanishing() {
            ArrayList<SweetSpot> sss = new ArrayList<SweetSpot>();
            this.sweetSpots.forEach(s -> sss.add(s.vanishing(0.1f)));
            return new Difficulty(this.speed, this.penalty, this.decay, this.modifiers, sss);
        }

        public Difficulty moving(float movingRate) {
            ArrayList<SweetSpot> sss = new ArrayList<SweetSpot>();
            this.sweetSpots.forEach(s -> sss.add(s.moving(movingRate)));
            return new Difficulty(this.speed, this.penalty, this.decay, this.modifiers, sss);
        }

        public Difficulty moving() {
            ArrayList<SweetSpot> sss = new ArrayList<SweetSpot>();
            this.sweetSpots.forEach(s -> sss.add(s.moving(1.0f)));
            return new Difficulty(this.speed, this.penalty, this.decay, this.modifiers, sss);
        }

        public Difficulty flip() {
            ArrayList<SweetSpot> sss = new ArrayList<SweetSpot>();
            this.sweetSpots.forEach(s -> sss.add(s.flip()));
            return new Difficulty(this.speed, this.penalty, this.decay, this.modifiers, sss);
        }
    }

    public static enum Daytime implements StringRepresentable
    {
        ALL("all"),
        DAY("day"),
        NOON("noon"),
        NIGHT("night"),
        MIDNIGHT("midnight");

        public static final Codec<Daytime> CODEC;
        public static final StreamCodec<FriendlyByteBuf, Daytime> STREAM_CODEC;
        private final String key;

        private Daytime(String key) {
            this.key = key;
        }

        public String getSerializedName() {
            return this.key;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Daytime::values);
            STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(Daytime.class);
        }
    }

    public static enum Weather implements StringRepresentable
    {
        ALL("all"),
        CLEAR("clear"),
        RAIN("rain"),
        THUNDER("thunder");

        public static final Codec<Weather> CODEC;
        public static final StreamCodec<FriendlyByteBuf, Weather> STREAM_CODEC;
        private final String key;

        private Weather(String key) {
            this.key = key;
        }

        public String getSerializedName() {
            return this.key;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Weather::values);
            STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(Weather.class);
        }
    }

    public static class Builder {
        private CatchInfo.Builder catchInfo = new CatchInfo.Builder();
        private int baseChance = 5;
        private SizeAndWeight sw = SizeAndWeight.DEFAULT;
        private Rarity rarity = Rarity.COMMON;
        private WorldRestrictions wr = WorldRestrictions.DEFAULT;
        private BaitRestrictions br = BaitRestrictions.DEFAULT;
        private Difficulty dif = Difficulty.EASY;
        private Daytime daytime = Daytime.ALL;
        private Weather weather = Weather.ALL;
        private boolean skipMinigame = false;
        private boolean hasGuideEntry = true;

        public Builder withCatchInfo(CatchInfo.Builder builder) {
            this.catchInfo = builder;
            return this;
        }

        public Builder withFish(Holder<Item> fish) {
            this.catchInfo.withFish(fish);
            return this;
        }

        public Builder withTreasure(Holder<Item> treasure) {
            this.catchInfo.treasure = treasure;
            return this;
        }

        public Builder withBucketedFish(Holder<Item> bucketedFish) {
            this.catchInfo.withBucketedFish(bucketedFish);
            return this;
        }

        public Builder withEntityToSpawn(Holder<EntityType<?>> entity) {
            this.catchInfo.withEntityToSpawn(entity);
            return this;
        }

        public Builder withAlwaysSpawnEntity(boolean alwaysSpawnEntity) {
            this.catchInfo.withAlwaysSpawnEntity(alwaysSpawnEntity);
            return this;
        }

        public Builder withItemToOverrideWith(Holder<Item> itemToOverrideWith) {
            this.catchInfo.withOverrideMinigameWith(itemToOverrideWith);
            return this;
        }

        public Builder withBaseChance(int baseChance) {
            this.baseChance = baseChance;
            return this;
        }

        public Builder withSizeAndWeight(SizeAndWeight sizeAndWeight) {
            this.sw = sizeAndWeight;
            return this;
        }

        public Builder withRarity(Rarity rarity) {
            this.rarity = rarity;
            return this;
        }

        public Builder withWorldRestrictions(WorldRestrictions wr) {
            this.wr = wr;
            return this;
        }

        public Builder withBaitRestrictions(BaitRestrictions br) {
            this.br = br;
            return this;
        }

        public Builder withDifficulty(Difficulty dif) {
            this.dif = dif;
            return this;
        }

        public Builder withDaytime(Daytime daytime) {
            this.daytime = daytime;
            return this;
        }

        public Builder withWeather(Weather weather) {
            this.weather = weather;
            return this;
        }

        public Builder withSkipMinigame(boolean skipMinigame) {
            this.skipMinigame = skipMinigame;
            return this;
        }

        public Builder withHasGuideEntry(boolean hasGuideEntry) {
            this.hasGuideEntry = hasGuideEntry;
            return this;
        }

        public Builder withSeasons(WorldRestrictions.Seasons ... seasons) {
            this.wr = this.wr.withSeasons(seasons);
            return this;
        }

        public FishProperties build() {
            return new FishProperties(this.catchInfo.build(), this.baseChance, this.sw, this.rarity, this.wr, this.br, this.dif, this.daytime, this.weather, this.skipMinigame, this.hasGuideEntry);
        }
    }

    public record SweetSpot(ResourceLocation sweetSpotType, ResourceLocation texturePath, int size, int reward, boolean isFlip, float vanishingRate, float movingRate, int particleColor) {
        private static final ResourceLocation RL_NORMAL = Starcatcher.rl("textures/gui/minigame/spots/normal.png");
        private static final ResourceLocation RL_NORMAL_STEADY = Starcatcher.rl("textures/gui/minigame/spots/normal_steady.png");
        private static final ResourceLocation RL_THIN = Starcatcher.rl("textures/gui/minigame/spots/thin.png");
        private static final ResourceLocation RL_THIN_STEADY = Starcatcher.rl("textures/gui/minigame/spots/thin_steady.png");
        private static final ResourceLocation RL_FREEZE = Starcatcher.rl("textures/gui/minigame/spots/frozen.png");
        private static final ResourceLocation RL_TREASURE = Starcatcher.rl("textures/gui/minigame/spots/treasure.png");
        private static final ResourceLocation RL_WITHER = Starcatcher.rl("textures/gui/minigame/spots/wither.png");
        private static final ResourceLocation RL_WITHER_BIG = Starcatcher.rl("textures/gui/minigame/spots/wither_big.png");
        private static final ResourceLocation RL_CREEPER = Starcatcher.rl("textures/gui/minigame/spots/creeper.png");
        private static final ResourceLocation RL_TNT = Starcatcher.rl("textures/gui/minigame/spots/tnt.png");
        private static final ResourceLocation RL_STONE = Starcatcher.rl("textures/gui/minigame/spots/stone.png");
        private static final ResourceLocation RL_AQUA = Starcatcher.rl("textures/gui/minigame/spots/aqua.png");
        private static final ResourceLocation RL_NETHER_CRAB_CLAW = Starcatcher.rl("textures/gui/minigame/spots/nether_crab_claw.png");
        private static final ResourceLocation RL_NETHER_CRAB_LEG = Starcatcher.rl("textures/gui/minigame/spots/nether_crab_leg.png");
        private static final ResourceLocation RL_END_CRAB_LEG = Starcatcher.rl("textures/gui/minigame/spots/end_crab_leg.png");
        private static final ResourceLocation RL_END_CRAB_CLAW = Starcatcher.rl("textures/gui/minigame/spots/end_crab_claw.png");
        private static final ResourceLocation RL_DEEPSLATE_CRAB_LEG = Starcatcher.rl("textures/gui/minigame/spots/deepslate_crab_leg.png");
        private static final ResourceLocation RL_DEEPSLATE_CRAB_CLAW = Starcatcher.rl("textures/gui/minigame/spots/deepslate_crab_claw.png");
        private static final ResourceLocation RL_OBSIDIAN_CRAB_LEG = Starcatcher.rl("textures/gui/minigame/spots/obsidian_crab_leg.png");
        private static final ResourceLocation RL_OBSIDIAN_CRAB_CLAW = Starcatcher.rl("textures/gui/minigame/spots/obsidian_crab_claw.png");
        private static final ResourceLocation RL_THIN_STEADY_MOSSY = Starcatcher.rl("textures/gui/minigame/spots/thin_mossy.png");
        public static SweetSpot TRASH = new SweetSpot(ModSweetSpotsBehaviour.NORMAL, RL_NORMAL, 22, 30, 65280);
        public static SweetSpot NORMAL_STEADY = new SweetSpot(ModSweetSpotsBehaviour.NORMAL, RL_NORMAL_STEADY, 33, 15, 65280);
        public static SweetSpot NORMAL = new SweetSpot(ModSweetSpotsBehaviour.NORMAL, RL_NORMAL, 22, 15, 65280);
        public static SweetSpot THIN_STEADY = new SweetSpot(ModSweetSpotsBehaviour.NORMAL, RL_THIN_STEADY, 20, 20, 65280);
        public static SweetSpot THIN_STEADY_MOSSY = new SweetSpot(ModSweetSpotsBehaviour.NORMAL, RL_THIN_STEADY_MOSSY, 20, 10, true, 0.01f, 1.0f, 65280);
        public static SweetSpot THIN = new SweetSpot(ModSweetSpotsBehaviour.NORMAL, RL_THIN, 15, 20, 65280);
        public static SweetSpot FREEZE = new SweetSpot(ModSweetSpotsBehaviour.FROZEN, RL_FREEZE, 33, 15, 614290);
        public static SweetSpot NORMAL_HEAVY = new SweetSpot(ModSweetSpotsBehaviour.NORMAL, RL_NORMAL, 22, 1, 65280);
        public static SweetSpot TREASURE = new SweetSpot(ModSweetSpotsBehaviour.TREASURE, RL_TREASURE, 20, 15, 16766720);
        public static SweetSpot WITHER = new SweetSpot(ModSweetSpotsBehaviour.NORMAL, RL_WITHER, 22, 15, false, 0.0f, 3.0f, 0x1F1F1F);
        public static SweetSpot WITHER_BIG = new SweetSpot(ModSweetSpotsBehaviour.NORMAL, RL_WITHER_BIG, 33, 15, 0x1F1F1F);
        public static SweetSpot CREEPER = new SweetSpot(ModSweetSpotsBehaviour.NORMAL, RL_CREEPER, 22, 15, 0x515353);
        public static SweetSpot TNT = new SweetSpot(ModSweetSpotsBehaviour.TNT, RL_TNT, 33, 30, 0xFF0000);
        public static SweetSpot STONE = new SweetSpot(ModSweetSpotsBehaviour.NORMAL, RL_STONE, 33, 1, 0x494949);
        public static SweetSpot AQUA = new SweetSpot(ModSweetSpotsBehaviour.AQUA, RL_AQUA, 22, 15, 3701122);
        public static SweetSpot AQUA_1 = new SweetSpot(ModSweetSpotsBehaviour.AQUA, RL_AQUA, 22, 1, 3701122);
        public static SweetSpot AQUA_5 = new SweetSpot(ModSweetSpotsBehaviour.AQUA, RL_AQUA, 22, 1, 3701122);
        public static SweetSpot AQUA_10 = new SweetSpot(ModSweetSpotsBehaviour.AQUA, RL_AQUA, 22, 10, 3701122);
        public static SweetSpot DEEPSLATE_CRAB_CLAW = new SweetSpot(ModSweetSpotsBehaviour.NORMAL, RL_DEEPSLATE_CRAB_CLAW, 24, 10, 16745472);
        public static SweetSpot DEEPSLATE_CRAB_LEG = new SweetSpot(ModSweetSpotsBehaviour.NORMAL, RL_DEEPSLATE_CRAB_LEG, 15, 1, 16745472);
        public static SweetSpot OBSIDIAN_CRAB_CLAW = new SweetSpot(ModSweetSpotsBehaviour.NORMAL, RL_OBSIDIAN_CRAB_CLAW, 24, 10, 3876692);
        public static SweetSpot OBSIDIAN_CRAB_LEG = new SweetSpot(ModSweetSpotsBehaviour.NORMAL, RL_OBSIDIAN_CRAB_LEG, 15, 1, 3876692);
        public static SweetSpot NETHER_CRAB_CLAW = new SweetSpot(ModSweetSpotsBehaviour.NORMAL, RL_NETHER_CRAB_CLAW, 24, 10, 13452613);
        public static SweetSpot NETHER_CRAB_LEG = new SweetSpot(ModSweetSpotsBehaviour.NORMAL, RL_NETHER_CRAB_LEG, 15, 1, 13452613);
        public static SweetSpot END_CRAB_CLAW = new SweetSpot(ModSweetSpotsBehaviour.NORMAL, RL_END_CRAB_CLAW, 24, 10, 13008601);
        public static SweetSpot END_CRAB_LEG = new SweetSpot(ModSweetSpotsBehaviour.NORMAL, RL_END_CRAB_LEG, 15, 1, 13008601);
        public static final Codec<SweetSpot> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("sweet_spot_type").forGetter(SweetSpot::sweetSpotType), (App)ResourceLocation.CODEC.fieldOf("texture_path").forGetter(SweetSpot::texturePath), (App)Codec.INT.fieldOf("hitbox_size_in_pixels").forGetter(SweetSpot::size), (App)Codec.INT.fieldOf("reward").forGetter(SweetSpot::reward), (App)Codec.BOOL.fieldOf("is_flip").forGetter(SweetSpot::isFlip), (App)Codec.FLOAT.fieldOf("vanishing_rate").forGetter(SweetSpot::vanishingRate), (App)Codec.FLOAT.fieldOf("moving_rate").forGetter(SweetSpot::movingRate), (App)Codec.INT.fieldOf("color_as_int").forGetter(SweetSpot::particleColor)).apply((Applicative)instance, SweetSpot::new));
        public static final Codec<List<SweetSpot>> LIST_CODEC = CODEC.listOf();
        public static final StreamCodec<FriendlyByteBuf, SweetSpot> STREAM_CODEC = ExtraComposites.composite(ResourceLocation.STREAM_CODEC, SweetSpot::sweetSpotType, ResourceLocation.STREAM_CODEC, SweetSpot::texturePath, ByteBufCodecs.INT, SweetSpot::size, ByteBufCodecs.INT, SweetSpot::reward, ByteBufCodecs.BOOL, SweetSpot::isFlip, ByteBufCodecs.FLOAT, SweetSpot::vanishingRate, ByteBufCodecs.FLOAT, SweetSpot::movingRate, ByteBufCodecs.INT, SweetSpot::particleColor, SweetSpot::new);
        public static final StreamCodec<FriendlyByteBuf, List<SweetSpot>> LIST_STREAM_CODEC = STREAM_CODEC.apply(ByteBufCodecs.list());

        public SweetSpot(ResourceLocation sweetSpotType, ResourceLocation texturePath, int size, int reward, int particleColor) {
            this(sweetSpotType, texturePath, size, reward, false, 0.0f, 0.0f, particleColor);
        }

        public SweetSpot flip() {
            return new SweetSpot(this.sweetSpotType, this.texturePath, this.size, this.reward, true, this.vanishingRate, this.movingRate, this.particleColor);
        }

        public SweetSpot vanishing(float vanishingRate) {
            return new SweetSpot(this.sweetSpotType, this.texturePath, this.size, this.reward, this.isFlip, vanishingRate, this.movingRate, this.particleColor);
        }

        public SweetSpot moving(float movingRate) {
            return new SweetSpot(this.sweetSpotType, this.texturePath, this.size, this.reward, this.isFlip, this.vanishingRate, movingRate, this.particleColor);
        }
    }
}

