/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.secretnotes;

import com.mojang.blaze3d.platform.InputConstants;
import com.wdiscute.libtooltips.Tooltips;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.secretnotes.SecretNote;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class SecretNoteScreen
extends Screen {
    private static final ResourceLocation BACKGROUND = Starcatcher.rl("textures/gui/secret_note.png");
    private final String translationKey;
    int uiX;
    int uiY;

    protected void init() {
        super.init();
        this.uiX = (this.width - 512) / 2;
        this.uiY = (this.height - 256) / 2;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        String key;
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderImage(guiGraphics, BACKGROUND);
        for (int i = 0; i < 20 && I18n.exists((String)(key = this.translationKey + i)); ++i) {
            guiGraphics.drawString(this.font, Tooltips.decodeTranslationKey((String)key), this.uiX + 140, this.uiY + 55 + 9 * i, 6508608, false);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key key = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (this.minecraft.options.keyInventory.isActiveAndMatches(key)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public SecretNoteScreen(SecretNote.Note note) {
        super((Component)Component.empty());
        this.translationKey = "gui.secret_note." + note.getSerializedName() + ".";
    }

    private void renderImage(GuiGraphics guiGraphics, ResourceLocation rl) {
        guiGraphics.blit(rl, this.uiX, this.uiY, 0.0f, 0.0f, 512, 256, 512, 256);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

