/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.registry.fishing;

import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.registry.ModItems;
import com.wdiscute.starcatcher.registry.blocks.ModBlocks;
import com.wdiscute.starcatcher.registry.fishing.FishingPropertiesRegistry;
import com.wdiscute.starcatcher.storage.FishProperties;
import com.wdiscute.starcatcher.storage.TrophyProperties;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.biome.Biomes;

public class ModTrophyProperties {
    private static ResourceKey<TrophyProperties> createKey(TrophyProperties tp) {
        return ResourceKey.create(Starcatcher.TROPHY_REGISTRY, (ResourceLocation)tp.fish().getKey().location());
    }

    private static void register(BootstrapContext<TrophyProperties> context, TrophyProperties.Builder builder) {
        TrophyProperties entry = builder.build();
        context.register(ModTrophyProperties.createKey(entry), (Object)entry);
    }

    public static void bootstrap(BootstrapContext<TrophyProperties> context) {
        ModTrophyProperties.register(context, TrophyProperties.builder().setFish((Holder<Item>)ModBlocks.TROPHY_BRONZE.asItem().builtInRegistryHolder()).hideUntilCaught().setTrophyType(TrophyProperties.TrophyType.TROPHY).setAllProgress(new TrophyProperties.RarityProgress(50, 20)));
        ModTrophyProperties.register(context, TrophyProperties.builder().setFish((Holder<Item>)ModBlocks.TROPHY_SILVER.asItem().builtInRegistryHolder()).hideUntilCaught().setTrophyType(TrophyProperties.TrophyType.TROPHY).setAllProgress(new TrophyProperties.RarityProgress(100, 50)));
        ModTrophyProperties.register(context, TrophyProperties.builder().setFish((Holder<Item>)ModBlocks.TROPHY_GOLD.asItem().builtInRegistryHolder()).hideUntilCaught().setTrophyType(TrophyProperties.TrophyType.TROPHY).setAllProgress(new TrophyProperties.RarityProgress(200, 0)).withProgress(FishProperties.Rarity.COMMON, new TrophyProperties.RarityProgress(0, 36)).withProgress(FishProperties.Rarity.UNCOMMON, new TrophyProperties.RarityProgress(0, 23)).withProgress(FishProperties.Rarity.RARE, new TrophyProperties.RarityProgress(0, 14)).withProgress(FishProperties.Rarity.EPIC, new TrophyProperties.RarityProgress(0, 13)).withProgress(FishProperties.Rarity.LEGENDARY, new TrophyProperties.RarityProgress(0, 8)));
        ModTrophyProperties.register(context, TrophyProperties.builder().setFishProperties(FishingPropertiesRegistry.overworldFish(ModItems.DRIFTING_WATERLOGGED_BOTTLE)).setTrophyType(TrophyProperties.TrophyType.SECRET).setAllProgress(new TrophyProperties.RarityProgress(6, 15)));
        ModTrophyProperties.register(context, TrophyProperties.builder().setFishProperties(FishingPropertiesRegistry.overworldSurfaceLava(ModItems.SCALDING_BOTTLE)).setTrophyType(TrophyProperties.TrophyType.SECRET).setAllProgress(new TrophyProperties.RarityProgress(0, 27)).setChanceToCatch(33));
        ModTrophyProperties.register(context, TrophyProperties.builder().setFishProperties(FishingPropertiesRegistry.overworldSurfaceLava(ModItems.BURNING_BOTTLE)).setTrophyType(TrophyProperties.TrophyType.SECRET).setAllProgress(new TrophyProperties.RarityProgress(0, 42)).setChanceToCatch(33));
        ModTrophyProperties.register(context, TrophyProperties.builder().setFishProperties(FishingPropertiesRegistry.overworldDeepOceanFish(ModItems.HOPEFUL_BOTTLE)).setTrophyType(TrophyProperties.TrophyType.SECRET).withProgress(FishProperties.Rarity.EPIC, new TrophyProperties.RarityProgress(5, 0)).setChanceToCatch(33));
        ModTrophyProperties.register(context, TrophyProperties.builder().setFishProperties(FishingPropertiesRegistry.overworldDeepOceanFish(ModItems.HOPELESS_BOTTLE)).setTrophyType(TrophyProperties.TrophyType.SECRET).withProgress(FishProperties.Rarity.EPIC, new TrophyProperties.RarityProgress(5, 0)).setChanceToCatch(33));
        ModTrophyProperties.register(context, TrophyProperties.builder().setFishProperties(FishingPropertiesRegistry.overworldRiverFish(ModItems.TRUE_BLUE_BOTTLE)).setTrophyType(TrophyProperties.TrophyType.SECRET).withProgress(FishProperties.Rarity.LEGENDARY, new TrophyProperties.RarityProgress(1, 0)).setChanceToCatch(1));
        ModTrophyProperties.register(context, TrophyProperties.builder().setFishProperties(FishingPropertiesRegistry.fish(ModItems.WITHERED_BOTTLE).withBaseChance(0).withBaitRestrictions(FishProperties.BaitRestrictions.DEFAULT.withCorrectBait(BuiltInRegistries.ITEM.getKey((Object)Items.WITHER_SKELETON_SKULL)).withCorrectBaitChanceAdded(200))).setTrophyType(TrophyProperties.TrophyType.SECRET));
        ModTrophyProperties.register(context, TrophyProperties.builder().setFishProperties(FishingPropertiesRegistry.overworldDeepslateFish((Holder<Item>)BuiltInRegistries.ITEM.wrapAsHolder((Object)Items.DIAMOND))).setTrophyType(TrophyProperties.TrophyType.EXTRA).withProgress(FishProperties.Rarity.RARE, new TrophyProperties.RarityProgress(1, 4)));
        ModTrophyProperties.register(context, TrophyProperties.builder().setFishProperties(FishingPropertiesRegistry.netherLavaFish((Holder<Item>)BuiltInRegistries.ITEM.wrapAsHolder((Object)Items.GOLD_BLOCK))).setTrophyType(TrophyProperties.TrophyType.EXTRA).withProgress(FishProperties.Rarity.LEGENDARY, new TrophyProperties.RarityProgress(3, 0)).setChanceToCatch(33));
        ModTrophyProperties.register(context, TrophyProperties.builder().setFishProperties(FishingPropertiesRegistry.netherLavaFish((Holder<Item>)BuiltInRegistries.ITEM.wrapAsHolder((Object)Items.NETHERITE_SCRAP))).setTrophyType(TrophyProperties.TrophyType.EXTRA).withProgress(FishProperties.Rarity.LEGENDARY, new TrophyProperties.RarityProgress(0, 10)).setChanceToCatch(5).setRepeatable(true));
        ModTrophyProperties.register(context, TrophyProperties.builder().setFishProperties(FishingPropertiesRegistry.netherLavaFish((Holder<Item>)BuiltInRegistries.ITEM.wrapAsHolder((Object)Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE))).setTrophyType(TrophyProperties.TrophyType.EXTRA).setChanceToCatch(1).setRepeatable(true));
        ModTrophyProperties.register(context, TrophyProperties.builder().setFishProperties(FishingPropertiesRegistry.overworldForestFish(ModItems.NATURALIST_ROD)).setTrophyType(TrophyProperties.TrophyType.EXTRA).setChanceToCatch(1).setRepeatable(true));
        ModTrophyProperties.register(context, TrophyProperties.builder().setFishProperties(FishingPropertiesRegistry.overworldColdOceanFish(ModItems.ICEBORN_ROD)).setTrophyType(TrophyProperties.TrophyType.EXTRA).setChanceToCatch(1).setRepeatable(true));
        ModTrophyProperties.register(context, TrophyProperties.builder().setFishProperties(FishingPropertiesRegistry.netherLavaBasaltDeltasFish(ModItems.MAGMAFORGED_ROD)).setTrophyType(TrophyProperties.TrophyType.EXTRA).setChanceToCatch(1).setRepeatable(true));
        ModTrophyProperties.register(context, TrophyProperties.builder().setFishProperties(FishingPropertiesRegistry.overworldFish(ModItems.BAMBOO_ROD).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD.withBiomes(Biomes.BAMBOO_JUNGLE.location()))).setTrophyType(TrophyProperties.TrophyType.EXTRA).setChanceToCatch(1).setRepeatable(true));
        ModTrophyProperties.register(context, TrophyProperties.builder().setFishProperties(FishingPropertiesRegistry.overworldSurfaceLava(ModItems.OBSIDIAN_ROD)).setTrophyType(TrophyProperties.TrophyType.EXTRA).setChanceToCatch(1).setRepeatable(true));
        ModTrophyProperties.register(context, TrophyProperties.builder().setFishProperties(FishingPropertiesRegistry.netherLavaSoulSandValleyFish(ModItems.BONER_ROD)).setTrophyType(TrophyProperties.TrophyType.EXTRA).setChanceToCatch(1).setRepeatable(true));
        ModTrophyProperties.register(context, TrophyProperties.builder().setFishProperties(FishingPropertiesRegistry.overworldFish(ModItems.SKY_ROD).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD.withMustBeCaughtAboveY(300))).setTrophyType(TrophyProperties.TrophyType.EXTRA).setChanceToCatch(1).setRepeatable(true));
        ModTrophyProperties.register(context, TrophyProperties.builder().setFishProperties(FishingPropertiesRegistry.overworldLushCavesFish(ModItems.LUSH_GLOWBERRY_ROD)).setTrophyType(TrophyProperties.TrophyType.EXTRA).setChanceToCatch(1).setRepeatable(true));
        ModTrophyProperties.register(context, TrophyProperties.builder().setFishProperties(FishingPropertiesRegistry.overworldRiverFish(ModItems.HUMBLE_ROD)).setTrophyType(TrophyProperties.TrophyType.EXTRA).setChanceToCatch(1).setRepeatable(true));
    }
}

