/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.registry.custom.tackleskin;

import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.io.ModDataComponents;
import com.wdiscute.starcatcher.registry.custom.tackleskin.AbstractTackleSkin;
import com.wdiscute.starcatcher.registry.custom.tackleskin.BaseTackleSkin;
import com.wdiscute.starcatcher.registry.custom.tackleskin.ClearTackleSkin;
import com.wdiscute.starcatcher.registry.custom.tackleskin.ColorfulTackleSkin;
import com.wdiscute.starcatcher.registry.custom.tackleskin.FrogTackleSkin;
import com.wdiscute.starcatcher.registry.custom.tackleskin.KimbeTackleSkin;
import com.wdiscute.starcatcher.registry.custom.tackleskin.KingTackleSkin;
import com.wdiscute.starcatcher.registry.custom.tackleskin.PearlTackleSkin;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;

public interface ModTackleSkins {
    public static final DeferredRegister<Supplier<AbstractTackleSkin>> REGISTRY = DeferredRegister.create(Starcatcher.TACKLE_SKIN_REGISTRY, (String)"starcatcher");
    public static final ResourceLocation BASE_TACKLE_SKIN = ModTackleSkins.registerCatchModifier("base", BaseTackleSkin::new);
    public static final ResourceLocation PEARL_TACKLE_SKIN = ModTackleSkins.registerCatchModifier("pearl", PearlTackleSkin::new);
    public static final ResourceLocation KIMBE_TACKLE_SKIN = ModTackleSkins.registerCatchModifier("kimbe", KimbeTackleSkin::new);
    public static final ResourceLocation FROG_TACKLE_SKIN = ModTackleSkins.registerCatchModifier("frog", FrogTackleSkin::new);
    public static final ResourceLocation COLORFUL_TACKLE_SKIN = ModTackleSkins.registerCatchModifier("colorful", ColorfulTackleSkin::new);
    public static final ResourceLocation CLEAR_TACKLE_SKIN = ModTackleSkins.registerCatchModifier("clear", ClearTackleSkin::new);
    public static final ResourceLocation KING_TACKLE_SKIN = ModTackleSkins.registerCatchModifier("king", KingTackleSkin::new);

    public static ResourceLocation registerCatchModifier(String name, Supplier<AbstractTackleSkin> sup) {
        REGISTRY.register(name, () -> sup);
        return Starcatcher.rl(name);
    }

    public static void register(IEventBus eventBus) {
        REGISTRY.register(eventBus);
    }

    public static AbstractTackleSkin get(Level level, ItemStack itemInHand) {
        if (ModDataComponents.has(itemInHand, ModDataComponents.TACKLE_SKIN)) {
            ResourceLocation rl = (ResourceLocation)ModDataComponents.get(itemInHand, ModDataComponents.TACKLE_SKIN);
            Optional optional = level.registryAccess().registryOrThrow(Starcatcher.TACKLE_SKIN).getOptional(rl);
            if (optional.isPresent()) {
                return (AbstractTackleSkin)((Supplier)optional.get()).get();
            }
        }
        return new BaseTackleSkin();
    }
}

