/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.registry.custom.tackleskin;

import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.registry.custom.tackleskin.AbstractTackleSkin;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class FrogTackleSkin
extends AbstractTackleSkin {
    @Override
    public ModelLayerLocation getLayerLocation() {
        return new ModelLayerLocation(Starcatcher.rl("frog"), "main");
    }

    @Override
    public ResourceLocation getTexture() {
        return Starcatcher.rl("textures/entity/tackle/frog.png");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("root", CubeListBuilder.create().texOffs(0, 8).addBox(-2.0f, -3.0f, -2.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(10, 16).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(10, 19).addBox(-1.0f, 1.0f, 0.0f, 2.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(6, 18).addBox(0.0f, 1.0f, -1.0f, 0.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 15).addBox(-2.0f, -4.0f, -0.5f, 4.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(-8, 0).addBox(-4.0f, 0.0f, -4.0f, 8.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 18).addBox(-3.0f, -2.0f, -2.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 22).addBox(2.0f, -2.0f, -2.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 9).addBox(2.0f, -2.0f, 1.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(12, 9).addBox(-3.0f, -2.0f, 1.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(4, 24).addBox(-1.0f, -1.5f, 2.0f, 2.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)24.0f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    @Override
    public void onCast(Player player) {
        super.onCast(player);
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FROG_AMBIENT, SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    @Override
    public void onRetrieve(Player player) {
        super.onRetrieve(player);
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FROG_AMBIENT, SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    @Override
    public void onFailedMinigame(Player player) {
        super.onFailedMinigame(player);
        Vec3 p = player.position();
        player.level().playSound(null, p.x, p.y, p.z, SoundEvents.FROG_DEATH, SoundSource.AMBIENT);
    }
}

