/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.registry.custom.minigamemodifiers;

import com.mojang.datafixers.util.Pair;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.registry.custom.minigamemodifiers.AbstractMinigameModifier;
import com.wdiscute.starcatcher.registry.custom.minigamemodifiers.AquaBobberModifier;
import com.wdiscute.starcatcher.registry.custom.minigamemodifiers.ClearBobberModifier;
import com.wdiscute.starcatcher.registry.custom.minigamemodifiers.FreezeOnMissModifier;
import com.wdiscute.starcatcher.registry.custom.minigamemodifiers.HeavyHookModifier;
import com.wdiscute.starcatcher.registry.custom.minigamemodifiers.LowChanceTreasureSpawnModifier;
import com.wdiscute.starcatcher.registry.custom.minigamemodifiers.MossyHookModifier;
import com.wdiscute.starcatcher.registry.custom.minigamemodifiers.Nikdo53Modifier;
import com.wdiscute.starcatcher.registry.custom.minigamemodifiers.ShinyHookModifier;
import com.wdiscute.starcatcher.registry.custom.minigamemodifiers.SpawnFrozenSweetSpotsModifier;
import com.wdiscute.starcatcher.registry.custom.minigamemodifiers.SpawnTntSweetSpotsModifier;
import com.wdiscute.starcatcher.registry.custom.minigamemodifiers.SteadyBobberModifier;
import com.wdiscute.starcatcher.registry.custom.minigamemodifiers.StoneHookModifier;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;

public interface ModMinigameModifiers {
    public static final DeferredRegister<Supplier<AbstractMinigameModifier>> REGISTRY = DeferredRegister.create(Starcatcher.MINIGAME_MODIFIERS_REGISTRY, (String)"starcatcher");
    public static final Pair<ResourceLocation, Supplier<AbstractMinigameModifier>> FREEZE_ON_MISS = ModMinigameModifiers.registerMinigameModifier("freeze_on_miss", FreezeOnMissModifier::new);
    public static final Pair<ResourceLocation, Supplier<AbstractMinigameModifier>> SPAWN_FROZEN_SWEET_SPOTS = ModMinigameModifiers.registerMinigameModifier("spawn_frozen_sweet_spots", SpawnFrozenSweetSpotsModifier::new);
    public static final Pair<ResourceLocation, Supplier<AbstractMinigameModifier>> LOW_CHANCE_TREASURE_SPAWN = ModMinigameModifiers.registerMinigameModifier("low_chance_treasure_spawn", LowChanceTreasureSpawnModifier::new);
    public static final Pair<ResourceLocation, Supplier<AbstractMinigameModifier>> SPAWN_TNT_SWEET_SPOTS = ModMinigameModifiers.registerMinigameModifier("spawn_tnt_sweet_spots", SpawnTntSweetSpotsModifier::new);
    public static final Pair<ResourceLocation, Supplier<AbstractMinigameModifier>> SPAWN_TNT_SWEET_SPOTS_PLUS = ModMinigameModifiers.registerMinigameModifier("spawn_tnt_sweet_spots_plus", () -> new SpawnTntSweetSpotsModifier(0.5f, 4));
    public static final Pair<ResourceLocation, Supplier<AbstractMinigameModifier>> SPAWN_TREASURE_ON_THREE_HITS = ModMinigameModifiers.registerMinigameModifier("spawn_treasure_on_three_hits", ShinyHookModifier::new);
    public static final Pair<ResourceLocation, Supplier<AbstractMinigameModifier>> SLOWER_MOVING_SWEET_SPOTS = ModMinigameModifiers.registerMinigameModifier("slower_moving_sweet_spots", () -> new HeavyHookModifier(2.0f));
    public static final Pair<ResourceLocation, Supplier<AbstractMinigameModifier>> SLOWER_MOVING_SWEET_SPOTS_MORE = ModMinigameModifiers.registerMinigameModifier("slower_moving_sweet_spots_more", () -> new HeavyHookModifier(3.0f));
    public static final Pair<ResourceLocation, Supplier<AbstractMinigameModifier>> SLOWER_MOVING_SWEET_SPOTS_MORE_MORE = ModMinigameModifiers.registerMinigameModifier("slower_moving_sweet_spots_more_more", () -> new HeavyHookModifier(4.0f));
    public static final Pair<ResourceLocation, Supplier<AbstractMinigameModifier>> SLOWER_MOVING_SWEET_SPOTS_MORE_MORE_MORE = ModMinigameModifiers.registerMinigameModifier("slower_moving_sweet_spots_more_more_more", () -> new HeavyHookModifier(5.0f));
    public static final Pair<ResourceLocation, Supplier<AbstractMinigameModifier>> STOP_DECAY_ON_HIT = ModMinigameModifiers.registerMinigameModifier("stop_decay_on_hit", StoneHookModifier::new);
    public static final Pair<ResourceLocation, Supplier<AbstractMinigameModifier>> HARDER_WITH_TREASURE_ON_PERFECT = ModMinigameModifiers.registerMinigameModifier("harder_with_treasure_on_perfect", MossyHookModifier::new);
    public static final Pair<ResourceLocation, Supplier<AbstractMinigameModifier>> BIGGER_GREEN_SWEET_SPOTS = ModMinigameModifiers.registerMinigameModifier("bigger_green_sweet_spots", SteadyBobberModifier::new);
    public static final Pair<ResourceLocation, Supplier<AbstractMinigameModifier>> SLOWER_VANISHING = ModMinigameModifiers.registerMinigameModifier("slower_vanishing", ClearBobberModifier::new);
    public static final Pair<ResourceLocation, Supplier<AbstractMinigameModifier>> ADD_AQUA_SWEET_SPOT = ModMinigameModifiers.registerMinigameModifier("add_aqua_sweet_spot", () -> new AquaBobberModifier(1));
    public static final Pair<ResourceLocation, Supplier<AbstractMinigameModifier>> ADD_THREE_AQUA_SWEET_SPOT = ModMinigameModifiers.registerMinigameModifier("add_three_aqua_sweet_spot", () -> new AquaBobberModifier(3));
    public static final Pair<ResourceLocation, Supplier<AbstractMinigameModifier>> NIKDO53_MODIFIER = ModMinigameModifiers.registerMinigameModifier("nikdo53_modifier", Nikdo53Modifier::new);

    public static Pair<ResourceLocation, Supplier<AbstractMinigameModifier>> registerMinigameModifier(String name, Supplier<AbstractMinigameModifier> sup) {
        REGISTRY.register(name, () -> sup);
        return Pair.of((Object)Starcatcher.rl(name), sup);
    }

    public static void register(IEventBus eventBus) {
        REGISTRY.register(eventBus);
    }
}

