/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.registry.custom.catchmodifiers;

import com.wdiscute.starcatcher.registry.custom.catchmodifiers.AbstractCatchModifier;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class VanillaLootModifier
extends AbstractCatchModifier {
    @Override
    public boolean shouldCancelBeforeSkipsMinigameCheck() {
        return true;
    }

    @Override
    public void onReelAfterTreasureCheck() {
        super.onReelAfterTreasureCheck();
        Player player = this.instance.player;
        Level level = this.instance.level();
        LootParams lootparams = new LootParams.Builder((ServerLevel)level).withParameter(LootContextParams.ORIGIN, (Object)this.instance.position()).withParameter(LootContextParams.TOOL, (Object)this.instance.rod).withParameter(LootContextParams.THIS_ENTITY, (Object)this.instance).withParameter(LootContextParams.ATTACKING_ENTITY, (Object)this.instance.getOwner()).withLuck(player.getLuck()).create(LootContextParamSets.FISHING);
        LootTable table = level.getServer().reloadableRegistries().getLootTable(BuiltInLootTables.FISHING);
        ObjectArrayList items = table.getRandomItems(lootparams);
        if (items.isEmpty()) {
            return;
        }
        ItemEntity itemFished = new ItemEntity(level, this.instance.position().x, this.instance.position().y + (double)1.2f, this.instance.position().z, (ItemStack)items.get(0));
        double x = Math.clamp((player.position().x - this.instance.position().x) / 25.0, -1.0, 1.0);
        double y = Math.clamp((player.position().y - this.instance.position().y) / 20.0, -1.0, 1.0);
        double z = Math.clamp((player.position().z - this.instance.position().z) / 25.0, -1.0, 1.0);
        Vec3 vec3 = new Vec3(x, 0.7 + y, z);
        itemFished.setDeltaMovement(vec3);
        level.addFreshEntity((Entity)itemFished);
        this.instance.kill();
    }
}

