/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.registry.custom.catchmodifiers;

import com.mojang.datafixers.util.Pair;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.StarcatcherTags;
import com.wdiscute.starcatcher.io.ModDataComponents;
import com.wdiscute.starcatcher.io.SingleStackContainer;
import com.wdiscute.starcatcher.registry.custom.catchmodifiers.AbstractCatchModifier;
import com.wdiscute.starcatcher.registry.custom.catchmodifiers.DecreaseLureTimeModifier;
import com.wdiscute.starcatcher.registry.custom.catchmodifiers.ExtraExpBasedOnPerformanceModifier;
import com.wdiscute.starcatcher.registry.custom.catchmodifiers.ExtraItemsModifier;
import com.wdiscute.starcatcher.registry.custom.catchmodifiers.ForceFishEntityModifier;
import com.wdiscute.starcatcher.registry.custom.catchmodifiers.GuaranteeNewFishModifier;
import com.wdiscute.starcatcher.registry.custom.catchmodifiers.IgnoreDaytimeWeatherRestrictions;
import com.wdiscute.starcatcher.registry.custom.catchmodifiers.VanillaLootModifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;

public interface ModCatchModifiers {
    public static final DeferredRegister<Supplier<AbstractCatchModifier>> REGISTRY = DeferredRegister.create(Starcatcher.CATCH_MODIFIERS_REGISTRY, (String)"starcatcher");
    public static final Pair<ResourceLocation, Supplier<AbstractCatchModifier>> DECREASES_LURE_TIME = ModCatchModifiers.registerCatchModifier("decrease_lure_time", () -> new DecreaseLureTimeModifier(20, 100, 80));
    public static final Pair<ResourceLocation, Supplier<AbstractCatchModifier>> BIG_DECREASES_LURE_TIME = ModCatchModifiers.registerCatchModifier("big_decrease_lure_time", () -> new DecreaseLureTimeModifier(50, 170, 80));
    public static final Pair<ResourceLocation, Supplier<AbstractCatchModifier>> INCREASE_DECREASES_LURE_TIME = ModCatchModifiers.registerCatchModifier("increase_lure_time", () -> new DecreaseLureTimeModifier(-20, -100, -80));
    public static final Pair<ResourceLocation, Supplier<AbstractCatchModifier>> VANILLA_LOOT = ModCatchModifiers.registerCatchModifier("vanilla_loot", VanillaLootModifier::new);
    public static final Pair<ResourceLocation, Supplier<AbstractCatchModifier>> FISH_ENTITY = ModCatchModifiers.registerCatchModifier("fish_entity", ForceFishEntityModifier::new);
    public static final Pair<ResourceLocation, Supplier<AbstractCatchModifier>> GUARANTEE_NEW_FISH_ALWAYS = ModCatchModifiers.registerCatchModifier("guarantee_new_fish_always", () -> new GuaranteeNewFishModifier(101.0f));
    public static final Pair<ResourceLocation, Supplier<AbstractCatchModifier>> GUARANTEE_NEW_FISH_HALF = ModCatchModifiers.registerCatchModifier("guarantee_new_fish_half", () -> new GuaranteeNewFishModifier(50.0f));
    public static final Pair<ResourceLocation, Supplier<AbstractCatchModifier>> EXTRA_EXP_BASED_ON_PERFORMANCE = ModCatchModifiers.registerCatchModifier("extra_exp_based_on_performance", ExtraExpBasedOnPerformanceModifier::new);
    public static final Pair<ResourceLocation, Supplier<AbstractCatchModifier>> EXTRA_ITEM = ModCatchModifiers.registerCatchModifier("extra_item", () -> new ExtraItemsModifier(1));
    public static final Pair<ResourceLocation, Supplier<AbstractCatchModifier>> EXTRA_TWO_ITEMS = ModCatchModifiers.registerCatchModifier("extra_two_item", () -> new ExtraItemsModifier(2));
    public static final Pair<ResourceLocation, Supplier<AbstractCatchModifier>> EXTRA_THREE_ITEMS = ModCatchModifiers.registerCatchModifier("extra_three_item", () -> new ExtraItemsModifier(3));
    public static final Pair<ResourceLocation, Supplier<AbstractCatchModifier>> EXTRA_FIVE_ITEMS = ModCatchModifiers.registerCatchModifier("extra_five_item", () -> new ExtraItemsModifier(5));
    public static final Pair<ResourceLocation, Supplier<AbstractCatchModifier>> EXTRA_TEN_ITEMS = ModCatchModifiers.registerCatchModifier("extra_ten_item", () -> new ExtraItemsModifier(10));
    public static final Pair<ResourceLocation, Supplier<AbstractCatchModifier>> EXTRA_THIRTY_TWO_ITEMS = ModCatchModifiers.registerCatchModifier("extra_thirty_two_item", () -> new ExtraItemsModifier(32));
    public static final Pair<ResourceLocation, Supplier<AbstractCatchModifier>> IGNORE_DAYTIME_AND_WEATHER_RESTRICTIONS = ModCatchModifiers.registerCatchModifier("ignore_daytime_and_weather_restrictions", IgnoreDaytimeWeatherRestrictions::new);

    public static Pair<ResourceLocation, Supplier<AbstractCatchModifier>> registerCatchModifier(String name, Supplier<AbstractCatchModifier> sup) {
        REGISTRY.register(name, () -> sup);
        return Pair.of((Object)Starcatcher.rl(name), sup);
    }

    public static void register(IEventBus eventBus) {
        REGISTRY.register(eventBus);
    }

    public static List<AbstractCatchModifier> getAllCatchModifiers(Level level, ItemStack is) {
        return ModCatchModifiers.getAllCatchModifiers(level, is, true);
    }

    public static List<AbstractCatchModifier> getAllCatchModifiers(Level level, ItemStack is, boolean checkRodItemStack) {
        ArrayList<AbstractCatchModifier> modifiers = new ArrayList<AbstractCatchModifier>();
        if (is.is(StarcatcherTags.RODS) && checkRodItemStack) {
            modifiers.addAll(ModCatchModifiers.getAllCatchModifiers(level, ((SingleStackContainer)ModDataComponents.get(is, ModDataComponents.BOBBER)).stack(), false));
            modifiers.addAll(ModCatchModifiers.getAllCatchModifiers(level, ((SingleStackContainer)ModDataComponents.get(is, ModDataComponents.BAIT)).stack(), false));
            modifiers.addAll(ModCatchModifiers.getAllCatchModifiers(level, ((SingleStackContainer)ModDataComponents.get(is, ModDataComponents.HOOK)).stack(), false));
        }
        if (ModDataComponents.has(is, ModDataComponents.CATCH_MODIFIERS)) {
            for (ResourceLocation rl : Objects.requireNonNull((List)ModDataComponents.get(is, ModDataComponents.CATCH_MODIFIERS))) {
                Optional optional = level.registryAccess().registryOrThrow(Starcatcher.CATCH_MODIFIERS).getOptional(rl);
                optional.ifPresent(abstractCatchModifierSupplier -> modifiers.add((AbstractCatchModifier)abstractCatchModifierSupplier.get()));
            }
        }
        return modifiers;
    }

    public static boolean hasModifier(ItemStack is, ResourceLocation rl) {
        return ModCatchModifiers.hasModifier(is, rl, true);
    }

    public static boolean hasModifier(ItemStack is, ResourceLocation rl, boolean checkRodItemStack) {
        if (is.is(StarcatcherTags.RODS) && checkRodItemStack) {
            return ModCatchModifiers.hasModifier(((SingleStackContainer)ModDataComponents.get(is, ModDataComponents.BOBBER)).stack(), rl) || ModCatchModifiers.hasModifier(((SingleStackContainer)ModDataComponents.get(is, ModDataComponents.BAIT)).stack(), rl) || ModCatchModifiers.hasModifier(((SingleStackContainer)ModDataComponents.get(is, ModDataComponents.HOOK)).stack(), rl) || ModCatchModifiers.hasModifier(is, rl, false);
        }
        if (ModDataComponents.has(is, ModDataComponents.CATCH_MODIFIERS)) {
            return ((List)ModDataComponents.get(is, ModDataComponents.CATCH_MODIFIERS)).contains(rl);
        }
        return false;
    }
}

