/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.registry.custom.catchmodifiers;

import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.bob.FishingBobEntity;
import com.wdiscute.starcatcher.io.ModDataComponents;
import com.wdiscute.starcatcher.io.SingleStackContainer;
import com.wdiscute.starcatcher.registry.custom.catchmodifiers.AbstractCatchModifier;
import com.wdiscute.starcatcher.storage.FishProperties;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class IgnoreDaytimeWeatherRestrictions
extends AbstractCatchModifier {
    @Override
    public List<FishProperties> modifyAvailablePool(List<FishProperties> ignore) {
        ArrayList<FishProperties> available = new ArrayList<FishProperties>();
        for (FishProperties fp : this.instance.level().registryAccess().registryOrThrow(Starcatcher.FISH_REGISTRY)) {
            int chance = IgnoreDaytimeWeatherRestrictions.getChanceMeteorological(fp, (Entity)this.instance, this.instance.rod);
            for (int i = 0; i < chance; ++i) {
                available.add(fp);
            }
        }
        return available;
    }

    public static int getChanceMeteorological(FishProperties fp, Entity entity, ItemStack rod) {
        ItemStack bait;
        Level level = entity.level();
        if (!FishProperties.isSeasonCorrect(entity, fp)) {
            return 0;
        }
        if (!FishProperties.isDimensionCorrect(entity, fp)) {
            return 0;
        }
        if (!FishProperties.isBiomeCorrect(entity, fp)) {
            return 0;
        }
        if (!FishProperties.isElevationCorrect(entity, fp)) {
            return 0;
        }
        boolean fluid = fp.wr().fluids().contains(BuiltInRegistries.FLUID.getKey((Object)FishProperties.getSource(level.getFluidState(entity.blockPosition()).getType())));
        boolean fluidAbove = fp.wr().fluids().contains(BuiltInRegistries.FLUID.getKey((Object)FishProperties.getSource(level.getFluidState(entity.blockPosition().above()).getType())));
        boolean fluidBelow = fp.wr().fluids().contains(BuiltInRegistries.FLUID.getKey((Object)FishProperties.getSource(level.getFluidState(entity.blockPosition().below()).getType())));
        if (!fluid && !fluidAbove && !fluidBelow && entity instanceof FishingBobEntity) {
            return 0;
        }
        ItemStack itemStack = bait = ModDataComponents.has(rod, ModDataComponents.BAIT) ? ((SingleStackContainer)ModDataComponents.get(rod, ModDataComponents.BAIT)).stack().copy() : ItemStack.EMPTY;
        if (fp.br().correctBait().contains(BuiltInRegistries.ITEM.getKey((Object)bait.getItem()))) {
            return fp.baseChance() + fp.br().correctBaitChanceAdded();
        }
        return fp.baseChance();
    }
}

