/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.registry.blocks;

import com.mojang.serialization.MapCodec;
import com.wdiscute.starcatcher.registry.blocks.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TrophyBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock,
EntityBlock {
    public TrophyBlock() {
        super(BlockBehaviour.Properties.of().noOcclusion().lightLevel(state -> 5).sound(SoundType.AMETHYST));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (state.getValue((Property)FACING) == Direction.WEST || ((Direction)state.getValue((Property)FACING)).equals((Object)Direction.EAST)) {
            return Shapes.or((VoxelShape)Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0), (VoxelShape[])new VoxelShape[]{Block.box((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)3.0, (double)12.0), Block.box((double)6.0, (double)3.0, (double)6.0, (double)10.0, (double)5.0, (double)10.0), Block.box((double)7.0, (double)5.0, (double)7.0, (double)9.0, (double)8.0, (double)9.0), Block.box((double)6.0, (double)6.0, (double)1.0, (double)10.0, (double)14.0, (double)15.0)});
        }
        return Shapes.or((VoxelShape)Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0), (VoxelShape[])new VoxelShape[]{Block.box((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)3.0, (double)12.0), Block.box((double)6.0, (double)3.0, (double)6.0, (double)10.0, (double)5.0, (double)10.0), Block.box((double)7.0, (double)5.0, (double)7.0, (double)9.0, (double)8.0, (double)9.0), Block.box((double)1.0, (double)6.0, (double)6.0, (double)15.0, (double)14.0, (double)10.0)});
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return null;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState bs = this.defaultBlockState();
        bs = (BlockState)bs.setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
        bs = (BlockState)bs.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).is((Fluid)Fluids.WATER)));
        return bs;
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return ModBlockEntities.TROPHY.get().create(blockPos, blockState);
    }
}

