/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.registry.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.wdiscute.starcatcher.io.NBTCodecHelper;
import com.wdiscute.starcatcher.registry.blocks.ModBlockEntities;
import com.wdiscute.starcatcher.tournament.StandMenu;
import com.wdiscute.starcatcher.tournament.Tournament;
import com.wdiscute.starcatcher.tournament.TournamentHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.nikdo53.tinymultiblocklib.blockentities.AbstractMultiBlockEntity;
import org.jetbrains.annotations.Nullable;

public class StandBlockEntity
extends AbstractMultiBlockEntity
implements MenuProvider {
    public Tournament tournament;
    public Map<UUID, String> profiles;
    private UUID uuid;
    public final ItemStackHandler entryCost = new ItemStackHandler(this, 9){

        protected int getStackLimit(int slot, ItemStack stack) {
            return 64;
        }
    };

    public StandBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.STAND.get(), pos, blockState);
    }

    public Tournament makeOrGetTournament() {
        if (this.tournament != null) {
            return this.tournament;
        }
        Tournament t = TournamentHandler.getTournamentOrNull(this.getUuid());
        if (t != null) {
            this.tournament = t;
            return this.tournament;
        }
        this.tournament = Tournament.empty(this.getUuid());
        return this.tournament;
    }

    public UUID getUuid() {
        if (this.uuid == null) {
            this.setUuid(UUID.randomUUID());
        }
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
        this.sync();
    }

    public void sync() {
        this.setChanged();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new StandMenu(i, inventory, (BlockEntity)this);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (!this.isCenter()) {
            return;
        }
        if (this.uuid != null) {
            tag.putUUID("tournament_uuid", this.uuid);
        }
        NBTCodecHelper.encode(Tournament.CODEC, this.tournament, tag, "tournament");
        StarcatcherGameProfileCache cache = StandBlockEntity.gameProfilesHelper(this.level, this.tournament);
        NBTCodecHelper.encode(StarcatcherGameProfileCache.GAME_PROFILES_CODEC, cache, tag, "profiles");
    }

    public static StarcatcherGameProfileCache gameProfilesHelper(Level level, Tournament tournament) {
        if (level.isClientSide) {
            return new StarcatcherGameProfileCache(new HashMap<UUID, String>());
        }
        if (tournament == null) {
            return new StarcatcherGameProfileCache(new HashMap<UUID, String>());
        }
        HashMap<UUID, String> map = new HashMap<UUID, String>();
        tournament.playerScores.forEach(entry -> {
            GameProfileCache profileCache = level.getServer().getProfileCache();
            if (profileCache != null) {
                Optional gameProfile = profileCache.get(entry.playerUUID);
                gameProfile.ifPresent(i -> map.put(i.getId(), i.getName()));
            }
        });
        return new StarcatcherGameProfileCache(map);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (!this.isCenter()) {
            return;
        }
        if (tag.contains("tournament_uuid")) {
            this.uuid = tag.getUUID("tournament_uuid");
        }
        this.tournament = NBTCodecHelper.decode(Tournament.CODEC, tag, "tournament");
        StarcatcherGameProfileCache awd = NBTCodecHelper.decode(StarcatcherGameProfileCache.GAME_PROFILES_CODEC, tag, "profiles");
        if (awd != null) {
            this.profiles = awd.map;
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public Component getDisplayName() {
        return Component.empty();
    }

    public record StarcatcherGameProfileCache(Map<UUID, String> map) {
        public static final Codec<StarcatcherGameProfileCache> GAME_PROFILES_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)UUIDUtil.STRING_CODEC, (Codec)Codec.STRING).fieldOf("map").forGetter(StarcatcherGameProfileCache::map)).apply((Applicative)instance, StarcatcherGameProfileCache::new));
    }
}

