/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.minigame;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import com.mojang.math.Axis;
import com.wdiscute.starcatcher.Config;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.StarcatcherTags;
import com.wdiscute.starcatcher.U;
import com.wdiscute.starcatcher.io.ModDataComponents;
import com.wdiscute.starcatcher.io.SingleStackContainer;
import com.wdiscute.starcatcher.io.network.FishingCompletedPayload;
import com.wdiscute.starcatcher.minigame.ActiveSweetSpot;
import com.wdiscute.starcatcher.minigame.HitFakeParticle;
import com.wdiscute.starcatcher.minigame.PartialTickHelper;
import com.wdiscute.starcatcher.registry.ModItems;
import com.wdiscute.starcatcher.registry.ModKeymappings;
import com.wdiscute.starcatcher.registry.custom.minigamemodifiers.AbstractMinigameModifier;
import com.wdiscute.starcatcher.registry.custom.minigamemodifiers.BaseModifier;
import com.wdiscute.starcatcher.registry.custom.tackleskin.AbstractTackleSkin;
import com.wdiscute.starcatcher.registry.custom.tackleskin.BaseTackleSkin;
import com.wdiscute.starcatcher.storage.FishProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Quaternionf;
import org.joml.Vector2d;

public class FishingMinigameScreen
extends Screen
implements GuiEventListener {
    public static final ResourceLocation TEXTURE = Starcatcher.rl("textures/gui/minigame/minigame.png");
    private static final ResourceLocation NETHER = Starcatcher.rl("textures/gui/minigame/nether.png");
    private static final ResourceLocation CAVE = Starcatcher.rl("textures/gui/minigame/cave.png");
    private static final ResourceLocation SURFACE = Starcatcher.rl("textures/gui/minigame/surface.png");
    public ResourceLocation tankTexture = SURFACE;
    public final FishProperties fishProperties;
    public FishProperties.Difficulty difficulty;
    public final ItemStack itemBeingFished;
    public final ItemStack bobber;
    public final ItemStack bait;
    public final ItemStack hook;
    public final ItemStack treasureIS;
    public final AbstractTackleSkin tackleSkin;
    public final InteractionHand handToSwing;
    public int penalty;
    public float decay;
    public float kimbeMarkerPos = 0.0f;
    public float kimbeMarkerAlpha = 0.0f;
    public int kimbeMarkerColor = 65280;
    public int gracePeriod = 80;
    public boolean minigameStarted;
    public float pointerSpeed;
    public float pointerBaseSpeed;
    public int tickCount = 0;
    public int pointerPos = 0;
    public int currentRotation = 1;
    public float partial;
    public float hitDelay;
    public float progress = 20.0f;
    public int progressSmooth = 20;
    public boolean perfectCatch = true;
    public int consecutiveHits = 0;
    public boolean treasureActive;
    public int treasureProgress = 0;
    public int treasureProgressSmooth = 0;
    List<HitFakeParticle> hitParticles = new ArrayList<HitFakeParticle>();
    public final int holdingDelay = 6;
    public int holdingTicks = 0;
    protected boolean isHoldingKey = false;
    protected boolean isHoldingMouse = false;
    public float renderScale;
    protected final List<ActiveSweetSpot> activeSweetSpots = new ArrayList<ActiveSweetSpot>();
    protected final List<AbstractMinigameModifier> modifiers = new ArrayList<AbstractMinigameModifier>();

    public FishingMinigameScreen(FishProperties fp, ItemStack rod) {
        super((Component)Component.empty());
        this.handToSwing = Minecraft.getInstance().player.getMainHandItem().is(StarcatcherTags.RODS) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        this.renderScale = ((Double)Config.MINIGAME_RENDER_SCALE.get()).floatValue();
        this.hitDelay = ((Double)Config.HIT_DELAY.get()).floatValue();
        this.fishProperties = fp;
        this.difficulty = fp.dif();
        this.itemBeingFished = !fp.catchInfo().overrideMinigameWith().is(ModItems.MISSINGNO.getKey()) ? new ItemStack(fp.catchInfo().overrideMinigameWith()) : new ItemStack(fp.catchInfo().fish());
        this.bobber = ((SingleStackContainer)ModDataComponents.get(rod, ModDataComponents.BOBBER)).stack().copy();
        this.bait = ((SingleStackContainer)ModDataComponents.get(rod, ModDataComponents.BAIT)).stack().copy();
        this.hook = ((SingleStackContainer)ModDataComponents.get(rod, ModDataComponents.HOOK)).stack().copy();
        this.treasureIS = new ItemStack(fp.catchInfo().treasure());
        if (ModDataComponents.has(rod, ModDataComponents.TACKLE_SKIN)) {
            ResourceLocation rl = (ResourceLocation)ModDataComponents.get(rod, ModDataComponents.TACKLE_SKIN);
            Optional optional = Minecraft.getInstance().level.registryAccess().registryOrThrow(Starcatcher.TACKLE_SKIN).getOptional(rl);
            this.tackleSkin = optional.isPresent() ? (AbstractTackleSkin)((Supplier)optional.get()).get() : new BaseTackleSkin();
        } else {
            this.tackleSkin = new BaseTackleSkin();
        }
        ClientLevel level = Minecraft.getInstance().level;
        ResourceKey dim = level.dimension();
        LocalPlayer player = Minecraft.getInstance().player;
        if (player.getY() < 50.0 && dim.equals(Level.OVERWORLD)) {
            this.tankTexture = CAVE;
        }
        if (dim.equals(Level.NETHER)) {
            this.tankTexture = NETHER;
        }
        this.pointerSpeed = this.difficulty.speed();
        this.pointerBaseSpeed = this.difficulty.speed();
        this.penalty = this.difficulty.penalty();
        this.decay = this.difficulty.decay();
        this.addModifier(new BaseModifier());
        for (ResourceLocation rl : fp.dif().modifiers()) {
            Optional newModifier = level.registryAccess().registryOrThrow(Starcatcher.MINIGAME_MODIFIERS).getOptional(rl);
            newModifier.ifPresent(mod -> this.addModifier((AbstractMinigameModifier)mod.get()));
        }
        List<ItemStack> allItems = List.of(this.bobber, rod, this.bait, this.hook);
        for (ItemStack is : allItems) {
            if (!ModDataComponents.has(is, ModDataComponents.MINIGAME_MODIFIERS)) continue;
            for (ResourceLocation rl : Objects.requireNonNull((List)ModDataComponents.get(is, ModDataComponents.MINIGAME_MODIFIERS))) {
                Optional newModifier = level.registryAccess().registryOrThrow(Starcatcher.MINIGAME_MODIFIERS).getOptional(rl);
                newModifier.ifPresent(mod -> this.addModifier((AbstractMinigameModifier)mod.get()));
            }
        }
        for (FishProperties.SweetSpot ss : fp.dif().sweetSpots()) {
            ActiveSweetSpot newSweetSpot = new ActiveSweetSpot(this, ss, this.bobber, this.bait, this.hook);
            this.addSweetSpot(newSweetSpot);
        }
    }

    public void addModifier(AbstractMinigameModifier mod) {
        mod.onAdd(this);
        if (!mod.removed) {
            this.modifiers.add(mod);
        }
    }

    public void addUniqueModifier(AbstractMinigameModifier mod) {
        if (this.modifiers.stream().noneMatch(m -> m.getClass() == mod.getClass())) {
            mod.onAdd(this);
            if (!mod.removed) {
                this.modifiers.add(mod);
            }
        }
    }

    public void addSweetSpot(ActiveSweetSpot ass) {
        ass.behaviour.onAdd(this, ass);
        for (AbstractMinigameModifier modifier : this.modifiers) {
            ass = modifier.onSpotAdded(ass);
        }
        if (!ass.removed) {
            this.activeSweetSpots.add(ass);
        }
    }

    public int getRandomFreePosition(int sizeOfTheSweetspotToPlace) {
        int posBeingChecked = U.r.nextInt(360);
        for (int i = 0; i < 180; ++i) {
            for (int j = 1; j > -2; j -= 2) {
                int checkPos = FishingMinigameScreen.clampPos(posBeingChecked + i * j);
                if (!this.activeSweetSpots.stream().noneMatch(s -> FishingMinigameScreen.doDegreesOverlapWithLeeway(checkPos, s.pos, (s.thickness + sizeOfTheSweetspotToPlace) / 2))) continue;
                return checkPos;
            }
        }
        LogUtils.getLogger().warn("Starcatcher's minigame couldn't find a non-overlapping free position! Consider not having so many active sweet spots");
        return U.r.nextInt(360);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTickNeo) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTickNeo);
        float partialTick = (Boolean)Config.VANILLA_PARTIAL_TICK.get() != false ? partialTickNeo : PartialTickHelper.INSTANCE.getPartialTicks((Level)this.minecraft.level);
        PoseStack poseStack = guiGraphics.pose();
        this.partial = partialTick;
        poseStack.pushPose();
        poseStack.translate((float)(this.width >> 1), (float)(this.height >> 1), 0.0f);
        poseStack.scale(this.renderScale, this.renderScale, 1.0f);
        poseStack.translate((float)(-this.width >> 1), (float)(-this.height >> 1), 0.0f);
        this.modifiers.forEach(modifier -> modifier.renderBackground(guiGraphics, partialTick, this.width, this.height));
        if (this.treasureActive) {
            this.renderTreasure(guiGraphics);
        }
        guiGraphics.blit(this.tankTexture, this.width / 2 - 42 - 100, this.height / 2 - 48, 85, 97, 0.0f, 0.0f, 85, 97, 85, 97);
        guiGraphics.blit(TEXTURE, this.width / 2 - 32, this.height / 2 - 32, 64, 64, 0.0f, 192.0f, 64, 64, 256, 256);
        guiGraphics.blit(TEXTURE, this.width / 2 - 16, this.height / 2 + 40, 32, 16, this.isHoldingKey ? 48.0f : 0.0f, 112.0f, 32, 16, 256, 256);
        this.activeSweetSpots.forEach(ass -> this.renderSweetSpot((ActiveSweetSpot)ass, guiGraphics, partialTick, poseStack));
        guiGraphics.blit(TEXTURE, this.width / 2 - 32, this.height / 2 - 32, 64, 64, 64.0f, 192.0f, 64, 64, 256, 256);
        this.renderPointer(guiGraphics, poseStack, partialTick);
        this.renderKimbeMarker(guiGraphics);
        guiGraphics.blit(TEXTURE, this.width / 2 - 16, this.height / 2 - 16, 32, 32, 208.0f, 208.0f, 32, 32, 256, 256);
        guiGraphics.blit(TEXTURE, this.width / 2 - 32 - 70, this.height / 2 - 24 - 57, 64, 48, 192.0f, 0.0f, 64, 48, 256, 256);
        guiGraphics.blit(TEXTURE, this.width / 2 - 6 - 102, this.height / 2 - 56 - 18, 16, 112 - this.progressSmooth, 176.0f, (float)this.progressSmooth, 16, 112 - this.progressSmooth, 256, 256);
        guiGraphics.renderItem(this.itemBeingFished, this.width / 2 - 8 - 100, this.height / 2 - 8 + 35 - this.progressSmooth);
        this.activeSweetSpots.forEach(sweetspot -> sweetspot.behaviour.renderForeground(guiGraphics, partialTick, this.width, this.height));
        this.modifiers.forEach(modifier -> modifier.renderForeground(guiGraphics, partialTick, this.width, this.height));
        this.hitParticles.forEach(p -> p.render(guiGraphics, this.width, this.height));
        poseStack.popPose();
    }

    public void renderSweetSpot(ActiveSweetSpot ass, GuiGraphics guiGraphics, float partialTick, PoseStack poseStack) {
        float centerX = (float)this.width / 2.0f;
        float centerY = (float)this.height / 2.0f;
        poseStack.pushPose();
        poseStack.translate(centerX, centerY, 0.0f);
        poseStack.rotateAround(Axis.ZP.rotationDegrees(ass.pos + partialTick * ass.movingRate), 0.0f, 0.0f, 0.0f);
        boolean isDisabled = this.modifiers.stream().anyMatch(mod -> mod.disableSweetSpotRendering(ass));
        if (!isDisabled) {
            ass.behaviour.render(guiGraphics, poseStack, partialTick);
        }
        this.modifiers.forEach(mod -> mod.renderOnSweetSpot(guiGraphics, poseStack, ass, partialTick));
        poseStack.popPose();
    }

    public void renderTreasure(GuiGraphics guiGraphics) {
        guiGraphics.blit(TEXTURE, this.width / 2 - 158, this.height / 2 - 42 + (int)(64.0f - 64.0f * (float)this.treasureProgressSmooth / 100.0f), 5, 64 * this.treasureProgressSmooth / 100, 141.0f, 70.0f - (float)(64 * this.treasureProgressSmooth) / 100.0f, 5, 64 * this.treasureProgressSmooth / 100, 256, 256);
        guiGraphics.blit(TEXTURE, this.width / 2 - 16 - 155, this.height / 2 - 48, 32, 96, 96.0f, 0.0f, 32, 96, 256, 256);
        guiGraphics.renderItem(this.treasureIS, this.width / 2 - 163, (int)((float)this.height / 2.0f - 64.0f * (float)this.treasureProgressSmooth / 100.0f) + 15);
        if (this.treasureProgress > 99) {
            guiGraphics.blit(TEXTURE, this.width / 2 - 16 - 155, this.height / 2 - 48, 32, 96, 64.0f, 0.0f, 32, 96, 256, 256);
        }
    }

    public void renderKimbeMarker(GuiGraphics guiGraphics) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        float centerX = (float)this.width / 2.0f;
        float centerY = (float)this.height / 2.0f;
        poseStack.translate(centerX, centerY, 0.0f);
        poseStack.mulPose(new Quaternionf().rotateZ((float)Math.toRadians(this.kimbeMarkerPos)));
        poseStack.translate(-centerX, -centerY, 0.0f);
        RenderSystem.setShaderColor((float)((float)U.intToRed(this.kimbeMarkerColor) / 255.0f), (float)((float)U.intToGreen(this.kimbeMarkerColor) / 255.0f), (float)((float)U.intToBlue(this.kimbeMarkerColor) / 255.0f), (float)this.kimbeMarkerAlpha);
        RenderSystem.enableBlend();
        guiGraphics.blit(TEXTURE, this.width / 2 - 32, this.height / 2 - 32 - 16, 64, 64, 128.0f, 128.0f, 64, 64, 256, 256);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        poseStack.popPose();
    }

    public void renderPointer(GuiGraphics guiGraphics, PoseStack poseStack, float partialTick) {
        poseStack.pushPose();
        float centerX = (float)this.width / 2.0f;
        float centerY = (float)this.height / 2.0f;
        poseStack.translate(centerX, centerY, 0.0f);
        poseStack.mulPose(Axis.ZP.rotationDegrees((float)this.pointerPos + this.pointerSpeed * partialTick * (float)this.currentRotation));
        poseStack.translate(0.0f, -16.0f, 0.0f);
        boolean isDisabled = this.modifiers.stream().anyMatch(AbstractMinigameModifier::disablePointerRendering);
        if (!isDisabled) {
            FishingMinigameScreen.renderPoseCentered(guiGraphics, TEXTURE, 64, 64, 128, 192, 256);
        }
        poseStack.translate(0.0f, 16.0f, 0.0f);
        this.modifiers.forEach(mod -> mod.renderOnPointer(guiGraphics, poseStack, partialTick));
        poseStack.popPose();
    }

    public boolean keyReleased(int keyCode, int scanCode, int keyModifiers) {
        if (keyCode == ModKeymappings.MINIGAME_HIT.getKey().getValue()) {
            this.isHoldingKey = false;
            this.holdingTicks = 0;
        }
        this.modifiers.forEach(mod -> mod.onKeyReleased(keyCode, scanCode, keyModifiers));
        return super.keyReleased(keyCode, scanCode, keyModifiers);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.isHoldingMouse = false;
        this.holdingTicks = 0;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.inputPressed();
        this.isHoldingMouse = true;
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int keyModifiers) {
        InputConstants.Key mouseKey = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (this.minecraft.options.keyInventory.isActiveAndMatches(mouseKey)) {
            this.onClose();
            return true;
        }
        if (ModKeymappings.MINIGAME_HIT.isActiveAndMatches(mouseKey)) {
            if (!this.isHoldingKey) {
                this.inputPressed();
            }
            this.isHoldingKey = true;
        }
        this.modifiers.forEach(mod -> mod.onKeyPress(keyCode, scanCode, keyModifiers));
        return super.keyPressed(keyCode, scanCode, keyModifiers);
    }

    public void inputPressed() {
        if (this.gracePeriod > 0) {
            this.gracePeriod = 0;
        }
        Minecraft.getInstance().player.swing(this.handToSwing, true);
        boolean hitSomething = false;
        Vec3 pos = Minecraft.getInstance().player.position();
        ClientLevel level = Minecraft.getInstance().level;
        this.kimbeMarkerPos = this.getPointerPosPrecise();
        for (ActiveSweetSpot ass : this.activeSweetSpots) {
            if (!FishingMinigameScreen.doDegreesOverlapWithLeeway(this.getPointerPosPrecise(), ass.pos, ass.thickness / 2)) continue;
            boolean isCanceled = false;
            for (AbstractMinigameModifier modifier : this.modifiers) {
                if (!modifier.onHit(ass)) continue;
                isCanceled = true;
            }
            if (isCanceled) continue;
            hitSomething = true;
            ass.behaviour.onHit();
            break;
        }
        if (!hitSomething) {
            this.modifiers.forEach(AbstractMinigameModifier::onMiss);
            this.consecutiveHits = 0;
            level.playLocalSound(pos.x, pos.y, pos.z, SoundEvents.COMPARATOR_CLICK, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            this.progress -= (float)this.penalty;
        }
    }

    public float getPointerPosPrecise() {
        float pointerPosPrecise = (float)this.pointerPos + this.pointerSpeed * this.partial * (float)this.currentRotation;
        return pointerPosPrecise += this.hitDelay * this.pointerSpeed * (float)this.currentRotation;
    }

    public static boolean doDegreesOverlapWithLeeway(float degrees1, float degrees2, int leeway) {
        boolean b = Math.abs(degrees2 - degrees1) < (float)leeway;
        boolean b2 = Math.abs(degrees2 - degrees1) > 360.0f - (float)leeway;
        return b || b2;
    }

    public void tick() {
        if (this.isHoldingInput()) {
            ++this.holdingTicks;
            if (this.holdingTicks > 6) {
                this.inputPressed();
            }
        }
        this.modifiers.forEach(AbstractMinigameModifier::tick);
        this.activeSweetSpots.forEach(s -> s.behaviour.tick());
        this.activeSweetSpots.removeIf(s -> {
            if (s.removed) {
                s.behaviour.onRemove();
            }
            return s.removed;
        });
        this.modifiers.removeIf(m -> {
            if (m.removed) {
                m.onRemove();
            }
            return m.removed;
        });
        this.pointerPos += (int)(this.pointerSpeed * (float)this.currentRotation);
        this.kimbeMarkerAlpha -= 0.1f;
        if (this.pointerPos > 360) {
            this.pointerPos -= 360;
        }
        if (this.pointerPos < 0) {
            this.pointerPos += 360;
        }
        --this.gracePeriod;
        ++this.tickCount;
        this.progressSmooth += (int)Math.signum(this.progress - (float)this.progressSmooth);
        this.progressSmooth += (int)Math.signum(this.progress - (float)this.progressSmooth);
        this.treasureProgressSmooth += (int)Math.signum(this.treasureProgress - this.treasureProgressSmooth);
        if (this.tickCount % 5 == 0 && this.gracePeriod < 0) {
            this.progress -= this.decay;
        }
        if (!this.isSettingsScreen()) {
            if (this.progressSmooth < 0) {
                this.onClose();
            }
            if (this.progressSmooth > 75) {
                boolean awardTreasure = this.treasureProgress > 100 || this.modifiers.stream().anyMatch(AbstractMinigameModifier::forceAwardTreasure);
                PacketDistributor.sendToServer((CustomPacketPayload)new FishingCompletedPayload(this.tickCount, awardTreasure, this.perfectCatch, this.consecutiveHits), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.onClose();
            }
        }
        this.hitParticles.removeIf(HitFakeParticle::tick);
    }

    public void onClose() {
        this.modifiers.forEach(AbstractMinigameModifier::onRemove);
        PacketDistributor.sendToServer((CustomPacketPayload)new FishingCompletedPayload(-1, false, false, this.consecutiveHits), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.minecraft.popGuiLayer();
    }

    public void addParticles(float posInDegrees, int count, int color) {
        int xPos = (int)(30.0 * Math.cos(Math.toRadians(posInDegrees - 90.0f)));
        int yPos = (int)(30.0 * Math.sin(Math.toRadians(posInDegrees - 90.0f)));
        for (int i = 0; i < count; ++i) {
            this.hitParticles.add(new HitFakeParticle(xPos, yPos, new Vector2d((double)(U.r.nextFloat() * 2.0f - 1.0f), (double)(U.r.nextFloat() * 2.0f - 1.0f)), (float)U.intToRed(color) / 255.0f, (float)U.intToGreen(color) / 255.0f, (float)U.intToBlue(color) / 255.0f, 1.0f));
        }
    }

    public static void renderPoseCentered(GuiGraphics guiGraphics, ResourceLocation texture, int spriteSize) {
        guiGraphics.blit(texture, -spriteSize >> 1, -spriteSize >> 1, spriteSize, spriteSize, 0.0f, 0.0f, spriteSize, spriteSize, spriteSize, spriteSize);
    }

    public static void renderPoseCentered(GuiGraphics guiGraphics, ResourceLocation texture, int spriteWidth, int spriteHeight, int uOffset, int vOffset, int textureSize) {
        guiGraphics.blit(texture, -spriteWidth >> 1, -spriteHeight >> 1, spriteWidth, spriteHeight, (float)uOffset, (float)vOffset, spriteWidth, spriteHeight, textureSize, textureSize);
    }

    public boolean isHoldingInput() {
        return this.isHoldingMouse || this.isHoldingKey;
    }

    public static boolean hasDistantHorizons() {
        return ModList.get().isLoaded("distanthorizons");
    }

    public boolean isSettingsScreen() {
        return false;
    }

    public static int clampPos(int pos) {
        if ((pos %= 360) < 0) {
            pos += 360;
        }
        return pos;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void refreshSweetSpotsAlphas() {
        this.activeSweetSpots.forEach(s -> {
            s.alpha = 1.0f;
        });
    }

    public void removeAllSweetSpots() {
        for (ActiveSweetSpot dws : this.activeSweetSpots) {
            dws.removed = true;
        }
    }
}

