/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.minigame;

import com.mojang.logging.LogUtils;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.minigame.FishingMinigameScreen;
import com.wdiscute.starcatcher.registry.custom.sweetspotbehaviour.AbstractSweetSpotBehaviour;
import com.wdiscute.starcatcher.storage.FishProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ActiveSweetSpot {
    public final AbstractSweetSpotBehaviour behaviour;
    public final FishProperties.SweetSpot baseSS;
    public int thickness;
    public ResourceLocation texture;
    public int reward;
    public int particleColor;
    public final FishingMinigameScreen instance;
    public final ItemStack bobber;
    public final ItemStack bait;
    public final ItemStack hook;
    public boolean isFlip;
    public float vanishingRate;
    public float movingRate;
    public float alpha;
    public float pos;
    public int currentRotation;
    public boolean removed = false;
    public boolean shouldSudokuOnVanish = false;
    public Map<Integer, Object> extraData = new HashMap<Integer, Object>();

    public ActiveSweetSpot(FishingMinigameScreen instance, FishProperties.SweetSpot ss, ItemStack bobber, ItemStack bait, ItemStack hook) {
        Optional behaviour = Minecraft.getInstance().level.registryAccess().registryOrThrow(Starcatcher.SWEET_SPOT_BEHAVIOUR).getOptional(ss.sweetSpotType());
        if (behaviour.isPresent()) {
            this.behaviour = (AbstractSweetSpotBehaviour)((Supplier)behaviour.get()).get();
        } else {
            this.behaviour = null;
            LogUtils.getLogger().error("The sweet-spot type {} is not registered, as such the sweet-spot has not been added", (Object)ss.sweetSpotType());
            this.removed = true;
        }
        this.instance = instance;
        this.baseSS = ss;
        this.texture = ss.texturePath();
        this.thickness = ss.size();
        this.reward = ss.reward();
        this.particleColor = ss.particleColor();
        this.bobber = bobber;
        this.bait = bait;
        this.hook = hook;
        this.isFlip = ss.isFlip();
        this.vanishingRate = ss.vanishingRate();
        this.movingRate = ss.movingRate();
        this.currentRotation = 1;
        this.alpha = 1.0f;
    }

    public ActiveSweetSpot(FishingMinigameScreen instance, FishProperties.SweetSpot ss) {
        this(instance, ss, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY);
    }

    public boolean isHoveredOver() {
        return FishingMinigameScreen.doDegreesOverlapWithLeeway(this.instance.getPointerPosPrecise(), this.pos, this.thickness);
    }
}

