/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.items;

import com.wdiscute.starcatcher.fishentity.FishEntity;
import com.wdiscute.starcatcher.io.ModDataComponents;
import com.wdiscute.starcatcher.io.SingleStackContainer;
import com.wdiscute.starcatcher.registry.ModEntities;
import com.wdiscute.starcatcher.registry.ModItems;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class StarcaughtBucket
extends BucketItem {
    EntityType<FishEntity> entity = ModEntities.FISH.get();

    public StarcaughtBucket(Fluid fluid) {
        super(fluid, new Item.Properties().stacksTo(16));
    }

    public void checkExtraContent(@Nullable Player player, Level level, ItemStack containerStack, BlockPos pos) {
        if (level instanceof ServerLevel) {
            this.spawn((ServerLevel)level, containerStack, pos);
            level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, pos);
        }
    }

    private void spawn(ServerLevel serverLevel, ItemStack bucketedMobStack, BlockPos pos) {
        FishEntity fishEntity = (FishEntity)this.entity.spawn(serverLevel, bucketedMobStack, null, pos, MobSpawnType.BUCKET, true, false);
        if (ModDataComponents.has(bucketedMobStack, ModDataComponents.BUCKETED_FISH)) {
            fishEntity.setFish(StarcaughtBucket.getFish(bucketedMobStack));
        } else {
            fishEntity.setFish(ModItems.AURORA.toStack());
        }
    }

    private static ItemStack getFish(ItemStack bucket) {
        return ModDataComponents.getOrDefault(bucket, ModDataComponents.BUCKETED_FISH, new SingleStackContainer(ItemStack.EMPTY)).stack();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        ItemStack fish = StarcaughtBucket.getFish(stack);
        if (fish.isEmpty()) {
            tooltipComponents.add(1, (Component)Component.translatable((String)"tooltip.starcatcher.starcaught_bucket.creative.1").withColor(0x888888));
            tooltipComponents.add(1, (Component)Component.translatable((String)"tooltip.starcatcher.starcaught_bucket.creative.0").withColor(0x888888));
        }
    }

    public Component getName(ItemStack stack) {
        SingleStackContainer ssc = (SingleStackContainer)ModDataComponents.get(stack, ModDataComponents.BUCKETED_FISH);
        if (ssc == null) {
            return super.getName(stack);
        }
        return Component.translatable((String)"tooltip.starcatcher.starcaught_bucket.before").append(ssc.stack().getItem().getName(stack)).append((Component)Component.translatable((String)"tooltip.starcatcher.starcaught_bucket.after"));
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return Optional.of(new BucketTooltip(StarcaughtBucket.getFish(stack)));
    }

    public record BucketTooltip(ItemStack fish) implements TooltipComponent
    {
    }
}

