/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.items;

import com.wdiscute.starcatcher.Config;
import com.wdiscute.starcatcher.guide.SettingsScreen;
import com.wdiscute.starcatcher.io.ModDataComponents;
import com.wdiscute.starcatcher.io.SizeAndWeightInstance;
import com.wdiscute.starcatcher.items.StarcaughtBucket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;

public class BucketTooltipRenderer
implements ClientTooltipComponent {
    public StarcaughtBucket.BucketTooltip tooltip;
    public String text = "";

    public BucketTooltipRenderer(StarcaughtBucket.BucketTooltip tooltip) {
        this.tooltip = tooltip;
        if (ModDataComponents.has(tooltip.fish(), ModDataComponents.SIZE_AND_WEIGHT)) {
            SizeAndWeightInstance sw = (SizeAndWeightInstance)ModDataComponents.get(tooltip.fish(), ModDataComponents.SIZE_AND_WEIGHT);
            SettingsScreen.Units units = (SettingsScreen.Units)((Object)Config.UNIT.get());
            String size = units.getSizeAsString(sw.sizeInCentimeters());
            String weight = units.getWeightAsString(sw.weightInGrams());
            this.text = size + " - " + weight;
        }
    }

    public int getHeight() {
        return this.isEmpty() ? 0 : 18;
    }

    public int getWidth(Font font) {
        if (this.isEmpty()) {
            return 0;
        }
        int ret = 16 + Math.round((float)this.text.length() * 5.8f);
        return this.hasProperties() ? ret : 16;
    }

    public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
        if (!this.isEmpty()) {
            guiGraphics.renderItem(this.tooltip.fish(), x, y);
            if (this.hasProperties()) {
                guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)this.text), x + 20, y + 4, 0x888888, true);
            }
        }
    }

    public boolean isEmpty() {
        return this.tooltip.fish().isEmpty();
    }

    public boolean hasProperties() {
        if (this.isEmpty()) {
            return false;
        }
        return ModDataComponents.has(this.tooltip.fish(), ModDataComponents.SIZE_AND_WEIGHT);
    }
}

