/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.io.network;

import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.io.FishCaughtCounter;
import com.wdiscute.starcatcher.io.attachments.FishingGuideAttachment;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record FPsSeenPayload(List<ResourceLocation> locs) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<FPsSeenPayload> TYPE = new CustomPacketPayload.Type(Starcatcher.rl("fps_seen"));
    public static final StreamCodec<ByteBuf, FPsSeenPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC.apply(ByteBufCodecs.list()), FPsSeenPayload::locs, FPsSeenPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            HashMap<ResourceLocation, FishCaughtCounter> map = new HashMap<ResourceLocation, FishCaughtCounter>(FishingGuideAttachment.getFishesCaught(context.player()));
            this.locs.forEach(loc -> {
                FishCaughtCounter fishCaughtCounter = (FishCaughtCounter)map.get(loc);
                if (fishCaughtCounter != null) {
                    map.replace((ResourceLocation)loc, fishCaughtCounter.removeNotification());
                }
            });
            FishingGuideAttachment.setFishesCaught(context.player(), map);
        });
    }
}

