/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.io.attachments;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.wdiscute.starcatcher.io.FishCaughtCounter;
import com.wdiscute.starcatcher.io.ModDataAttachments;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class FishingGuideAttachment {
    public Map<ResourceLocation, FishCaughtCounter> fishesCaught;
    public Map<ResourceLocation, Integer> trophiesCaught;
    public boolean receivedGuide;
    public static final Codec<FishingGuideAttachment> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, FishCaughtCounter.CODEC).fieldOf("fishes_caught").forGetter(data -> data.fishesCaught), (App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, (Codec)Codec.INT).fieldOf("trophies_caught").forGetter(data -> data.trophiesCaught), (App)Codec.BOOL.lenientOptionalFieldOf("received_guide", (Object)false).forGetter(data -> data.receivedGuide)).apply((Applicative)instance, FishingGuideAttachment::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, FishingGuideAttachment> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ResourceLocation.STREAM_CODEC, FishCaughtCounter.STREAM_CODEC), data -> data.fishesCaught, (StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ResourceLocation.STREAM_CODEC, (StreamCodec)ByteBufCodecs.INT), data -> data.trophiesCaught, (StreamCodec)ByteBufCodecs.BOOL, data -> data.receivedGuide, FishingGuideAttachment::new);

    public FishingGuideAttachment(Map<ResourceLocation, FishCaughtCounter> fishesCaught, Map<ResourceLocation, Integer> trophiesCaught, boolean receivedGuide) {
        this.fishesCaught = new HashMap<ResourceLocation, FishCaughtCounter>(fishesCaught);
        this.trophiesCaught = new HashMap<ResourceLocation, Integer>(trophiesCaught);
        this.receivedGuide = receivedGuide;
    }

    public static FishingGuideAttachment createDefault() {
        return new FishingGuideAttachment(new HashMap<ResourceLocation, FishCaughtCounter>(), new HashMap<ResourceLocation, Integer>(), false);
    }

    public static Map<ResourceLocation, Integer> getTrophiesCaught(Player player) {
        return FishingGuideAttachment.get((Entity)player).trophiesCaught;
    }

    public static void setTrophiesCaught(Player player, Map<ResourceLocation, Integer> trophiesCaught) {
        FishingGuideAttachment.get((Entity)player).trophiesCaught = trophiesCaught;
        FishingGuideAttachment.sync(player);
    }

    public static Map<ResourceLocation, FishCaughtCounter> getFishesCaught(Player player) {
        return FishingGuideAttachment.get((Entity)player).fishesCaught;
    }

    public static void setFishesCaught(Player player, Map<ResourceLocation, FishCaughtCounter> fishesCaught) {
        FishingGuideAttachment.get((Entity)player).fishesCaught = fishesCaught;
        FishingGuideAttachment.sync(player);
    }

    public static boolean getReceivedGuide(Player player) {
        return FishingGuideAttachment.get((Entity)player).receivedGuide;
    }

    public static void setReceivedGuide(Player player, boolean receivedGuide) {
        FishingGuideAttachment.get((Entity)player).receivedGuide = receivedGuide;
        FishingGuideAttachment.sync(player);
    }

    public static FishingGuideAttachment get(Entity holder) {
        return (FishingGuideAttachment)holder.getData(ModDataAttachments.FISHING_GUIDE);
    }

    public static void sync(Player player) {
        player.syncData(ModDataAttachments.FISHING_GUIDE);
    }

    public static boolean hasLegacyData(Player player) {
        return (Boolean)ModDataAttachments.get((Entity)player, ModDataAttachments.RECEIVED_GUIDE) != false || FishingGuideAttachment.getFishesCaught(player).size() > 1;
    }

    public void loadFromLegacy(Player player) {
        ((List)ModDataAttachments.get((Entity)player, ModDataAttachments.FISHES_CAUGHT)).forEach(legacy -> this.fishesCaught.putIfAbsent(legacy.fp(), legacy.covert()));
        ((List)ModDataAttachments.get((Entity)player, ModDataAttachments.TROPHIES_CAUGHT)).forEach(loc -> this.trophiesCaught.putIfAbsent((ResourceLocation)loc, 0));
        this.receivedGuide = (Boolean)ModDataAttachments.get((Entity)player, ModDataAttachments.RECEIVED_GUIDE) != false || this.receivedGuide;
        ModDataAttachments.remove((Entity)player, ModDataAttachments.FISHES_CAUGHT);
        ModDataAttachments.remove((Entity)player, ModDataAttachments.FISHES_NOTIFICATION);
        ModDataAttachments.remove((Entity)player, ModDataAttachments.TROPHIES_CAUGHT);
        ModDataAttachments.remove((Entity)player, ModDataAttachments.RECEIVED_GUIDE);
        FishingGuideAttachment.sync(player);
    }
}

