/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.io;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.tournament.Tournament;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import org.slf4j.Logger;

public class TournamentSavedData
extends SavedData {
    public static final Codec<List<Tournament>> CODEC = Tournament.CODEC.listOf();
    public static final String NAME = "tournaments";
    private List<Tournament> tournaments = new ArrayList<Tournament>();

    public TournamentSavedData(List<Tournament> tournaments) {
        this.tournaments = tournaments;
    }

    public TournamentSavedData() {
    }

    public static TournamentSavedData get(ServerLevel level) {
        return (TournamentSavedData)level.getDataStorage().computeIfAbsent(TournamentSavedData.factory(), NAME);
    }

    public List<Tournament> getTournaments() {
        return this.tournaments;
    }

    public void setTournaments(List<Tournament> tournaments) {
        this.tournaments = tournaments;
        this.setDirty();
    }

    public static SavedData.Factory<TournamentSavedData> factory() {
        return new SavedData.Factory(TournamentSavedData::new, TournamentSavedData::load);
    }

    public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider registries) {
        CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.tournaments).resultOrPartial(arg_0 -> ((Logger)Starcatcher.LOGGER).error(arg_0)).ifPresent(tag -> compoundTag.put(NAME, tag));
        return compoundTag;
    }

    public static TournamentSavedData load(CompoundTag compoundTag, HolderLookup.Provider registries) {
        Tag tag = compoundTag.get(NAME);
        List tournamentsNew = CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag).resultOrPartial(arg_0 -> ((Logger)Starcatcher.LOGGER).error(arg_0)).map(Pair::getFirst).orElseGet(ArrayList::new);
        return new TournamentSavedData(tournamentsNew);
    }
}

