/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.io;

import com.mojang.serialization.Codec;
import com.wdiscute.starcatcher.io.SingleStackContainer;
import com.wdiscute.starcatcher.io.SizeAndWeightInstance;
import com.wdiscute.starcatcher.secretnotes.SecretNote;
import com.wdiscute.starcatcher.storage.FishProperties;
import com.wdiscute.starcatcher.storage.TrophyProperties;
import java.util.List;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModDataComponents {
    public static final DeferredRegister<DataComponentType<?>> DATA_COMPONENT_TYPES = DeferredRegister.createDataComponents((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"starcatcher");
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<SingleStackContainer>> BUCKETED_FISH = ModDataComponents.register("bucketed_fish", builder -> builder.persistent(SingleStackContainer.CODEC));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<SingleStackContainer>> BOBBER = ModDataComponents.register("bobber", builder -> builder.persistent(SingleStackContainer.CODEC));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<SingleStackContainer>> BAIT = ModDataComponents.register("bait", builder -> builder.persistent(SingleStackContainer.CODEC));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<SingleStackContainer>> HOOK = ModDataComponents.register("hook", builder -> builder.persistent(SingleStackContainer.CODEC));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<TrophyProperties>> TROPHY = ModDataComponents.register("trophy", builder -> builder.persistent(TrophyProperties.CODEC));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<FishProperties>> FISH_PROPERTIES = ModDataComponents.register("fish_properties", builder -> builder.persistent(FishProperties.CODEC));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<SecretNote.Note>> SECRET_NOTE = ModDataComponents.register("secret_note", builder -> builder.persistent(SecretNote.Note.CODEC));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<SizeAndWeightInstance>> SIZE_AND_WEIGHT = ModDataComponents.register("size_and_weight", builder -> builder.persistent(SizeAndWeightInstance.CODEC));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<List<ResourceLocation>>> MINIGAME_MODIFIERS = ModDataComponents.register("minigame_modifiers", builder -> builder.persistent(ResourceLocation.CODEC.listOf()));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<List<ResourceLocation>>> CATCH_MODIFIERS = ModDataComponents.register("catch_modifiers", builder -> builder.persistent(ResourceLocation.CODEC.listOf()));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<ResourceLocation>> TACKLE_SKIN = ModDataComponents.register("tackle_skin", builder -> builder.persistent(ResourceLocation.CODEC));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> NETHERITE_UPGRADE = ModDataComponents.register("netherite_upgraded", builder -> builder.persistent((Codec)Codec.BOOL));

    public static <T> void set(ItemStack stack, Supplier<DataComponentType<T>> component, T data) {
        stack.set(component, data);
    }

    @Nullable
    public static <T> T get(ItemStack stack, Supplier<DataComponentType<T>> component) {
        return (T)stack.get(component);
    }

    public static <T> boolean has(ItemStack stack, Supplier<DataComponentType<T>> component) {
        return stack.has(component);
    }

    public static <T> void remove(ItemStack stack, Supplier<DataComponentType<T>> component) {
        stack.remove(component);
    }

    @Nonnull
    public static <T> T getOrDefault(ItemStack stack, Supplier<DataComponentType<T>> component, T defaultValue) {
        return (T)stack.getOrDefault(component, defaultValue);
    }

    private static <T> DeferredHolder<DataComponentType<?>, DataComponentType<T>> register(String name, UnaryOperator<DataComponentType.Builder<T>> builderOperator) {
        return DATA_COMPONENT_TYPES.register(name, () -> ((DataComponentType.Builder)builderOperator.apply(DataComponentType.builder())).build());
    }

    public static void register(IEventBus eventBus) {
        DATA_COMPONENT_TYPES.register(eventBus);
    }
}

