/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.io;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.wdiscute.starcatcher.Config;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.U;
import com.wdiscute.starcatcher.compat.FTBTeamsCompat;
import com.wdiscute.starcatcher.io.ExtraComposites;
import com.wdiscute.starcatcher.io.attachments.FishingGuideAttachment;
import com.wdiscute.starcatcher.io.network.FishCaughtPayload;
import com.wdiscute.starcatcher.storage.FishProperties;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.network.PacketDistributor;

public record FishCaughtCounter(int count, int fastestTicks, float averageTicks, int size, int weight, boolean caughtGolden, boolean perfectCatch, boolean hasGuideNotification) {
    public static final Codec<FishCaughtCounter> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("count", (Object)0).forGetter(FishCaughtCounter::count), (App)Codec.INT.optionalFieldOf("fastest_ticks", (Object)0).forGetter(FishCaughtCounter::fastestTicks), (App)Codec.FLOAT.optionalFieldOf("average_ticks", (Object)Float.valueOf(0.0f)).forGetter(FishCaughtCounter::averageTicks), (App)Codec.INT.optionalFieldOf("best_size", (Object)0).forGetter(FishCaughtCounter::size), (App)Codec.INT.optionalFieldOf("best_weight", (Object)0).forGetter(FishCaughtCounter::weight), (App)Codec.BOOL.optionalFieldOf("caught_golden", (Object)false).forGetter(FishCaughtCounter::caughtGolden), (App)Codec.BOOL.optionalFieldOf("perfect_catch", (Object)false).forGetter(FishCaughtCounter::perfectCatch), (App)Codec.BOOL.optionalFieldOf("has_guide_notification", (Object)false).forGetter(FishCaughtCounter::hasGuideNotification)).apply((Applicative)instance, FishCaughtCounter::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, FishCaughtCounter> STREAM_CODEC = ExtraComposites.composite(ByteBufCodecs.VAR_INT, FishCaughtCounter::count, ByteBufCodecs.VAR_INT, FishCaughtCounter::fastestTicks, ByteBufCodecs.FLOAT, FishCaughtCounter::averageTicks, ByteBufCodecs.INT, FishCaughtCounter::size, ByteBufCodecs.INT, FishCaughtCounter::weight, ByteBufCodecs.BOOL, FishCaughtCounter::caughtGolden, ByteBufCodecs.BOOL, FishCaughtCounter::perfectCatch, ByteBufCodecs.BOOL, FishCaughtCounter::hasGuideNotification, FishCaughtCounter::new);

    public static FishCaughtCounter get(Player player, FishProperties loc) {
        return FishCaughtCounter.get(player, U.getRlFromFp(player.level(), loc));
    }

    public static FishCaughtCounter get(Player player, ResourceLocation loc) {
        return FishingGuideAttachment.getFishesCaught(player).get(loc);
    }

    public static FishCaughtCounter createHacked() {
        return new FishCaughtCounter(999999, 0, 0.0f, 0, 0, false, false, true);
    }

    public FishCaughtCounter removeNotification() {
        return new FishCaughtCounter(this.count, this.fastestTicks, this.averageTicks, this.size, this.weight, this.caughtGolden, this.perfectCatch, false);
    }

    @Nonnull
    public static FishCaughtCounter create(int ticks, int size, int weight, boolean perfectCatch) {
        return new FishCaughtCounter(1, ticks, ticks, size, weight, false, perfectCatch, true);
    }

    public FishCaughtCounter getUpdated(int ticks, int size, int weight, boolean perfectCatch) {
        boolean perfect;
        int fastestToSave = Math.min(this.fastestTicks, ticks);
        float averageToSave = (this.averageTicks * (float)this.count + (float)ticks) / (float)(this.count + 1);
        int countToSave = this.count;
        boolean bl = perfect = perfectCatch || this.perfectCatch;
        if (this.fastestTicks == 0) {
            fastestToSave = ticks;
        }
        if (this.averageTicks == 0.0f) {
            averageToSave = ticks;
        }
        if (this.count == 999999) {
            countToSave = 0;
        }
        int sizeToSave = Math.max(size, this.size);
        int weightToSave = Math.max(weight, this.weight);
        return new FishCaughtCounter(countToSave + 1, fastestToSave, averageToSave, sizeToSave, weightToSave, this.caughtGolden, perfect, true);
    }

    public static void awardFishCaughtCounter(FishProperties fpCaught, Player player, int ticks, int size, int weight, boolean perfectCatch, boolean awardToTeam) {
        ResourceLocation loc;
        if (ModList.get().isLoaded("ftbteams") && awardToTeam && ((Boolean)Config.ENABLE_FTB_TEAM_SHARING.get()).booleanValue()) {
            FTBTeamsCompat.awardToTeam(player, fpCaught);
            return;
        }
        Map<ResourceLocation, FishCaughtCounter> fishesCaught = FishingGuideAttachment.getFishesCaught(player);
        FishCaughtCounter fishCaughtCounter = fishesCaught.get(loc = player.level().registryAccess().registryOrThrow(Starcatcher.FISH_REGISTRY).getKey((Object)fpCaught));
        boolean newFish = fishCaughtCounter == null;
        fishCaughtCounter = newFish ? FishCaughtCounter.create(ticks, size, weight, perfectCatch) : fishCaughtCounter.getUpdated(ticks, size, weight, perfectCatch);
        fishesCaught.put(loc, fishCaughtCounter);
        if (!fpCaught.catchInfo().alwaysSpawnEntity()) {
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new FishCaughtPayload(fpCaught, newFish, size, weight), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        FishingGuideAttachment.setFishesCaught(player, fishesCaught);
    }
}

