/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.guide;

import com.wdiscute.starcatcher.Config;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.guide.SettingsScreen;
import com.wdiscute.starcatcher.minigame.FishingMinigameScreen;
import com.wdiscute.starcatcher.registry.custom.minigamemodifiers.AbstractMinigameModifier;
import com.wdiscute.starcatcher.storage.FishProperties;
import java.util.function.Supplier;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewSettingsScreen
extends FishingMinigameScreen {
    public static final ResourceLocation TEXTURE = Starcatcher.rl("textures/gui/minigame/minigame.png");
    public static final ResourceLocation TANK = Starcatcher.rl("textures/gui/minigame/surface.png");
    public static final ResourceLocation SETTINGS = Starcatcher.rl("textures/gui/minigame/settings.png");
    public static final ResourceLocation GUI_SCALE = Starcatcher.rl("textures/gui/minigame/gui_scale.png");
    boolean changeRotation;
    boolean moveMarkers = false;
    boolean isHoveringWidgets = false;
    SettingsScreen.Units unitSelected;

    public NewSettingsScreen(FishProperties fp, ItemStack rod) {
        super(fp, rod);
    }

    protected void init() {
        super.init();
        this.hitDelay = ((Double)Config.HIT_DELAY.get()).floatValue();
        this.unitSelected = (SettingsScreen.Units)((Object)Config.UNIT.get());
        this.addRenderableWidget((GuiEventListener)new LeftRightButtonWidget(this, () -> Float.valueOf(this.renderScale), () -> this.renderScale -= 0.1f, () -> this.renderScale += 0.1f, (Comparable)Float.valueOf(0.2f), (Comparable)Float.valueOf(5.9f), Component.literal((String)"Scale"), this.width / 2 + 100, this.height / 2 - 90, 91, 19, 160, 69, 256, 256, SETTINGS, 13));
        this.addRenderableWidget((GuiEventListener)new LeftRightButtonWidget(this, () -> Float.valueOf(this.hitDelay), () -> this.hitDelay -= 0.2f, () -> this.hitDelay += 0.2f, (Comparable)Float.valueOf(-5.0f), (Comparable)Float.valueOf(5.0f), Component.literal((String)"Hit Delay"), this.width / 2 + 100, this.height / 2 - 40, 91, 19, 160, 69, 256, 256, SETTINGS, 13));
        this.addRenderableWidget((GuiEventListener)new LeftRightButtonWidget(this, () -> Float.valueOf(this.pointerSpeed), () -> this.pointerSpeed -= 0.1f, () -> this.pointerSpeed += 0.1f, null, null, Component.literal((String)"Speed"), this.width / 2 + 100, this.height / 2 + 10, 91, 19, 160, 69, 256, 256, SETTINGS, 13));
        this.addRenderableWidget((GuiEventListener)new LeftRightButtonWidget(this, () -> this.unitSelected, () -> {
            this.unitSelected = this.unitSelected.previous();
        }, () -> {
            this.unitSelected = this.unitSelected.next();
        }, null, null, Component.literal((String)"Units"), this.width / 2, this.height / 2 + 80, 136, 25, 34, 222, 256, 256, SETTINGS, 16));
    }

    public Options getOptions() {
        return this.getMinecraft().options;
    }

    @NotNull
    private OptionInstance<Integer> guiScale() {
        return this.getOptions().guiScale();
    }

    @Override
    public boolean isSettingsScreen() {
        return true;
    }

    @Override
    public void inputPressed() {
        if (!this.isHoldingMouse || !this.children().stream().anyMatch(GuiEventListener::isFocused)) {
            super.inputPressed();
        }
        if (this.progress > 100.0f) {
            this.progress = 100.0f;
        }
        if (this.progress < 0.0f) {
            this.progress = 0.0f;
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.progress > 100.0f) {
            this.progress = 100.0f;
        }
        if (this.progress < 0.0f) {
            this.progress = 0.0f;
        }
    }

    @Override
    public void onClose() {
        Config.HIT_DELAY.set((Object)((double)Math.round(this.hitDelay * 10.0f) / 10.0));
        Config.HIT_DELAY.save();
        Config.MINIGAME_RENDER_SCALE.set((Object)this.renderScale);
        Config.MINIGAME_RENDER_SCALE.save();
        Config.UNIT.set((Object)this.unitSelected);
        Config.UNIT.save();
        this.modifiers.forEach(AbstractMinigameModifier::onRemove);
        this.minecraft.popGuiLayer();
    }

    public class LeftRightButtonWidget<T extends Comparable<T>>
    extends AbstractWidget {
        int uOffset;
        int vOffset;
        int textureWidth;
        int textureHeight;
        int buttonWidth;
        ResourceLocation texture;
        Supplier<T> value;
        @Nullable
        T rightLimit;
        @Nullable
        T leftLimit;
        Runnable rightAction;
        Runnable leftAction;
        Component name;
        final /* synthetic */ NewSettingsScreen this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public LeftRightButtonWidget(Supplier<T> value, Runnable leftAction, @Nullable Runnable rightAction, @Nullable T leftLimit, T rightLimit, MutableComponent name, int x, int y, int width, int height, int uOffset, int vOffset, int textureWidth, int textureHeight, ResourceLocation texture, int buttonWidth) {
            this.this$0 = (NewSettingsScreen)this$0;
            super(x - (width >> 1), y - (height >> 1), width, height, (Component)Component.empty());
            this.uOffset = uOffset;
            this.vOffset = vOffset;
            this.texture = texture;
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
            this.buttonWidth = buttonWidth;
            this.rightAction = rightAction;
            this.leftAction = leftAction;
            this.rightLimit = rightLimit;
            this.leftLimit = leftLimit;
            this.value = value;
            this.name = name;
        }

        protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            Object o = this.value.get();
            if (o instanceof Float) {
                Float number = (Float)o;
                number = Float.valueOf((float)Math.round(number.floatValue() * 10.0f) / 10.0f);
                o = number;
            }
            MutableComponent component = Component.empty().append(this.name).append(": ").append(String.valueOf(o));
            guiGraphics.drawCenteredString(this.this$0.getMinecraft().font, (Component)component, this.getX() + this.getWidth() / 2, this.getY() + this.getHeight() / 4, 0);
            guiGraphics.blit(this.texture, this.getX(), this.getY(), this.getWidth(), this.getHeight(), (float)this.uOffset, (float)this.vOffset, this.getWidth(), this.getHeight(), this.textureWidth, this.textureHeight);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (!(mouseX > (double)this.getX() && mouseX < (double)this.getRight() && mouseY > (double)this.getY() && mouseY < (double)this.getBottom())) {
                return super.mouseClicked(mouseX, mouseY, button);
            }
            if (mouseX < (double)(this.getX() + this.buttonWidth)) {
                if (this.leftLimit != null && ((Comparable)this.value.get()).compareTo(this.leftLimit) <= 0) {
                    return false;
                }
                this.leftAction.run();
            }
            if (mouseX > (double)(this.getRight() - this.buttonWidth)) {
                if (this.rightLimit != null && ((Comparable)this.value.get()).compareTo(this.rightLimit) >= 0) {
                    return false;
                }
                this.rightAction.run();
            }
            return true;
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }
    }

    public class GuiScaleWidget
    extends AbstractWidget {
        public GuiScaleWidget(int x, int y, int width, int height) {
            super(x, y, width, height, (Component)Component.empty());
            if (FishingMinigameScreen.hasDistantHorizons()) {
                this.setTooltip(Tooltip.create((Component)Component.literal((String)"GUI Scale is not supported while Distant Horizons is installed. It causes a massive frame drop upon starting and ending the minigame.")));
            } else {
                this.setTooltip(Tooltip.create((Component)Component.literal((String)"Change the GUI Scale of the minigame.")));
            }
        }

        protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            guiGraphics.blit(GUI_SCALE, this.getX(), this.getY(), this.getWidth(), this.getHeight(), 0.0f, 0.0f, this.getWidth(), this.getHeight(), this.getWidth(), this.getHeight());
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (!(mouseX > (double)this.getX() && mouseX < (double)this.getRight() && mouseY > (double)this.getY() && mouseY < (double)this.getBottom())) {
                return super.mouseClicked(mouseX, mouseY, button);
            }
            int current = (Integer)NewSettingsScreen.this.guiScale().get();
            if (mouseX < (double)((float)this.getX() + (float)this.getWidth() / 2.0f)) {
                if (current > 1) {
                    NewSettingsScreen.this.guiScale().set((Object)(current - 1));
                }
            } else {
                NewSettingsScreen.this.guiScale().set((Object)(current + 1));
            }
            return true;
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }
    }
}

