/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.guide;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.wdiscute.libtooltips.Tooltips;
import com.wdiscute.starcatcher.Config;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.StarcatcherTags;
import com.wdiscute.starcatcher.U;
import com.wdiscute.starcatcher.compat.EclipticSeasonsCompat;
import com.wdiscute.starcatcher.compat.SereneSeasonsCompat;
import com.wdiscute.starcatcher.compat.TerraFirmaCraftSeasonsCompat;
import com.wdiscute.starcatcher.guide.NewSettingsScreen;
import com.wdiscute.starcatcher.guide.SettingsScreen;
import com.wdiscute.starcatcher.io.FishCaughtCounter;
import com.wdiscute.starcatcher.io.ModDataComponents;
import com.wdiscute.starcatcher.io.attachments.FishingGuideAttachment;
import com.wdiscute.starcatcher.io.network.FPsSeenPayload;
import com.wdiscute.starcatcher.registry.ModItems;
import com.wdiscute.starcatcher.registry.blocks.ModBlocks;
import com.wdiscute.starcatcher.secretnotes.NoteContainer;
import com.wdiscute.starcatcher.secretnotes.SecretNoteScreen;
import com.wdiscute.starcatcher.storage.FishProperties;
import com.wdiscute.starcatcher.storage.TrophyProperties;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SequencedCollection;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.network.PacketDistributor;

public class FishingGuideScreen
extends Screen {
    private static final ResourceLocation BACKGROUND_INDEX_FIRST = Starcatcher.rl("textures/gui/guide/background_index_first.png");
    private static final ResourceLocation BACKGROUND_INDEX_SECOND = Starcatcher.rl("textures/gui/guide/background_index_second.png");
    private static final ResourceLocation BACKGROUND_ENTRY = Starcatcher.rl("textures/gui/guide/background_entry.png");
    private static final ResourceLocation BACKGROUND_BASICS = Starcatcher.rl("textures/gui/guide/background_basics.png");
    private static final ResourceLocation HIGHLIGHT_LEFT = Starcatcher.rl("textures/gui/guide/highlight_page_left.png");
    private static final ResourceLocation HIGHLIGHT_RIGHT = Starcatcher.rl("textures/gui/guide/highlight_page_right.png");
    private static final ResourceLocation FISHES_IN_AREA_TOP_RIGHT_DECORATION = Starcatcher.rl("textures/gui/guide/fishes_in_area_top_right_decoration.png");
    private static final ResourceLocation FISHES_IN_AREA_BOTTOM_LEFT_DECORATION = Starcatcher.rl("textures/gui/guide/fishes_in_area_bottom_left_decoration.png");
    private static final ResourceLocation FISHES_IN_AREA_BOTTOM_DECORATION = Starcatcher.rl("textures/gui/guide/fishes_in_area_bottom_decoration.png");
    private static final ResourceLocation FISHES_IN_AREA_FISH_DECORATION = Starcatcher.rl("textures/gui/guide/fishes_in_area_fish_decoration.png");
    private static final ResourceLocation HELP_PAGE_BASICS = Starcatcher.rl("textures/gui/guide/help_basics.png");
    private static final ResourceLocation HELP_PAGE_SWEETSPOTS = Starcatcher.rl("textures/gui/guide/help_sweetspots.png");
    private static final ResourceLocation HELP_PAGE_TREASURE = Starcatcher.rl("textures/gui/guide/help_treasure.png");
    private static final ResourceLocation HELP_PAGE_LAVA_FISHING = Starcatcher.rl("textures/gui/guide/help_lava_fishing.png");
    private static final ResourceLocation HELP_PAGE_HOOKS_BOBBERS_BAITS = Starcatcher.rl("textures/gui/guide/help_hooks_bobbers_baits.png");
    private static final ResourceLocation HELP_PAGE_GADGETS_COSMETICS = Starcatcher.rl("textures/gui/guide/help_gadgets_cosmetics.png");
    private static final ResourceLocation HELP_PAGE_TEMPLATES_EQUIPMENT = Starcatcher.rl("textures/gui/guide/help_templates_equipment.png");
    private static final ResourceLocation HELP_PAGE_TROPHIES = Starcatcher.rl("textures/gui/guide/help_trophies.png");
    private static final ResourceLocation HELP_PAGE_TOURNAMENTS = Starcatcher.rl("textures/gui/guide/help_tournaments.png");
    private static final ResourceLocation ARROW_PREVIOUS = Starcatcher.rl("textures/gui/guide/arrow_previous.png");
    private static final ResourceLocation ARROW_PREVIOUS_PRESSED = Starcatcher.rl("textures/gui/guide/arrow_previous_pressed.png");
    private static final ResourceLocation ARROW_PREVIOUS_HIGHLIGHT = Starcatcher.rl("textures/gui/guide/arrow_previous_highlight.png");
    private static final ResourceLocation ARROW_NEXT = Starcatcher.rl("textures/gui/guide/arrow_next.png");
    private static final ResourceLocation ARROW_NEXT_PRESSED = Starcatcher.rl("textures/gui/guide/arrow_next_pressed.png");
    private static final ResourceLocation ARROW_NEXT_HIGHLIGHT = Starcatcher.rl("textures/gui/guide/arrow_next_highlight.png");
    private static final ResourceLocation ARROW_INDEX = Starcatcher.rl("textures/gui/guide/arrow_index.png");
    private static final ResourceLocation ARROW_INDEX_PRESSED = Starcatcher.rl("textures/gui/guide/arrow_index_pressed.png");
    private static final ResourceLocation ARROW_INDEX_HIGHLIGHT = Starcatcher.rl("textures/gui/guide/arrow_index_highlight.png");
    private static final ResourceLocation NEW_FISH = Starcatcher.rl("textures/gui/guide/new_fish.png");
    private static final ResourceLocation STAR = Starcatcher.rl("textures/gui/guide/star.png");
    private static final ResourceLocation GLOW = Starcatcher.rl("textures/gui/guide/glow.png");
    private static final ResourceLocation SEASONS = Starcatcher.rl("textures/gui/guide/seasons.png");
    private static final int MAX_HELP_PAGES = 8;
    private final List<ItemStack> hooksAndBobbers = new ArrayList<ItemStack>();
    private final List<ItemStack> baits = new ArrayList<ItemStack>();
    private final List<ItemStack> gadgets = new ArrayList<ItemStack>();
    private final List<ItemStack> templates = new ArrayList<ItemStack>();
    private final List<ItemStack> equipments = new ArrayList<ItemStack>();
    private final ItemStack basicsIndexIcon;
    private final ItemStack upgradeIndexIcon;
    private final ItemStack addonsIndexIcon;
    private final ItemStack cosmeticsIndexIcon;
    private final ItemStack tournamentIndexIcon;
    private final ItemStack trophiesIndexIcon;
    private final ItemStack settingsIndexIcon;
    private final ItemStack sweetspotsIcon;
    private final ItemStack treasureIcon;
    private final ItemStack equipmentIcon;
    private final ItemStack hookIcon;
    private final ItemStack baitIcon;
    private final ItemStack secretsIcon;
    private final ItemStack templateIcon;
    private List<Pair<ItemStack, String>> indexEntries;
    int uiX;
    int uiY;
    int imageWidth;
    int imageHeight;
    int clickedX;
    int clickedY;
    float highlightLeftAlpha = 0.0f;
    float highlightRightAlpha = 0.0f;
    boolean arrowPreviousPressed;
    boolean arrowNextPressed;
    boolean arrowIndexPressed;
    boolean hasNextPage = false;
    int lastIndexPage = 0;
    int menu = 0;
    int page = 0;
    ClientLevel level;
    LocalPlayer player;
    List<ResourceLocation> fpsSeen = new ArrayList<ResourceLocation>();
    List<FishProperties> entries = new ArrayList<FishProperties>(999);
    List<TrophyProperties> trophiesTps = new ArrayList<TrophyProperties>();
    List<TrophyProperties> secretsTps = new ArrayList<TrophyProperties>();
    List<FishProperties> fishInArea = new ArrayList<FishProperties>();
    Map<ResourceLocation, FishCaughtCounter> fishCaughtCounterMap = new HashMap<ResourceLocation, FishCaughtCounter>();
    TrophyProperties.RarityProgress all = TrophyProperties.RarityProgress.DEFAULT;
    private final Map<FishProperties.Rarity, TrophyProperties.RarityProgress> progressMap = new EnumMap<FishProperties.Rarity, TrophyProperties.RarityProgress>(Map.of(FishProperties.Rarity.COMMON, new TrophyProperties.RarityProgress(0, -1), FishProperties.Rarity.UNCOMMON, TrophyProperties.RarityProgress.DEFAULT, FishProperties.Rarity.RARE, TrophyProperties.RarityProgress.DEFAULT, FishProperties.Rarity.EPIC, TrophyProperties.RarityProgress.DEFAULT, FishProperties.Rarity.LEGENDARY, TrophyProperties.RarityProgress.DEFAULT));

    protected void init() {
        super.init();
        this.entries = new ArrayList<FishProperties>();
        this.trophiesTps = new ArrayList<TrophyProperties>();
        this.secretsTps = new ArrayList<TrophyProperties>();
        this.imageWidth = 420;
        this.imageHeight = 260;
        this.uiX = (this.width - this.imageWidth) / 2;
        this.uiY = (this.height - this.imageHeight) / 2;
        this.level = Minecraft.getInstance().level;
        this.player = Minecraft.getInstance().player;
        this.fishInArea = FishProperties.getFpsWithGuideEntryForArea((Entity)this.player);
        this.fishCaughtCounterMap = FishingGuideAttachment.getFishesCaught((Player)this.player);
        for (FishProperties fp : FishProperties.getFPs((Level)this.level)) {
            if (!fp.hasGuideEntry()) continue;
            this.entries.add(fp);
        }
        this.entries = FishingGuideScreen.sortEntries((Sort)((Object)Config.SORT.get()), this.entries, (Player)this.player);
        this.fishInArea = FishingGuideScreen.sortEntries((Sort)((Object)Config.SORT.get()), this.fishInArea, (Player)this.player);
        for (TrophyProperties tp : this.level.registryAccess().registryOrThrow(Starcatcher.TROPHY_REGISTRY)) {
            if (tp.trophyType() != TrophyProperties.TrophyType.TROPHY) continue;
            this.trophiesTps.add(tp);
        }
        for (TrophyProperties tp : this.level.registryAccess().registryOrThrow(Starcatcher.TROPHY_REGISTRY)) {
            if (tp.trophyType() != TrophyProperties.TrophyType.SECRET || !FishingGuideAttachment.getTrophiesCaught((Player)this.player).containsKey(this.level.registryAccess().registryOrThrow(Starcatcher.TROPHY_REGISTRY).getKey((Object)tp))) continue;
            this.secretsTps.add(tp);
        }
        this.all = TrophyProperties.RarityProgress.fromAttachment((Player)this.player);
        this.fishCaughtCounterMap.forEach((loc, counter) -> {
            this.all = new TrophyProperties.RarityProgress(this.all.total() + counter.count(), this.all.unique());
            this.progressMap.computeIfPresent(U.getFpFromRl((Level)this.level, loc).rarity(), (r, p) -> new TrophyProperties.RarityProgress(p.total() + counter.count(), p.unique() + 1));
        });
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key key = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (this.minecraft.options.keyInventory.isActiveAndMatches(key)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        double x = mouseX - (double)this.uiX;
        double y = mouseY - (double)this.uiY;
        this.arrowIndexPressed = false;
        this.arrowNextPressed = false;
        this.arrowPreviousPressed = false;
        if (x > 49.0 && x < 69.0 && y > 203.0 && y < 217.0) {
            switch (this.menu) {
                case 0: {
                    if (this.page == 0) break;
                    this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
                    --this.page;
                    return true;
                }
                case 1: {
                    this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
                    if (this.page == 0) {
                        this.menu = 0;
                        this.page = this.lastIndexPage;
                        return true;
                    }
                    --this.page;
                    return true;
                }
                case 2: {
                    this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
                    if (this.page == 0) {
                        this.menu = 1;
                        this.page = 8;
                        return true;
                    }
                    --this.page;
                    return true;
                }
            }
        }
        if (x > 336.0 && x < 356.0 && y > 202.0 && y < 216.0) {
            switch (this.menu) {
                case 0: {
                    this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
                    if (this.hasNextPage) {
                        ++this.page;
                        return true;
                    }
                    this.menu = 1;
                    this.page = 0;
                    return true;
                }
                case 1: {
                    this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
                    if (this.page != 8) {
                        this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
                        ++this.page;
                        return true;
                    }
                    this.menu = 2;
                    this.page = 0;
                    return true;
                }
                case 2: {
                    if (this.entries.size() > this.page * 2 + 2) {
                        this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
                        ++this.page;
                        return true;
                    }
                    return true;
                }
            }
        }
        if (x > 174.0 && x < 196.0 && y > 202.0 && y < 216.0) {
            this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
            this.menu = 0;
            this.page = 0;
            return true;
        }
        if (button == 0) {
            this.clickedX = (int)mouseX;
            this.clickedY = (int)mouseY;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        double x = mouseX - (double)this.uiX;
        double y = mouseY - (double)this.uiY;
        if (x > 51.0 && x < 116.0 && y > 67.0 && y < 76.0) {
            if (button == 0) {
                Config.SORT.set((Object)((Sort)((Object)Config.SORT.get())).next());
            }
            if (button == 1) {
                Config.SORT.set((Object)((Sort)((Object)Config.SORT.get())).previous());
            }
            Config.SORT.save();
            this.entries = FishingGuideScreen.sortEntries((Sort)((Object)Config.SORT.get()), this.entries, (Player)this.player);
            this.fishInArea = FishingGuideScreen.sortEntries((Sort)((Object)Config.SORT.get()), this.fishInArea, (Player)this.player);
        }
        if (x > 49.0 && x < 69.0 && y > 203.0 && y < 217.0 && (this.menu != 0 || this.page != 0)) {
            this.arrowPreviousPressed = true;
        }
        if (x > 336.0 && x < 356.0 && y > 202.0 && y < 216.0 && this.entries.size() > this.page * 2 + 2) {
            this.arrowNextPressed = true;
        }
        if (x > 174.0 && x < 196.0 && y > 202.0 && y < 216.0) {
            this.arrowIndexPressed = true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void tick() {
        super.tick();
        this.highlightLeftAlpha -= 0.025f;
        this.highlightRightAlpha -= 0.025f;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        switch (this.menu) {
            case -1: {
                Minecraft.getInstance().setScreen((Screen)new NewSettingsScreen(FishProperties.builder().withFish((Holder<Item>)ModItems.AURORA).build(), new ItemStack((ItemLike)ModItems.ROD.get())));
                return;
            }
            case 0: {
                if (this.page == 0) {
                    this.renderImage(guiGraphics, BACKGROUND_INDEX_FIRST);
                } else {
                    this.renderImage(guiGraphics, BACKGROUND_INDEX_SECOND);
                }
                this.renderIndex(guiGraphics, mouseX, mouseY);
                break;
            }
            case 1: {
                this.renderImage(guiGraphics, BACKGROUND_BASICS);
                this.renderTheBasics(guiGraphics, mouseX, mouseY);
                break;
            }
            case 2: {
                this.renderImage(guiGraphics, BACKGROUND_ENTRY);
                this.renderEntry(guiGraphics, mouseX, mouseY, 52, this.page * 2);
                this.renderEntry(guiGraphics, mouseX, mouseY, 212, this.page * 2 + 1);
            }
        }
        double x = mouseX - this.uiX;
        double y = mouseY - this.uiY;
        if (this.menu != 0 || this.page != 0) {
            if (x > 49.0 && x < 69.0 && y > 203.0 && y < 217.0) {
                this.renderImage(guiGraphics, ARROW_PREVIOUS_HIGHLIGHT);
            }
            this.renderImage(guiGraphics, this.arrowPreviousPressed ? ARROW_PREVIOUS_PRESSED : ARROW_PREVIOUS);
            if (x > 174.0 && x < 196.0 && y > 202.0 && y < 216.0) {
                this.renderImage(guiGraphics, ARROW_INDEX_HIGHLIGHT);
            }
            this.renderImage(guiGraphics, this.arrowIndexPressed ? ARROW_INDEX_PRESSED : ARROW_INDEX);
        }
        if (this.entries.size() > this.page * 2 + 2) {
            if (x > 336.0 && x < 356.0 && y > 202.0 && y < 216.0) {
                this.renderImage(guiGraphics, ARROW_NEXT_HIGHLIGHT);
            }
            this.renderImage(guiGraphics, this.arrowNextPressed ? ARROW_NEXT_PRESSED : ARROW_NEXT);
        }
        this.clickedX = 0;
        this.clickedY = 0;
    }

    private void renderHelpText(GuiGraphics guiGraphics, String pageName) {
        MutableComponent comp;
        int i;
        for (i = 0; i < 40 && I18n.exists((String)("gui.guide.page." + pageName + ".left." + i)); ++i) {
            comp = Tooltips.decodeTranslationKey((String)("gui.guide.page." + pageName + ".left." + i)).copy().withColor(6508608);
            guiGraphics.drawString(this.font, (Component)comp, this.uiX + 52, this.uiY + 10 * i + 13, -16777216, false);
        }
        for (i = 0; i < 40 && I18n.exists((String)("gui.guide.page." + pageName + ".right." + i)); ++i) {
            comp = Tooltips.decodeTranslationKey((String)("gui.guide.page." + pageName + ".right." + i)).copy().withColor(6508608);
            guiGraphics.drawString(this.font, (Component)comp, this.uiX + 213, this.uiY + 10 * i + 13, -16777216, false);
        }
    }

    private void renderSecrets(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        for (int i = 0; i < this.secretsTps.size(); ++i) {
            Item item;
            int rowSize = Math.min(6, this.secretsTps.size() - i / 6 * 6);
            int x = 70 - rowSize * 23 / 2;
            int xrender = x + i % 6 * 23;
            int y = i / 6 * 25;
            TrophyProperties tp = this.secretsTps.get(i);
            ItemStack is = new ItemStack(tp.fish());
            ModDataComponents.set(is, ModDataComponents.TROPHY, tp);
            guiGraphics.renderOutline((xrender += this.uiX + 223) - 10, (y += this.uiY + 110) - 2, 20, 20, -16777216);
            this.renderItem(is, xrender - 8, y, 1.0f);
            if (mouseX > xrender - 10 && mouseX < xrender + 10 && mouseY > y - 2 && mouseY < y + 18) {
                guiGraphics.renderTooltip(this.font, is, mouseX, mouseY);
            }
            if (this.clickedX <= xrender - 10 || this.clickedX >= xrender + 10 || this.clickedY <= y - 2 || this.clickedY >= y + 18 || !((item = is.getItem()) instanceof NoteContainer)) continue;
            NoteContainer nc = (NoteContainer)item;
            Minecraft.getInstance().setScreen((Screen)new SecretNoteScreen(nc.note));
        }
    }

    private void renderTrophies(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        for (int i = 0; i < this.trophiesTps.size(); ++i) {
            ItemStack is;
            boolean isMouseOnTop;
            int rowSize = Math.min(6, this.trophiesTps.size() - i / 6 * 6);
            int x = 60 - rowSize * 23 / 2;
            int xrender = x + i % 6 * 23;
            int y = i / 6 * 25;
            TrophyProperties tp = this.trophiesTps.get(i);
            boolean bl = isMouseOnTop = mouseX > (xrender += this.uiX + 73) - 10 && mouseX < xrender + 10 && mouseY > (y += this.uiY + 120) - 2 && mouseY < y + 18;
            if (FishingGuideAttachment.getTrophiesCaught((Player)this.player).containsKey(this.level.registryAccess().registryOrThrow(Starcatcher.TROPHY_REGISTRY).getKey((Object)tp))) {
                is = new ItemStack(tp.fish());
                ModDataComponents.set(is, ModDataComponents.TROPHY, tp);
                if (isMouseOnTop) {
                    guiGraphics.renderTooltip(this.font, is, mouseX, mouseY);
                }
            } else {
                if (isMouseOnTop) {
                    ArrayList<MutableComponent> list = new ArrayList<MutableComponent>(List.of(Component.literal((String)"Requirements:")));
                    if (tp.all().total() != 0) {
                        list.add(Component.empty().append(Tooltips.decodeTranslationKey((String)"gui.guide.trophy.all.total")).append("[" + this.all.total() + "/" + tp.all().total() + "]"));
                    }
                    if (tp.all().unique() != 0) {
                        list.add(Component.empty().append(Tooltips.decodeTranslationKey((String)"gui.guide.trophy.all.unique")).append("[" + this.all.unique() + "/" + tp.all().unique() + "]"));
                    }
                    for (FishProperties.Rarity value : FishProperties.Rarity.values()) {
                        TrophyProperties.RarityProgress progress = tp.getProgress(value);
                        TrophyProperties.RarityProgress active = this.progressMap.get((Object)value);
                        if (progress.total() != 0) {
                            list.add(Component.empty().append(Tooltips.decodeTranslationKey((String)("gui.guide.trophy." + value.getSerializedName() + ".total"))).append("[" + active.total() + "/" + progress.total() + "]"));
                        }
                        if (progress.unique() == 0) continue;
                        list.add(Component.empty().append(Tooltips.decodeTranslationKey((String)("gui.guide.trophy." + value.getSerializedName() + ".unique"))).append("[" + active.unique() + "/" + progress.unique() + "]"));
                    }
                    guiGraphics.renderTooltip(this.font, list, Optional.empty(), mouseX, mouseY);
                }
                is = new ItemStack((ItemLike)ModItems.MISSINGNO.get());
            }
            guiGraphics.renderOutline(xrender - 10, y - 2, 20, 20, -16777216);
            this.renderItem(is, xrender - 8, y, 1.0f);
        }
    }

    private void renderTheBasics(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.page + "/8", this.uiX + 213, this.uiY + 206, 10258812, false);
        switch (this.page) {
            case 0: {
                this.renderHelpText(guiGraphics, "basics");
                this.renderImage(guiGraphics, HELP_PAGE_BASICS);
                this.renderItem(this.basicsIndexIcon, this.uiX + 166, this.uiY + 39, 1.0f);
                guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.basics"), this.uiX + 80, this.uiY + 45, 6508608, false);
                break;
            }
            case 1: {
                this.renderHelpText(guiGraphics, "sweetspots");
                this.renderImage(guiGraphics, HELP_PAGE_SWEETSPOTS);
                this.renderItem(this.sweetspotsIcon, this.uiX + 166, this.uiY + 39, 1.0f);
                guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.sweetspots"), this.uiX + 80, this.uiY + 45, 6508608, false);
                break;
            }
            case 2: {
                this.renderHelpText(guiGraphics, "treasure");
                this.renderImage(guiGraphics, HELP_PAGE_TREASURE);
                this.renderItem(this.treasureIcon, this.uiX + 166, this.uiY + 39, 1.0f);
                guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.treasures"), this.uiX + 80, this.uiY + 45, 6508608, false);
                break;
            }
            case 3: {
                this.renderHelpText(guiGraphics, "upgrades");
                this.renderImage(guiGraphics, HELP_PAGE_LAVA_FISHING);
                this.renderItem(this.upgradeIndexIcon, this.uiX + 166, this.uiY + 39, 1.0f);
                this.renderItem(this.equipmentIcon, this.uiX + 321, this.uiY + 39, 1.0f);
                guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.lava_fishing"), this.uiX + 80, this.uiY + 45, 6508608, false);
                guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.modifiers"), this.uiX + 230, this.uiY + 45, 6508608, false);
                break;
            }
            case 4: {
                this.renderHelpText(guiGraphics, "hooks");
                this.renderImage(guiGraphics, HELP_PAGE_HOOKS_BOBBERS_BAITS);
                this.renderItem(this.hookIcon, this.uiX + 166, this.uiY + 39, 1.0f);
                guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.hooks_and_bobbers"), this.uiX + 60, this.uiY + 45, 6508608, false);
                int s1 = 5;
                int d1 = 23;
                int h1 = 0;
                if (this.hooksAndBobbers.size() > 15) {
                    s1 = 6;
                }
                if (this.hooksAndBobbers.size() > 18) {
                    s1 = 7;
                }
                if (this.hooksAndBobbers.size() > 18) {
                    d1 = 21;
                }
                if (this.hooksAndBobbers.size() > 18) {
                    h1 = 6;
                }
                for (int i = 0; i < Math.min(this.hooksAndBobbers.size(), 21); ++i) {
                    int x = 70 - Math.min(s1, this.hooksAndBobbers.size() - i / s1 * s1) * 23 / 2;
                    int xrender = x + i % s1 * d1;
                    int y = i / s1 * 25;
                    guiGraphics.fill((xrender += this.uiX + 60 + h1) - 10, (y += this.uiY + 130) - 2, xrender + 10, y + 18, -4938089);
                    this.renderItem(this.hooksAndBobbers.get(i), xrender - 8, y, 1.0f);
                    if (mouseX <= xrender - 10 || mouseX >= xrender + 10 || mouseY <= y - 2 || mouseY >= y + 18) continue;
                    guiGraphics.renderTooltip(this.font, this.hooksAndBobbers.get(i), mouseX, mouseY);
                }
                this.renderItem(this.baitIcon, this.uiX + 321, this.uiY + 39, 1.0f);
                guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.baits"), this.uiX + 230, this.uiY + 45, 6508608, false);
                int s2 = 5;
                int d2 = 23;
                int h2 = 0;
                if (this.baits.size() > 15) {
                    s2 = 6;
                }
                if (this.baits.size() > 18) {
                    s2 = 7;
                }
                if (this.baits.size() > 18) {
                    d2 = 21;
                }
                if (this.baits.size() > 18) {
                    h2 = 6;
                }
                for (int i = 0; i < Math.min(this.baits.size(), 18); ++i) {
                    int x = 70 - Math.min(s2, this.baits.size() - i / s2 * s2) * 23 / 2;
                    int xrender = x + i % s2 * d2;
                    int y = i / s2 * 25;
                    guiGraphics.fill((xrender += this.uiX + 223 + h2) - 10, (y += this.uiY + 130) - 2, xrender + 10, y + 18, -4938089);
                    this.renderItem(this.baits.get(i), xrender - 8, y, 1.0f);
                    if (mouseX <= xrender - 10 || mouseX >= xrender + 10 || mouseY <= y - 2 || mouseY >= y + 18) continue;
                    guiGraphics.renderTooltip(this.font, this.baits.get(i), mouseX, mouseY);
                }
                break;
            }
            case 5: {
                this.renderHelpText(guiGraphics, "cosmetics");
                this.renderImage(guiGraphics, HELP_PAGE_GADGETS_COSMETICS);
                this.renderItem(this.upgradeIndexIcon, this.uiX + 166, this.uiY + 39, 1.0f);
                this.renderItem(this.equipmentIcon, this.uiX + 321, this.uiY + 39, 1.0f);
                guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.gadgets"), this.uiX + 80, this.uiY + 45, 6508608, false);
                guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.cosmetics"), this.uiX + 230, this.uiY + 45, 6508608, false);
                int s1 = 5;
                int d1 = 23;
                int h1 = 0;
                if (this.gadgets.size() > 15) {
                    s1 = 6;
                }
                if (this.gadgets.size() > 18) {
                    s1 = 7;
                }
                if (this.gadgets.size() > 18) {
                    d1 = 21;
                }
                if (this.gadgets.size() > 18) {
                    h1 = 6;
                }
                for (int i = 0; i < Math.min(this.gadgets.size(), 21); ++i) {
                    int x = 70 - Math.min(s1, this.gadgets.size() - i / s1 * s1) * 23 / 2;
                    int xrender = x + i % s1 * d1;
                    int y = i / s1 * 25;
                    guiGraphics.fill((xrender += this.uiX + 60 + h1) - 10, (y += this.uiY + 130) - 2, xrender + 10, y + 18, -4938089);
                    this.renderItem(this.gadgets.get(i), xrender - 8, y, 1.0f);
                    if (mouseX <= xrender - 10 || mouseX >= xrender + 10 || mouseY <= y - 2 || mouseY >= y + 18) continue;
                    guiGraphics.renderTooltip(this.font, this.gadgets.get(i), mouseX, mouseY);
                }
                break;
            }
            case 6: {
                this.renderHelpText(guiGraphics, "templates");
                this.renderImage(guiGraphics, HELP_PAGE_TEMPLATES_EQUIPMENT);
                this.renderItem(this.templateIcon, this.uiX + 166, this.uiY + 39, 1.0f);
                guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.templates"), this.uiX + 80, this.uiY + 45, 6508608, false);
                int s1 = 5;
                int d1 = 23;
                int h1 = 0;
                for (int i = 0; i < Math.min(this.templates.size(), 12); ++i) {
                    int x = 70 - Math.min(s1, this.templates.size() - i / s1 * s1) * 23 / 2;
                    int xrender = x + i % s1 * d1;
                    int y = i / s1 * 25;
                    guiGraphics.fill((xrender += this.uiX + 60 + h1) - 10, (y += this.uiY + 157) - 2, xrender + 10, y + 18, -4938089);
                    this.renderItem(this.templates.get(i), xrender - 8, y, 1.0f);
                    if (mouseX <= xrender - 10 || mouseX >= xrender + 10 || mouseY <= y - 2 || mouseY >= y + 18) continue;
                    guiGraphics.renderTooltip(this.font, this.templates.get(i), mouseX, mouseY);
                }
                this.renderItem(this.equipmentIcon, this.uiX + 321, this.uiY + 39, 1.0f);
                guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.equipment"), this.uiX + 230, this.uiY + 45, 6508608, false);
                int s2 = 7;
                int d2 = 21;
                int h2 = 0;
                for (int i = 0; i < Math.min(this.equipments.size(), 18); ++i) {
                    int x = 70 - Math.min(s2, this.equipments.size() - i / s2 * s2) * 23 / 2;
                    int xrender = x + i % s2 * d2;
                    int y = i / s2 * 25;
                    guiGraphics.fill((xrender += this.uiX + 229 + h2) - 10, (y += this.uiY + 157) - 2, xrender + 10, y + 18, -4938089);
                    this.renderItem(this.equipments.get(i), xrender - 8, y, 1.0f);
                    if (mouseX <= xrender - 10 || mouseX >= xrender + 10 || mouseY <= y - 2 || mouseY >= y + 18) continue;
                    guiGraphics.renderTooltip(this.font, this.equipments.get(i), mouseX, mouseY);
                }
                break;
            }
            case 7: {
                this.renderHelpText(guiGraphics, "tournaments");
                this.renderImage(guiGraphics, HELP_PAGE_TOURNAMENTS);
                this.renderItem(this.tournamentIndexIcon, this.uiX + 166, this.uiY + 39, 1.0f);
                guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.tournaments"), this.uiX + 60, this.uiY + 45, 6508608, false);
                break;
            }
            case 8: {
                this.renderHelpText(guiGraphics, "trophies");
                this.renderImage(guiGraphics, HELP_PAGE_TROPHIES);
                this.renderItem(this.trophiesIndexIcon, this.uiX + 166, this.uiY + 39, 1.0f);
                this.renderItem(this.secretsIcon, this.uiX + 321, this.uiY + 39, 1.0f);
                guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.trophies"), this.uiX + 60, this.uiY + 45, 6508608, false);
                this.renderTrophies(guiGraphics, mouseX, mouseY);
                guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.secrets"), this.uiX + 230, this.uiY + 45, 6508608, false);
                this.renderSecrets(guiGraphics, mouseX, mouseY);
            }
        }
    }

    private void renderIndex(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int i;
        int topLeftCorner = this.uiX + 53;
        if (this.page == 0) {
            int x = topLeftCorner;
            for (int i2 = 0; i2 < 7; ++i2) {
                this.renderItem((ItemStack)this.indexEntries.get(i2).getFirst(), x + 2, this.uiY + 47, 1.0f);
                if (mouseX > x - 2 && mouseX < x + 17 && mouseY > this.uiY + 47 - 2 && mouseY < this.uiY + 47 + 17) {
                    guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)((String)this.indexEntries.get(i2).getSecond())), mouseX, mouseY);
                }
                if (this.clickedX > x - 2 && this.clickedX < x + 17 && this.clickedY > this.uiY + 47 - 2 && this.clickedY < this.uiY + 47 + 17) {
                    this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
                    this.menu = 1;
                    switch (i2) {
                        case 0: {
                            this.page = 0;
                            break;
                        }
                        case 1: {
                            this.page = 3;
                            break;
                        }
                        case 2: {
                            this.page = 4;
                            break;
                        }
                        case 3: {
                            this.page = 5;
                            break;
                        }
                        case 4: {
                            this.page = 7;
                            break;
                        }
                        case 5: {
                            this.page = 8;
                        }
                    }
                    if (i2 == 6) {
                        this.menu = -1;
                    }
                }
                x += 20;
            }
        }
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.sort"), this.uiX + 52, this.uiY + 67, 14999768, false);
        if (this.page == 0) {
            for (i = 0; i < this.fishInArea.size() && i < 42; ++i) {
                FishProperties fp = this.fishInArea.get(i);
                int xpos = topLeftCorner + i % 7 * 20;
                int ypos = this.uiY + 47 + i / 7 * 20 + 38;
                this.renderFishIndex(guiGraphics, xpos, ypos, mouseX, mouseY, fp, -3752529);
            }
            if (this.fishInArea.size() > 6) {
                this.renderImage(guiGraphics, FISHES_IN_AREA_TOP_RIGHT_DECORATION);
            }
            int numberOfRows = (this.fishInArea.size() - 1) / 7 + 1;
            int x = mouseX - this.uiX;
            int y = mouseY - this.uiY;
            if (x > 51 && x < 116 && y > 67 && y < 76) {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)((Sort)((Object)Config.SORT.get())).getTranslationKey()), mouseX, mouseY);
            }
            if (numberOfRows < 4) {
                this.renderImage(guiGraphics, FISHES_IN_AREA_BOTTOM_DECORATION);
            }
            if (numberOfRows == 4 && this.fishInArea.size() % 7 < 5 && this.fishInArea.size() % 7 != 0) {
                this.renderImage(guiGraphics, FISHES_IN_AREA_BOTTOM_DECORATION);
            }
            if (!this.fishInArea.isEmpty()) {
                this.renderImage(guiGraphics, FISHES_IN_AREA_BOTTOM_LEFT_DECORATION, 0, (Math.min(numberOfRows, 6) - 1) * 20);
            }
            int xFishSkeletonOffset = 0;
            if (this.fishInArea.size() % 7 > 4 || this.fishInArea.size() % 7 == 0) {
                xFishSkeletonOffset = 20;
            }
            if (numberOfRows < 6) {
                this.renderImage(guiGraphics, FISHES_IN_AREA_FISH_DECORATION, 0, (numberOfRows - 1) * 20 + xFishSkeletonOffset);
            }
            if (numberOfRows == 6 && this.fishInArea.size() % 7 < 5 && this.fishInArea.size() % 7 != 0) {
                this.renderImage(guiGraphics, FISHES_IN_AREA_FISH_DECORATION, 0, (numberOfRows - 1) * 20 + xFishSkeletonOffset);
            }
        }
        this.hasNextPage = false;
        if (this.page == 0) {
            for (i = 0; i < 49; ++i) {
                if (i > this.entries.size() - 1) {
                    return;
                }
                this.renderFishIndex(guiGraphics, topLeftCorner + 160 + i % 7 * 20, this.uiY + 56 + i / 7 * 20, mouseX, mouseY, this.entries.get(i), -3752529);
            }
        } else {
            int order;
            for (i = 0; i < 49 && (order = i + 49 * (this.page * 2 - 1)) <= this.entries.size() - 1; ++i) {
                this.renderFishIndex(guiGraphics, topLeftCorner + i % 7 * 20, this.uiY + 56 + i / 7 * 20, mouseX, mouseY, this.entries.get(order), -3752529);
            }
            for (i = 0; i < 49; ++i) {
                order = i + 49 + 49 * (this.page * 2 - 1);
                if (order > this.entries.size() - 1) {
                    return;
                }
                this.renderFishIndex(guiGraphics, topLeftCorner + 160 + i % 7 * 20, this.uiY + 56 + i / 7 * 20, mouseX, mouseY, this.entries.get(order), -3752529);
            }
        }
        this.lastIndexPage = Math.max(this.page + 1, this.lastIndexPage);
        this.hasNextPage = true;
    }

    private void renderFishIndex(GuiGraphics guiGraphics, int xOffset, int yOffset, int mouseX, int mouseY, FishProperties fp, int backgroundFillColor) {
        int caught;
        Map<ResourceLocation, FishCaughtCounter> fishesCaught = FishingGuideAttachment.getFishesCaught((Player)this.player);
        FishCaughtCounter fishCaughtCounter = FishCaughtCounter.get((Player)this.player, fp);
        ItemStack is = new ItemStack(fp.catchInfo().fish());
        int n = caught = fishCaughtCounter == null ? 0 : fishCaughtCounter.count();
        if (this.clickedX > xOffset - 3 && this.clickedX < xOffset + 21 - 3 && this.clickedY > yOffset - 3 && this.clickedY < yOffset + 21 - 3) {
            this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
            this.menu = 2;
            this.page = this.entries.indexOf(fp) / 2;
            if (this.entries.indexOf(fp) % 2 == 0) {
                this.highlightLeftAlpha = 0.5f;
            } else {
                this.highlightRightAlpha = 0.5f;
            }
        }
        guiGraphics.fill(xOffset - 1, yOffset - 1, xOffset + 17, yOffset + 17, backgroundFillColor);
        int color = switch (fp.rarity()) {
            default -> throw new MatchException(null, null);
            case FishProperties.Rarity.COMMON -> FastColor.ARGB32.color((int)0, (int)-1);
            case FishProperties.Rarity.UNCOMMON -> FastColor.ARGB32.color((int)255, (int)9630349);
            case FishProperties.Rarity.RARE -> FastColor.ARGB32.color((int)255, (int)7915775);
            case FishProperties.Rarity.EPIC -> FastColor.ARGB32.color((int)255, (int)12607743);
            case FishProperties.Rarity.LEGENDARY -> FastColor.ARGB32.color((int)175, (int)Color.HSBtoRGB(Tooltips.hue * 2.0f, 1.0f, 1.0f));
        };
        float red = (float)FastColor.ARGB32.red((int)color) / 255.0f;
        float green = (float)FastColor.ARGB32.green((int)color) / 255.0f;
        float blue = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
        float alpha = (float)FastColor.ARGB32.alpha((int)color) / 255.0f;
        guiGraphics.setColor(red, green, blue, alpha);
        RenderSystem.enableBlend();
        guiGraphics.blit(GLOW, xOffset - 1, yOffset - 1, 0.0f, 0.0f, 18, 18, 18, 18);
        RenderSystem.disableBlend();
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        if (caught != 0) {
            this.renderItem(is, xOffset, yOffset, 1.0f);
        } else {
            this.renderItem(new ItemStack((ItemLike)ModItems.MISSINGNO.get()), xOffset, yOffset, 1.0f);
        }
        if (fishCaughtCounter != null && fishCaughtCounter.hasGuideNotification()) {
            guiGraphics.blit(STAR, xOffset + 10, yOffset + 7, 0.0f, 0.0f, 10, 10, 10, 10);
        }
        if (mouseX > xOffset - 3 && mouseX < xOffset + 21 - 3 && mouseY > yOffset - 3 && mouseY < yOffset + 21 - 3) {
            ArrayList<Object> components = new ArrayList<Object>();
            if (caught == 0) {
                components.add(Component.translatable((String)"gui.guide.not_caught_fish_name"));
                components.add(Tooltips.decodeTranslationKey((String)("gui.guide.rarity." + fp.rarity().getSerializedName())));
                components.add(Component.translatable((String)"gui.guide.not_caught_yet").withColor(10700086));
            } else {
                components.add(Component.translatable((String)((Item)fp.catchInfo().fish().value()).getDescriptionId()));
                components.add(Tooltips.decodeTranslationKey((String)("gui.guide.rarity." + fp.rarity().getSerializedName())));
                components.add(Component.translatable((String)"gui.guide.caught").append((Component)Component.literal((String)(" [" + caught + "]"))).withColor(4224300));
            }
            components.add(Component.literal((String)""));
            String check = "";
            color = FishProperties.isDimensionCorrect((Entity)this.player, fp) ? 4224300 : 10700086;
            check = FishProperties.isDimensionCorrect((Entity)this.player, fp) ? "\u2705" : "\u274c";
            components.add(Component.translatable((String)"gui.guide.dimension").append((Component)Component.literal((String)check)).withColor(color));
            color = FishProperties.isBiomeCorrect((Entity)this.player, fp) ? 4224300 : 10700086;
            check = FishProperties.isBiomeCorrect((Entity)this.player, fp) ? "\u2705" : "\u274c";
            components.add(Component.translatable((String)"gui.guide.biome").append((Component)Component.literal((String)check)).withColor(color));
            color = FishProperties.isWeatherCorrect((Entity)this.player, fp, ItemStack.EMPTY) ? 4224300 : 10700086;
            check = FishProperties.isWeatherCorrect((Entity)this.player, fp, ItemStack.EMPTY) ? "\u2705" : "\u274c";
            components.add(Component.translatable((String)"gui.guide.weather").append((Component)Component.literal((String)check)).withColor(color));
            color = FishProperties.isDaytimeCorrect((Entity)this.player, fp) ? 4224300 : 10700086;
            check = FishProperties.isDaytimeCorrect((Entity)this.player, fp) ? "\u2705" : "\u274c";
            components.add(Component.translatable((String)"gui.guide.daytime").append((Component)Component.literal((String)check)).withColor(color));
            color = FishProperties.isElevationCorrect((Entity)this.player, fp) ? 4224300 : 10700086;
            check = FishProperties.isElevationCorrect((Entity)this.player, fp) ? "\u2705" : "\u274c";
            components.add(Component.translatable((String)"gui.guide.elevation").append((Component)Component.literal((String)check)).withColor(color));
            components.add(Component.literal((String)""));
            if (ModList.get().isLoaded("sereneseasons") && ((Boolean)Config.ENABLE_SEASONS.get()).booleanValue()) {
                if (SereneSeasonsCompat.canCatch(fp, (Level)this.level)) {
                    components.add(Component.translatable((String)"gui.guide.seasons.in_season").withStyle(Style.EMPTY.withColor(4224300)));
                } else {
                    components.add(Component.translatable((String)"gui.guide.seasons.not_in_season").withStyle(Style.EMPTY.withColor(10700086)));
                }
            }
            if (ModList.get().isLoaded("eclipticseasons") && ((Boolean)Config.ENABLE_SEASONS.get()).booleanValue()) {
                if (EclipticSeasonsCompat.canCatch(fp, (Level)this.level)) {
                    components.add(Component.translatable((String)"gui.guide.seasons.in_season").withStyle(Style.EMPTY.withColor(4224300)));
                } else {
                    components.add(Component.translatable((String)"gui.guide.seasons.not_in_season").withStyle(Style.EMPTY.withColor(10700086)));
                }
            }
            if (ModList.get().isLoaded("tfc") && ((Boolean)Config.ENABLE_SEASONS.get()).booleanValue()) {
                if (TerraFirmaCraftSeasonsCompat.canCatch(fp, (Level)this.level)) {
                    components.add(Component.translatable((String)"gui.guide.seasons.in_season").withStyle(Style.EMPTY.withColor(4224300)));
                } else {
                    components.add(Component.translatable((String)"gui.guide.seasons.not_in_season").withStyle(Style.EMPTY.withColor(10700086)));
                }
            }
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
        }
    }

    private void renderEntry(GuiGraphics guiGraphics, int mouseX, int mouseY, int xOffset, int entry) {
        MutableComponent comp;
        MutableComponent hardCodedTranslations;
        String aboveBelow;
        MutableComponent comp2;
        MutableComponent comp3;
        if (this.level == null) {
            this.level = this.getMinecraft().level;
        }
        double x = mouseX - this.uiX;
        double y = mouseY - this.uiY;
        if (this.entries.size() <= entry) {
            return;
        }
        ItemStack is = new ItemStack(this.entries.get(entry).catchInfo().fish());
        FishProperties fp = this.entries.get(entry);
        ResourceLocation loc = fp.toLoc((Level)this.level);
        FishCaughtCounter fishCaughtCounter = this.fishCaughtCounterMap.get(loc);
        if (fishCaughtCounter != null && !this.fpsSeen.contains(loc) && fishCaughtCounter.hasGuideNotification()) {
            this.fpsSeen.add(loc);
        }
        FishCaughtCounter fcc = FishCaughtCounter.get((Player)this.player, fp);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.caught"), this.uiX + xOffset + 73, this.uiY + 68, 10258812, false);
        if (fcc == null) {
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.not_caught"), this.uiX + xOffset + 73, this.uiY + 78, 10258812, false);
        } else {
            MutableComponent c = Component.literal((String)("[" + fcc.count() + "]")).withColor(6508608);
            guiGraphics.drawString(this.font, (Component)Component.empty().append((Component)c), this.uiX + xOffset + 73, this.uiY + 78, 0, false);
        }
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.rarity"), this.uiX + xOffset + 73, this.uiY + 90, 10258812, false);
        guiGraphics.drawString(this.font, Tooltips.decodeTranslationKey((String)("gui.guide.rarity." + fp.rarity().getSerializedName())), this.uiX + xOffset + 73, this.uiY + 100, 0, false);
        if ((ModList.get().isLoaded("sereneseasons") || ModList.get().isLoaded("eclipticseasons") || ModList.get().isLoaded("tfc")) && ((Boolean)Config.ENABLE_SEASONS.get()).booleanValue()) {
            int seasonX = 79;
            int seasonY = 48;
            int spacing = 15;
            List<FishProperties.WorldRestrictions.Seasons> seasons = fp.wr().seasons();
            if (U.containsAny(seasons, FishProperties.WorldRestrictions.Seasons.ALL, FishProperties.WorldRestrictions.Seasons.SPRING, FishProperties.WorldRestrictions.Seasons.EARLY_SPRING, FishProperties.WorldRestrictions.Seasons.MID_SPRING, FishProperties.WorldRestrictions.Seasons.LATE_SPRING)) {
                guiGraphics.blit(SEASONS, this.uiX + xOffset + seasonX, this.uiY + seasonY, 8, 8, 0.0f, 0.0f, 8, 8, 32, 8);
            }
            if (U.containsAny(seasons, FishProperties.WorldRestrictions.Seasons.ALL, FishProperties.WorldRestrictions.Seasons.SUMMER, FishProperties.WorldRestrictions.Seasons.EARLY_SUMMER, FishProperties.WorldRestrictions.Seasons.MID_SUMMER, FishProperties.WorldRestrictions.Seasons.LATE_SUMMER)) {
                guiGraphics.blit(SEASONS, this.uiX + xOffset + seasonX + spacing * 1, this.uiY + seasonY, 8, 8, 8.0f, 0.0f, 8, 8, 32, 8);
            }
            if (U.containsAny(seasons, FishProperties.WorldRestrictions.Seasons.ALL, FishProperties.WorldRestrictions.Seasons.AUTUMN, FishProperties.WorldRestrictions.Seasons.EARLY_AUTUMN, FishProperties.WorldRestrictions.Seasons.MID_AUTUMN, FishProperties.WorldRestrictions.Seasons.LATE_AUTUMN)) {
                guiGraphics.blit(SEASONS, this.uiX + xOffset + seasonX + spacing * 2, this.uiY + seasonY, 8, 8, 16.0f, 0.0f, 8, 8, 32, 8);
            }
            if (U.containsAny(seasons, FishProperties.WorldRestrictions.Seasons.ALL, FishProperties.WorldRestrictions.Seasons.WINTER, FishProperties.WorldRestrictions.Seasons.EARLY_WINTER, FishProperties.WorldRestrictions.Seasons.MID_WINTER, FishProperties.WorldRestrictions.Seasons.LATE_WINTER)) {
                guiGraphics.blit(SEASONS, this.uiX + xOffset + seasonX + spacing * 3, this.uiY + seasonY, 8, 8, 24.0f, 0.0f, 8, 8, 32, 8);
            }
            if (x > (double)(xOffset + 70) && x < (double)(xOffset + 140) && y > 46.0 && y < 57.0) {
                ArrayList<MutableComponent> seasonsComp = new ArrayList<MutableComponent>();
                seasonsComp.add(Component.translatable((String)"gui.guide.seasons"));
                if (fp.wr().seasons().contains((Object)FishProperties.WorldRestrictions.Seasons.ALL)) {
                    seasonsComp.add(Component.translatable((String)"gui.guide.seasons.all"));
                } else {
                    for (FishProperties.WorldRestrictions.Seasons s : seasons) {
                        seasonsComp.add(Component.translatable((String)("gui.guide.seasons." + s.getSerializedName())));
                    }
                }
                guiGraphics.renderTooltip(this.font, seasonsComp, Optional.empty(), mouseX, mouseY);
            }
        }
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.rarity"), this.uiX + xOffset + 73, this.uiY + 90, 10258812, false);
        if (fcc == null) {
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.not_caught_fish_name"), this.uiX + xOffset + 30, this.uiY + 36, 6508608, false);
        } else {
            MutableComponent compName = Component.translatable((String)((Item)fp.catchInfo().fish().value()).getDescriptionId());
            if (xOffset > 200) {
                guiGraphics.drawString(this.font, (Component)compName, this.uiX + xOffset + 15, this.uiY + 36, 6508608, false);
            } else {
                guiGraphics.drawString(this.font, (Component)compName, this.uiX + xOffset + 30, this.uiY + 36, 6508608, false);
            }
        }
        if (fcc != null) {
            this.renderItem(is, this.uiX + xOffset + 26, this.uiY + 70);
        }
        int color = switch (fp.rarity()) {
            default -> throw new MatchException(null, null);
            case FishProperties.Rarity.COMMON -> FastColor.ARGB32.color((int)0, (int)-1);
            case FishProperties.Rarity.UNCOMMON -> FastColor.ARGB32.color((int)200, (int)9630349);
            case FishProperties.Rarity.RARE -> FastColor.ARGB32.color((int)200, (int)7915775);
            case FishProperties.Rarity.EPIC -> FastColor.ARGB32.color((int)200, (int)12607743);
            case FishProperties.Rarity.LEGENDARY -> FastColor.ARGB32.color((int)175, (int)Color.HSBtoRGB(Tooltips.hue * 2.0f, 1.0f, 1.0f));
        };
        float red = (float)FastColor.ARGB32.red((int)color) / 255.0f;
        float green = (float)FastColor.ARGB32.green((int)color) / 255.0f;
        float blue = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
        float alpha = (float)FastColor.ARGB32.alpha((int)color) / 255.0f;
        guiGraphics.setColor(red, green, blue, alpha);
        RenderSystem.enableBlend();
        if (fcc != null) {
            guiGraphics.blit(GLOW, this.uiX + xOffset + 10, this.uiY + 55, 0.0f, 0.0f, 48, 48, 48, 48);
        }
        RenderSystem.disableBlend();
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        FishCaughtCounter counter = this.fishCaughtCounterMap.get(U.getRlFromFp((Level)this.level, fp));
        if (counter != null && counter.hasGuideNotification()) {
            this.renderImage(guiGraphics, NEW_FISH, xOffset - 52, 0);
        }
        if (mouseX > this.uiX + xOffset + 0 && mouseX < this.uiX + xOffset + 65 && mouseY > this.uiY + 45 && mouseY < this.uiY + 110 && fcc != null) {
            guiGraphics.renderTooltip(this.font, is, mouseX, mouseY);
        }
        if (mouseX > this.uiX + xOffset + 66 && mouseX < this.uiX + xOffset + 140 && mouseY > this.uiY + 57 && mouseY < this.uiY + 110 && fcc != null) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
            float averageTicks = (float)((int)(fcc.averageTicks() / 20.0f * 100.0f)) / 100.0f;
            SettingsScreen.Units unit = (SettingsScreen.Units)((Object)Config.UNIT.get());
            String size = unit.getSizeAsString(fcc.size());
            String weight = unit.getWeightAsString(fcc.weight());
            components.add(Component.literal((String)"Fastest Catch: ").append((Component)Component.literal((String)((float)fcc.fastestTicks() / 20.0f + "s")).withStyle(ChatFormatting.BOLD)));
            components.add(Component.literal((String)"Average Catch: ").append((Component)Component.literal((String)(averageTicks + "s")).withStyle(ChatFormatting.BOLD)));
            components.add(Component.literal((String)""));
            components.add(Component.literal((String)"Biggest Catch: ").append((Component)Component.literal((String)size).withStyle(ChatFormatting.BOLD)));
            components.add(Component.literal((String)"Heaviest Catch: ").append((Component)Component.literal((String)weight).withStyle(ChatFormatting.BOLD)));
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
        }
        int yOffset = 121;
        if (fp.wr().dims().isEmpty()) {
            comp3 = Component.translatable((String)"gui.guide.no_restriction");
        } else if (fp.wr().dims().size() == 1) {
            comp3 = Component.translatable((String)("dimension." + fp.wr().dims().getFirst().toLanguageKey()));
        } else {
            comp3 = Component.translatable((String)"gui.guide.hover");
            if (x > (double)xOffset && x < (double)(xOffset + 100) && y > (double)(yOffset - 2) && y < (double)(yOffset + 10)) {
                ArrayList<MutableComponent> c = new ArrayList<MutableComponent>();
                c.add(Component.translatable((String)"gui.guide.dimensions"));
                for (int i = 0; i < fp.wr().dims().size(); ++i) {
                    c.add(Component.translatable((String)("dimension." + fp.wr().dims().get(i).toLanguageKey())));
                }
                guiGraphics.renderTooltip(this.font, c, Optional.empty(), mouseX, mouseY);
            }
        }
        comp3 = fp.wr().dims().isEmpty() ? comp3.copy().withColor(4224300) : (fp.wr().dims().contains(this.level.dimension().location()) ? comp3.copy().withColor(4224300) : comp3.copy().withColor(10700086));
        MutableComponent start = Component.translatable((String)"gui.guide.dimension");
        guiGraphics.drawString(this.font, (Component)start.copy().append((Component)comp3), this.uiX + xOffset, this.uiY + yOffset, 6508608, false);
        if (!fp.wr().dimsBlacklist().isEmpty()) {
            guiGraphics.drawString(this.font, (Component)Component.literal((String)"[!]").withColor(10700086), this.uiX + xOffset + 160, this.uiY + yOffset, 0, false);
            if (x > (double)(xOffset + 155) && x < (double)(xOffset + 175) && y > (double)(yOffset - 4) && y < (double)(yOffset + 12)) {
                ArrayList<MutableComponent> c = new ArrayList<MutableComponent>();
                c.add(Component.translatable((String)"gui.guide.blacklisted_dimensions"));
                for (int i = 0; i < fp.wr().dimsBlacklist().size(); ++i) {
                    c.add(Component.literal((String)fp.wr().dimsBlacklist().get(i).toString()));
                }
                guiGraphics.renderTooltip(this.font, c, Optional.empty(), mouseX, mouseY);
            }
        }
        yOffset += 12;
        List<ResourceLocation> biomesBL = FishProperties.getBiomesBlacklistAsList(fp, (Level)this.level);
        List<ResourceLocation> biomes = FishProperties.getBiomesAsList(fp, (Level)this.level);
        if (biomes.isEmpty()) {
            comp2 = Component.translatable((String)"gui.guide.no_restriction");
            if (fp.wr().biomesBlacklistTags().equals(List.of(StarcatcherTags.IS_OCEAN, StarcatcherTags.IS_RIVER))) {
                comp2 = Component.translatable((String)"gui.guide.lakes");
                if (x > (double)(25 + xOffset) && x < (double)(120 + xOffset) && y > 133.0 && y < 140.0) {
                    c = Component.translatable((String)"gui.guide.lakes.hover");
                    guiGraphics.renderTooltip(this.font, (Component)c, mouseX, mouseY);
                }
            }
        } else if (biomes.size() == 1) {
            comp2 = Component.translatable((String)("biome." + biomes.getFirst().toLanguageKey()));
        } else if (fp.wr().biomesTags().size() == 1) {
            comp2 = Component.translatable((String)("tag." + fp.wr().biomesTags().getFirst().toLanguageKey()));
            if (x > (double)xOffset && x < (double)(xOffset + 100) && y > (double)(yOffset - 2) && y < (double)(yOffset + 10)) {
                c = new ArrayList();
                if (!fp.wr().biomesTags().isEmpty()) {
                    c.add(Component.translatable((String)"gui.guide.biome_tags").withStyle(Style.EMPTY.withBold(Boolean.valueOf(true))));
                    for (ResourceLocation rl : fp.wr().biomesTags()) {
                        c.add(Component.translatable((String)("tag." + rl.toLanguageKey())));
                    }
                    c.add(Component.empty());
                }
                c.add(Component.translatable((String)"gui.guide.biomes").withStyle(Style.EMPTY.withBold(Boolean.valueOf(true))));
                for (ResourceLocation rl : biomes) {
                    c.add(Component.translatable((String)("biome." + rl.toLanguageKey())));
                }
                guiGraphics.renderTooltip(this.font, (List)c, Optional.empty(), mouseX, mouseY);
            }
        } else {
            comp2 = Component.translatable((String)"gui.guide.hover");
            if (x > (double)xOffset && x < (double)(xOffset + 100) && y > (double)(yOffset - 2) && y < (double)(yOffset + 10)) {
                c = new ArrayList();
                c.add(Component.translatable((String)"gui.guide.biome"));
                for (ResourceLocation rl : biomes) {
                    c.add(Component.translatable((String)("biome." + rl.toLanguageKey())));
                }
                guiGraphics.renderTooltip(this.font, (List)c, Optional.empty(), mouseX, mouseY);
            }
        }
        ResourceLocation rl = ResourceLocation.parse((String)this.level.getBiome(Minecraft.getInstance().player.blockPosition()).getRegisteredName());
        comp2 = comp2.copy().withColor(4224300);
        if (!biomes.contains(rl) && !biomes.isEmpty()) {
            comp2 = comp2.copy().withColor(10700086);
        }
        if (biomesBL.contains(rl)) {
            comp2 = comp2.copy().withColor(10700086);
        }
        MutableComponent start2 = Component.translatable((String)"gui.guide.biome");
        guiGraphics.drawString(this.font, (Component)start2.copy().append((Component)comp2), this.uiX + xOffset, this.uiY + yOffset, 6508608, false);
        if (!biomesBL.isEmpty()) {
            guiGraphics.drawString(this.font, (Component)Component.literal((String)"[!]").withColor(10700086), this.uiX + xOffset + 130, this.uiY + yOffset - 1, 0, false);
            if (x > (double)(xOffset + 129) && x < (double)(xOffset + 140) && y > (double)(yOffset - 3) && y < (double)(yOffset + 8)) {
                ArrayList<MutableComponent> c = new ArrayList<MutableComponent>();
                if (!fp.wr().biomesBlacklistTags().isEmpty()) {
                    c.add(Component.translatable((String)"gui.guide.blacklisted_biome_tags").withStyle(Style.EMPTY.withBold(Boolean.valueOf(true))));
                    for (ResourceLocation rl2 : fp.wr().biomesBlacklistTags()) {
                        c.add(Component.translatable((String)("tag." + rl2.toLanguageKey())));
                    }
                    c.add(Component.empty());
                }
                c.add(Component.translatable((String)"gui.guide.blacklisted_biomes").withStyle(Style.EMPTY.withBold(Boolean.valueOf(true))));
                for (ResourceLocation rl2 : biomesBL) {
                    c.add(Component.translatable((String)("biome." + rl2.toLanguageKey())));
                }
                guiGraphics.renderTooltip(this.font, c, Optional.empty(), mouseX, mouseY);
            }
        }
        yOffset += 12;
        if (fp.baseChance() == 0) {
            guiGraphics.drawString(this.font, (Component)Component.literal((String)"[!]").withColor(10700086), this.uiX + xOffset + 130, this.uiY + yOffset - 1, 0, false);
            if (x > (double)(xOffset + 129) && x < (double)(xOffset + 140) && y > (double)(yOffset - 3) && y < (double)(yOffset + 8)) {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.guide.bait_required"), mouseX, mouseY);
            }
        }
        if (fp.br().correctBait().isEmpty()) {
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.bait").append((Component)Component.translatable((String)"gui.guide.no_restriction")), this.uiX + xOffset, this.uiY + yOffset, 6508608, false);
        } else {
            ItemStack bait = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(fp.br().correctBait().getFirst()));
            if (bait.is((Item)ModItems.LEGENDARY_BAIT.get())) {
                guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.bait").append(Tooltips.RGBEachLetter((String)I18n.get((String)bait.getDescriptionId(), (Object[])new Object[0]))), this.uiX + xOffset, this.uiY + yOffset, 6508608, false);
            } else {
                guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.bait").append((Component)Component.translatable((String)bait.getDescriptionId())), this.uiX + xOffset, this.uiY + yOffset, 6508608, false);
            }
            if (x > (double)xOffset && x < (double)(xOffset + 100) && y > (double)(yOffset - 2) && y < (double)(yOffset + 10)) {
                guiGraphics.renderTooltip(this.font, bait, mouseX, mouseY);
            }
        }
        yOffset += 12;
        if (fp.weather() == FishProperties.Weather.ALL) {
            comp2 = Component.translatable((String)"gui.guide.no_restriction").withColor(6508608);
        } else {
            comp2 = Component.translatable((String)"gui.guide.no_restriction");
            if (fp.weather() == FishProperties.Weather.RAIN) {
                comp2 = (double)this.level.getRainLevel(0.0f) > 0.5 ? Component.translatable((String)"gui.guide.raining").withColor(4224300) : Component.translatable((String)"gui.guide.raining").withColor(10700086);
            }
            if (fp.weather() == FishProperties.Weather.THUNDER) {
                comp2 = (double)this.level.getThunderLevel(0.0f) > 0.5 ? Component.translatable((String)"gui.guide.thundering").withColor(4224300) : Component.translatable((String)"gui.guide.thundering").withColor(10700086);
            }
            if (fp.weather() == FishProperties.Weather.CLEAR) {
                comp2 = (double)this.level.getRainLevel(0.0f) > 0.5 || (double)this.level.getThunderLevel(0.0f) > 0.5 ? Component.translatable((String)"gui.guide.clear").withColor(10700086) : Component.translatable((String)"gui.guide.clear").withColor(4224300);
            }
        }
        MutableComponent start3 = Component.translatable((String)"gui.guide.weather");
        guiGraphics.drawString(this.font, (Component)start3.copy().append((Component)comp2), this.uiX + xOffset, this.uiY + yOffset, 6508608, false);
        yOffset += 12;
        if (fp.daytime() == FishProperties.Daytime.ALL) {
            comp2 = Component.translatable((String)"gui.guide.no_restriction").withColor(6508608);
        } else {
            long time = this.level.getDayTime() % 24000L;
            comp2 = switch (fp.daytime()) {
                case FishProperties.Daytime.DAY -> {
                    if (time <= 23000L && time >= 12700L) {
                        yield Component.translatable((String)"gui.guide.day").withColor(10700086);
                    }
                    yield Component.translatable((String)"gui.guide.day").withColor(4224300);
                }
                case FishProperties.Daytime.NOON -> {
                    if (time <= 3500L || time >= 8500L) {
                        yield Component.translatable((String)"gui.guide.noon").withColor(10700086);
                    }
                    yield Component.translatable((String)"gui.guide.noon").withColor(4224300);
                }
                case FishProperties.Daytime.NIGHT -> {
                    if (time >= 23000L || time <= 12700L) {
                        yield Component.translatable((String)"gui.guide.night").withColor(10700086);
                    }
                    yield Component.translatable((String)"gui.guide.night").withColor(4224300);
                }
                case FishProperties.Daytime.MIDNIGHT -> {
                    if (time <= 16500L || time >= 19500L) {
                        yield Component.translatable((String)"gui.guide.midnight").withColor(10700086);
                    }
                    yield Component.translatable((String)"gui.guide.midnight").withColor(4224300);
                }
                default -> Component.empty();
            };
        }
        start = Component.translatable((String)"gui.guide.daytime");
        guiGraphics.drawString(this.font, (Component)start.copy().append((Component)comp2), this.uiX + xOffset, this.uiY + yOffset, 6508608, false);
        yOffset += 12;
        int above = fp.wr().mustBeCaughtAboveY();
        int below = fp.wr().mustBeCaughtBelowY();
        switch (aboveBelow = above + ", " + below) {
            case "100, 2147483647": {
                MutableComponent mutableComponent = Component.translatable((String)"gui.guide.mountain");
                break;
            }
            case "50, 100": 
            case "50, 2147483647": {
                MutableComponent mutableComponent = Component.translatable((String)"gui.guide.surface");
                break;
            }
            case "-2147483648, 50": {
                MutableComponent mutableComponent = Component.translatable((String)"gui.guide.underground");
                break;
            }
            case "0, 50": {
                MutableComponent mutableComponent = Component.translatable((String)"gui.guide.caves");
                break;
            }
            case "-2147483648, 0": {
                MutableComponent mutableComponent = Component.translatable((String)"gui.guide.deepslate");
                break;
            }
            case "-2147483648, 2147483647": {
                MutableComponent mutableComponent = Component.translatable((String)"gui.guide.no_restriction");
                break;
            }
            default: {
                MutableComponent mutableComponent = hardCodedTranslations = Component.literal((String)("> " + above + ", < " + below));
            }
        }
        if (this.player.getY() > (double)above && this.player.getY() < (double)below) {
            hardCodedTranslations.withColor(4224300);
        } else {
            hardCodedTranslations.withColor(10700086);
        }
        ArrayList<MutableComponent> hoverTooltip = new ArrayList<MutableComponent>(List.of());
        if (above > Integer.MIN_VALUE) {
            hoverTooltip.add(Component.translatable((String)"gui.guide.above").append("" + above));
        }
        if (below < Integer.MAX_VALUE) {
            hoverTooltip.add(Component.translatable((String)"gui.guide.below").append("" + below));
        }
        if (x > (double)xOffset && x < (double)(xOffset + 140) && y > (double)(yOffset - 2) && y < (double)(yOffset + 10)) {
            guiGraphics.renderTooltip(this.font, hoverTooltip, Optional.empty(), mouseX, mouseY);
        }
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.elevation").append((Component)hardCodedTranslations), this.uiX + xOffset, this.uiY + yOffset, 6508608, false);
        yOffset += 12;
        List<ResourceLocation> fluids = fp.wr().fluids();
        if (fluids.size() == 1) {
            comp = Component.translatable((String)("block." + fluids.getFirst().toLanguageKey()));
        } else {
            comp = Component.translatable((String)"gui.guide.hover");
            if (x > (double)xOffset && x < (double)(xOffset + 100) && y > (double)(yOffset - 2) && y < (double)(yOffset + 10)) {
                ArrayList<MutableComponent> c = new ArrayList<MutableComponent>();
                c.add(Component.translatable((String)"gui.guide.fluid"));
                for (ResourceLocation rl3 : fluids) {
                    c.add(Component.translatable((String)("block." + rl3.toLanguageKey())));
                }
                guiGraphics.renderTooltip(this.font, c, Optional.empty(), mouseX, mouseY);
            }
        }
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.fluid").append((Component)comp), this.uiX + xOffset, this.uiY + yOffset, 6508608, false);
        if (this.highlightRightAlpha > 0.0f) {
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.highlightRightAlpha);
            this.renderImage(guiGraphics, HIGHLIGHT_RIGHT);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
        }
        if (this.highlightLeftAlpha > 0.0f) {
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.highlightLeftAlpha);
            this.renderImage(guiGraphics, HIGHLIGHT_LEFT);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
        }
    }

    private void renderImage(GuiGraphics guiGraphics, ResourceLocation rl) {
        this.renderImage(guiGraphics, rl, 0, 0);
    }

    private void renderImage(GuiGraphics guiGraphics, ResourceLocation rl, int xOffset, int yOffset) {
        guiGraphics.blit(rl, this.uiX + xOffset, this.uiY + yOffset, 0.0f, 0.0f, 420, 260, 420, 260);
    }

    private void renderItem(ItemStack stack, int x, int y) {
        this.renderItem(stack, x, y, 3.0f);
    }

    private void renderItem(ItemStack stack, int x, int y, float scale) {
        ClientLevel level = Minecraft.getInstance().level;
        LocalPlayer entity = Minecraft.getInstance().player;
        if (!stack.isEmpty()) {
            boolean usesBlockLight;
            BakedModel bakedmodel = this.minecraft.getItemRenderer().getModel(stack, (Level)level, (LivingEntity)entity, 234234);
            PoseStack pose = new PoseStack();
            pose.pushPose();
            pose.translate((float)(x + 8), (float)(y + 8), 150.0f);
            pose.scale(16.0f * scale, -16.0f * scale, 16.0f * scale);
            boolean bl = usesBlockLight = !bakedmodel.usesBlockLight();
            if (usesBlockLight) {
                Lighting.setupForFlatItems();
            }
            this.minecraft.getItemRenderer().render(stack, ItemDisplayContext.GUI, false, pose, (MultiBufferSource)Minecraft.getInstance().renderBuffers().bufferSource(), 0xF000F0, OverlayTexture.NO_OVERLAY, bakedmodel);
            RenderSystem.disableDepthTest();
            Minecraft.getInstance().renderBuffers().bufferSource().endBatch();
            RenderSystem.enableDepthTest();
            if (usesBlockLight) {
                Lighting.setupFor3DItems();
            }
            pose.popPose();
        }
    }

    public void onClose() {
        PacketDistributor.sendToServer((CustomPacketPayload)new FPsSeenPayload(this.fpsSeen), (CustomPacketPayload[])new CustomPacketPayload[0]);
        super.onClose();
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected boolean shouldNarrateNavigation() {
        return false;
    }

    public static List<FishProperties> sortEntries(Sort sort, List<FishProperties> entriesToSort, Player player) {
        ArrayList<FishProperties> entriesSorted;
        if (sort.equals((Object)Sort.RARITY_DOWN) || sort.equals((Object)Sort.RARITY_UP)) {
            entriesToSort = entriesToSort.stream().sorted(Comparator.comparing(o -> ((ResourceKey)o.catchInfo().fish().unwrapKey().get()).location().getPath())).toList();
            ArrayList entriesSorted2 = new ArrayList();
            entriesToSort.forEach(e -> {
                if (e.rarity().equals((Object)FishProperties.Rarity.COMMON)) {
                    entriesSorted2.add(e);
                }
            });
            entriesToSort.forEach(e -> {
                if (e.rarity().equals((Object)FishProperties.Rarity.UNCOMMON)) {
                    entriesSorted2.add(e);
                }
            });
            entriesToSort.forEach(e -> {
                if (e.rarity().equals((Object)FishProperties.Rarity.RARE)) {
                    entriesSorted2.add(e);
                }
            });
            entriesToSort.forEach(e -> {
                if (e.rarity().equals((Object)FishProperties.Rarity.EPIC)) {
                    entriesSorted2.add(e);
                }
            });
            entriesToSort.forEach(e -> {
                if (e.rarity().equals((Object)FishProperties.Rarity.LEGENDARY)) {
                    entriesSorted2.add(e);
                }
            });
            return sort.equals((Object)Sort.RARITY_UP) ? entriesSorted2 : entriesSorted2.reversed();
        }
        if (sort.equals((Object)Sort.ALPHABETICAL_DOWN) || sort.equals((Object)Sort.ALPHABETICAL_UP)) {
            List<FishProperties> entriesSorted3 = entriesToSort.stream().sorted(Comparator.comparing(o -> ((ResourceKey)o.catchInfo().fish().unwrapKey().get()).location().getPath())).toList();
            return sort.equals((Object)Sort.ALPHABETICAL_UP) ? entriesSorted3 : entriesSorted3.reversed();
        }
        if (sort.equals((Object)Sort.MOD_DOWN) || sort.equals((Object)Sort.MOD_UP)) {
            entriesToSort = entriesToSort.stream().sorted(Comparator.comparing(o -> ((ResourceKey)o.catchInfo().fish().unwrapKey().get()).location().getPath())).toList();
            entriesSorted = new ArrayList<FishProperties>();
            ArrayList<String> allNamespaces = new ArrayList<String>();
            for (FishProperties fp : entriesToSort) {
                String namespace = ((ResourceKey)fp.catchInfo().fish().unwrapKey().get()).location().getNamespace();
                if (allNamespaces.contains(namespace)) continue;
                allNamespaces.add(namespace);
            }
            for (String s : allNamespaces) {
                for (FishProperties fp : entriesToSort) {
                    String namespace = ((ResourceKey)fp.catchInfo().fish().unwrapKey().get()).location().getNamespace();
                    if (!namespace.equals(s)) continue;
                    entriesSorted.add(fp);
                }
            }
            SequencedCollection<FishProperties> sequencedCollection = entriesToSort = sort.equals((Object)Sort.MOD_UP) ? entriesSorted : entriesSorted.reversed();
        }
        if (sort.equals((Object)Sort.FLUID_DOWN) || sort.equals((Object)Sort.FLUID_UP)) {
            entriesToSort = entriesToSort.stream().sorted(Comparator.comparing(o -> ((ResourceKey)o.catchInfo().fish().unwrapKey().get()).location().getPath())).toList();
            entriesSorted = new ArrayList();
            ArrayList<FishProperties> entriesRemaining = new ArrayList<FishProperties>(entriesToSort);
            while (!entriesRemaining.isEmpty()) {
                ResourceLocation rlBeingSorted = ((FishProperties)entriesRemaining.getFirst()).wr().fluids().getFirst();
                ArrayList<FishProperties> temp = new ArrayList<FishProperties>(entriesRemaining);
                temp.forEach(e -> {
                    if (e.wr().fluids().getFirst().equals((Object)rlBeingSorted)) {
                        entriesSorted.add((FishProperties)e);
                        entriesRemaining.remove(e);
                    }
                });
            }
            SequencedCollection<FishProperties> sequencedCollection = entriesToSort = sort.equals((Object)Sort.FLUID_UP) ? entriesSorted : entriesSorted.reversed();
        }
        if (sort.equals((Object)Sort.CAUGHT_UP) || sort.equals((Object)Sort.CAUGHT_DOWN)) {
            entriesToSort = entriesToSort.stream().sorted(Comparator.comparing(o -> ((ResourceKey)o.catchInfo().fish().unwrapKey().get()).location().getPath())).toList();
            Map<ResourceLocation, FishCaughtCounter> fishesCaught = FishingGuideAttachment.getFishesCaught(player);
            ArrayList hasCaught = new ArrayList();
            ArrayList hasNotCaught = new ArrayList();
            ArrayList<FishProperties> toReturn = new ArrayList<FishProperties>();
            entriesToSort.forEach(e -> {
                if (e.hasGuideEntry() && fishesCaught.containsKey(U.getRlFromFp(player.level(), e))) {
                    hasCaught.add(e);
                } else {
                    hasNotCaught.add(e);
                }
            });
            if (sort.equals((Object)Sort.CAUGHT_UP)) {
                toReturn.addAll(hasCaught);
                toReturn.addAll(hasNotCaught);
            } else {
                toReturn.addAll(hasNotCaught);
                toReturn.addAll(hasCaught);
            }
            return toReturn;
        }
        if (sort.equals((Object)Sort.SEASON_DOWN) || sort.equals((Object)Sort.SEASON_UP)) {
            entriesToSort = entriesToSort.stream().sorted(Comparator.comparing(o -> ((ResourceKey)o.catchInfo().fish().unwrapKey().get()).location().getPath())).toList();
            entriesSorted = new ArrayList();
            ArrayList<FishProperties> entriesUnsorted = new ArrayList<FishProperties>(entriesToSort);
            for (FishProperties fp : entriesUnsorted) {
                if (!fp.wr().seasons().contains((Object)FishProperties.WorldRestrictions.Seasons.ALL)) continue;
                entriesSorted.add(fp);
            }
            entriesUnsorted.removeAll(entriesSorted);
            for (FishProperties fp : entriesUnsorted) {
                if (!fp.wr().seasons().contains((Object)FishProperties.WorldRestrictions.Seasons.SPRING)) continue;
                entriesSorted.add(fp);
            }
            entriesUnsorted.removeAll(entriesSorted);
            for (FishProperties fp : entriesUnsorted) {
                if (!fp.wr().seasons().contains((Object)FishProperties.WorldRestrictions.Seasons.EARLY_SPRING)) continue;
                entriesSorted.add(fp);
            }
            entriesUnsorted.removeAll(entriesSorted);
            for (FishProperties fp : entriesUnsorted) {
                if (!fp.wr().seasons().contains((Object)FishProperties.WorldRestrictions.Seasons.MID_SPRING)) continue;
                entriesSorted.add(fp);
            }
            entriesUnsorted.removeAll(entriesSorted);
            for (FishProperties fp : entriesUnsorted) {
                if (!fp.wr().seasons().contains((Object)FishProperties.WorldRestrictions.Seasons.LATE_SPRING)) continue;
                entriesSorted.add(fp);
            }
            entriesUnsorted.removeAll(entriesSorted);
            for (FishProperties fp : entriesUnsorted) {
                if (!fp.wr().seasons().contains((Object)FishProperties.WorldRestrictions.Seasons.SUMMER)) continue;
                entriesSorted.add(fp);
            }
            entriesUnsorted.removeAll(entriesSorted);
            for (FishProperties fp : entriesUnsorted) {
                if (!fp.wr().seasons().contains((Object)FishProperties.WorldRestrictions.Seasons.EARLY_SUMMER)) continue;
                entriesSorted.add(fp);
            }
            entriesUnsorted.removeAll(entriesSorted);
            for (FishProperties fp : entriesUnsorted) {
                if (!fp.wr().seasons().contains((Object)FishProperties.WorldRestrictions.Seasons.MID_SUMMER)) continue;
                entriesSorted.add(fp);
            }
            entriesUnsorted.removeAll(entriesSorted);
            for (FishProperties fp : entriesUnsorted) {
                if (!fp.wr().seasons().contains((Object)FishProperties.WorldRestrictions.Seasons.LATE_SUMMER)) continue;
                entriesSorted.add(fp);
            }
            entriesUnsorted.removeAll(entriesSorted);
            for (FishProperties fp : entriesUnsorted) {
                if (!fp.wr().seasons().contains((Object)FishProperties.WorldRestrictions.Seasons.AUTUMN)) continue;
                entriesSorted.add(fp);
            }
            entriesUnsorted.removeAll(entriesSorted);
            for (FishProperties fp : entriesUnsorted) {
                if (!fp.wr().seasons().contains((Object)FishProperties.WorldRestrictions.Seasons.EARLY_AUTUMN)) continue;
                entriesSorted.add(fp);
            }
            entriesUnsorted.removeAll(entriesSorted);
            for (FishProperties fp : entriesUnsorted) {
                if (!fp.wr().seasons().contains((Object)FishProperties.WorldRestrictions.Seasons.MID_AUTUMN)) continue;
                entriesSorted.add(fp);
            }
            entriesUnsorted.removeAll(entriesSorted);
            for (FishProperties fp : entriesUnsorted) {
                if (!fp.wr().seasons().contains((Object)FishProperties.WorldRestrictions.Seasons.LATE_AUTUMN)) continue;
                entriesSorted.add(fp);
            }
            entriesUnsorted.removeAll(entriesSorted);
            for (FishProperties fp : entriesUnsorted) {
                if (!fp.wr().seasons().contains((Object)FishProperties.WorldRestrictions.Seasons.WINTER)) continue;
                entriesSorted.add(fp);
            }
            entriesUnsorted.removeAll(entriesSorted);
            for (FishProperties fp : entriesUnsorted) {
                if (!fp.wr().seasons().contains((Object)FishProperties.WorldRestrictions.Seasons.EARLY_WINTER)) continue;
                entriesSorted.add(fp);
            }
            entriesUnsorted.removeAll(entriesSorted);
            for (FishProperties fp : entriesUnsorted) {
                if (!fp.wr().seasons().contains((Object)FishProperties.WorldRestrictions.Seasons.MID_WINTER)) continue;
                entriesSorted.add(fp);
            }
            entriesUnsorted.removeAll(entriesSorted);
            for (FishProperties fp : entriesUnsorted) {
                if (!fp.wr().seasons().contains((Object)FishProperties.WorldRestrictions.Seasons.LATE_WINTER)) continue;
                entriesSorted.add(fp);
            }
            entriesUnsorted.removeAll(entriesSorted);
            return sort.equals((Object)Sort.SEASON_UP) ? entriesSorted : entriesSorted.reversed();
        }
        return entriesToSort;
    }

    public FishingGuideScreen() {
        super((Component)Component.empty());
        BuiltInRegistries.ITEM.getTag(StarcatcherTags.BOBBERS).ifPresent(o -> o.stream().forEach(i -> this.hooksAndBobbers.add(((Item)i.value()).getDefaultInstance())));
        BuiltInRegistries.ITEM.getTag(StarcatcherTags.HOOKS).ifPresent(o -> o.stream().forEach(i -> this.hooksAndBobbers.add(((Item)i.value()).getDefaultInstance())));
        BuiltInRegistries.ITEM.getTag(StarcatcherTags.BAITS).ifPresent(o -> o.stream().forEach(i -> this.baits.add(((Item)i.value()).getDefaultInstance())));
        BuiltInRegistries.ITEM.getTag(StarcatcherTags.GADGETS).ifPresent(o -> o.stream().forEach(i -> this.gadgets.add(((Item)i.value()).getDefaultInstance())));
        BuiltInRegistries.ITEM.getTag(StarcatcherTags.TEMPLATES).ifPresent(o -> o.stream().forEach(i -> this.templates.add(((Item)i.value()).getDefaultInstance())));
        BuiltInRegistries.ITEM.getTag(StarcatcherTags.EQUIPMENTS).ifPresent(o -> o.stream().forEach(i -> this.equipments.add(((Item)i.value()).getDefaultInstance())));
        this.basicsIndexIcon = new ItemStack((ItemLike)ModItems.ROD.get());
        this.upgradeIndexIcon = new ItemStack((ItemLike)Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE);
        this.addonsIndexIcon = new ItemStack((ItemLike)ModItems.HOOK.get());
        this.cosmeticsIndexIcon = new ItemStack((ItemLike)ModItems.PEARL_SMITHING_TEMPLATE.get());
        this.tournamentIndexIcon = new ItemStack((ItemLike)ModBlocks.STAND.get());
        this.trophiesIndexIcon = new ItemStack((ItemLike)ModBlocks.TROPHY_GOLD.get());
        this.settingsIndexIcon = new ItemStack((ItemLike)ModItems.SETTINGS.get());
        this.indexEntries = new ArrayList<Pair>(List.of(Pair.of((Object)this.basicsIndexIcon, (Object)"gui.guide.index.basics"), Pair.of((Object)this.upgradeIndexIcon, (Object)"gui.guide.index.upgrades"), Pair.of((Object)this.addonsIndexIcon, (Object)"gui.guide.index.addons"), Pair.of((Object)this.cosmeticsIndexIcon, (Object)"gui.guide.index.cosmetics"), Pair.of((Object)this.tournamentIndexIcon, (Object)"gui.guide.index.tournament"), Pair.of((Object)this.trophiesIndexIcon, (Object)"gui.guide.index.trophies"), Pair.of((Object)this.settingsIndexIcon, (Object)"gui.guide.index.settings")));
        this.sweetspotsIcon = new ItemStack((ItemLike)ModItems.AURORA.get());
        this.treasureIcon = new ItemStack((ItemLike)ModItems.WATERLOGGED_SATCHEL.get());
        this.equipmentIcon = new ItemStack((ItemLike)ModItems.AZURE_CRYSTAL_ROD.get());
        this.hookIcon = new ItemStack((ItemLike)ModItems.HOOK.get());
        this.baitIcon = new ItemStack((ItemLike)ModItems.CHERRY_BAIT.get());
        this.secretsIcon = new ItemStack((ItemLike)ModItems.HOPEFUL_BOTTLE.get());
        this.templateIcon = new ItemStack((ItemLike)ModItems.PEARL_SMITHING_TEMPLATE.get());
    }

    public static enum Sort {
        ALPHABETICAL_UP("gui.guide.sort.alphabetical_up"),
        ALPHABETICAL_DOWN("gui.guide.sort.alphabetical_down"),
        MOD_UP("gui.guide.sort.mod_up"),
        MOD_DOWN("gui.guide.sort.mod_down"),
        RARITY_UP("gui.guide.sort.rarity_up"),
        RARITY_DOWN("gui.guide.sort.rarity_down"),
        CAUGHT_UP("gui.guide.sort.caught_up"),
        CAUGHT_DOWN("gui.guide.sort.caught_down"),
        FLUID_UP("gui.guide.sort.fluid_up"),
        FLUID_DOWN("gui.guide.sort.fluid_down"),
        SEASON_UP("gui.guide.sort.season_up"),
        SEASON_DOWN("gui.guide.sort.season_down");

        private static final Sort[] vals;
        private final String translationKey;

        String getTranslationKey() {
            return this.translationKey;
        }

        private Sort(String translationKey) {
            this.translationKey = translationKey;
        }

        public Sort previous() {
            int lenght = vals.length - 2;
            if (ModList.get().isLoaded("sereneseasons") || ModList.get().isLoaded("eclipticseasons")) {
                lenght += 2;
            }
            if (this.ordinal() == 0) {
                return vals[lenght - 1];
            }
            return vals[(this.ordinal() - 1) % lenght];
        }

        public Sort next() {
            int lenght = vals.length - 2;
            if (ModList.get().isLoaded("sereneseasons") || ModList.get().isLoaded("eclipticseasons")) {
                lenght += 2;
            }
            return vals[(this.ordinal() + 1) % lenght];
        }

        static {
            vals = Sort.values();
        }
    }
}

