/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.fishspotter;

import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.U;
import com.wdiscute.starcatcher.io.attachments.FishingGuideAttachment;
import com.wdiscute.starcatcher.registry.ModItems;
import com.wdiscute.starcatcher.storage.FishProperties;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class FishRadarLayer
implements LayeredDraw.Layer {
    private static final ResourceLocation ONE_ROW = Starcatcher.rl("textures/gui/fish_radar/1_row.png");
    private static final ResourceLocation TWO_ROWS = Starcatcher.rl("textures/gui/fish_radar/2_row.png");
    private static final ResourceLocation THREE_ROWS = Starcatcher.rl("textures/gui/fish_radar/3_row.png");
    private static final ResourceLocation FOUR_ROWS = Starcatcher.rl("textures/gui/fish_radar/4_row.png");
    private static final ResourceLocation FIVE_ROWS = Starcatcher.rl("textures/gui/fish_radar/5_row.png");
    private static final ResourceLocation SIX_ROWS = Starcatcher.rl("textures/gui/fish_radar/6_row.png");
    int uiX;
    int uiY;
    float offScreen = -150.0f;
    Font font;
    int imageWidth = 101;
    int imageHeight = 160;
    float counterSinceLastRefresh = 999.0f;
    Player player;
    ClientLevel level;
    List<FishProperties> fpsInArea = new ArrayList<FishProperties>();
    List<FishProperties> fishesCaught = new ArrayList<FishProperties>();

    private void recalculate() {
        this.fpsInArea = FishProperties.getFpsWithGuideEntryForArea((Entity)this.player);
        this.fishesCaught.clear();
        FishingGuideAttachment.getFishesCaught(this.player).forEach((loc, counter) -> this.fishesCaught.add(U.getFpFromRl((Level)this.level, loc)));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        boolean shouldShow;
        this.font = Minecraft.getInstance().font;
        this.uiX = Minecraft.getInstance().getWindow().getGuiScaledWidth() - this.imageWidth;
        this.uiY = Minecraft.getInstance().getWindow().getGuiScaledHeight() - this.imageHeight - 80;
        if (Minecraft.getInstance().level == null) {
            return;
        }
        this.level = Minecraft.getInstance().level;
        if (Minecraft.getInstance().player == null) {
            return;
        }
        this.player = Minecraft.getInstance().player;
        boolean bl = shouldShow = this.player.getMainHandItem().is(ModItems.FISH_RADAR) || this.player.getOffhandItem().is(ModItems.FISH_RADAR);
        if (!shouldShow) {
            if (!(this.offScreen > -150.0f)) {
                this.offScreen = -150.0f;
                return;
            }
            this.offScreen -= 15.0f * deltaTracker.getGameTimeDeltaTicks();
        } else {
            this.offScreen = this.offScreen < 0.0f ? (this.offScreen += 15.0f * deltaTracker.getGameTimeDeltaTicks()) : 0.0f;
        }
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(-this.offScreen, 0.0f, 0.0f);
        switch (this.fpsInArea.size()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.renderImage(guiGraphics, ONE_ROW);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.renderImage(guiGraphics, TWO_ROWS);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                this.renderImage(guiGraphics, THREE_ROWS);
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                this.renderImage(guiGraphics, FOUR_ROWS);
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                this.renderImage(guiGraphics, FIVE_ROWS);
                break;
            }
            default: {
                this.renderImage(guiGraphics, SIX_ROWS);
            }
        }
        int animationFrame = (int)(this.level.getGameTime() / 2L % 32L + 1L);
        this.renderImage(guiGraphics, Starcatcher.rl("textures/gui/fish_radar/radar_animation" + animationFrame + ".png"));
        this.counterSinceLastRefresh += 1.0f * deltaTracker.getGameTimeDeltaTicks();
        if (this.counterSinceLastRefresh > 100.0f) {
            this.recalculate();
        }
        int i = 0;
        while (true) {
            if (i >= this.fpsInArea.size()) {
                guiGraphics.pose().popPose();
                return;
            }
            ItemStack is = new ItemStack((ItemLike)ModItems.MISSINGNO.get());
            if (this.fishesCaught.contains(this.fpsInArea.get(i))) {
                is = new ItemStack(this.fpsInArea.get(i).catchInfo().fish());
            }
            guiGraphics.renderItem(is, this.uiX + 9 + i * 18 % 90, this.uiY + 48 + i / 5 * 18);
            ++i;
        }
    }

    private void renderImage(GuiGraphics guiGraphics, ResourceLocation rl) {
        guiGraphics.blit(rl, this.uiX, this.uiY, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
    }

    private void drawComp(GuiGraphics guiGraphics, Component comp, int xOffset, int yOffset) {
        guiGraphics.drawString(this.font, comp, this.uiX + xOffset, this.uiY + yOffset, 0, false);
    }
}

