/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.fishentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.fishentity.FishEntity;
import com.wdiscute.starcatcher.fishentity.fishmodels.AgaveBream;
import com.wdiscute.starcatcher.fishentity.fishmodels.BigeyeTuna;
import com.wdiscute.starcatcher.fishentity.fishmodels.Boreal;
import com.wdiscute.starcatcher.fishentity.fishmodels.CactiFish;
import com.wdiscute.starcatcher.fishentity.fishmodels.Charfish;
import com.wdiscute.starcatcher.fishentity.fishmodels.CrystalbackBoreal;
import com.wdiscute.starcatcher.fishentity.fishmodels.CrystalbackMinnow;
import com.wdiscute.starcatcher.fishentity.fishmodels.CrystalbackTrout;
import com.wdiscute.starcatcher.fishentity.fishmodels.DeepjawHerring;
import com.wdiscute.starcatcher.fishentity.fishmodels.DownfallBream;
import com.wdiscute.starcatcher.fishentity.fishmodels.Driftfin;
import com.wdiscute.starcatcher.fishentity.fishmodels.DriftingBream;
import com.wdiscute.starcatcher.fishentity.fishmodels.DusktailSnapper;
import com.wdiscute.starcatcher.fishentity.fishmodels.Embergill;
import com.wdiscute.starcatcher.fishentity.fishmodels.FrostgillChub;
import com.wdiscute.starcatcher.fishentity.fishmodels.FrostjawTrout;
import com.wdiscute.starcatcher.fishentity.fishmodels.HollowbellyDarter;
import com.wdiscute.starcatcher.fishentity.fishmodels.IcetoothSturgeon;
import com.wdiscute.starcatcher.fishentity.fishmodels.LilySnapper;
import com.wdiscute.starcatcher.fishentity.fishmodels.MistbackChub;
import com.wdiscute.starcatcher.fishentity.fishmodels.PinkKoi;
import com.wdiscute.starcatcher.fishentity.fishmodels.SilverveilPerch;
import com.wdiscute.starcatcher.fishentity.fishmodels.SludgeCatfish;
import com.wdiscute.starcatcher.fishentity.fishmodels.Whiteveil;
import com.wdiscute.starcatcher.fishentity.fishmodels.WillowBream;
import com.wdiscute.starcatcher.fishentity.fishmodels.WinteryPike;
import com.wdiscute.starcatcher.registry.ModItems;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;

public class FishRenderer
extends EntityRenderer<FishEntity> {
    ItemRenderer itemRenderer;
    Map<Item, EntityModel<FishEntity>> map = new HashMap<Item, EntityModel<FishEntity>>();

    public FishRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemRenderer = context.getItemRenderer();
        this.map.put((Item)ModItems.AGAVE_BREAM.get(), new AgaveBream(context.bakeLayer(AgaveBream.LAYER_LOCATION)));
        this.map.put((Item)ModItems.BIGEYE_TUNA.get(), new BigeyeTuna(context.bakeLayer(BigeyeTuna.LAYER_LOCATION)));
        this.map.put((Item)ModItems.BOREAL.get(), new Boreal(context.bakeLayer(Boreal.LAYER_LOCATION)));
        this.map.put((Item)ModItems.CACTIFISH.get(), new CactiFish(context.bakeLayer(CactiFish.LAYER_LOCATION)));
        this.map.put((Item)ModItems.CHARFISH.get(), new Charfish(context.bakeLayer(Charfish.LAYER_LOCATION)));
        this.map.put((Item)ModItems.CRYSTALBACK_BOREAL.get(), new CrystalbackBoreal(context.bakeLayer(CrystalbackBoreal.LAYER_LOCATION)));
        this.map.put((Item)ModItems.CRYSTALBACK_MINNOW.get(), new CrystalbackMinnow(context.bakeLayer(CrystalbackMinnow.LAYER_LOCATION)));
        this.map.put((Item)ModItems.DEEPJAW_HERRING.get(), new DeepjawHerring(context.bakeLayer(DeepjawHerring.LAYER_LOCATION)));
        this.map.put((Item)ModItems.DOWNFALL_BREAM.get(), new DownfallBream(context.bakeLayer(DownfallBream.LAYER_LOCATION)));
        this.map.put((Item)ModItems.DRIFTFIN.get(), new Driftfin(context.bakeLayer(Driftfin.LAYER_LOCATION)));
        this.map.put((Item)ModItems.DRIFTING_BREAM.get(), new DriftingBream(context.bakeLayer(DriftingBream.LAYER_LOCATION)));
        this.map.put((Item)ModItems.DUSKTAIL_SNAPPER.get(), new DusktailSnapper(context.bakeLayer(DusktailSnapper.LAYER_LOCATION)));
        this.map.put((Item)ModItems.LILY_SNAPPER.get(), new LilySnapper(context.bakeLayer(LilySnapper.LAYER_LOCATION)));
        this.map.put((Item)ModItems.PINK_KOI.get(), new PinkKoi(context.bakeLayer(PinkKoi.LAYER_LOCATION)));
        this.map.put((Item)ModItems.SILVERVEIL_PERCH.get(), new SilverveilPerch(context.bakeLayer(SilverveilPerch.LAYER_LOCATION)));
        this.map.put((Item)ModItems.SLUDGE_CATFISH.get(), new SludgeCatfish(context.bakeLayer(SludgeCatfish.LAYER_LOCATION)));
        this.map.put((Item)ModItems.WHITEVEIL.get(), new Whiteveil(context.bakeLayer(Whiteveil.LAYER_LOCATION)));
        this.map.put((Item)ModItems.WILLOW_BREAM.get(), new WillowBream(context.bakeLayer(WillowBream.LAYER_LOCATION)));
        this.map.put((Item)ModItems.WINTERY_PIKE.get(), new WinteryPike(context.bakeLayer(WinteryPike.LAYER_LOCATION)));
        this.map.put((Item)ModItems.CRYSTALBACK_TROUT.get(), new CrystalbackTrout(context.bakeLayer(CrystalbackTrout.LAYER_LOCATION)));
        this.map.put((Item)ModItems.EMBERGILL.get(), new Embergill(context.bakeLayer(Embergill.LAYER_LOCATION)));
        this.map.put((Item)ModItems.FROSTGILL_CHUB.get(), new FrostgillChub(context.bakeLayer(FrostgillChub.LAYER_LOCATION)));
        this.map.put((Item)ModItems.FROSTJAW_TROUT.get(), new FrostjawTrout(context.bakeLayer(FrostjawTrout.LAYER_LOCATION)));
        this.map.put((Item)ModItems.HOLLOWBELLY_DARTER.get(), new HollowbellyDarter(context.bakeLayer(HollowbellyDarter.LAYER_LOCATION)));
        this.map.put((Item)ModItems.ICETOOTH_STURGEON.get(), new IcetoothSturgeon(context.bakeLayer(IcetoothSturgeon.LAYER_LOCATION)));
        this.map.put((Item)ModItems.MISTBACK_CHUB.get(), new MistbackChub(context.bakeLayer(MistbackChub.LAYER_LOCATION)));
    }

    public void render(FishEntity fish, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        poseStack.translate(0.0f, 1.3f, 0.0f);
        poseStack.scale(1.0f, -1.0f, -1.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(entityYaw));
        if (!fish.isInWater()) {
            float f = 4.3f * Mth.sin((float)(1.0f * (float)fish.tickCount + partialTicks));
            poseStack.translate(1.1f, 1.4f, -0.1f);
            poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
            poseStack.mulPose(Axis.ZP.rotationDegrees(f));
        }
        if (!fish.getBodyArmorItem().isEmpty() && !this.renderCustomModel(fish.getBodyArmorItem().getItem(), poseStack, buffer, packedLight)) {
            poseStack.translate(0.0f, 1.0f, 0.0f);
            poseStack.mulPose(Axis.YP.rotationDegrees(270.0f));
            poseStack.mulPose(Axis.ZP.rotationDegrees(45.0f));
            this.itemRenderer.renderStatic(fish.getBodyArmorItem(), ItemDisplayContext.FIXED, packedLight, OverlayTexture.NO_OVERLAY, poseStack, buffer, fish.level(), fish.getId());
        }
        poseStack.popPose();
    }

    public ResourceLocation getTextureLocation(FishEntity fish) {
        return null;
    }

    private boolean renderCustomModel(Item fish, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (this.map.containsKey(fish)) {
            this.renderModel(BuiltInRegistries.ITEM.getKey((Object)fish).getPath(), this.map.get(fish), buffer, poseStack, packedLight);
            return true;
        }
        return false;
    }

    private void renderModel(String rl, EntityModel<FishEntity> model, MultiBufferSource buffer, PoseStack poseStack, int packedLight) {
        VertexConsumer vertexconsumer = buffer.getBuffer(model.renderType(Starcatcher.rl("textures/entity/fishes/" + rl + ".png")));
        model.renderToBuffer(poseStack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY);
    }
}

