/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.fishentity;

import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.StarcatcherTags;
import com.wdiscute.starcatcher.U;
import com.wdiscute.starcatcher.io.ModDataComponents;
import com.wdiscute.starcatcher.io.SingleStackContainer;
import com.wdiscute.starcatcher.registry.ModItems;
import com.wdiscute.starcatcher.storage.FishProperties;
import java.util.ArrayList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class FishEntity
extends AbstractFish {
    private boolean shouldDropItem = true;

    public FishEntity(EntityType<? extends FishEntity> entityType, Level level) {
        super(entityType, level);
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.TROPICAL_FISH_AMBIENT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.TROPICAL_FISH_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.TROPICAL_FISH_HURT;
    }

    @Nullable
    public ItemStack getPickResult() {
        return this.getBodyArmorItem();
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.TROPICAL_FISH_FLOP;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 3.0);
    }

    public void tick() {
        super.tick();
        if (this.getBodyArmorItem().isEmpty() && !this.level().isClientSide) {
            this.shouldDropItem = false;
            ArrayList<FishProperties> available = new ArrayList<FishProperties>();
            for (FishProperties fp : this.level().registryAccess().registryOrThrow(Starcatcher.FISH_REGISTRY)) {
                if (FishProperties.getChance(fp, (Entity)this, ModItems.ROD.toStack()) <= 0 || !fp.catchInfo().fish().is(StarcatcherTags.BUCKETABLE_FISHES)) continue;
                available.add(fp);
            }
            if (available.isEmpty()) {
                this.kill();
            } else {
                FishProperties fp = (FishProperties)available.get(U.r.nextInt(available.size() - 1));
                ItemStack is = new ItemStack(fp.catchInfo().fish());
                this.setBodyArmorItem(is);
            }
        }
    }

    protected void dropAllDeathLoot(ServerLevel p_level, DamageSource damageSource) {
        if (this.shouldDropItem) {
            super.dropAllDeathLoot(p_level, damageSource);
        }
    }

    public void setFish(ItemStack is) {
        this.setBodyArmorItem(is);
        this.shouldDropItem = true;
        this.setCustomName(is.getDisplayName());
    }

    public ItemStack getBucketItemStack() {
        ItemStack is = new ItemStack((ItemLike)ModItems.STARCAUGHT_BUCKET.get());
        ModDataComponents.set(is, ModDataComponents.BUCKETED_FISH, new SingleStackContainer(this.getBodyArmorItem().copy()));
        return is;
    }
}

