/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.datagen;

import com.wdiscute.starcatcher.datagen.FishingPropertiesProvider;
import com.wdiscute.starcatcher.datagen.ModAdvancementProvider;
import com.wdiscute.starcatcher.datagen.ModBlocksTagProvider;
import com.wdiscute.starcatcher.datagen.ModItemModelProvider;
import com.wdiscute.starcatcher.datagen.ModItemsTagProvider;
import com.wdiscute.starcatcher.datagen.ModRegistryProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="starcatcher")
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        CompletableFuture registries = event.getLookupProvider();
        PackOutput output = gen.getPackOutput();
        gen.addProvider(event.includeServer(), (DataProvider)new FishingPropertiesProvider(output, registries));
        gen.addProvider(event.includeServer(), (DataProvider)new ModRegistryProvider(output, registries));
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        gen.addProvider(event.includeServer(), (DataProvider)new ModItemModelProvider(output, existingFileHelper));
        ModBlocksTagProvider btp = new ModBlocksTagProvider(output, registries, existingFileHelper);
        gen.addProvider(event.includeServer(), (DataProvider)btp);
        ModItemsTagProvider itp = new ModItemsTagProvider(output, registries, btp.contentsGetter(), existingFileHelper);
        gen.addProvider(event.includeServer(), (DataProvider)itp);
        gen.addProvider(event.includeServer(), (DataProvider)new ModAdvancementProvider(output, registries, existingFileHelper));
    }
}

