/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.compat;

import com.wdiscute.starcatcher.storage.FishProperties;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.Month;
import net.dries007.tfc.util.calendar.Season;
import net.minecraft.world.level.Level;

public class TerraFirmaCraftSeasonsCompat {
    public static boolean canCatch(FishProperties fp, Level level) {
        if (!fp.wr().seasons().contains((Object)FishProperties.WorldRestrictions.Seasons.ALL)) {
            return fp.wr().seasons().contains((Object)TerraFirmaCraftSeasonsCompat.getSeason(level)) || fp.wr().seasons().contains((Object)TerraFirmaCraftSeasonsCompat.getSubSeason(level));
        }
        return true;
    }

    public static FishProperties.WorldRestrictions.Seasons getSeason(Level level) {
        Season season = level.isClientSide ? Calendars.CLIENT.getAbsoluteCalendarMonthOfYear().getSeason() : Calendars.SERVER.getAbsoluteCalendarMonthOfYear().getSeason();
        return switch (season) {
            case Season.SPRING -> FishProperties.WorldRestrictions.Seasons.SPRING;
            case Season.SUMMER -> FishProperties.WorldRestrictions.Seasons.SUMMER;
            case Season.FALL -> FishProperties.WorldRestrictions.Seasons.AUTUMN;
            default -> FishProperties.WorldRestrictions.Seasons.WINTER;
        };
    }

    public static FishProperties.WorldRestrictions.Seasons getSubSeason(Level level) {
        Month month = level.isClientSide ? Calendars.CLIENT.getAbsoluteCalendarMonthOfYear() : Calendars.SERVER.getAbsoluteCalendarMonthOfYear();
        return switch (month) {
            default -> throw new MatchException(null, null);
            case Month.JANUARY -> FishProperties.WorldRestrictions.Seasons.MID_WINTER;
            case Month.FEBRUARY -> FishProperties.WorldRestrictions.Seasons.LATE_WINTER;
            case Month.MARCH -> FishProperties.WorldRestrictions.Seasons.EARLY_SPRING;
            case Month.APRIL -> FishProperties.WorldRestrictions.Seasons.MID_SPRING;
            case Month.MAY -> FishProperties.WorldRestrictions.Seasons.LATE_SPRING;
            case Month.JUNE -> FishProperties.WorldRestrictions.Seasons.EARLY_SUMMER;
            case Month.JULY -> FishProperties.WorldRestrictions.Seasons.MID_SUMMER;
            case Month.AUGUST -> FishProperties.WorldRestrictions.Seasons.LATE_SUMMER;
            case Month.SEPTEMBER -> FishProperties.WorldRestrictions.Seasons.EARLY_AUTUMN;
            case Month.OCTOBER -> FishProperties.WorldRestrictions.Seasons.MID_AUTUMN;
            case Month.NOVEMBER -> FishProperties.WorldRestrictions.Seasons.LATE_AUTUMN;
            case Month.DECEMBER -> FishProperties.WorldRestrictions.Seasons.EARLY_WINTER;
        };
    }
}

