/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.compat;

import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.StarcatcherTags;
import com.wdiscute.starcatcher.io.ModDataComponents;
import com.wdiscute.starcatcher.recipe.FishingRodSmithingRecipe;
import com.wdiscute.starcatcher.registry.ModItems;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class StarcatcherEmiSmithingRecipe
implements EmiRecipe {
    protected final EmiIngredient template;
    protected final EmiIngredient input;
    protected final EmiStack netheriteIngot = EmiStack.of((ItemLike)Items.NETHERITE_INGOT);
    protected final boolean isNetheriteUpgrade;
    protected final EmiStack output;

    public StarcatcherEmiSmithingRecipe(FishingRodSmithingRecipe recipe) {
        this.template = EmiIngredient.of((Ingredient)recipe.template());
        this.input = EmiIngredient.of((Ingredient)recipe.rod());
        ItemStack stack = Arrays.stream(recipe.rod().getItems()).findFirst().get().copy();
        ModDataComponents.set(stack, ModDataComponents.NETHERITE_UPGRADE, true);
        this.isNetheriteUpgrade = true;
        this.output = EmiStack.of((ItemStack)stack);
    }

    public StarcatcherEmiSmithingRecipe(Item item) {
        this.template = EmiIngredient.of((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{item}));
        this.input = EmiIngredient.of((Ingredient)Ingredient.of(StarcatcherTags.RODS));
        ItemStack is = ((Item)ModItems.ROD.get()).getDefaultInstance();
        ResourceLocation wadd = (ResourceLocation)ModDataComponents.get(item.getDefaultInstance(), ModDataComponents.TACKLE_SKIN);
        ModDataComponents.set(is, ModDataComponents.TACKLE_SKIN, wadd);
        this.isNetheriteUpgrade = false;
        this.output = EmiStack.of((ItemStack)is);
    }

    public EmiRecipeCategory getCategory() {
        return VanillaEmiRecipeCategories.SMITHING;
    }

    public ResourceLocation getId() {
        return Starcatcher.rl("/" + BuiltInRegistries.ITEM.getKey((Object)((EmiStack)this.template.getEmiStacks().getFirst()).getItemStack().getItem()).getPath());
    }

    public List<EmiIngredient> getInputs() {
        return List.of(this.template, this.input);
    }

    public List<EmiStack> getOutputs() {
        return List.of(this.output);
    }

    public int getDisplayWidth() {
        return 112;
    }

    public int getDisplayHeight() {
        return 18;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 62, 1);
        widgets.addSlot(this.template, 0, 0);
        widgets.addSlot(this.input, 18, 0);
        if (this.isNetheriteUpgrade) {
            widgets.addSlot((EmiIngredient)this.netheriteIngot, 36, 0);
        }
        widgets.addSlot((EmiIngredient)this.output, 94, 0).recipeContext((EmiRecipe)this);
    }
}

